/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSContinuationQueue;
import com.att.aft.dme2.jms.DME2JMSErrorMessage;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSLocalQueue;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSQueueConnectionFactory;
import com.att.aft.dme2.jms.DME2JMSQueueReceiver;
import com.att.aft.dme2.jms.DME2JMSRemoteQueue;
import com.att.aft.dme2.jms.DME2JMSTemporaryQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.DME2JMSTopicConnectionFactory;
import com.att.aft.dme2.jms.DME2JMSXAQueueConnectionFactory;
import com.att.aft.dme2.jms.util.CleanupScheduler;
import com.att.aft.dme2.jms.util.DME2JMSExceptionHandler;
import com.att.aft.dme2.jms.util.DME2UniformResource;
import com.att.aft.dme2.jms.util.JMSConstants;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2UrlStreamHandler;
import com.att.aft.dme2.util.ErrorContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;

public class DME2JMSManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSManager.class.getName());
    private static volatile DME2JMSManager instance = null;
    private final int MSG_PARSING_BUFFER = 8096;
    private final byte[] lock = new byte[0];
    private final Map<String, DME2JMSQueueConnectionFactory> qcfs = Collections.synchronizedMap(new HashMap());
    private final Map<String, DME2JMSXAQueueConnectionFactory> xaqcfs = Collections.synchronizedMap(new HashMap());
    private final Map<String, DME2JMSTopicConnectionFactory> tcfs = Collections.synchronizedMap(new HashMap());
    private final Map<String, DME2JMSQueue> localQueues = Collections.synchronizedMap(new HashMap());
    private final Map<QueueSession, List<String>> tempQueueSessions = Collections.synchronizedMap(new HashMap());
    private final Map<QueueConnection, List<String>> tempQueueConnections = Collections.synchronizedMap(new HashMap());
    private final Map<String, DME2JMSContinuationQueue> contQueues = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<DME2JMSQueueReceiver>> tempQueueReceivers = Collections.synchronizedMap(new HashMap());
    private static final int TEMP_QUEUE_IDLE_TIMEOUT = 2;
    private static final int CONSTANT_TEMPQUEUECLEANUPINTERVAL = 300000;
    private static final int CONSTANT_CONTQUEUECLEANUPINTERVAL = 240000;
    private int tempQueueCleanupInterval = 300000;
    private int contQueueCleanupInterval = 240000;
    private final DME2Manager manager;
    private String userName;
    private String password;
    private static final String EXTENDEDMESSAGE = "extendedMessage";
    private static final String ROUTEOFFER = "routeOffer=";
    private static final String SLASHSLASH = "\\?";
    private static final String DME2JMSMANAGER = ";DME2JMSManager=";
    private static final String AFTDME26110 = "AFT-DME2-6110";
    private DME2Configuration config;

    protected DME2JMSManager(DME2Manager manager) {
        logger.debug(null, "DME2JMSManager", LogMessage.METHOD_ENTER);
        this.manager = manager;
        this.config = manager.getConfig();
        this.manager.disableMetricsFilter();
        logger.debug((URI)null, "ctor", "manager: {}", (Object)this.manager.getName());
        logger.debug((URI)null, "ctor", "cleanup constants are: {}", (Object)JMSConstants.DME2_TEMP_QUEUE_CLEANUP_INTERVAL_MS);
        this.tempQueueCleanupInterval = this.config.getInt(JMSConstants.DME2_TEMP_QUEUE_CLEANUP_INTERVAL_MS, 300000);
        logger.debug((URI)null, "ctor", "tempQueueCleanupInterval: {}", (Object)this.tempQueueCleanupInterval);
        this.contQueueCleanupInterval = this.config.getInt(JMSConstants.DME2_CONT_QUEUE_CLEANUP_INTERVAL_MS, 240000);
        logger.debug(null, "ctor", "contQueueCleanupInterval: " + this.contQueueCleanupInterval);
        new CleanupScheduler("DME2::CleanupIdleTempQueues").schedulePeriodically(new Runnable(){

            @Override
            public void run() {
                try {
                    DME2JMSManager.this.cleanupTemporaryQueues(2);
                }
                catch (Throwable e) {
                    logger.warn(null, "DME2JMSManager", "Code=Exception.DME2JMSManager.cleanupTemporaryQueues;Exception=" + e.toString());
                }
            }
        }, this.tempQueueCleanupInterval);
        new CleanupScheduler("DME2::CleanupContinuationQueues").schedulePeriodically(new Runnable(){

            @Override
            public void run() {
                try {
                    DME2JMSManager.this.cleanupContinuationQueues();
                }
                catch (Throwable e) {
                    logger.warn((URI)null, "DME2JMSManager", "Code=Exception.DME2JMSManager.cleanupContinuationQueues;Exception={}", (Object)e.toString());
                }
            }
        }, this.contQueueCleanupInterval);
        logger.debug(null, "DME2JMSManager", LogMessage.METHOD_EXIT);
    }

    public static DME2JMSManager getDefaultInstance() throws JMSException {
        return DME2JMSManager.getDefaultInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DME2JMSManager getDefaultInstance(Properties props) throws JMSException {
        DME2JMSManager result = instance;
        try {
            if (result != null) return result;
            Class<DME2JMSManager> clazz = DME2JMSManager.class;
            synchronized (DME2JMSManager.class) {
                result = instance;
                if (result != null) return result;
                ArrayList<String> defaultConfigs = new ArrayList<String>();
                defaultConfigs.add("jms-provider_defaultConfigs.properties");
                defaultConfigs.add("dme-api_defaultConfigs.properties");
                DME2Configuration config = new DME2Configuration("DefaultDME2JmsManager", defaultConfigs, null, props);
                DME2Manager manager = new DME2Manager("DefaultDME2JmsManager", config);
                manager.disableMetricsFilter();
                instance = result = new DME2JMSManager(manager);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
        }
        catch (Exception e) {
            throw DME2JMSExceptionHandler.handleException(e, "Not Specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTemporaryQueue(URI uri, DME2JMSQueue temporaryQueue) throws JMSException {
        logger.debug(null, "addTemporaryQueue", LogMessage.METHOD_ENTER);
        try {
            List<String> cachedQueueConnections;
            Map<Object, Object> map;
            logger.debug((URI)null, "addTemporaryQueue", "Adding to localQueues, key={}", (Object)uri);
            DME2JMSTemporaryQueue tempQueue = (DME2JMSTemporaryQueue)temporaryQueue;
            QueueSession session = tempQueue.getQueueSession();
            QueueConnection connection = tempQueue.getQueueConnection();
            List<String> cachedQueueSessions = this.tempQueueSessions.get(session);
            if (cachedQueueSessions != null) {
                if (!cachedQueueSessions.contains(tempQueue.getURI().toString())) {
                    Map<QueueSession, List<String>> map2 = this.tempQueueSessions;
                    synchronized (map2) {
                        cachedQueueSessions.add(tempQueue.getURI().toString());
                    }
                }
            } else {
                ArrayList<String> queueList = new ArrayList<String>();
                queueList.add(tempQueue.getURI().toString());
                map = this.tempQueueSessions;
                synchronized (map) {
                    this.tempQueueSessions.put(session, queueList);
                }
            }
            if ((cachedQueueConnections = this.tempQueueConnections.get(connection)) != null) {
                if (!cachedQueueConnections.contains(tempQueue.getURI().toString())) {
                    map = this.tempQueueConnections;
                    synchronized (map) {
                        cachedQueueConnections.add(tempQueue.getURI().toString());
                    }
                }
            } else {
                ArrayList<String> queueList = new ArrayList<String>();
                queueList.add(tempQueue.getURI().toString());
                Map<QueueConnection, List<String>> map3 = this.tempQueueConnections;
                synchronized (map3) {
                    this.tempQueueConnections.put(connection, queueList);
                }
            }
            map = this.localQueues;
            synchronized (map) {
                this.localQueues.put(uri.toString(), temporaryQueue);
            }
        }
        catch (Exception e) {
            throw DME2JMSExceptionHandler.handleException(e, uri.toString());
        }
        logger.debug(null, "addTemporaryQueue", LogMessage.METHOD_EXIT);
    }

    protected DME2JMSQueue getTemporaryQueue(URI uri) {
        return this.localQueues.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTemporaryQueue(URI uri) throws JMSException {
        block16: {
            long start = System.currentTimeMillis();
            logger.debug((URI)null, "removeTemporaryQueue", (LogMessage)JMSLogMessage.QUEUE_REMOVETMP, (Object)uri);
            try {
                logger.debug((URI)null, "removeTemporaryQueue", "Code=Trace.DME2JMSManager.removeTemporaryQueue;Removing temporary queue {}", (Object)uri);
                Map<String, DME2JMSQueue> map = this.localQueues;
                synchronized (map) {
                    if (this.localQueues.containsKey(uri.toString())) {
                        logger.debug((URI)null, "removeTemporaryQueue", "Code=Trace.DME2JMSManager.removeTemporaryQueue; Removing temporary queue {}", (Object)uri);
                        DME2JMSQueue queue = this.localQueues.remove(uri.toString());
                        this.tempQueueReceivers.remove(queue);
                    }
                }
                boolean deleteQueueFromConnCache = this.config.getBoolean("AFT_DME2_REMOVE_QUEUE_CONN_CACHE");
                if (!deleteQueueFromConnCache) break block16;
                ArrayList<QueueConnection> connList = new ArrayList<QueueConnection>();
                Map<QueueConnection, List<String>> map2 = this.tempQueueConnections;
                synchronized (map2) {
                    connList.addAll(this.tempQueueConnections.keySet());
                }
                if (connList != null) {
                    for (QueueConnection qc : connList) {
                        List<String> qs = this.tempQueueConnections.get(qc);
                        ArrayList<String> qnameList = new ArrayList<String>();
                        qnameList.addAll(qs);
                        try {
                            if (!qnameList.contains(uri.toURL().toString())) continue;
                            Map<QueueConnection, List<String>> map3 = this.tempQueueConnections;
                            synchronized (map3) {
                                logger.debug((URI)null, "removeTemporaryQueue", "DME2JMSManager.removeTemporaryQueue;Removing temporary queue {} from connection cache list", (Object)uri.toString());
                                qs.remove(uri.toURL().toString());
                            }
                        }
                        catch (MalformedURLException e) {
                            logger.debug((URI)null, "removeTemporaryQueue", "MalformedURLException {}", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
                        }
                    }
                }
                logger.debug((URI)null, "removeTemporaryQueue", "DME2JMSManager.removeTemporaryQueue; elapsedTime={} ms", (Object)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                throw DME2JMSExceptionHandler.handleException(e, uri.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTemporaryQueues(QueueSession session) throws JMSException {
        logger.debug(null, "closeTemporaryQueues", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "closeTemporaryQueues", (LogMessage)JMSLogMessage.QUEUE_CLOSETMP, (Object)session);
        List<String> queueSessionList = this.tempQueueSessions.get(session);
        if (queueSessionList != null) {
            for (String qs : queueSessionList) {
                DME2JMSQueue queue = this.localQueues.get(qs);
                if (!(queue instanceof DME2JMSTemporaryQueue)) continue;
                this.removeTemporaryQueue(((DME2JMSTemporaryQueue)queue).getURI());
            }
        }
        Map<QueueSession, List<String>> map = this.tempQueueSessions;
        synchronized (map) {
            this.tempQueueSessions.remove(session);
        }
        logger.debug(null, "closeTemporaryQueues", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTemporaryQueues(QueueConnection connection) throws JMSException {
        logger.debug(null, "closeTemporaryQueues", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "closeTemporaryQueues", "Closing temporary queues for connection ", (Object)connection);
        List<String> queueConnsList = this.tempQueueConnections.get(connection);
        if (queueConnsList != null) {
            for (String qs : queueConnsList) {
                DME2JMSQueue queue = this.localQueues.get(qs);
                if (!(queue instanceof DME2JMSTemporaryQueue)) continue;
                DME2JMSTemporaryQueue tmpQueue = (DME2JMSTemporaryQueue)queue;
                QueueSession queueSession = tmpQueue.getQueueSession();
                this.removeTemporaryQueue(((DME2JMSTemporaryQueue)queue).getURI());
                Map<QueueSession, List<String>> map = this.tempQueueSessions;
                synchronized (map) {
                    this.tempQueueSessions.remove(queueSession);
                }
            }
        }
        Map<QueueConnection, List<String>> map = this.tempQueueConnections;
        synchronized (map) {
            this.tempQueueConnections.remove(connection);
        }
        logger.debug(null, "closeTemporaryQueues", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DME2JMSQueue getQueue(String newQueuePath) throws JMSException, URISyntaxException {
        DME2JMSQueue lqueue;
        block18: {
            String queuePath = newQueuePath;
            logger.debug((URI)null, "getQueue", "queuePath [{}].", (Object)queuePath);
            logger.debug((URI)null, "getQueue", LogMessage.METHOD_ENTER, (Object)queuePath);
            lqueue = null;
            try {
                URI uri = new URI(queuePath);
                if (queuePath.contains("//DME2LOCAL/")) {
                    Object queuePathScheme;
                    String uriPath;
                    String[] tmpUri;
                    String queuePathUri;
                    DME2UniformResource uniformResource;
                    String lrmRO = System.getProperty("lrmRO");
                    try {
                        uniformResource = new DME2UniformResource(this.config, new URL(uri.getScheme(), uri.getHost(), uri.getPort(), queuePath, new DME2UrlStreamHandler()));
                    }
                    catch (MalformedURLException e) {
                        throw new DME2JMSException("AFT-DME2-0607", new ErrorContext().add(EXTENDEDMESSAGE, e.getMessage()).add("URI", uri.toString()), (Throwable)e);
                    }
                    if (lrmRO != null) {
                        String inRouteOffer;
                        String tempPath = uri.getPath();
                        String qstr = uri.getQuery();
                        if (tempPath != null && (inRouteOffer = uniformResource.getRouteOffer()) != null) {
                            lrmRO = lrmRO.replaceAll("'", "");
                            tempPath = tempPath.replace(ROUTEOFFER + inRouteOffer, ROUTEOFFER + lrmRO);
                            logger.debug((URI)null, "getQueue", "Changed queuePath [{}] to [{}] due to local LRM configuration", (Object)queuePath, (Object)tempPath);
                            queuePath = qstr != null ? tempPath + "?" + qstr : tempPath;
                        }
                    }
                    if ((lqueue = this.localQueues.get(queuePathUri = (tmpUri = (uriPath = uri.toString()).split(SLASHSLASH))[0])) == null) {
                        queuePathScheme = queuePath.replace("http://", "DME2://");
                        uri = new URI((String)queuePathScheme);
                        uriPath = uri.toString();
                        tmpUri = uriPath.split(SLASHSLASH);
                        queuePathUri = tmpUri[0];
                        lqueue = this.localQueues.get(queuePathUri);
                    }
                    if (lqueue != null) break block18;
                    logger.debug(null, "getQueue", "queuePathUri={} {} {};localQueues={}", queuePathUri, DME2JMSMANAGER, this, this.localQueues);
                    queuePathScheme = this.localQueues;
                    synchronized (queuePathScheme) {
                        lqueue = this.localQueues.get(uri.getPath());
                        if (lqueue == null) {
                            logger.debug(null, "getQueue", "uri.getPath={} {} {};localQueues={}", uri.getPath(), DME2JMSMANAGER, this, this.localQueues);
                            if (uri != null) {
                                try {
                                    logger.debug((URI)null, "getQueue", "queuePath [{}] uri [{}]", (Object)queuePath, (Object)uri.toString());
                                }
                                catch (Exception e) {
                                    logger.debug((URI)null, "getQueue", "Exception", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
                                }
                            }
                            lqueue = new DME2JMSLocalQueue(this, uri, false);
                            this.localQueues.put(queuePathUri, lqueue);
                        }
                    }
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("EVENT_TIME", System.currentTimeMillis());
                    props.put("INIT_EVENT", true);
                    props.put("QUEUE_NAME", lqueue.getQueueName());
                    props.put("DME2_INTERFACE_PROTOCOL", this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL"));
                    this.getDME2Manager().postStatEvent(props);
                    break block18;
                }
                if (queuePath.contains("//DME2REPLY/")) {
                    String uriPath = new URI(queuePath).getPath();
                    StringTokenizer tokens = new StringTokenizer(uriPath, "/");
                    if (tokens.countTokens() > 0) {
                        String corrId = tokens.nextToken();
                        lqueue = this.contQueues.get(corrId);
                        logger.debug(null, "getQueueFromCache", "Returning continuation queue for corrId=", corrId, "; Continuation queue=", lqueue);
                    }
                } else {
                    lqueue = new DME2JMSRemoteQueue(this, uri);
                }
            }
            catch (Exception e) {
                throw DME2JMSExceptionHandler.handleException(e, queuePath);
            }
        }
        logger.debug(null, "getQueueFromCache", LogMessage.METHOD_EXIT);
        return lqueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DME2JMSQueue getQueueFromCache(String newQueuePath) throws JMSException, URISyntaxException {
        String queuePath = newQueuePath;
        logger.debug((URI)null, "getQueueFromCache", LogMessage.METHOD_ENTER, (Object)queuePath);
        DME2JMSQueue lqueue = null;
        try {
            String uriPath;
            StringTokenizer tokens;
            URI uri = new URI(queuePath);
            if (queuePath.contains("//DME2LOCAL/")) {
                String uriPath2;
                String[] tmpUri;
                String queuePathUri;
                String inRouteOffer;
                String tempPath;
                DME2UniformResource uniformResource;
                String lrmRO = System.getProperty("lrmRO");
                try {
                    uniformResource = new DME2UniformResource(this.config, uri);
                }
                catch (MalformedURLException e) {
                    throw new DME2JMSException("AFT-DME2-0607", new ErrorContext().add(EXTENDEDMESSAGE, e.getMessage()).add("URI", uri.toString()), (Throwable)e);
                }
                if (lrmRO != null && (tempPath = uri.getPath()) != null && (inRouteOffer = uniformResource.getRouteOffer()) != null) {
                    lrmRO = lrmRO.replaceAll("'", "");
                    tempPath = tempPath.replace(ROUTEOFFER + inRouteOffer, ROUTEOFFER + lrmRO);
                    logger.debug(null, "getQueueFromCache", "DME2JMSManager.getQueueFromCache(..) - Changed queuePath [", queuePath, "] to [", tempPath, "] due to local LRM configuration.");
                    queuePath = tempPath;
                }
                if ((lqueue = this.localQueues.get(queuePathUri = (tmpUri = (uriPath2 = uri.toString()).split(SLASHSLASH))[0])) == null) {
                    String queuePathScheme = queuePath.replace("http://", "DME2://");
                    uri = new URI(queuePathScheme);
                    uriPath2 = uri.toString();
                    tmpUri = uriPath2.split(SLASHSLASH);
                    queuePathUri = tmpUri[0];
                    lqueue = this.localQueues.get(queuePathUri);
                }
                if (lqueue == null) {
                    logger.debug(null, "getQueueFromCache", "queuePathUri=", queuePathUri, DME2JMSMANAGER, this, ";localQueues=", this.localQueues);
                    Map<String, DME2JMSQueue> map = this.localQueues;
                    synchronized (map) {
                        lqueue = this.localQueues.get(uri.getPath());
                        if (lqueue == null) {
                            logger.debug(null, "getQueueFromCache", "getQueueFromCache uri.getPath=", uri.getPath(), DME2JMSMANAGER, this, ";localQueues=", this.localQueues);
                            return lqueue;
                        }
                    }
                }
                return lqueue;
            }
            if (queuePath.contains("//DME2REPLY/") && (tokens = new StringTokenizer(uriPath = new URI(queuePath).getPath(), "/")).countTokens() > 0) {
                String corrId = tokens.nextToken();
                lqueue = this.contQueues.get(corrId);
                logger.debug(null, "getQueueFromCache", "Returning continuation queue for corrId=", corrId, "; Continuation queue=", lqueue);
                return lqueue;
            }
        }
        catch (Exception e) {
            throw DME2JMSExceptionHandler.handleException(e, queuePath);
        }
        return lqueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DME2JMSQueue getQueue(String queuePath, boolean client) throws JMSException, URISyntaxException {
        DME2UniformResource uniformResource;
        logger.debug((URI)null, "getQueue", LogMessage.METHOD_ENTER, (Object)queuePath);
        URI uri = new URI(queuePath);
        if (queuePath.startsWith("http://DME2LOCAL/")) {
            DME2JMSQueue lqueue = this.localQueues.get(uri.toString());
            if (lqueue == null) {
                Map<String, DME2JMSQueue> map = this.localQueues;
                synchronized (map) {
                    lqueue = this.localQueues.get(uri.getPath());
                    if (lqueue == null) {
                        lqueue = new DME2JMSLocalQueue(this, uri, false);
                        lqueue.setClient(client);
                        this.localQueues.put(uri.toString(), lqueue);
                    }
                }
            }
            return lqueue;
        }
        try {
            uniformResource = new DME2UniformResource(this.config, new URL(uri.getScheme(), uri.getHost(), uri.getPort(), queuePath, new DME2UrlStreamHandler()));
        }
        catch (MalformedURLException e) {
            throw new DME2JMSException("AFT-DME2-0607", new ErrorContext().add(EXTENDEDMESSAGE, e.getMessage()).add("URI", uri.toString()), (Throwable)e);
        }
        StringBuffer modUriStr = new StringBuffer();
        if (uniformResource.getUserName() == null && uniformResource.getPassword() == null) {
            modUriStr.append(uri.toString());
            if (modUriStr.toString().contains("?")) {
                if (this.userName != null && this.password != null) {
                    modUriStr.append("&username=" + this.userName);
                    modUriStr.append("&password=" + this.password);
                }
            } else if (this.userName != null && this.password != null) {
                modUriStr.append("?username=" + this.userName);
                modUriStr.append("&password=" + this.password);
            }
        }
        logger.debug((URI)null, "getQueue", "modUriString=", (Object)modUriStr);
        return new DME2JMSRemoteQueue(this, new URI(modUriStr.toString()));
    }

    public DME2JMSMessage createMessage(Map<String, String> headers, int code, String text) throws JMSException {
        logger.debug(null, "createMessage", LogMessage.METHOD_ENTER);
        DME2JMSTextMessage m = new DME2JMSTextMessage();
        m.setText(text);
        for (String key : headers.keySet()) {
            m.setStringProperty(key, headers.get(key));
        }
        logger.debug(null, "createMessage", LogMessage.METHOD_EXIT);
        return m;
    }

    public DME2JMSMessage createMessage(InputStream inputStream, Map<String, String> parameterMap) throws JMSException, URISyntaxException, UnsupportedEncodingException {
        String charset = null;
        try {
            charset = parameterMap.get("Content-Type");
            if (charset == null) {
                charset = parameterMap.get("content-type");
            }
            if (charset != null) {
                String[] toks = charset.split(";");
                if (toks.length > 1) {
                    charset = toks[1];
                    String[] toks2 = toks[1].split("=");
                    charset = toks2.length > 1 ? toks2[1] : null;
                } else {
                    charset = null;
                }
            }
        }
        catch (Exception e) {
            DME2JMSExceptionHandler.handleException(e, "Not Specified");
        }
        logger.debug((URI)null, "createMessage", "charset is: {}", (Object)charset);
        return this.createMessage(inputStream, parameterMap, charset);
    }

    public DME2JMSMessage createMessage(InputStream inputStream, Map<String, String> parameterMap, String newCharset) throws JMSException, URISyntaxException, UnsupportedEncodingException {
        logger.debug(null, "createMessage", LogMessage.METHOD_ENTER);
        String charset = newCharset;
        DME2JMSTextMessage m = null;
        try {
            if (charset == null) {
                charset = this.manager.getCharacterSet();
            }
            m = new DME2JMSTextMessage();
            for (String key : parameterMap.keySet()) {
                String value = parameterMap.get(key);
                if (key == null || value == null) continue;
                if ("JMSMessageID".equals(key) || this.config.getProperty("DME2_HEADER_PREFIX").concat("JMSMessageID").equals(key)) {
                    m.setJMSMessageID(value);
                    continue;
                }
                if ("JMSCorrelationID".equals(key) || this.config.getProperty("DME2_HEADER_PREFIX").concat("JMSCorrelationID").equals(key)) {
                    m.setJMSCorrelationID(value);
                    continue;
                }
                if ("JMSType".equals(key)) {
                    m.setJMSType(value);
                    continue;
                }
                if ("JMSDeliveryMode".equals(key)) {
                    m.setJMSDeliveryMode(Integer.parseInt(value));
                    continue;
                }
                if ("JMSExpiration".equals(key)) {
                    m.setJMSExpiration(Long.parseLong(value));
                    continue;
                }
                if ("JMSPriority".equals(key)) {
                    m.setJMSPriority(Integer.parseInt(value));
                    continue;
                }
                if ("JMSTimestamp".equals(key)) {
                    m.setJMSTimestamp(Long.parseLong(value));
                    continue;
                }
                if ("JMSDestination".equals(key) || this.config.getProperty("DME2_HEADER_PREFIX").concat("JMSDestination").equals(key)) {
                    m.setJMSDestination((Destination)this.getQueue(value));
                    continue;
                }
                if ("JMSReplyTo".equals(key)) {
                    m.setJMSReplyTo((Destination)this.getQueue(value));
                    continue;
                }
                if ("JMSRedelivered".equals(key)) {
                    m.setJMSRedelivered(Boolean.parseBoolean(value));
                    continue;
                }
                m.setStringProperty(key, value);
            }
            GZIPInputStream gis = null;
            if (parameterMap != null && parameterMap.get(this.config.getBoolean("AFT_DME2_CONTENT_ENCODING_KEY")) != null && this.config.getBoolean("AFT_DME2_ALLOW_COMPRESS_ENCODING") && parameterMap.get(this.config.getProperty("AFT_DME2_CONTENT_ENCODING_KEY")).equalsIgnoreCase(this.config.getProperty("AFT_DME2_COMPRESS_ENCODING"))) {
                try {
                    gis = new GZIPInputStream(inputStream);
                }
                catch (Exception e) {
                    JMSException j = new JMSException("UNABLE TO READ COMPRESSED INPUT JMS MESSAGE");
                    j.initCause((Throwable)e);
                    throw new DME2JMSException("AFT-DME2-5501", new ErrorContext().add("manager", this.manager.getName()), (Throwable)j);
                }
            }
            BufferedReader reader = null;
            try {
                if (charset != null && !charset.equals("null")) {
                    logger.debug((URI)null, "createMessage(InputStream,Map<String,String>,String)", "charset is: {}", (Object)charset);
                    reader = gis != null ? new BufferedReader(new InputStreamReader(gis, charset)) : new BufferedReader(new InputStreamReader(inputStream, charset));
                } else {
                    reader = gis == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(gis));
                }
                char[] buffer = new char[8096];
                StringBuilder inputText = new StringBuilder(8096);
                int n = -1;
                while ((n = reader.read(buffer)) != -1) {
                    inputText.append(buffer, 0, n);
                }
                m.setText(inputText.toString());
            }
            catch (IOException e) {
                JMSException j = new JMSException("UNABLE TO READ INPUT JMS MESSAGE");
                j.initCause((Throwable)e);
                throw new DME2JMSException("AFT-DME2-5501", new ErrorContext().add("manager", this.manager.getName()), (Throwable)j);
            }
        }
        catch (Exception e) {
            DME2JMSExceptionHandler.handleException(e, "Not Specified");
        }
        logger.debug(null, "createMessage", LogMessage.METHOD_EXIT);
        return m;
    }

    public void streamMessage(DME2JMSMessage m, PrintWriter writer) throws JMSException, IOException {
        logger.debug(null, "streamMessage", LogMessage.METHOD_ENTER);
        DME2JMSTextMessage m1 = (DME2JMSTextMessage)m;
        logger.debug((URI)null, "streamMessage", (LogMessage)JMSLogMessage.CONTENTS, (Object)m1.getText());
        writer.print(m1.getText());
        logger.debug(null, "streamMessage", LogMessage.METHOD_EXIT);
    }

    public void streamMessage(DME2JMSMessage m, OutputStream outputStream) throws JMSException, IOException {
        logger.debug(null, "streamMessage", LogMessage.METHOD_ENTER);
        DME2JMSTextMessage m1 = (DME2JMSTextMessage)m;
        logger.debug((URI)null, "streamMessage", (LogMessage)JMSLogMessage.CONTENTS, (Object)m1.getText());
        String charset = m.getStringProperty("com.att.aft.dme2.charset");
        if (charset == null && (charset = m.getStringProperty("com.att.aft.dme2.jms.charset")) == null) {
            charset = this.manager.getCharacterSet();
        }
        if (charset != null && charset.equals("null")) {
            charset = null;
        }
        if (charset == null) {
            outputStream.write(m1.getText().getBytes());
        } else {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
            writer.append(m1.getText());
            writer.close();
        }
        logger.debug(null, "streamMessage", LogMessage.METHOD_EXIT);
    }

    protected synchronized DME2JMSQueueConnectionFactory getQCF(String path) throws URISyntaxException {
        logger.debug(null, "getQCF", LogMessage.METHOD_ENTER);
        DME2JMSQueueConnectionFactory factory = this.qcfs.get(path);
        if (factory == null) {
            factory = new DME2JMSQueueConnectionFactory(this, path);
            this.qcfs.put(path, factory);
        }
        logger.debug(null, "getQCF", LogMessage.METHOD_EXIT);
        return factory;
    }

    protected synchronized DME2JMSXAQueueConnectionFactory getXAQCF(String path) throws URISyntaxException {
        logger.debug(null, "getXAQCF", LogMessage.METHOD_ENTER);
        DME2JMSXAQueueConnectionFactory factory = this.xaqcfs.get(path);
        if (factory == null) {
            factory = new DME2JMSXAQueueConnectionFactory(this, path);
            this.qcfs.put(path, factory);
        }
        logger.debug(null, "getXAQCF", LogMessage.METHOD_EXIT);
        return factory;
    }

    protected synchronized DME2JMSTopicConnectionFactory getDummyTCF(String path) throws URISyntaxException {
        logger.debug(null, "getDummyTCF", LogMessage.METHOD_ENTER);
        DME2JMSTopicConnectionFactory factory = this.tcfs.get(path);
        if (factory == null) {
            factory = new DME2JMSTopicConnectionFactory();
            this.tcfs.put(path, factory);
        }
        logger.debug(null, "getDummyTCF", LogMessage.METHOD_EXIT);
        return factory;
    }

    public DME2JMSMessage createErrorMessage(Throwable e, Map<String, String> responseHeaders) throws JMSException {
        logger.debug(null, "createErrorMessage", LogMessage.METHOD_ENTER);
        DME2JMSException j = new DME2JMSException(e.getMessage());
        j.initCause(e);
        DME2JMSErrorMessage m = null;
        if (j.getMessage() != null && j.getMessage().contains("AFT-DME2-0703")) {
            m = new DME2JMSErrorMessage(j, true);
            String traceInfo = responseHeaders.get("AFT_DME2_REQ_TRACE_INFO");
            if (traceInfo != null) {
                m.setStringProperty("AFT_DME2_REQ_TRACE_INFO", traceInfo);
            }
        } else {
            m = new DME2JMSErrorMessage(j);
        }
        String c = responseHeaders.get("JMSCorrelationID");
        if (c != null) {
            m.setJMSCorrelationID(c);
        } else {
            String msgId = responseHeaders.get("JMSMessageID");
            if (msgId == null) {
                msgId = responseHeaders.get(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSMessageID");
            }
            m.setJMSCorrelationID(msgId);
        }
        logger.debug(null, "createErrorMessage", LogMessage.METHOD_EXIT);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupTemporaryQueues(int policy) {
        QueueConnection connection;
        logger.debug(null, "cleanupTemporaryQueues", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "cleanupTemporaryQueues", "DME2JMSManager.cleanupTemporaryQueues entering; localQueues size={}", (Object)this.localQueues.size());
        ArrayList<String> qList = new ArrayList<String>();
        Map<String, DME2JMSQueue> map = this.localQueues;
        synchronized (map) {
            qList.addAll(this.localQueues.keySet());
        }
        ArrayList<DME2JMSTemporaryQueue> closeableQs = new ArrayList<DME2JMSTemporaryQueue>();
        ArrayList<DME2JMSLocalQueue> localCloseableQs = new ArrayList<DME2JMSLocalQueue>();
        for (String qname : qList) {
            DME2JMSQueue queue = this.localQueues.get(qname);
            logger.debug(null, "cleanupTemporaryQueues", "DME2JMSManager.cleanupTemporaryQueues; qname=", qname, ";queueObj=", queue);
            if (queue instanceof DME2JMSTemporaryQueue) {
                DME2JMSTemporaryQueue tempQueue = (DME2JMSTemporaryQueue)queue;
                QueueConnection qConnection = tempQueue.getQueueConnection();
                QueueSession qSession = tempQueue.getQueueSession();
                logger.debug(null, "cleanupTemporaryQueues", "DME2JMSManager.cleanupTemporaryQueues; qname={};qsession={};qConn={}", qname, qSession, qConnection);
                if (qConnection == null || qSession == null) {
                    closeableQs.add(tempQueue);
                    continue;
                }
                logger.debug(null, "cleanupTemporaryQueues", "DME2JMSManager.cleanupTemporaryQueues; qname={} isClosed()");
                switch (policy) {
                    case 2: {
                        if (!tempQueue.isClosed()) break;
                        closeableQs.add(tempQueue);
                    }
                }
                continue;
            }
            if (!(queue instanceof DME2JMSLocalQueue)) continue;
            try {
                DME2JMSLocalQueue lqueue = (DME2JMSLocalQueue)this.localQueues.get(qname);
                if (!qname.contains("DME2LOCAL") || qname.contains("version=") || qname.contains("routeoffer=") || qname.contains("service=") || !lqueue.isClient() || lqueue.getCreateTime() + this.manager.getConfig().getLong("DME2_LOCAL_CLIENT_QUEUE_EXPIRES_AFTER") > System.currentTimeMillis()) continue;
                try {
                    logger.debug((URI)null, "cleanupTemporaryQueues", "Adding LocalQueue to be removed with createTime={}; QueueName={}", (Object)lqueue.getCreateTime(), (Object)lqueue.getQueueName());
                    localCloseableQs.add(lqueue);
                }
                catch (Exception e) {
                    logger.debug((URI)null, "cleanupTemporaryQueue", "Exception {}", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
                }
                for (DME2JMSLocalQueue lq : localCloseableQs) {
                    logger.debug((URI)null, "cleanupTemporaryQueue", "Removing local queue with qname {}", (Object)lq.getQueueName());
                    Map<String, DME2JMSQueue> map2 = this.localQueues;
                    synchronized (map2) {
                        this.localQueues.remove(lq);
                    }
                }
            }
            catch (JMSException e) {
                logger.error((URI)null, "cleanupTemporaryQueue", "AFT-DME2-6302 {}", (Object)new ErrorContext().add("Queue", qname), (Object)e);
            }
        }
        logger.debug((URI)null, "cleanupTemporaryQueues", "Removing from localQueues, closeableQs size={}", (Object)closeableQs.size());
        for (DME2JMSTemporaryQueue q : closeableQs) {
            logger.debug((URI)null, "cleanupTemporaryQueues", "Deleting temporary queue {}", (Object)q);
            QueueSession session = q.getQueueSession();
            connection = q.getQueueConnection();
            try {
                q.delete();
                Object e = this.localQueues;
                synchronized (e) {
                    this.localQueues.remove(q.getURI().toString());
                    this.tempQueueReceivers.remove(q.getQueueName());
                }
                e = this.tempQueueSessions;
                synchronized (e) {
                    this.tempQueueSessions.remove(session);
                }
                e = this.tempQueueConnections;
                synchronized (e) {
                    this.tempQueueConnections.remove(connection);
                }
                logger.debug((URI)null, "cleanupTemporaryQueues", "DME2JMSManager.cleanupTemporaryQueues key={} removed temporary queue successfully", (Object)q.getURI());
            }
            catch (JMSException e) {
                logger.debug((URI)null, "cleanupTemporaryQueues", "AFT-DME2-6302 {}", (Object)new ErrorContext().add("Queue", q.getURI().toString()), (Object)e);
            }
        }
        long start = System.currentTimeMillis();
        ArrayList<QueueSession> sessionList = new ArrayList<QueueSession>();
        connection = this.tempQueueSessions;
        synchronized (connection) {
            sessionList.addAll(this.tempQueueSessions.keySet());
        }
        int count = 0;
        if (sessionList != null) {
            for (QueueSession qs : sessionList) {
                List<String> qlist = this.tempQueueSessions.get(qs);
                ArrayList<String> qnameList = new ArrayList<String>();
                qnameList.addAll(qlist);
                for (String qname : qnameList) {
                    if (this.localQueues.get(qname) != null) continue;
                    Map<QueueSession, List<String>> map3 = this.tempQueueSessions;
                    synchronized (map3) {
                        logger.debug((URI)null, "cleanupTemporaryQueues", "deleting queue {}", (Object)qname);
                        qlist.remove(qname);
                        ++count;
                    }
                }
            }
        }
        logger.debug((URI)null, "cleanupTemporaryQueues", "deleted cached queue sessions;count={};elapsedTime={} ms", (Object)count, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ArrayList<QueueConnection> connList = new ArrayList<QueueConnection>();
        Map<QueueConnection, List<String>> map4 = this.tempQueueConnections;
        synchronized (map4) {
            connList.addAll(this.tempQueueConnections.keySet());
        }
        count = 0;
        if (connList != null) {
            for (QueueConnection qc : connList) {
                List<String> qs = this.tempQueueConnections.get(qc);
                ArrayList<String> qnameList = new ArrayList<String>();
                qnameList.addAll(qs);
                for (String qname : qnameList) {
                    if (this.localQueues.get(qname) != null) continue;
                    Map<QueueConnection, List<String>> map5 = this.tempQueueConnections;
                    synchronized (map5) {
                        logger.debug((URI)null, "cleanupTemporaryQueues", "deleting queue {}", (Object)qname);
                        qs.remove(qname);
                        ++count;
                    }
                }
            }
        }
        logger.debug((URI)null, "cleanupTemporaryQueues", "deleted cached connection queues;count={};elapsedTime={} ms", (Object)count, (Object)(System.currentTimeMillis() - start));
        logger.debug(null, "cleanupTemporaryQueues", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupContinuationQueues() {
        logger.debug(null, "cleanupContinuationQueues", LogMessage.METHOD_ENTER);
        ArrayList<String> qList = new ArrayList<String>();
        qList.addAll(this.contQueues.keySet());
        ArrayList<String> removableQs = new ArrayList<String>();
        for (String msgId : qList) {
            DME2JMSContinuationQueue tempQueue;
            DME2JMSQueue queue = this.contQueues.get(msgId);
            if (!(queue instanceof DME2JMSContinuationQueue) || (tempQueue = (DME2JMSContinuationQueue)queue).getCreateTime() + this.config.getLong("AFT_DME2_CONT_QUEUE_EXPIRES_AFTER") > System.currentTimeMillis()) continue;
            try {
                logger.debug(null, "cleanupContinuationQueues", "Adding ContQueue to be removed with createTime={}; QueueName={}; msgId={}", tempQueue.getCreateTime(), tempQueue.getQueueName(), msgId);
            }
            catch (Exception e) {
                logger.debug((URI)null, "cleanupContinuationQueues", "Exception {}", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
            }
            removableQs.add(msgId);
        }
        for (String msgid : removableQs) {
            logger.debug((URI)null, "cleanupContinuationQueues", "Deleting continuation queue for message id {}", (Object)msgid);
            Map<String, DME2JMSContinuationQueue> map = this.contQueues;
            synchronized (map) {
                this.contQueues.remove(msgid);
            }
        }
        logger.debug(null, "cleanupContinuationQueues", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeContinuation(String msgId) {
        Map<String, DME2JMSContinuationQueue> map = this.contQueues;
        synchronized (map) {
            this.contQueues.remove(msgId);
            return true;
        }
    }

    public void addContinuation(String msgId, DME2JMSContinuationQueue contQueue) {
        this.contQueues.put(msgId, contQueue);
    }

    public DME2Manager getDME2Manager() {
        return this.manager;
    }

    public void setClientCredentials(String username, String password) {
        this.userName = username;
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueReceiverToMap(Queue queue, DME2JMSQueueReceiver receiver) {
        try {
            List<DME2JMSQueueReceiver> receivers = this.tempQueueReceivers.get(queue.getQueueName());
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                if (receivers == null) {
                    receivers = new ArrayList<DME2JMSQueueReceiver>();
                    receivers.add(receiver);
                    this.tempQueueReceivers.put(queue.getQueueName(), receivers);
                } else {
                    receivers.add(receiver);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (JMSException e) {
            logger.warn((URI)null, "addQueueReceiverToMap", "AFT-DME2-6110 {}", (Object)new ErrorContext(), (Object)e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueReceiverFromMap(Queue queue, DME2JMSQueueReceiver receiver) {
        try {
            List<DME2JMSQueueReceiver> receivers = this.tempQueueReceivers.get(queue.getQueueName());
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                if (receivers != null && !receivers.isEmpty() && receivers.contains(receiver)) {
                    receivers.remove(receiver);
                    if (receivers.size() == 0) {
                        this.tempQueueReceivers.remove(queue.getQueueName());
                    }
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (JMSException e) {
            logger.warn((URI)null, "removeQueueReceiverFromMap", "AFT-DME2-6110 {}", (Object)new ErrorContext(), (Object)e);
        }
        {
            return;
        }
    }

    public boolean containsQueueReceivers(Queue queue) {
        try {
            List<DME2JMSQueueReceiver> receivers = this.tempQueueReceivers.get(queue.getQueueName());
            if (receivers != null && receivers.size() > 0) {
                return true;
            }
        }
        catch (JMSException e) {
            logger.warn((URI)null, "containsQueueReceivers", "AFT-DME2-6110 {}", (Object)new ErrorContext(), (Object)e);
        }
        return false;
    }

    public List<DME2JMSQueueReceiver> getQueueReceivers(Queue queue) {
        List<DME2JMSQueueReceiver> receivers = null;
        try {
            receivers = this.tempQueueReceivers.get(queue.getQueueName());
        }
        catch (JMSException e) {
            logger.warn((URI)null, "containsQueueReceivers", "AFT-DME2-6110 {}", (Object)new ErrorContext(), (Object)e);
        }
        return receivers;
    }

    public Map<String, DME2JMSQueue> getLocalQueues() {
        Map<String, DME2JMSQueue> readOnlyMap = Collections.unmodifiableMap(this.localQueues);
        return this.localQueues;
    }

    int getMSG_PARSING_BUFFER() {
        return 8096;
    }
}

