/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public abstract class DME2JMSMessage
implements Message {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSMessage.class.getName());
    private final Properties props = new Properties();
    private Destination destination;
    private Destination replyTo;

    protected void genID() {
        String id = "ID:" + UUID.randomUUID();
        this.props.setProperty("JMSMessageID", id);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void acknowledge() throws JMSException {
    }

    public void clearProperties() throws JMSException {
        this.props.clear();
    }

    public boolean getBooleanProperty(String key) throws JMSException {
        return Boolean.parseBoolean(this.props.getProperty(key));
    }

    public byte getByteProperty(String key) throws JMSException {
        return Byte.parseByte(this.props.getProperty(key));
    }

    public double getDoubleProperty(String key) throws JMSException {
        return Double.parseDouble(this.props.getProperty(key));
    }

    public float getFloatProperty(String key) throws JMSException {
        return Float.parseFloat(this.props.getProperty(key));
    }

    public int getIntProperty(String key) throws JMSException {
        return Integer.parseInt(this.props.getProperty(key));
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.props.getProperty("JMSCorrelationID");
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        String id = this.props.getProperty("JMSCorrelationID");
        if (id != null) {
            return id.getBytes();
        }
        return null;
    }

    public int getJMSDeliveryMode() throws JMSException {
        String s = this.props.getProperty("JMSDeliverMode");
        if (s != null) {
            return Integer.parseInt(s);
        }
        return 1;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public long getJMSExpiration() throws JMSException {
        String s = this.props.getProperty("JMSExpiration");
        if (s != null) {
            return Long.parseLong(s);
        }
        return -1L;
    }

    public String getJMSMessageID() throws JMSException {
        return this.props.getProperty("JMSMessageID");
    }

    public int getJMSPriority() throws JMSException {
        String s = this.props.getProperty("JMSPriority");
        if (s != null) {
            return Integer.parseInt(s);
        }
        return -1;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return Boolean.parseBoolean(this.props.getProperty("JMSRedelivered"));
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        String s = this.props.getProperty("JMSTimestamp");
        if (s != null) {
            return Long.parseLong(s);
        }
        return 0L;
    }

    public String getJMSType() throws JMSException {
        return this.props.getProperty("JMSType");
    }

    public long getLongProperty(String key) throws JMSException {
        String s = this.props.getProperty(key);
        if (s != null) {
            return Long.parseLong(s);
        }
        return 0L;
    }

    public Object getObjectProperty(String key) throws JMSException {
        return this.props.get(key);
    }

    public Enumeration<?> getPropertyNames() throws JMSException {
        return this.props.keys();
    }

    public short getShortProperty(String key) throws JMSException {
        String s = this.props.getProperty(key);
        if (s != null) {
            return Short.parseShort(s);
        }
        return 0;
    }

    public String getStringProperty(String key) throws JMSException {
        return this.props.getProperty(key);
    }

    public boolean propertyExists(String key) throws JMSException {
        return this.props.contains(key);
    }

    public void setBooleanProperty(String key, boolean value) throws JMSException {
        this.props.setProperty(key, Boolean.toString(value));
    }

    public void setByteProperty(String key, byte value) throws JMSException {
        this.props.setProperty(key, Byte.toString(value));
    }

    public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        this.props.setProperty(arg0, Double.toString(arg1));
    }

    public void setFloatProperty(String arg0, float arg1) throws JMSException {
        this.props.setProperty(arg0, Float.toString(arg1));
    }

    public void setIntProperty(String arg0, int arg1) throws JMSException {
        this.props.setProperty(arg0, Integer.toString(arg1));
    }

    public void setJMSCorrelationID(String arg0) throws JMSException {
        if (arg0 != null) {
            this.props.setProperty("JMSCorrelationID", arg0);
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] arg0) throws JMSException {
        if (arg0 != null) {
            this.props.setProperty("JMSCorrelationID", new String(arg0));
        }
    }

    public void setJMSDeliveryMode(int arg0) throws JMSException {
        this.props.setProperty("JMSDeliveryMode", Integer.toString(arg0));
    }

    public void setJMSDestination(Destination arg0) throws JMSException {
        this.destination = arg0;
    }

    public void setJMSExpiration(long arg0) throws JMSException {
        this.props.setProperty("JMSExpiration", Long.toString(arg0));
    }

    public void setJMSMessageID(String arg0) throws JMSException {
        if (this.getJMSMessageID() == null && arg0 != null) {
            this.props.setProperty("JMSMessageID", arg0);
        }
    }

    public void setJMSPriority(int arg0) throws JMSException {
        this.props.setProperty("JMSPriority", Integer.toString(arg0));
    }

    public void setJMSRedelivered(boolean arg0) throws JMSException {
        this.props.setProperty("JMSRedelivered", Boolean.toString(arg0));
    }

    public void setJMSReplyTo(Destination arg0) throws JMSException {
        this.replyTo = arg0;
    }

    public void setJMSTimestamp(long arg0) throws JMSException {
        this.props.setProperty("JMSTimestamp", Long.toString(arg0));
    }

    public void setJMSType(String arg0) throws JMSException {
        if (arg0 != null) {
            this.props.setProperty("JMSType", arg0);
        }
    }

    public void setLongProperty(String arg0, long arg1) throws JMSException {
        this.props.setProperty(arg0, Long.toString(arg1));
    }

    public void setObjectProperty(String key, Object obj) throws JMSException {
        this.checkNullAndEmpty(key);
        if (!(obj instanceof Integer || obj instanceof String || obj instanceof Long || obj instanceof Double || obj instanceof Boolean || obj instanceof Short || obj instanceof Byte || obj instanceof Float || obj instanceof Character || obj == null)) {
            throw new DME2JMSException("AFT-DME2-5600", new ErrorContext().add("JMSProperty-Name", key).add("JMSProperty-Value", obj.toString()));
        }
        if (obj != null) {
            this.props.put(key, obj);
        }
    }

    public void setShortProperty(String arg0, short arg1) throws JMSException {
        this.props.setProperty(arg0, Short.toString(arg1));
    }

    public void setStringProperty(String arg0, String arg1) throws JMSException {
        this.props.setProperty(arg0, arg1);
    }

    public boolean matches(String filter) throws JMSException {
        String[] expressions;
        logger.debug((URI)null, "matches", "DME2JMSMessage matches filter={};messageFilter={}", (Object)filter, (Object)this.getJMSCorrelationID());
        if (filter == null || filter != null && filter.trim().equals("")) {
            logger.debug((URI)null, "matches", "DME2JMSMessage matches filter={};messageFilter={};matches=true", (Object)filter, (Object)this.getJMSCorrelationID());
            return true;
        }
        for (String expression : expressions = filter.split("AND|OR")) {
            String[] toks = expression.split("=");
            if (toks.length < 2) continue;
            String key = toks[0];
            String value = toks[1];
            if (!key.trim().equals("JMSCorrelationID") || this.getJMSCorrelationID() == null || !this.getJMSCorrelationID().trim().equals(value.trim().replaceAll("'", ""))) continue;
            return true;
        }
        return false;
    }

    public boolean isExpired() throws JMSException {
        long expiration = this.getJMSExpiration();
        if (expiration > 0L && expiration < System.currentTimeMillis()) {
            logger.debug((URI)null, "isExpired", "message has expired: ", (Object)this.getJMSMessageID());
            return true;
        }
        return false;
    }

    protected void checkNullAndEmpty(String key) throws JMSException {
        if (key == null) {
            throw new DME2JMSException("AFT-DME2-5601", new ErrorContext().add("JMSProperty-Name", key));
        }
        if (key == "") {
            throw new DME2JMSException("AFT-DME2-5601", new ErrorContext().add("JMSProperty-Name", key));
        }
    }
}

