/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSErrorMessage;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSLocalQueue;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSServiceHolder;
import com.att.aft.dme2.jms.DME2JMSServlet;
import com.att.aft.dme2.jms.DME2JMSTemporaryQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.util.DME2JMSExceptionHandler;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.servlet.Servlet;

public class DME2JMSQueueReceiver
extends DME2JMSMessageConsumer
implements QueueReceiver {
    private final DME2JMSQueue queue;
    private String messageSelector = null;
    private MessageListener listener = null;
    private boolean open = true;
    private DME2Configuration config;
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSQueueReceiver.class.getName());
    private Message msg = null;
    private static Map<String, Boolean> registeredListeners = Collections.synchronizedMap(new HashMap());
    private boolean isReceiverWaiting;
    private boolean hasListeners;
    private final DME2JMSManager manager;

    protected DME2JMSQueueReceiver(DME2JMSManager manager, Queue queue) {
        this.queue = (DME2JMSQueue)queue;
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        if (this.config.getBoolean("DME2_JMS_TEMP_QUEUE_REC_CLEANUP") && this.manager != null && queue instanceof DME2JMSTemporaryQueue) {
            this.manager.addQueueReceiverToMap(queue, this);
        }
    }

    protected DME2JMSQueueReceiver(DME2JMSManager manager, Queue queue, String messageSelector) {
        this.queue = (DME2JMSQueue)queue;
        this.messageSelector = messageSelector;
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        if (this.config.getBoolean("DME2_JMS_TEMP_QUEUE_REC_CLEANUP") && this.manager != null && queue instanceof DME2JMSTemporaryQueue) {
            this.manager.addQueueReceiverToMap(queue, this);
        }
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public void close() throws JMSException {
        try {
            if (this.listener != null) {
                this.removeMessageListener(this.listener);
            }
            this.open = false;
            this.listener = null;
        }
        finally {
            if (this.config.getBoolean("DME2_JMS_TEMP_QUEUE_REC_CLEANUP") && this.manager != null) {
                this.manager.removeQueueReceiverFromMap(this.queue, this);
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long ttl) throws JMSException {
        logger.debug(null, "receive", LogMessage.METHOD_ENTER);
        if (!this.open) {
            throw new DME2JMSException("AFT-DME2-5800", new ErrorContext());
        }
        try {
            this.isReceiverWaiting = true;
            Map<String, Boolean> map = registeredListeners;
            synchronized (map) {
                if (!this.queue.isClient() && registeredListeners.get(this.queue.getQueueName()) == null) {
                    try {
                        logger.debug((URI)null, "receive", "Queue {} is being registered", (Object)this.queue.getQueueName());
                        DME2JMSServiceHolder serviceHolder = new DME2JMSServiceHolder(this.queue);
                        serviceHolder.setServiceURI(this.queue.getQueueNameURI());
                        serviceHolder.setServlet((Servlet)new DME2JMSServlet(this.manager));
                        serviceHolder.setSecurityRealm(this.queue.getRealmName());
                        serviceHolder.setAllowedRoles(this.queue.getAllowedRoles());
                        serviceHolder.setLoginMethod(this.queue.getLoginMethod());
                        serviceHolder.setManager(this.manager.getDME2Manager());
                        this.manager.getDME2Manager().bindService(serviceHolder);
                        registeredListeners.put(this.queue.getQueueName(), true);
                    }
                    catch (DME2Exception e) {
                        throw new DME2JMSException("AFT-DME2-5801", new ErrorContext(), (Throwable)e);
                    }
                }
            }
            if (this.queue instanceof DME2JMSLocalQueue && !this.queue.isClient()) {
                this.queue.getActiveReceiverCount().incrementAndGet();
            }
            if (!(this.queue instanceof DME2JMSLocalQueue)) {
                throw new DME2JMSException("AFT-DME2-5802", new ErrorContext().add("QueueName", this.queue.getQueueName()));
            }
            DME2JMSLocalQueue lQueue = (DME2JMSLocalQueue)this.queue;
            logger.debug((URI)null, "receive", (LogMessage)JMSLogMessage.QUEUE_INVOKE, (Object)lQueue.getQueueName(), (Object)this.messageSelector);
            logger.debug((URI)null, "receive", "Code=Trace.DME2JMSQueueReceiver.receive; QueueReceiver invoking queue {} get with message selector {}", (Object)lQueue.getQueueName(), (Object)this.messageSelector);
            long start = System.currentTimeMillis();
            this.msg = lQueue.get(ttl, this.messageSelector);
            logger.debug((URI)null, "receive", "Returning messageID: {} in {}", this.msg == null ? this.msg : this.msg.getJMSMessageID(), (Object)(System.currentTimeMillis() - start));
            if (lQueue.isClient()) {
                if (this.msg == null) {
                    logger.info((URI)null, "receive", "AFT-DME2-5804 {}", (Object)new ErrorContext().add("Event", "Client.Response.Timedout").add("Timeout", ttl + ""));
                    logger.info((URI)null, "receive", "Code=Client.Response.Timedout;Timeout={};MessageSelector={}", (Object)ttl, (Object)this.messageSelector);
                }
                if (this.msg instanceof DME2JMSErrorMessage) {
                    throw new DME2JMSException("AFT-DME2-5803", new ErrorContext().add("EndpointsAttempted", this.msg.getStringProperty("AFT_DME2_REQ_TRACE_INFO")), (Throwable)((DME2JMSErrorMessage)this.msg).getJMSException());
                }
            }
        }
        catch (Exception e) {
            throw DME2JMSExceptionHandler.handleException(e, this.queue.getQueueName());
        }
        finally {
            this.isReceiverWaiting = false;
            if (this.queue instanceof DME2JMSLocalQueue && !this.queue.isClient()) {
                this.queue.getActiveReceiverCount().decrementAndGet();
            }
        }
        return this.msg;
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(-1L);
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        logger.debug((URI)null, "setMessageListener", "DME2JMSQueueReceiver setMessageListener {} for queue {}", (Object)listener, (Object)this.queue.getQueueName());
        this.queue.addListener(this, listener, this.messageSelector);
        this.hasListeners = true;
        this.listener = listener;
    }

    public void removeMessageListener(DME2JMSMessageConsumer consumer, MessageListener listener) throws JMSException {
        this.queue.removeListener(this, listener);
        logger.debug((URI)null, "removeMessageListener", "DME2JMSQueueReceiver removeMessageListener {} for queue {}", (Object)listener, (Object)this.queue.getQueueName());
        this.hasListeners = false;
        this.listener = listener;
    }

    public void removeMessageListener(MessageListener listener) throws JMSException {
        this.queue.removeListener(this);
        this.hasListeners = false;
        this.listener = listener;
    }

    public DME2JMSTextMessage copy(DME2JMSMessage message) throws JMSException {
        DME2JMSTextMessage copy = new DME2JMSTextMessage();
        Properties properties = message.getProperties();
        Enumeration<?> propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            String value = properties.getProperty(name);
            copy.setStringProperty(name, value);
        }
        if (message instanceof DME2JMSTextMessage) {
            copy.setText(((DME2JMSTextMessage)message).getText());
        }
        if (message.getJMSCorrelationID() != null) {
            copy.setJMSCorrelationID(message.getJMSCorrelationID());
        }
        if (message.getJMSCorrelationIDAsBytes() != null) {
            copy.setJMSCorrelationIDAsBytes(message.getJMSCorrelationIDAsBytes());
        }
        copy.setJMSDeliveryMode(message.getJMSDeliveryMode());
        if (message.getJMSDestination() != null) {
            copy.setJMSDestination(message.getJMSDestination());
        }
        copy.setJMSExpiration(message.getJMSExpiration());
        if (message.getJMSMessageID() != null) {
            copy.setJMSMessageID(message.getJMSMessageID());
        }
        copy.setJMSPriority(message.getJMSPriority());
        copy.setJMSRedelivered(message.getJMSRedelivered());
        if (message.getJMSReplyTo() != null) {
            copy.setJMSReplyTo(message.getJMSReplyTo());
        }
        copy.setJMSTimestamp(message.getJMSTimestamp());
        if (message.getJMSType() != null) {
            copy.setJMSType(message.getJMSType());
        }
        return copy;
    }

    public static Map<String, Boolean> getRegisteredListeners() {
        return registeredListeners;
    }

    public boolean hasListeners() {
        return this.hasListeners;
    }

    public boolean isReceiverWaiting() {
        return this.isReceiverWaiting;
    }
}

