/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSNotImplementedException;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSQueueConnection;
import com.att.aft.dme2.jms.DME2JMSQueueReceiver;
import com.att.aft.dme2.jms.DME2JMSQueueSender;
import com.att.aft.dme2.jms.DME2JMSSession;
import com.att.aft.dme2.jms.DME2JMSTemporaryQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.DME2JMSXAResource;
import com.att.aft.dme2.jms.util.DME2JMSExceptionHandler;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.Serializable;
import java.net.URI;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;
import javax.transaction.xa.XAResource;

public class DME2JMSQueueSession
extends DME2JMSSession
implements QueueSession,
XAQueueSession {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSQueueSession.class.getName());
    private boolean transacted = false;
    private final int ackMode;
    private DME2JMSQueueConnection connection = null;
    private boolean closed = false;
    private final DME2JMSManager manager;
    private Message distinquishedMessage = null;
    private MessageListener listener = null;
    private DME2JMSXAResource xaResource = null;
    private static final String QUEUENAME = "queueName";
    private static final String MSGSELECTOR = "messageSelector";
    private static final String DESTTYPE = "DestinationType";

    protected DME2JMSQueueSession(DME2JMSQueueConnection connection, boolean transacted, int ackMode) {
        logger.debug((URI)null, "DME2JMSQueueSession", (LogMessage)JMSLogMessage.SESSION_CREATED, (Object)connection);
        this.connection = connection;
        this.transacted = transacted;
        this.ackMode = ackMode;
        this.manager = connection.getManager();
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        DME2JMSTemporaryQueue tempQueue;
        this.assertNotClosed();
        if (queue instanceof DME2JMSTemporaryQueue && (tempQueue = (DME2JMSTemporaryQueue)queue).getQueueConnection() != this.connection) {
            throw new DME2JMSException("AFT-DME2-6000", new ErrorContext().add(QUEUENAME, queue.getQueueName()));
        }
        return new DME2JMSQueueReceiver(this.manager, queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        DME2JMSTemporaryQueue tempQueue;
        this.assertNotClosed();
        if (queue instanceof DME2JMSTemporaryQueue && (tempQueue = (DME2JMSTemporaryQueue)queue).getQueueConnection() != this.connection) {
            throw new DME2JMSException("AFT-DME2-6001", new ErrorContext().add(QUEUENAME, queue.getQueueName()).add(MSGSELECTOR, messageSelector));
        }
        DME2JMSQueueReceiver receiver = new DME2JMSQueueReceiver(this.manager, queue, messageSelector);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.assertNotClosed();
        DME2JMSQueueSender sender = new DME2JMSQueueSender((DME2JMSQueue)queue, this);
        return sender;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.assertNotClosed();
        logger.debug((URI)null, "setMessageListener", (LogMessage)JMSLogMessage.SESSION_LISTENER, (Object)listener.getClass().getName());
        this.listener = listener;
    }

    public Queue createQueue(String arg0) throws JMSException {
        DME2JMSQueue queue;
        this.assertNotClosed();
        try {
            queue = this.manager.getQueue(arg0);
        }
        catch (Exception e) {
            logger.error((URI)null, "createQueue", "AFT-DME2-6002 {}", (Object)new ErrorContext().add(QUEUENAME, arg0).add("extendedMessage", e.getMessage()), (Object)e);
            throw new DME2JMSException("AFT-DME2-6002", new ErrorContext().add(QUEUENAME, arg0).add("extendedMessage", e.getMessage()), (Throwable)e);
        }
        return queue;
    }

    public MessageConsumer createConsumer(Destination dest) throws JMSException {
        this.assertNotClosed();
        DME2JMSQueueReceiver rec = null;
        try {
            DME2JMSTemporaryQueue tempQueue;
            if (dest instanceof DME2JMSTemporaryQueue && (tempQueue = (DME2JMSTemporaryQueue)dest).getQueueConnection() != this.connection) {
                throw new DME2JMSException("AFT-DME2-6003", new ErrorContext().add(QUEUENAME, tempQueue.getQueueName()));
            }
            if (!(dest instanceof DME2JMSQueue)) {
                throw new DME2JMSException("AFT-DME2-6004", new ErrorContext().add(DESTTYPE, dest.getClass().getName()));
            }
            rec = new DME2JMSQueueReceiver(this.manager, (DME2JMSQueue)dest);
        }
        catch (Exception e) {
            DME2JMSExceptionHandler.handleException(e, "Not Specified");
        }
        return rec;
    }

    public MessageProducer createProducer(Destination dest) throws JMSException {
        this.assertNotClosed();
        if (dest == null) {
            return new DME2JMSQueueSender(null, this);
        }
        if (dest instanceof DME2JMSQueue) {
            return new DME2JMSQueueSender((DME2JMSQueue)dest, this);
        }
        throw new DME2JMSException("AFT-DME2-6005", new ErrorContext().add(DESTTYPE, dest.getClass().getName()));
    }

    public TextMessage createTextMessage() throws JMSException {
        this.assertNotClosed();
        return new DME2JMSTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.assertNotClosed();
        DME2JMSTextMessage m = new DME2JMSTextMessage();
        m.setText(text);
        return m;
    }

    public void close() throws JMSException {
        this.closed = true;
        this.manager.closeTemporaryQueues(this);
    }

    public void commit() throws JMSException {
    }

    public QueueBrowser createBrowser(Queue arg0) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createBrowser");
    }

    public QueueBrowser createBrowser(Queue arg0, String arg1) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createBrowser");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createBytesMessage");
    }

    public MessageConsumer createConsumer(Destination dest, String selector) throws JMSException {
        DME2JMSTemporaryQueue tempQueue;
        this.assertNotClosed();
        if (dest instanceof DME2JMSTemporaryQueue && (tempQueue = (DME2JMSTemporaryQueue)dest).getQueueConnection() != this.connection) {
            throw new DME2JMSException("AFT-DME2-6006", new ErrorContext());
        }
        if (dest instanceof DME2JMSQueue) {
            return new DME2JMSQueueReceiver(this.manager, (DME2JMSQueue)dest, selector);
        }
        throw new DME2JMSException("AFT-DME2-6007", new ErrorContext().add(DESTTYPE, dest.getClass().getName()).add(MSGSELECTOR, selector));
    }

    public MessageConsumer createConsumer(Destination dest, String selector, boolean arg2) throws JMSException {
        DME2JMSTemporaryQueue tempQueue;
        this.assertNotClosed();
        if (dest instanceof DME2JMSTemporaryQueue && (tempQueue = (DME2JMSTemporaryQueue)dest).getQueueConnection() != this.connection) {
            throw new DME2JMSException("AFT-DME2-6008", new ErrorContext().add(QUEUENAME, tempQueue.getQueueName()).add(MSGSELECTOR, selector));
        }
        if (dest instanceof DME2JMSQueue) {
            return new DME2JMSQueueReceiver(this.manager, (DME2JMSQueue)dest, selector);
        }
        throw new DME2JMSException("AFT-DME2-6009", new ErrorContext().add(DESTTYPE, dest.getClass().getName()).add(MSGSELECTOR, selector));
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createDurableSubscriber");
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createDurableSubscriber");
    }

    public MapMessage createMapMessage() throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Message Type Not Supported (map)");
    }

    public Message createMessage() throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Message Type Not Supported (generic)");
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Message Type Not Supported (object)");
    }

    public ObjectMessage createObjectMessage(Serializable arg0) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Message Type Not Supported (object)");
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Message Type Not Supported (stream)");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.assertNotClosed();
        return (TemporaryQueue)this.connection.createTemporaryDestination(this, false);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createTemporaryTopic");
    }

    public Topic createTopic(String arg0) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.createTopic");
    }

    public int getAcknowledgeMode() throws JMSException {
        this.assertNotClosed();
        return 0;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.assertNotClosed();
        return this.listener;
    }

    public boolean getTransacted() throws JMSException {
        this.assertNotClosed();
        return this.transacted;
    }

    public void recover() throws JMSException {
    }

    public void rollback() throws JMSException {
    }

    public void run() {
        if (this.distinquishedMessage == null) {
            logger.debug(null, "run", JMSLogMessage.SESSION_NO_NEXTMSG);
            return;
        }
        if (this.listener == null) {
            logger.debug(null, "run", JMSLogMessage.SESSION_NO_LISTENER);
        }
        this.listener.onMessage(this.distinquishedMessage);
        this.distinquishedMessage = null;
    }

    public void unsubscribe(String arg0) throws JMSException {
        this.assertNotClosed();
        throw new DME2JMSNotImplementedException("Session.unsubscribe");
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public int getAckMode() {
        return this.ackMode;
    }

    private void assertNotClosed() throws JMSException {
        if (!this.isOpen()) {
            throw new DME2JMSException("AFT-DME2-6010", new ErrorContext());
        }
    }

    @Override
    public boolean isOpen() {
        if (this.closed) {
            return false;
        }
        return this.connection.isOpen();
    }

    void setDistinquishedMessage(Message m) {
        this.distinquishedMessage = m;
    }

    Message getDistinquishedMessage() {
        return this.distinquishedMessage;
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        if (this.xaResource == null) {
            this.xaResource = new DME2JMSXAResource();
        }
        return this.xaResource;
    }

    public QueueSession getQueueSession() throws JMSException {
        return this;
    }
}

