/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSHttpReplyHandler;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.util.DME2UniformResource;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ErrorContext;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;

public class DME2JMSRemoteQueue
extends DME2JMSQueue {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSRemoteQueue.class.getName());
    private static final int CONSTANT_1000 = 10000;
    private static final String[] SERVICEID_URI_PROPERTIES = new String[]{"dataContext", "partner", "stickySelectorKey"};
    private static final String PROPERTYNAME_PREFIX1 = "com.att.aft.dme2.";
    private static final String PROPERTYNAME_PREFIX2 = "com.att.aft.dme2.jms.";
    private final DME2JMSManager manager;
    private final boolean isOriginalURIDirect;
    private final boolean isAuditRequests;
    private final String originalURIQuery;
    private String autoReplyToQueue = null;
    private DME2Configuration config;

    public DME2JMSRemoteQueue(DME2JMSManager manager, URI name) throws JMSException {
        super(manager, name);
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        this.autoReplyToQueue = this.config.getProperty("autoJMSReplyToQueue");
        DME2UniformResource uniformResource = null;
        try {
            String uriStr = name.toString();
            if (!uriStr.startsWith("http://") || !uriStr.startsWith("https://")) {
                uriStr = "http://DME2LOCAL" + uriStr;
            }
            uniformResource = new DME2UniformResource(this.config, uriStr);
        }
        catch (MalformedURLException e) {
            throw new DME2JMSException("AFT-DME2-0607", new ErrorContext().add("extendedMessage", e.getMessage()).add("URI", name.toString()), (Throwable)e);
        }
        this.isOriginalURIDirect = uniformResource.getUrlType() == DME2UniformResource.DME2UrlType.DIRECT;
        this.isAuditRequests = Boolean.valueOf(this.config.getProperty("AFT_DME2_EXCHANGE_JMS_AUDIT_REQUEST", "true"));
        this.originalURIQuery = name.getQuery();
    }

    @Override
    public void put(DME2JMSMessage m) throws JMSException {
        logger.debug(null, "put", LogMessage.METHOD_ENTER);
        DME2JMSTextMessage tm = (DME2JMSTextMessage)m;
        if (tm.getJMSMessageID() == null) {
            tm.genID();
        }
        logger.debug((URI)null, "put", "put text={} props={}", (Object)tm.getText(), (Object)tm.getProperties());
        if (this.isAuditRequests) {
            this.initLoggingContext(m);
            logger.info((URI)null, "put", "AFT-DME2-6109 {}", (Object)new ErrorContext().add("QueueURI", this.getQueueName()));
        }
        String charset = this.getProperty(m, "charset");
        long perEndpointTimeoutMs = m.getLongProperty("com.att.aft.dme2.perEndpointTimeoutMs");
        if (perEndpointTimeoutMs < 1L) {
            perEndpointTimeoutMs = m.getLongProperty("com.att.aft.dme2.jms.perEndpointTimeoutMs");
        }
        if (perEndpointTimeoutMs < 1L) {
            perEndpointTimeoutMs = 10000L;
        }
        DME2Client client = null;
        try {
            client = new DME2Client(this.manager.getDME2Manager(), this.buildRequestURI(m), perEndpointTimeoutMs, charset);
        }
        catch (DME2Exception e) {
            throw new DME2JMSException("AFT-DME2-6101", new ErrorContext().add("queueName", this.getQueueName()).add("extendedMessage", e.getMessage()), (Throwable)e);
        }
        Map<String, String> requestQueryParams = this.getMapProperty(m, "queryParams");
        if (requestQueryParams != null) {
            client.setQueryParams(requestQueryParams, true);
        }
        client.setHeaders(this.buildReplyHeaders(m, tm));
        client.setReplyHandler(new DME2JMSHttpReplyHandler(this.manager));
        client.setPayload(tm.getText());
        if (this.getUserName() != null && this.getPassword() != null) {
            client.setCredentials(this.getUserName(), this.getPassword());
        } else if (this.manager.getUserName() != null && this.manager.getPassword() != null) {
            client.setCredentials(this.manager.getUserName(), this.manager.getPassword());
        }
        try {
            client.send();
        }
        catch (DME2Exception e) {
            throw new DME2JMSException(e);
        }
        logger.debug(null, "put", LogMessage.METHOD_EXIT);
    }

    private Map<String, String> buildReplyHeaders(DME2JMSMessage m, DME2JMSTextMessage tm) throws JMSException {
        HashMap<Object, Object> replyHeaders = new HashMap<Object, Object>(tm.getProperties());
        if (m.getJMSReplyTo() != null) {
            Queue q = (Queue)m.getJMSReplyTo();
            replyHeaders.put("JMSReplyTo", q.getQueueName());
        } else if (this.autoReplyToQueue != null) {
            replyHeaders.put("JMSReplyTo", this.autoReplyToQueue);
        }
        String conversationId = this.getProperty(m, "conversationID");
        if (conversationId != null) {
            replyHeaders.put("JMSConversationID", conversationId);
        }
        return replyHeaders;
    }

    private String buildQueryStringFromMessageProperties(DME2JMSMessage m) throws JMSException {
        HashSet<String> jmsQueryParamKeys = new HashSet<String>();
        jmsQueryParamKeys.add("matchVersionRange");
        jmsQueryParamKeys.add("DME2NonFailoverStatusCodes");
        jmsQueryParamKeys.add("userName");
        jmsQueryParamKeys.add("password");
        jmsQueryParamKeys.add("preferLocal");
        jmsQueryParamKeys.add("ignoreFailoverOnExpire");
        jmsQueryParamKeys.add("connectTimeoutInMs");
        Properties props = m.getProperties();
        HashMap<String, String> queryParamsMap = new HashMap<String, String>();
        if (props != null) {
            for (String paramKey : jmsQueryParamKeys) {
                String queryParamValue = this.getProperty(m, paramKey);
                if (queryParamValue == null) continue;
                queryParamsMap.put(paramKey, queryParamValue);
            }
        }
        StringBuilder queryString = new StringBuilder();
        Iterator iter = queryParamsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String paramKey = (String)entry.getKey();
            String paramValue = (String)entry.getValue();
            queryString.append(paramKey + "=" + paramValue);
            if (!iter.hasNext()) continue;
            queryString.append("&");
        }
        if (queryString.length() > 0) {
            return queryString.toString();
        }
        return null;
    }

    private URI buildRequestURI(DME2JMSMessage m) throws JMSException {
        StringBuilder uri = new StringBuilder();
        uri.append("http://").append(this.getQueueHost());
        if (!this.getQueueName().startsWith("/")) {
            uri.append("/");
        }
        uri.append(this.getQueueName());
        StringBuilder query = new StringBuilder();
        String finalQueryString = this.originalURIQuery;
        String queryParamsFromMessageProps = this.buildQueryStringFromMessageProperties(m);
        if (queryParamsFromMessageProps != null) {
            finalQueryString = finalQueryString == null ? queryParamsFromMessageProps : finalQueryString + "&" + queryParamsFromMessageProps;
        }
        if (finalQueryString != null) {
            query.append(finalQueryString);
        }
        if (!this.isOriginalURIDirect) {
            for (String key : SERVICEID_URI_PROPERTIES) {
                String value = this.getProperty(m, key);
                if (value == null) continue;
                uri.append("/").append(key).append("=").append(value);
            }
        }
        String dataContext = this.getProperty(m, "dataContext");
        String partner = this.getProperty(m, "partner");
        String stickySelectorKey = this.getProperty(m, "stickySelectorKey");
        String partnerStr = partner == null ? "" : "/partner=" + partner;
        String dataContextStr = dataContext == null ? "" : "/dataContext=" + dataContext;
        String stickySelectorKeyStr = stickySelectorKey == null ? "" : "/stickySelectorKey=" + stickySelectorKey;
        uri.append(dataContextStr + partnerStr + stickySelectorKeyStr);
        if (query.length() > 0) {
            uri.append("?").append((CharSequence)query);
        }
        try {
            return new URI(uri.toString());
        }
        catch (URISyntaxException e1) {
            throw new DME2JMSException("AFT-DME2-6100", new ErrorContext().add("queueName", this.getQueueName()));
        }
    }

    private String getProperty(DME2JMSMessage m, String name) throws JMSException {
        String value = m.getStringProperty(PROPERTYNAME_PREFIX1 + name);
        if (value != null) {
            return value;
        }
        return m.getStringProperty(PROPERTYNAME_PREFIX2 + name);
    }

    public String getQueryParams(Map<String, String> mapParams, boolean encode) {
        String tmpQueryParams = "";
        if (mapParams == null || mapParams.size() == 0) {
            return tmpQueryParams;
        }
        StringBuffer sb = new StringBuffer(mapParams.size() * 2);
        sb.append("?");
        for (Map.Entry<String, String> e : mapParams.entrySet()) {
            try {
                sb.append(e.getKey()).append("=").append(encode ? URLEncoder.encode(e.getValue() != null ? e.getValue() : "", Charset.forName("UTF-8").name()) : (e.getValue() != null ? e.getValue() : "")).append("&");
            }
            catch (UnsupportedEncodingException uee) {
                logger.debug((URI)null, "getQueryParams", "Could not encode parameter: {}", (Object)e.toString(), (Object)uee);
            }
        }
        tmpQueryParams = sb.toString();
        return tmpQueryParams;
    }

    private Map<String, String> getMapProperty(DME2JMSMessage m, String name) throws JMSException {
        String encoded = this.getProperty(m, name);
        if (encoded == null) {
            return null;
        }
        HashMap<String, String> out = new HashMap<String, String>();
        for (String entry : encoded.split("&")) {
            String[] keyValue = entry.split("=");
            if (keyValue.length != 2) continue;
            out.put(keyValue[0], keyValue[1]);
        }
        return out;
    }

    private void initLoggingContext(DME2JMSMessage msg) {
        String trackingID = null;
        try {
            String msgId = msg.getJMSMessageID();
            String conversationId = msg.getStringProperty("JMSConversationID");
            if (conversationId == null) {
                conversationId = msg.getStringProperty("com.att.aft.dme2.jms.conversationID");
            }
            trackingID = msgId + (conversationId == null ? "" : "(" + conversationId + ")");
            DME2Constants.setContext(trackingID, null);
        }
        catch (Exception e) {
            logger.warn((URI)null, "initLoggingContext", (LogMessage)JMSLogMessage.INIT_CTX_FAIL, (Object)e);
        }
    }

    @Override
    public void addListener(DME2JMSMessageConsumer consumer, MessageListener listener, String filter) throws JMSException {
        throw new DME2JMSException("AFT-DME2-6103", new ErrorContext().add("queueName", this.getQueueName()).add("filter", filter));
    }

    public String toString() {
        try {
            return "RemoteQueue: " + this.getQueueName();
        }
        catch (JMSException e) {
            return "RemoteQueue";
        }
    }
}

