/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSLocalQueue;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueueReceiver;
import com.att.aft.dme2.jms.util.JMSConstants;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class DME2JMSTemporaryQueue
extends DME2JMSLocalQueue
implements TemporaryQueue {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSTemporaryQueue.class.getName());
    private String identifier = null;
    private URI uri = null;
    private QueueSession session = null;
    private QueueConnection connection = null;
    private long createTime = -1L;
    private long lastPutTime = -1L;
    private long lastGetTime = -1L;
    private static final int CONSTANT_1000 = 1000;
    private static final long CONSTANT_60L = 60L;
    private long idleTimeoutMs = 60000L;
    private final DME2JMSManager manager;
    private static final String NOW = ", now=";
    private static final String IDLETIMOUTMS = ", idleTimeoutMs=";
    private static final String LASTPUTTIME = ", lastPutTime=";
    private static final String LASTGETTIME = ", lastGetTime=";
    private DME2Configuration config;

    public DME2JMSTemporaryQueue(DME2JMSManager manager, URI uri, QueueSession session, QueueConnection qConnection) throws JMSException {
        super(manager, uri, true);
        super.setClient(true);
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        this.uri = uri;
        this.identifier = uri.toString();
        this.session = session;
        this.connection = qConnection;
        this.createTime = System.currentTimeMillis();
        manager.getDME2Manager().getConfig().getLong(JMSConstants.DME2_TEMPQUEUE_IDLETIMEOUT_MS);
        manager.addTemporaryQueue(uri, this);
        logger.debug((URI)null, "DME2JMSTemporaryQueue", "Created temporary queue: {}. {}", (Object)this.identifier, (Object)this.toString());
    }

    protected QueueConnection getQueueConnection() {
        return this.connection;
    }

    public QueueSession getQueueSession() {
        return this.session;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastPutTime() {
        return this.lastPutTime;
    }

    public long getLastGetTime() {
        return this.lastGetTime;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setIdleTimeoutMs(long idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    @Override
    protected Message get(long timeout, String filter) throws JMSException {
        logger.debug(null, "Message", LogMessage.METHOD_ENTER);
        if (this.isClosed()) {
            logger.debug((URI)null, "get", "TemporaryQueue closed {}", (Object)this.getQueueName());
            throw new DME2JMSException("AFT-DME2-6300", new ErrorContext().add("QueueName", this.identifier).add("messageSelector", filter).add("idleTimeoutMs", String.valueOf(this.idleTimeoutMs)));
        }
        this.lastGetTime = System.currentTimeMillis();
        Message msg = super.get(timeout, filter);
        if (msg instanceof DME2JMSMessage) {
            Properties debugProps = ((DME2JMSMessage)msg).getProperties();
            StringBuffer debugSB = new StringBuffer();
            Enumeration<?> e = debugProps.propertyNames();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = debugProps.get(key);
                if (debugSB.length() > 1) {
                    debugSB.append(",");
                }
                debugSB.append(key);
                debugSB.append("=");
                debugSB.append(value);
            }
            logger.debug((URI)null, "get", "get:", (Object)debugSB);
        }
        logger.debug(null, "get", LogMessage.METHOD_EXIT);
        return msg;
    }

    @Override
    public void put(DME2JMSMessage m) throws JMSException {
        logger.debug(null, "get", LogMessage.METHOD_ENTER);
        Properties debugProps = m.getProperties();
        StringBuffer debugSB = new StringBuffer();
        Enumeration<?> e = debugProps.propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = debugProps.get(key);
            if (debugSB.length() > 1) {
                debugSB.append(",");
            }
            debugSB.append(key);
            debugSB.append("=");
            debugSB.append(value);
        }
        logger.debug((URI)null, "put", "put:", (Object)debugSB);
        this.lastPutTime = System.currentTimeMillis();
        if (this.isClosed()) {
            throw new DME2JMSException("AFT-DME2-6301", new ErrorContext().add("QueueName", this.identifier).add("idleTimeoutMs", String.valueOf(this.idleTimeoutMs)));
        }
        super.put(m);
        logger.debug(null, "put", LogMessage.METHOD_EXIT);
    }

    public void delete() throws JMSException {
        List<DME2JMSQueueReceiver> receivers;
        logger.debug(null, "delete", LogMessage.METHOD_ENTER);
        if (this.config.getBoolean("DME2_JMS_TEMP_QUEUE_REC_CLEANUP") && this.manager.containsQueueReceivers(this) && (receivers = this.manager.getQueueReceivers(this)) != null && !receivers.isEmpty()) {
            ArrayList<DME2JMSQueueReceiver> receiverTempList = new ArrayList<DME2JMSQueueReceiver>(receivers);
            for (DME2JMSQueueReceiver receiver : receiverTempList) {
                if (!receiver.hasListeners() && !receiver.isReceiverWaiting()) continue;
                throw new DME2JMSException("AFT-DME2-6302", new ErrorContext().add("QueueIdentifier", this.identifier));
            }
        }
        super.close();
        this.manager.removeTemporaryQueue(this.uri);
        logger.debug(null, "delete", LogMessage.METHOD_EXIT);
    }

    protected boolean isClosed() {
        logger.debug(null, "isClosed", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "isClosed", "TempQueue {}. idleTimeoutMs={}", (Object)this, (Object)this.idleTimeoutMs);
        if (!this.isOpen()) {
            logger.debug((URI)null, "isClosed", "DME2JMSTemporaryQueue.isClosed isOpen=false. TempQueue ", (Object)this, (Object)". TempQueue is percevied as closed");
            return true;
        }
        logger.debug(null, "isClosed", "DME2JMSTemporaryQueue.isClosed isOpen=true;");
        if (this.idleTimeoutMs == -1L) {
            logger.debug(null, "isClosed", "DME2JMSTemporaryQueue.isClosed idleTimeoutMs=-1");
            return false;
        }
        logger.debug(null, "isClosed", "DME2JMSTemporaryQueue.isClosed idleTimeoutMs>1");
        long nowMillis = System.currentTimeMillis();
        if (nowMillis - this.createTime < this.idleTimeoutMs && this.lastGetTime == -1L && this.lastPutTime == -1L) {
            logger.debug(null, "isClosed", "TempQueue ", this, " created but has not reached the idleTimeout period and no put and get performed. createTime=", this.createTime, IDLETIMOUTMS, this.idleTimeoutMs, LASTPUTTIME, this.lastPutTime, LASTGETTIME, this.lastGetTime, NOW, nowMillis);
            return false;
        }
        logger.debug(null, "isClosed", "DME2JMSTemporaryQueue isClosed TempQueue ", this, " created but either reached the idleTimeout period or put and get performed. createTime=", this.createTime, IDLETIMOUTMS, this.idleTimeoutMs, LASTPUTTIME, this.lastPutTime, LASTGETTIME, this.lastGetTime, NOW, nowMillis, ";", Thread.currentThread().getName());
        if (nowMillis - this.createTime > this.idleTimeoutMs && (this.lastGetTime == -1L || this.lastPutTime == -1L)) {
            logger.debug(null, "isClosed", "TempQueue ", this, " created and has exceeded the idleTimeout period and no put or get performed. TempQueue is percevied as closed. createTime=", this.createTime, IDLETIMOUTMS, this.idleTimeoutMs, LASTPUTTIME, this.lastPutTime, LASTGETTIME, this.lastGetTime, NOW, nowMillis);
            return true;
        }
        logger.debug(null, "isClosed", " created but either has not exceeded the idleTimeout period or put or get had been performed. createTime=", this.createTime, IDLETIMOUTMS, this.idleTimeoutMs, LASTPUTTIME, this.lastPutTime, LASTGETTIME, this.lastGetTime, NOW, nowMillis, ";");
        if (nowMillis - this.lastGetTime < this.idleTimeoutMs || nowMillis - this.lastPutTime < this.idleTimeoutMs) {
            logger.debug(null, "isClosed", "TempQueue ", this, " created and last put or get time has not exceeded idleTimeout period. createTime=", this.createTime, IDLETIMOUTMS, this.idleTimeoutMs, LASTPUTTIME, this.lastPutTime, LASTGETTIME, this.lastGetTime, NOW, nowMillis);
            return false;
        }
        logger.debug(null, "isClosed", "TempQueue ", this, " created and last put or get time has exceeded idleTimeout period. TempQueue is percevied as closed. createTime=", this.createTime, IDLETIMOUTMS, this.idleTimeoutMs, LASTPUTTIME, this.lastPutTime, LASTGETTIME, this.lastGetTime, NOW, nowMillis);
        return true;
    }
}

