/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSLocalQueue;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import java.net.URI;
import javax.jms.JMSException;

class WaiterNotifier {
    private static final Logger logger = LoggerFactory.getLogger(WaiterNotifier.class.getName());
    private String filter = null;
    private DME2JMSMessage m = null;
    private DME2JMSLocalQueue queue = null;
    private boolean active = false;

    public WaiterNotifier(String filter, DME2JMSLocalQueue queue) {
        this.filter = filter;
        this.queue = queue;
    }

    public boolean matches(DME2JMSMessage m) throws JMSException {
        logger.debug((URI)null, "matches", LogMessage.METHOD_ENTER, (Object)this.queue.getQueueName());
        boolean match = m.matches(this.filter);
        logger.debug(null, "matches", LogMessage.METHOD_EXIT);
        logger.debug((URI)null, "matches", "DME2JMSLocalQueue matches filter={};match={}", (Object)this.filter, (Object)match);
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean notify(DME2JMSMessage m) {
        boolean notified = false;
        try {
            try {
                logger.debug((URI)null, "matches", LogMessage.METHOD_ENTER, (Object)this.queue.getQueueName());
            }
            catch (Exception e) {
                logger.debug((URI)null, "matches", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
            }
            this.m = m;
            try {
                logger.debug(null, "matches", "notifying ", m.getJMSMessageID(), " ReplyTo:", m.getJMSReplyTo());
            }
            catch (Exception e) {
                logger.debug((URI)null, "matches", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
            }
            if (!this.active) {
                boolean bl = false;
                return bl;
            }
            this.notify();
            notified = true;
            boolean bl = notified;
            return bl;
        }
        finally {
            logger.debug(null, "matches", LogMessage.METHOD_EXIT);
        }
    }

    public synchronized DME2JMSMessage get(long ttl) throws JMSException {
        String trackingId = null;
        this.active = true;
        try {
            logger.debug((URI)null, "get", LogMessage.METHOD_ENTER, (Object)this.queue.getQueueName());
        }
        catch (Exception e) {
            logger.debug((URI)null, "get", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
        }
        if (this.m == null) {
            try {
                this.wait(ttl);
                if (this.m != null) {
                    logger.debug((URI)null, "get", "Wait ending {} ReplyTo: {}", (Object)this.m.getJMSMessageID(), (Object)this.m.getJMSReplyTo());
                }
            }
            catch (InterruptedException e) {
                logger.debug(null, "get", LogMessage.THREAD_INTERRUPT);
            }
        }
        this.active = false;
        if (this.m != null) {
            String queueName = this.queue.getQueueName();
            String msgId = this.m.getStringProperty("JMSMessageID");
            String conversationId = this.m.getStringProperty("JMSConversationID");
            trackingId = msgId + (conversationId == null ? "" : "(" + conversationId + ")");
            if (queueName != null) {
                DME2Constants.setContext(queueName + DME2Constants.LOGRECORDSEP + trackingId, null);
            } else {
                DME2Constants.setContext(trackingId, null);
            }
        }
        logger.debug((URI)null, "get", LogMessage.METHOD_EXIT, (Object)this.queue.getQueueName());
        return this.m;
    }
}

