/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.quick;

import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;

public class QuickNoOpListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(QuickNoOpListener.class.getName());
    private QueueSession session = null;
    private String PID_DATA;

    public QuickNoOpListener(Connection connection, Destination serverDest, Session session) {
        this.session = (QueueSession)session;
        this.PID_DATA = ManagementFactory.getRuntimeMXBean().getName();
    }

    public void onMessage(Message message) {
        try {
            Queue replyTo = (Queue)message.getJMSReplyTo();
            if (replyTo == null) {
                return;
            }
            TextMessage replyMessage = this.session.createTextMessage(((TextMessage)message).getText() + "; Receiver: PID@HOST: " + this.PID_DATA);
            replyMessage.setJMSCorrelationID(message.getJMSMessageID());
            MessageProducer producer = this.session.createProducer((Destination)replyTo);
            producer.send((Message)replyMessage);
            producer.close();
        }
        catch (JMSException e) {
            logger.error((URI)null, "onMessage", e.toString(), (Object)e);
        }
        catch (Exception e) {
            logger.error((URI)null, "onMessage", e.toString(), (Object)e);
        }
    }
}

