/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.quick;

import com.att.aft.dme2.jms.DME2JMSInitialContextFactory;
import com.att.aft.dme2.jms.quick.QuickListener;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class QuickServer
extends Thread {
    private static String uSAGE1 = "java " + QuickServer.class.getCanonicalName() + " -d <destination> -t <thread-count> -l <message-listener-class>";
    private static String uSAGE2 = "where: ";
    private static String uSAGE3 = "    -d <destination>    : A DME2 destination address [http://DME2LOCAL/service=../version=../envContext=../routeOffer=..";
    private static String uSAGE4 = "    -t <thread-count>   : The number of listener threads to instantiate";
    private static String uSAGE5 = "    -l <listener-class> : A javax.jms.MessageListener implementation whose onMessage() will be invoked on each message receipt.";
    private static String uSAGE6 = "                          This class MUST have either a default constructor OR a constructor with the following signature:";
    private static String uSAGE7 = "                          (javax.jms.Connection,javax.jms.Destination,javax.jms.Session)";
    private static String uSAGE_ALL = uSAGE1 + '\n' + uSAGE2 + '\n' + uSAGE3 + '\n' + uSAGE4 + '\n' + uSAGE5 + '\n' + uSAGE6 + '\n' + uSAGE7;
    private QueueConnection connection;
    private Queue destination;
    private Constructor<MessageListener> constructor;
    private QueueSession session;
    private QueueReceiver receiver;
    private boolean hasArgs = false;
    private boolean started = false;
    private Throwable cause = null;
    private int threadCount = 0;
    private static final int CONSTANT_100000 = 100000;
    private static final Logger logger = LoggerFactory.getLogger(QuickServer.class.getName());

    public QuickServer(String destinationString, int threadCount, Constructor<MessageListener> constructor, boolean hasArgs) throws NamingException, JMSException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.factory.initial", DME2JMSInitialContextFactory.class.getName());
        table.put("java.naming.provider.url", "qcf://dme2");
        System.out.println("Getting InitialContext");
        InitialContext context = new InitialContext(table);
        System.out.println("Looking up QueueConnectionFactory");
        QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup("qcf://dme2");
        System.out.println("Looking up request Queue");
        this.destination = (Queue)context.lookup(destinationString);
        System.out.println("Creating QueueConnection");
        this.connection = qcf.createQueueConnection();
        this.constructor = constructor;
        this.hasArgs = hasArgs;
        this.threadCount = threadCount;
    }

    @Override
    public synchronized void start() {
        for (int i = 0; i < this.threadCount; ++i) {
            try {
                this.session = this.connection.createQueueSession(true, 1);
                this.receiver = this.session.createReceiver(this.destination);
                MessageListener listener = null;
                listener = this.hasArgs ? this.constructor.newInstance(this.connection, this.destination, this.session) : this.constructor.newInstance(new Object[0]);
                this.receiver.setMessageListener((MessageListener)new QuickListener((Connection)this.connection, (Destination)this.destination, (Session)this.session, listener));
                continue;
            }
            catch (Throwable e) {
                this.started = false;
                this.cause = e;
            }
        }
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public static void main(String[] args) throws Exception {
        String destination = null;
        String threadCountStr = null;
        String listenerClassName = null;
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                destination = args[i + 1];
                continue;
            }
            if (args[i].equals("-t")) {
                threadCountStr = args[i + 1];
                continue;
            }
            if (args[i].equals("-l")) {
                listenerClassName = args[i + 1];
                continue;
            }
            if (args[i].equals("-f")) {
                filename = args[i + 1];
                continue;
            }
            if (!args[i].equals("-?")) continue;
            QuickServer.displayUsage();
            System.exit(0);
        }
        ArrayList<QuickServer> servers = new ArrayList<QuickServer>();
        if (filename == null) {
            servers.add(QuickServer.launchQuickServer(destination, listenerClassName, threadCountStr));
        } else {
            String row;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((row = reader.readLine()) != null) {
                String[] toks = row.split("\\|");
                if (toks.length != 3) {
                    System.err.println("WARNING: Invalid row found: " + row);
                    continue;
                }
                servers.add(QuickServer.launchQuickServer(toks[0], toks[1], toks[2]));
            }
        }
        boolean failure = false;
        for (QuickServer server : servers) {
            server.join();
            if (server.isStarted()) continue;
            System.err.println("A QuickServer startup failed");
            if (server.getCause() != null) {
                server.getCause().printStackTrace();
            }
            failure = true;
        }
        if (!failure) {
            System.out.println("QuickServer Startup Successful - " + new Date());
            while (true) {
                Thread.sleep(100000L);
            }
        }
        System.err.println("QuickServer Startup Failed - " + new Date());
    }

    private static QuickServer launchQuickServer(String destination, String listenerClassName, String threadCountStr) throws Exception {
        Constructor<MessageListener> constructor;
        if (destination == null || threadCountStr == null || listenerClassName == null) {
            System.err.println("ERROR: Invalid and/or missing arguments");
            QuickServer.displayUsage();
            System.exit(1);
        }
        Integer threadCount = null;
        try {
            threadCount = Integer.parseInt(threadCountStr);
        }
        catch (NumberFormatException e) {
            System.err.println("ERROR: Thread count argument must be an integer, not " + threadCountStr);
            System.exit(2);
        }
        if (threadCount < 1) {
            System.err.println("ERROR: Thread count must be 1 or higher");
            System.exit(3);
        }
        Class<?> clz = QuickServer.class.getClassLoader().loadClass(listenerClassName);
        boolean hasArgs = false;
        try {
            constructor = clz.getConstructor(Connection.class, Destination.class, Session.class);
            hasArgs = true;
        }
        catch (Exception e) {
            constructor = clz.getConstructor(new Class[0]);
            hasArgs = false;
        }
        QuickServer server = new QuickServer(destination, threadCount, constructor, hasArgs);
        server.start();
        return server;
    }

    private static void displayUsage() {
        System.out.println(uSAGE_ALL);
    }
}

