/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.samples;

import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TestClientSender
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TestClientSender.class.getName());
    private static int sentCounter = 0;
    private static int successCounter = 0;
    private static int failCounter = 0;
    private static int timeoutCounter = 0;
    private static int mismatchCounter = 0;
    private String ID = null;
    private static final int CONSTANT_PAUSETIME = 100;
    private static final int CONSTANT_60000 = 60000;
    private static final int CONSTANT_100 = 100;
    private final long pausetime = 100L;
    private Queue replyToQueue = null;
    private boolean running = false;
    private QueueSender sender = null;
    private QueueConnection conn = null;
    private QueueSession session = null;
    private final String jndiClass;
    private final String jndiUrl;
    private final String clientConn;
    private final String clientDest;
    private final String clientReplyTo;

    public static final void dumpCounters() {
        System.err.println("Sent=" + sentCounter + ", Success=" + successCounter + ", Timeout=" + timeoutCounter + ", MisMatch=" + mismatchCounter + ", Fail=" + failCounter);
    }

    public String getID() {
        return this.ID;
    }

    public TestClientSender(String ID, String jndiClass, String jndiUrl, String clientConn, String clientDest, String clientReplyTo) {
        this.ID = ID;
        this.jndiClass = jndiClass;
        this.jndiUrl = jndiUrl;
        this.clientConn = clientConn;
        this.clientDest = clientDest;
        this.clientReplyTo = clientReplyTo;
    }

    public void start() throws JMSException, NamingException {
        if (this.conn != null) {
            return;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.factory.initial", this.jndiClass);
        table.put("java.naming.provider.url", this.jndiUrl);
        System.out.println("Getting InitialContext");
        InitialContext context = new InitialContext(table);
        System.out.println("Looking up QueueConnectionFactory");
        QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(this.clientConn);
        System.out.println("Looking up requeust Queue");
        Queue requestQueue = (Queue)context.lookup(this.clientDest);
        System.out.println("Looking up reply Queue");
        this.replyToQueue = (Queue)context.lookup(this.clientReplyTo);
        System.out.println("Creating QueueConnection");
        this.conn = qcf.createQueueConnection();
        System.out.println("Creating Session");
        this.session = this.conn.createQueueSession(true, 0);
        System.out.println("Creating MessageProducer");
        this.sender = this.session.createSender(requestQueue);
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                TextMessage message = this.session.createTextMessage();
                String dataContext = System.getProperty("dataContext");
                if (dataContext != null) {
                    message.setObjectProperty("com.att.aft.dme2.jms.dataContext", (Object)dataContext);
                } else {
                    message.setObjectProperty("com.att.aft.dme2.jms.dataContext", (Object)"205977");
                }
                String partner = System.getProperty("partner");
                if (partner != null) {
                    message.setStringProperty("com.att.aft.dme2.jms.partner", partner);
                } else {
                    message.setStringProperty("com.att.aft.dme2.jms.partner", "1C");
                }
                String selKey = System.getProperty("selKey");
                if (selKey != null) {
                    message.setStringProperty("com.att.aft.dme2.jms.stickySelectorKey", selKey);
                }
                String sentID = this.ID + "::" + System.currentTimeMillis();
                String xmlMsg = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><SOAP-ENV:Header><m:MessageHeader xmlns:m=\"http://csi.cingular.com/CSI/Namespaces/Types/Public/MessageHeader.xsd\" xmlns:m0=\"http://csi.cingular.com/CSI/Namespaces/Types/Public/CingularDataModel.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><m:TrackingMessageHeader><m0:version>v44</m0:version><m0:messageId>Vasanthi_Thu4_Mar_26_09-19-55_PDT_2009</m0:messageId><m0:originatorId>String</m0:originatorId><m0:responseTo>String</m0:responseTo><m0:returnURL>String</m0:returnURL><m0:timeToLive>300000</m0:timeToLive><m0:conversationId>String</m0:conversationId><m0:dateTimeStamp>2001-12-17T09:30:47.0Z</m0:dateTimeStamp></m:TrackingMessageHeader><m:SecurityMessageHeader><m0:userName>csitest</m0:userName><m0:userPassword>testcsi</m0:userPassword></m:SecurityMessageHeader><m:SequenceMessageHeader><m0:sequenceNumber>1</m0:sequenceNumber><m0:totalInSequence>1</m0:totalInSequence></m:SequenceMessageHeader></m:MessageHeader></SOAP-ENV:Header><SOAP-ENV:Body><EchoRequest xmlns=\"http://csi.cingular.com/CSI/Namespaces/Container/Public/EchoRequest.xsd\"><data>M2EM2E is an Infrastructure Framework.  The primary goal of M2E is to provide a high performance runtime platform for execution of services that are modeled based on MDA.  The short term vision is to provide an alternate/redundant execution environment for the existing XPDL process models.  Long term, M2E may emerge as the primary execution environment.M2E-CSIM2E-CSI is an Application Framework.  M2E-CSI takes the Model Drive Architecture (MDA) developed at Cingular and replaces the runtime implementation for faster performance and better, more cost-effective resource usage, resulting in great Return on Investment in MDA technology.  M2E-CSI components are JMS-Listening services that play the role of \"SPM\" layer within the overall CSI Application Model.  They must listen on CSI EMS Brokers on specified Request Queues and must respond on CSI EMS Brokers on specified Response Queues.  The protocol is a CSI specific XML Document protocol, engineered to interact with \"The Gateway\" (see CSI Documents). </data></EchoRequest></SOAP-ENV:Body></SOAP-ENV:Envelope>";
                message.setText(sentID + xmlMsg);
                long start = System.currentTimeMillis();
                ++sentCounter;
                TextMessage response = this.send(message, 60000L);
                long elapsed = System.currentTimeMillis() - start;
                if (response == null) {
                    logger.info(null, "run", (LogMessage)JMSLogMessage.CLIENT_TIMEOUT, this.ID, elapsed, message.getJMSMessageID(), this.clientReplyTo);
                    ++timeoutCounter;
                } else {
                    logger.info((URI)null, "run", (LogMessage)JMSLogMessage.CLIENT_DATA, (Object)sentID, (Object)response.getText());
                    if (response.getText().startsWith(sentID)) {
                        logger.info(null, "run", (LogMessage)JMSLogMessage.CLIENT_SUCCESS, this.ID, response.getText(), elapsed, response.getJMSMessageID(), response.getJMSCorrelationID(), this.clientReplyTo);
                        ++successCounter;
                    } else {
                        logger.info(null, "run", (LogMessage)JMSLogMessage.CLIENT_MISMATCH, this.ID, this.ID, elapsed, response.getJMSMessageID(), response.getJMSCorrelationID(), this.clientReplyTo);
                        ++mismatchCounter;
                    }
                }
                if (mismatchCounter == 100) {
                    this.running = false;
                }
                Thread.sleep(100L);
            }
            catch (JMSException e) {
                logger.warn((URI)null, "run", (LogMessage)JMSLogMessage.CLIENT_JMSEX_RCV, (Object)this.ID, (Object)e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception e) {
                logger.warn((URI)null, "run", (LogMessage)JMSLogMessage.CLIENT_FATAL, (Object)this.ID, (Object)e);
                ++failCounter;
                return;
            }
        }
    }

    private TextMessage send(TextMessage message, long timeout) throws JMSException {
        message.setJMSReplyTo((Destination)this.replyToQueue);
        this.sender.send((Message)message);
        QueueReceiver consumer = this.session.createReceiver(this.replyToQueue, "JMSCorrelationID = '" + message.getJMSMessageID() + "'");
        return (TextMessage)consumer.receive(timeout);
    }

    public void stop() throws JMSException {
        this.running = false;
        if (this.conn != null) {
            this.sender.close();
            this.session.close();
            this.conn.close();
            this.sender = null;
            this.session = null;
        }
        this.conn = null;
    }
}

