/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.samples;

import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Random;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class TestReceiveServerListener
extends Thread
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(TestReceiveServerListener.class.getName());
    private int id = 0;
    private QueueSession session = null;
    private static int counter = 0;
    private Queue serverDest = null;
    private QueueReceiver receiver = null;
    private QueueConnection connection;
    private String PID_DATA;
    private Message msg = null;
    private int receiveTimeout;
    private static final int CONSTANT_10 = 10;
    private static final int CONSTANT_250 = 250;
    private Random random = new Random();

    public TestReceiveServerListener(QueueConnection connection, Queue serverDest, int receiveTimeout) {
        logger.debug(null, "ctor", LogMessage.METHOD_ENTER);
        logger.info(null, "ctor", "connection={} serverDest={} receiveTimeout={}", connection, serverDest, receiveTimeout);
        this.connection = connection;
        this.serverDest = serverDest;
        this.receiveTimeout = receiveTimeout;
        this.id = counter++;
        this.PID_DATA = ManagementFactory.getRuntimeMXBean().getName();
        logger.debug(null, "ctor", LogMessage.METHOD_EXIT);
    }

    public void start1() throws JMSException {
        this.session = this.connection.createQueueSession(true, 1);
        this.receiver = this.session.createReceiver(this.serverDest);
        this.receiver.setMessageListener((MessageListener)this);
    }

    public void stop1() throws JMSException {
        this.receiver.setMessageListener(null);
        this.receiver.close();
        this.session.close();
    }

    @Override
    public void run() {
        logger.debug(null, "run", LogMessage.METHOD_ENTER);
        try {
            this.session = this.connection.createQueueSession(true, 1);
            this.receiver = this.session.createReceiver(this.serverDest);
            while (true) {
                this.msg = this.receiver.receive((long)this.receiveTimeout);
                if (this.msg == null) continue;
                try {
                    this.onMessage(this.msg);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(null, "run", LogMessage.METHOD_EXIT);
            return;
        }
    }

    public void onMessage(Message message) {
        try {
            logger.debug((URI)null, "onMessage", "Message arrived : {} for reply {}", (Object)message.getJMSMessageID(), (Object)message.getJMSReplyTo());
            Queue replyTo = (Queue)message.getJMSReplyTo();
            if (replyTo == null) {
                logger.info(null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_RECOW, this.id, message.getJMSMessageID(), message.getJMSCorrelationID());
                return;
            }
            Thread.sleep(10L);
            Thread.sleep(this.random.nextInt(10) + 250);
            TextMessage replyMessage = this.session.createTextMessage(((TextMessage)message).getText() + "; Receiver: PID@HOST: " + this.PID_DATA);
            replyMessage.setJMSCorrelationID(message.getJMSMessageID());
            MessageProducer producer = this.session.createProducer((Destination)replyTo);
            producer.send((Message)replyMessage);
            logger.debug((URI)null, "onMessage", "Message left : {} for reply {}", (Object)message.getJMSMessageID(), (Object)message.getJMSReplyTo());
            producer.close();
            logger.info(null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_RECRR, this.id, replyMessage.getJMSMessageID(), replyMessage.getJMSCorrelationID(), replyTo.getQueueName());
        }
        catch (JMSException e) {
            try {
                logger.debug((URI)null, "onMessage", "Message exception: {} for reply {}", new Object[]{message.getJMSMessageID(), message.getJMSReplyTo(), e});
            }
            catch (Exception e1) {
                logger.debug((URI)null, "onMessage", "Message exception: {}", (Object)message, (Object)e);
            }
            logger.error((URI)null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_EX, (Object)this.id, (Object)e);
        }
        catch (Exception e) {
            logger.warn((URI)null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_EX, (Object)this.id, (Object)e);
        }
    }
}

