/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.samples;

import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.net.URI;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class TestServerListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(TestServerListener.class.getName());
    private int id = 0;
    private QueueSession session = null;
    private static int counter = 0;
    private Queue serverDest = null;
    private QueueReceiver receiver = null;
    private final QueueConnection connection;
    private final String PID_DATA;

    public TestServerListener(QueueConnection connection, Queue serverDest) {
        this.connection = connection;
        this.serverDest = serverDest;
        this.id = counter++;
        this.PID_DATA = ManagementFactory.getRuntimeMXBean().getName();
    }

    public void start() throws JMSException {
        this.session = this.connection.createQueueSession(true, 1);
        this.receiver = this.session.createReceiver(this.serverDest);
        this.receiver.setMessageListener((MessageListener)this);
    }

    public void stop() throws JMSException {
        this.receiver.setMessageListener(null);
        this.receiver.close();
        this.session.close();
    }

    public void onMessage(Message message) {
        try {
            Queue replyTo = (Queue)message.getJMSReplyTo();
            if (replyTo == null) {
                logger.info(null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_RECOW, this.id, message.getJMSMessageID(), message.getJMSCorrelationID());
                return;
            }
            TextMessage replyMessage = this.session.createTextMessage(((TextMessage)message).getText() + "; Receiver: PID@HOST: " + this.PID_DATA);
            replyMessage.setJMSCorrelationID(message.getJMSMessageID());
            MessageProducer producer = this.session.createProducer((Destination)replyTo);
            producer.send((Message)replyMessage);
            producer.close();
            logger.info(null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_RECRR, this.id, replyMessage.getJMSMessageID(), replyMessage.getJMSCorrelationID(), replyTo.getQueueName());
        }
        catch (Exception e) {
            logger.warn((URI)null, "onMessage", (LogMessage)JMSLogMessage.CLIENT_EX, (Object)this.id, (Object)e);
        }
    }
}

