/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.samples;

import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TestTemporaryClientSender
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TestTemporaryClientSender.class.getName());
    private static int sentCounter = 0;
    private static int successCounter = 0;
    private static int failCounter = 0;
    private static int timeoutCounter = 0;
    private static int mismatchCounter = 0;
    private String ID = null;
    private static final int CONSTANT_100 = 100;
    private final long pausetime = 100L;
    private static final int CONSTANT_20000 = 20000;
    private boolean running = false;
    private QueueSender sender = null;
    private QueueConnection conn = null;
    private QueueSession session = null;
    private final String jndiClass;
    private final String jndiUrl;
    private final String clientConn;
    private final String clientDest;
    private String clientReplyTo;

    public static final void dumpCounters() {
        System.err.println("Sent=" + sentCounter + ", Success=" + successCounter + ", Timeout=" + timeoutCounter + ", MisMatch=" + mismatchCounter + ", Fail=" + failCounter);
    }

    public String getID() {
        return this.ID;
    }

    public TestTemporaryClientSender(String ID, String jndiClass, String jndiUrl, String clientConn, String clientDest) {
        this.ID = ID;
        this.jndiClass = jndiClass;
        this.jndiUrl = jndiUrl;
        this.clientConn = clientConn;
        this.clientDest = clientDest;
    }

    public void start() throws JMSException, NamingException {
        if (this.conn != null) {
            return;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.factory.initial", this.jndiClass);
        table.put("java.naming.provider.url", this.jndiUrl);
        System.out.println("Getting InitialContext");
        InitialContext context = new InitialContext(table);
        System.out.println("Looking up QueueConnectionFactory");
        QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(this.clientConn);
        System.out.println("Looking up requeust Queue");
        Queue requestQueue = (Queue)context.lookup(this.clientDest);
        System.out.println("Creating QueueConnection");
        this.conn = qcf.createQueueConnection();
        System.out.println("Creating Session");
        this.session = this.conn.createQueueSession(true, 0);
        TemporaryQueue strandedQueue = this.session.createTemporaryQueue();
        System.out.println("Created stranded queue:" + strandedQueue + " at " + System.currentTimeMillis());
        System.out.println("Creating MessageProducer");
        this.sender = this.session.createSender(requestQueue);
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                TextMessage message = this.session.createTextMessage();
                message.setStringProperty("com.att.aft.dme2.jms.dataContext", "205977");
                message.setStringProperty("com.att.aft.dme2.jms.partner", "APPLE");
                String sentID = this.ID + "::" + System.currentTimeMillis();
                message.setText(sentID);
                long start = System.currentTimeMillis();
                ++sentCounter;
                TextMessage response = this.send(message, 20000L);
                long elapsed = System.currentTimeMillis() - start;
                if (response == null) {
                    logger.info(null, "run", (LogMessage)JMSLogMessage.CLIENT_TIMEOUT, this.ID, elapsed, message.getJMSMessageID(), this.clientReplyTo);
                    ++timeoutCounter;
                } else {
                    logger.debug((URI)null, "run", (LogMessage)JMSLogMessage.CLIENT_DATA, (Object)sentID, (Object)response.getText());
                    if (response.getText().startsWith(sentID)) {
                        logger.info(null, "run", (LogMessage)JMSLogMessage.CLIENT_SUCCESS, this.ID, response.getText(), elapsed, response.getJMSMessageID(), response.getJMSCorrelationID(), this.clientReplyTo);
                        ++successCounter;
                    } else {
                        logger.info(null, "run", (LogMessage)JMSLogMessage.CLIENT_MISMATCH, this.ID, elapsed, response.getJMSMessageID(), response.getJMSCorrelationID(), this.clientReplyTo);
                        ++mismatchCounter;
                    }
                }
                Thread.sleep(100L);
                this.running = false;
            }
            catch (JMSException e) {
                logger.warn((URI)null, "run", (LogMessage)JMSLogMessage.CLIENT_JMSEX_RCV, (Object)this.ID, (Object)e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception e) {
                logger.error((URI)null, "run", (LogMessage)JMSLogMessage.CLIENT_FATAL, (Object)this.ID, (Object)e);
                ++failCounter;
                return;
            }
        }
    }

    private TextMessage send(TextMessage message, long timeout) throws JMSException {
        TemporaryQueue replyToQueue = this.session.createTemporaryQueue();
        message.setJMSReplyTo((Destination)replyToQueue);
        this.sender.send((Message)message);
        QueueReceiver consumer = this.session.createReceiver((Queue)replyToQueue, "JMSCorrelationID = '" + message.getJMSMessageID() + "'");
        return (TextMessage)consumer.receive(timeout);
    }

    public void stop() throws JMSException {
        this.running = false;
        if (this.conn != null) {
            this.sender.close();
            this.session.close();
            this.conn.close();
            this.sender = null;
            this.session = null;
        }
        this.conn = null;
    }
}

