/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.util;

import com.att.aft.dme2.jms.util.DME2JNDIStorableInterface;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class DME2JNDIReferenceFactory
implements ObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(DME2JNDIReferenceFactory.class.getName());

    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        DME2JNDIStorableInterface result = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            logger.info(null, "getObjectInstance", "Getting instance of " + reference.getClassName());
            Class<?> theClass = DME2JNDIReferenceFactory.loadClass(this, reference.getClassName());
            if (DME2JNDIStorableInterface.class.isAssignableFrom(theClass)) {
                DME2JNDIStorableInterface store = (DME2JNDIStorableInterface)theClass.newInstance();
                Properties properties = new Properties();
                Enumeration<RefAddr> iter = reference.getAll();
                while (iter.hasMoreElements()) {
                    StringRefAddr addr = (StringRefAddr)iter.nextElement();
                    properties.put(addr.getType(), addr.getContent() == null ? "" : addr.getContent());
                }
                store.setProperties(properties);
                result = store;
            }
        } else {
            logger.error(null, "getObjectInstance", "Object " + object + " is not a reference - cannot load");
            throw new RuntimeException("Object " + object + " is not a reference");
        }
        return result;
    }

    public static Reference createReference(String instanceClassName, DME2JNDIStorableInterface po) throws NamingException {
        logger.info(null, "createReference", "Creating reference: " + instanceClassName + "," + po);
        Reference result = new Reference(instanceClassName, DME2JNDIReferenceFactory.class.getName(), null);
        try {
            Properties props = po.getProperties();
            Enumeration<?> iter = props.propertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = props.getProperty(key);
                StringRefAddr addr = new StringRefAddr(key, value);
                result.add(addr);
            }
        }
        catch (Exception e) {
            logger.error(null, "createReference", e.getMessage());
            throw new NamingException(e.getMessage());
        }
        return result;
    }

    public static Class<?> loadClass(Object thisObj, String className) throws ClassNotFoundException {
        ClassLoader loader = thisObj.getClass().getClassLoader();
        Class<?> theClass = loader != null ? loader.loadClass(className) : Class.forName(className);
        return theClass;
    }
}

