/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.util;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSRemoteQueue;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ErrorContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;

public class DME2UniformResource {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSRemoteQueue.class.getName());
    public static final String STICKY_SELECTOR_KEY = "stickySelectorKey";
    public static final String DATA_CONTEXT_KEY = "dataContext";
    public static final String MATCH_VERSION_RANGE_KEY = "matchVersionRange";
    public static final String PARTNER_KEY = "partner";
    public static final String PREFERRED_ROUTE_OFFER = "preferredRouteOffer";
    private final URL url;
    private final String host;
    private final String path;
    private String stickySelectorKey;
    private String dataContext;
    private String envContext;
    private String partner;
    private String routeOffer;
    private String service;
    private String bindContext;
    private String subContext;
    private String version;
    private String userName;
    private String password;
    private String realmName;
    private String loginMethod;
    private String queryParams;
    private String logicalService;
    private String namespace;
    private String supportedVersionRange;
    private String driver;
    private String nonFailoverStatusCodesParam;
    private long endpointReadTimeout;
    private long roundTripTimeout;
    private long connectTimeout;
    private boolean preferLocalEPs;
    private boolean ignoreFailoverOnExpire;
    private boolean useVersionRange = true;
    private String[] allowedRoles;
    private DME2UrlType urlType;
    private DME2Configuration config;
    private int wsConnIdleTimeout;
    private int maxMessageSize = 5000;
    private final Map<String, String> queryParamsMap = new HashMap<String, String>();
    private String preferredRouteOffer;
    private boolean ignoreWsFailover = false;
    private Float throttlePctPerPartner = null;
    private Boolean throttleFilterDisabled;
    private String preferredVersion;

    public DME2UniformResource(DME2Configuration config, URI inURI) throws MalformedURLException {
        this(config, inURI.toURL());
    }

    public DME2UniformResource(DME2Configuration config, String inURLString) throws MalformedURLException {
        this(config, new URL(inURLString));
    }

    public DME2UniformResource(DME2Configuration config, String protocol, String host, int port, String path, URLStreamHandler handler) throws MalformedURLException {
        this(config, new URL(protocol, host, port, path, handler));
    }

    public DME2UniformResource(DME2Configuration config, URL inURL) {
        this.url = inURL;
        this.host = inURL.getHost();
        this.urlType = this.getDME2URLType(inURL.getHost());
        this.path = inURL.getPath();
        this.config = config;
        this.processResourcePath(inURL.getPath());
    }

    private DME2UrlType getDME2URLType(String host) {
        DME2UrlType type = null;
        type = host == null || host.toUpperCase().equals("DME2SEARCH") ? DME2UrlType.SEARCHABLE : (host.toUpperCase().equals("DME2RESOLVE") ? DME2UrlType.RESOLVABLE : DME2UrlType.DIRECT);
        return type;
    }

    private void processResourcePath(String inPath) {
        String[] toks = inPath.split("/");
        String inSubContext = null;
        this.service = this.getField(inPath, "/service=");
        this.version = this.getField(inPath, "/version=");
        this.partner = this.getField(inPath, "/partner=");
        this.envContext = this.getField(inPath, "/envContext=");
        this.dataContext = this.getField(inPath, "/dataContext=");
        this.routeOffer = this.getField(inPath, "/routeOffer=");
        this.bindContext = this.getField(inPath, "/bindContext=");
        this.stickySelectorKey = this.getField(inPath, "/stickySelectorKey=");
        this.namespace = this.getField(inPath, "/namespace=");
        this.driver = this.getField(inPath, "/driver=");
        this.preferredRouteOffer = this.getField(inPath, "/preferredRouteOffer=");
        for (String tok : toks) {
            if (inSubContext != null) {
                inSubContext = inSubContext + "/" + tok;
                continue;
            }
            String[] pair = tok.split("=");
            String key = pair[0];
            if (!key.equalsIgnoreCase("subcontext")) continue;
            inSubContext = "";
        }
        if (this.service == null || this.version == null && this.envContext == null) {
            String qParams = this.url.getQuery();
            if (qParams != null) {
                String[] queryToks;
                for (String qtok : queryToks = qParams.split("&")) {
                    String[] pair = qtok.split("=");
                    if (pair.length != 2) continue;
                    String key = pair[0];
                    String value = pair[1];
                    if (key.equalsIgnoreCase("routeoffer")) {
                        this.routeOffer = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("version")) {
                        this.version = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("envcontext")) {
                        this.envContext = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("stickyselectorkey")) {
                        this.stickySelectorKey = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(DATA_CONTEXT_KEY)) {
                        this.dataContext = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(PARTNER_KEY)) {
                        this.partner = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("ns")) {
                        this.namespace = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("subcontext")) {
                        inSubContext = value;
                        continue;
                    }
                    if (!key.equalsIgnoreCase(PREFERRED_ROUTE_OFFER)) continue;
                    this.preferredRouteOffer = value;
                }
            }
            if (this.urlType != DME2UrlType.RESOLVABLE && this.urlType != DME2UrlType.SEARCHABLE && this.version != null && this.envContext != null && (this.routeOffer != null || this.partner != null) && this.service == null) {
                String uriServiceName = this.url.getHost();
                int port = this.url.getPort();
                String serviceUri = null;
                serviceUri = this.getNamespace() == null ? this.getReversed(uriServiceName) : uriServiceName;
                if (this.url.getPath() != null && !this.url.getPath().equals("/")) {
                    this.bindContext = this.url.getPath();
                }
                String cpath = null;
                if (this.bindContext != null) {
                    cpath = this.bindContext.startsWith("/") ? this.bindContext.substring(1, this.bindContext.length()) : this.bindContext;
                }
                this.service = this.bindContext != null && cpath != null ? serviceUri + "/" + cpath.replaceAll("\\.", "\\\\\\\\.") : serviceUri;
                if (this.service != null && port <= 0) {
                    this.urlType = DME2UrlType.STANDARD;
                }
            }
        }
        this.subContext = inSubContext;
        this.processQueryString(this.url.getQuery());
    }

    private void processQueryString(String inQueryStr) {
        if (inQueryStr != null) {
            String[] queryToks;
            for (String qtok : queryToks = inQueryStr.split("&")) {
                String[] pair = qtok.split("=");
                if (pair.length != 2) continue;
                String key = pair[0];
                String value = pair[1];
                if (key.equalsIgnoreCase("endpointreadtimeout")) {
                    try {
                        this.endpointReadTimeout = Math.min(Long.parseLong(value), this.config.getLong("AFT_DME2_EP_READ_TIMEOUT"));
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "processQueryString", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                } else if (key.equalsIgnoreCase("roundtriptimeout")) {
                    try {
                        this.roundTripTimeout = Math.min(Long.parseLong(value), this.config.getLong("AFT_DME2_DEF_ROUNDTRIP_TIMEOUT_MS"));
                    }
                    catch (Exception e) {
                        this.roundTripTimeout = this.config.getLong("AFT_DME2_DEF_ROUNDTRIP_TIMEOUT_MS");
                    }
                } else if (key.equalsIgnoreCase("preferlocal")) {
                    this.preferLocalEPs = true;
                } else if (key.equalsIgnoreCase("ignorefailoveronexpire")) {
                    this.ignoreFailoverOnExpire = true;
                } else if (key.equalsIgnoreCase("ignoreWsfailover")) {
                    this.ignoreWsFailover = true;
                } else if (key.equalsIgnoreCase("connecttimeoutinms")) {
                    try {
                        this.connectTimeout = Math.min(Long.parseLong(value), this.config.getLong("AFT_DME2_EP_CONN_TIMEOUT"));
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "processQueryString", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                } else if (key.equalsIgnoreCase("username")) {
                    this.userName = value;
                } else if (key.equalsIgnoreCase("password")) {
                    this.password = value;
                } else if (key.equalsIgnoreCase("realm")) {
                    this.realmName = value;
                } else if (key.equalsIgnoreCase("loginmethod")) {
                    this.loginMethod = value;
                } else if (key.equalsIgnoreCase("allowedroles") && value != null) {
                    this.allowedRoles = value.split(",");
                } else if (key.equalsIgnoreCase(MATCH_VERSION_RANGE_KEY)) {
                    this.useVersionRange = Boolean.parseBoolean(value);
                } else if (key.equalsIgnoreCase("supportedVersionRange")) {
                    this.supportedVersionRange = value;
                } else if (key.equalsIgnoreCase("DME2NonFailoverStatusCodes")) {
                    this.nonFailoverStatusCodesParam = value;
                } else if (key.equalsIgnoreCase("wsConnIdleTimeout")) {
                    try {
                        this.wsConnIdleTimeout = Integer.parseInt(value) == 0 ? this.config.getInt("AFT_DME2_DEF_WS_IDLE_TIMEOUT") : Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "processQueryString", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                } else if (key.equalsIgnoreCase("throttlePctPerPartner")) {
                    try {
                        this.throttlePctPerPartner = Float.valueOf(Float.parseFloat(value));
                    }
                    catch (Exception exception) {
                        logger.debug((URI)null, "processQueryString", LogMessage.DEBUG_MESSAGE, (Object)"Error parsing Throttle percent per partner.", (Object)exception);
                    }
                } else if (key.equalsIgnoreCase("throttleFilterDisabled")) {
                    try {
                        this.throttleFilterDisabled = Boolean.valueOf(value);
                    }
                    catch (Exception exception) {
                        logger.debug((URI)null, "processQueryString", LogMessage.DEBUG_MESSAGE, (Object)"Error parsing Throttle filter disabled query parameter", (Object)exception);
                    }
                } else {
                    this.queryParams = this.queryParams == null ? key + "=" + value : this.queryParams + "&" + key + "=" + value;
                }
                this.queryParamsMap.put(key, value);
            }
        }
    }

    private String getReversed(String uriServiceName) {
        if (this.isIPAddress(uriServiceName)) {
            return null;
        }
        String[] domainNameArr = uriServiceName.split("\\.");
        StringBuffer reversedString = new StringBuffer();
        for (int i = domainNameArr.length - 1; i >= 0; --i) {
            if (i != 0) {
                reversedString.append(domainNameArr[i] + ".");
                continue;
            }
            reversedString.append(domainNameArr[i]);
        }
        return reversedString.toString();
    }

    private boolean isIPAddress(String ipAddress) {
        String[] tokens = ipAddress.split("\\.");
        if (tokens.length != 4) {
            return false;
        }
        for (String str : tokens) {
            try {
                int i = Integer.parseInt(str);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public String getRegistryFindEndpointSearchKey() {
        if (!this.service.contains("/")) {
            return this.service;
        }
        String uriServiceName = this.service.split("/", 2)[0];
        if (this.namespace == null) {
            return uriServiceName + "*";
        }
        return this.namespace + DME2Constants.getNAME_SEP() + uriServiceName + "*";
    }

    public String getRouteInfoServiceSearchKey() {
        String uriServiceName = this.service.split("/", 2)[0];
        if (this.namespace == null) {
            return uriServiceName;
        }
        return this.namespace + DME2Constants.getNAME_SEP() + uriServiceName;
    }

    public void assertValid() throws DME2Exception {
        ErrorContext ec = new ErrorContext().add("URL", this.url.toString());
        switch (this.urlType) {
            case SEARCHABLE: {
                if (this.partner != null) break;
                throw new DME2Exception("AFT-DME2-9703", ec);
            }
            case RESOLVABLE: 
            case DIRECT: 
            case STANDARD: {
                if (this.routeOffer != null || this.partner != null) break;
                throw new DME2Exception("AFT-DME2-9704", ec);
            }
            default: {
                throw new DME2Exception("AFT-DME2-9705", ec);
            }
        }
        if (this.service == null) {
            throw new DME2Exception("AFT-DME2-9700", ec);
        }
        if (this.version == null) {
            throw new DME2Exception("AFT-DME2-9701", ec);
        }
        if (this.envContext == null) {
            throw new DME2Exception("AFT-DME2-9702", ec);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getDataContext() {
        return this.dataContext;
    }

    public String getEnvContext() {
        return this.envContext;
    }

    public String getPartner() {
        return this.partner;
    }

    public String getRouteOffer() {
        return this.routeOffer;
    }

    public String getService() {
        return this.service;
    }

    public String getBindContext() {
        return this.bindContext;
    }

    public String getSubContext() {
        return this.subContext;
    }

    public void setSubContext(String subContext) {
        this.subContext = subContext;
    }

    public String getVersion() {
        return this.preferredVersion == null ? this.version : this.preferredVersion;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getLoginMethod() {
        return this.loginMethod;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public String getLogicalService() {
        return this.logicalService;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSupportedVersionRange() {
        return this.supportedVersionRange;
    }

    public String getNonFailoverStatusCodesParam() {
        return this.nonFailoverStatusCodesParam;
    }

    public long getEndpointReadTimeout() {
        return this.endpointReadTimeout;
    }

    public long getRoundTripTimeout() {
        return this.roundTripTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isPreferLocalEPs() {
        return this.preferLocalEPs;
    }

    public boolean isIgnoreFailoverOnExpire() {
        return this.ignoreFailoverOnExpire;
    }

    public boolean isUseVersionRange() {
        return this.useVersionRange;
    }

    public String[] getAllowedRoles() {
        return this.allowedRoles;
    }

    public DME2UrlType getUrlType() {
        return this.urlType;
    }

    public String getStickySelectorKey() {
        return this.stickySelectorKey;
    }

    public URL getOriginalURL() {
        return this.url;
    }

    public boolean isUsingVersionRanges() {
        return this.useVersionRange;
    }

    public String toString() {
        return this.url.toString();
    }

    public Map<String, String> getQueryParamsMap() {
        return this.queryParamsMap;
    }

    public String getDriver() {
        return this.driver;
    }

    private String getField(String servletPath, String field) {
        String fieldsWithSlash = this.config.getProperty("DME2_URI_FIELD_WITH_PATH_SEP", "/service=,/subContext=");
        boolean canEndWithSlash = false;
        if (fieldsWithSlash != null) {
            canEndWithSlash = fieldsWithSlash.contains(field);
        }
        return this.getField(servletPath, field, canEndWithSlash);
    }

    private String getField(String servletPath, String field, boolean canEndWithSlash) {
        int indexOfField = -1;
        indexOfField = servletPath.toLowerCase().indexOf(field.toLowerCase());
        if (indexOfField != -1) {
            try {
                String fieldVal = null;
                int indexOfNext = servletPath.indexOf("=", indexOfField + field.length());
                if (indexOfNext != -1) {
                    String temp = servletPath.substring(indexOfField, indexOfNext);
                    fieldVal = temp.substring(temp.indexOf("=") + 1, temp.lastIndexOf("/"));
                } else {
                    fieldVal = !canEndWithSlash && servletPath.endsWith("/") ? servletPath.substring(indexOfField + field.length(), servletPath.length() - 1) : servletPath.substring(indexOfField + field.length());
                }
                if (!canEndWithSlash && fieldVal != null && fieldVal.contains("/")) {
                    fieldVal = fieldVal.replaceAll("/", "");
                }
                if (fieldVal != null && fieldVal.contains("/") && fieldVal.replaceAll("/", "").length() == fieldVal.length() - 1 && fieldVal.indexOf("/") == fieldVal.length() - 1) {
                    fieldVal = fieldVal.replace("/", "");
                }
                return fieldVal != null ? (fieldVal.length() > 0 ? fieldVal : null) : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public long getWsConnIdleTimeout() {
        return this.wsConnIdleTimeout;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public String getPreferredRouteOffer() {
        return this.preferredRouteOffer;
    }

    public boolean isIgnoreWsFailover() {
        return this.ignoreWsFailover;
    }

    public Float getThrottlePctPerPartner() {
        return this.throttlePctPerPartner;
    }

    public void setThrottlePctPerPartner(Float throttlePctPerPartner) {
        this.throttlePctPerPartner = throttlePctPerPartner;
    }

    public Boolean getThrottleFilterDisabled() {
        return this.throttleFilterDisabled;
    }

    public void setThrottleFilterDisabled(Boolean throttleFilterDisabled) {
        this.throttleFilterDisabled = throttleFilterDisabled;
    }

    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(String preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public static enum DME2UrlType {
        DIRECT,
        RESOLVABLE,
        SEARCHABLE,
        STANDARD;

    }
}

