/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.logging;

import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.LoggingContext;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final DateFormat dateFormat = new SimpleDateFormat(System.getProperty("DME_LOGGER_DATE_FORMAT", "yyyy-MM-dd HH:mm:ss.S"));
    private static final String MSG_PARAMS = "{} {} {} {} {} {} {} {} ";
    private static final String DEFAULT_HOSTNAME;
    private static final String DEFAULT_PID;
    private static final String DEFAULT_THREADID;
    org.slf4j.Logger logger;
    String className;

    public Logger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.className = name;
    }

    public void error(URI serviceUri, String method, String msg) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
    }

    public void error(URI serviceUri, String method, LogMessage msg) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
    }

    public void error(String conversationId, URI serviceUri, String method, String msg) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
    }

    public void error(String conversationId, URI serviceUri, String method, LogMessage msg) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
    }

    public void error(URI serviceUri, String method, String msg, Object arg1) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
    }

    public void error(URI serviceUri, String method, LogMessage msg, Object arg1) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
    }

    public void error(String conversationId, URI serviceUri, String method, String msg, Object arg1) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
    }

    public void error(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
    }

    public void error(URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
    }

    public void error(URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
    }

    public void error(String conversationId, URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
    }

    public void error(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
    }

    public void error(URI serviceUri, String method, String msg, Object ... args) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
    }

    public void error(URI serviceUri, String method, LogMessage msg, Object ... args) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
    }

    public void error(String conversationId, URI serviceUri, String method, String msg, Object ... args) {
        this.logger.error(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
    }

    public void error(String conversationId, URI serviceUri, String method, LogMessage msg, Object ... args) {
        this.logger.error(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
    }

    public void warn(URI serviceUri, String method, String msg) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
    }

    public void warn(URI serviceUri, String method, LogMessage msg) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
    }

    public void warn(String conversationId, URI serviceUri, String method, String msg) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
    }

    public void warn(String conversationId, URI serviceUri, String method, LogMessage msg) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
    }

    public void warn(URI serviceUri, String method, String msg, Object arg1) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
    }

    public void warn(URI serviceUri, String method, LogMessage msg, Object arg1) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
    }

    public void warn(String conversationId, URI serviceUri, String method, String msg, Object arg1) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
    }

    public void warn(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
    }

    public void warn(URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
    }

    public void warn(URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
    }

    public void warn(String conversationId, URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
    }

    public void warn(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
    }

    public void warn(URI serviceUri, String method, String msg, Object ... args) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
    }

    public void warn(URI serviceUri, String method, LogMessage msg, Object ... args) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
    }

    public void warn(String conversationId, URI serviceUri, String method, String msg, Object ... args) {
        this.logger.warn(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
    }

    public void warn(String conversationId, URI serviceUri, String method, LogMessage msg, Object ... args) {
        this.logger.warn(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
    }

    public void info(URI serviceUri, String method, String msg) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
    }

    public void info(URI serviceUri, String method, LogMessage msg) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
    }

    public void info(String conversationId, URI serviceUri, String method, String msg) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
    }

    public void info(String conversationId, URI serviceUri, String method, LogMessage msg) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
    }

    public void info(URI serviceUri, String method, String msg, Object arg1) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
    }

    public void info(URI serviceUri, String method, LogMessage msg, Object arg1) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
    }

    public void info(String conversationId, URI serviceUri, String method, String msg, Object arg1) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
    }

    public void info(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
    }

    public void info(URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
    }

    public void info(URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
    }

    public void info(String conversationId, URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
    }

    public void info(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
    }

    public void info(URI serviceUri, String method, String msg, Object ... args) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
    }

    public void info(URI serviceUri, String method, LogMessage msg, Object ... args) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
    }

    public void info(String conversationId, URI serviceUri, String method, String msg, Object ... args) {
        this.logger.info(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
    }

    public void info(String conversationId, URI serviceUri, String method, LogMessage msg, Object ... args) {
        this.logger.info(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
    }

    public void debug(URI serviceUri, String method, String msg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
        }
    }

    public void debug(URI serviceUri, String method, LogMessage msg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, new Object[0]));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, String msg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, LogMessage msg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, new Object[0]));
        }
    }

    public void debug(URI serviceUri, String method, String msg, Object arg1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
        }
    }

    public void debug(URI serviceUri, String method, LogMessage msg, Object arg1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, String msg, Object arg1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1));
        }
    }

    public void debug(URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
        }
    }

    public void debug(URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, arg1, arg2));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, String msg, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, LogMessage msg, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, arg1, arg2));
        }
    }

    public void debug(URI serviceUri, String method, String msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
        }
    }

    public void debug(URI serviceUri, String method, LogMessage msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, LoggingContext.get("trackingid"), serviceUri, this.className, method, args));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, String msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
        }
    }

    public void debug(String conversationId, URI serviceUri, String method, LogMessage msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.formatMessage(msg.getTemplate()), Logger.formatArgs((Long)System.currentTimeMillis(), DEFAULT_HOSTNAME, DEFAULT_PID, DEFAULT_THREADID, conversationId, serviceUri, this.className, method, args));
        }
    }

    private static Object[] formatArgs(Date date, String hostname, String pid, String threadId, String conversationId, URI serviceUri, Class clazz, Method method, Object ... args) {
        return Logger.formatArgs(date, hostname, pid, threadId, conversationId, serviceUri, Logger.formatClass(clazz), Logger.formatMethod(method), args);
    }

    private static Object[] formatArgs(Long date, String hostname, String pid, String threadId, String conversationId, URI serviceUri, Class clazz, Method method, Object ... args) {
        return Logger.formatArgs(new Date(date), hostname, pid, threadId, conversationId, serviceUri, Logger.formatClass(clazz), Logger.formatMethod(method), args);
    }

    private static Object[] formatArgs(Date date, String hostname, String pid, String threadId, String conversationId, URI serviceUri, String clazz, String method, Object ... args) {
        Object[] newArgs = new Object[8 + args.length];
        newArgs[0] = Logger.formatDate(date);
        newArgs[1] = hostname;
        newArgs[2] = pid;
        newArgs[3] = threadId;
        newArgs[4] = conversationId;
        newArgs[5] = Logger.formatServiceUri(serviceUri);
        newArgs[6] = clazz;
        newArgs[7] = method;
        int i = 8;
        for (Object o : args) {
            newArgs[i++] = o;
        }
        return newArgs;
    }

    private static Object[] formatArgs(Date date, String hostname, String pid, String threadId, String conversationId, URI serviceUri, Class clazz, String method, Object ... args) {
        return Logger.formatArgs(date, hostname, pid, threadId, conversationId, serviceUri, Logger.formatClass(clazz), method, args);
    }

    private static Object[] formatArgs(Long date, String hostname, String pid, String threadId, String conversationId, URI serviceUri, Class clazz, String method, Object ... args) {
        return Logger.formatArgs(new Date(date), hostname, pid, threadId, conversationId, serviceUri, Logger.formatClass(clazz), method, args);
    }

    private static Object[] formatArgs(Long date, String hostname, String pid, String threadId, String conversationId, URI serviceUri, String className, String method, Object ... args) {
        return Logger.formatArgs(new Date(date), hostname, pid, threadId, conversationId, serviceUri, className, method, args);
    }

    private static String formatMethod(Method method) {
        return method == null ? "NULL" : method.getName();
    }

    private static String formatClass(Class clazz) {
        return clazz == null ? "NULL" : clazz.getName();
    }

    private static String formatServiceUri(URI serviceUri) {
        return serviceUri == null ? "NULL" : serviceUri.toASCIIString();
    }

    private static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    private static String formatMessage(String msg) {
        return MSG_PARAMS + msg;
    }

    static {
        DEFAULT_PID = ManagementFactory.getRuntimeMXBean().getName();
        DEFAULT_THREADID = Thread.currentThread().getName() + "-" + Thread.currentThread().getId();
        String tmpHostname = "Unknown";
        try {
            tmpHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
        }
        finally {
            DEFAULT_HOSTNAME = tmpHostname;
        }
    }
}

