/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.logging;

import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.LinkedHashMap;

public class LoggingContext {
    private static ThreadLocal<LinkedHashMap<String, String>> ctxThreadLocal = new ThreadLocal();
    public static final String TRACKINGID = "trackingid";
    public static final String USER = "user";

    public static void addContextParam(String name, String value) {
        LinkedHashMap<String, String> ctxMap = LoggingContext.getCurrentCtxMap();
        ctxMap.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, String> getCurrentCtxMap() {
        LinkedHashMap<String, String> ctxMap = ctxThreadLocal.get();
        Class<LoggingContext> clazz = LoggingContext.class;
        synchronized (LoggingContext.class) {
            if (ctxMap == null) {
                ctxMap = new LinkedHashMap();
                ctxThreadLocal.set(ctxMap);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ctxMap;
        }
    }

    public static void put(String key, String value) {
        LoggingContext.addContextParam(key, value);
    }

    public static String get(String key) {
        return LoggingContext.get(key, null);
    }

    public static String get(String key, String defaultValue) {
        LinkedHashMap<String, String> map = ctxThreadLocal.get();
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void reset() {
        LinkedHashMap ctxMap = new LinkedHashMap();
        ctxThreadLocal.set(ctxMap);
    }

    public static void clear() {
        ctxThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger("com.att.test.Logger");
        long start = System.currentTimeMillis();
        try {
            LoggingContext.put(TRACKINGID, "ID:38273823743823");
            LoggingContext.put(USER, "xy9876");
            long elapsed = System.currentTimeMillis() - start;
            logger.info(null, "LoggingContext.main", "Code=Server.Reply; Result=Success; Elapsed=" + elapsed + "; Service=MyService; Version=MyVersion;");
        }
        catch (Throwable e) {
            long elapsed = System.currentTimeMillis() - start;
            logger.warn(null, "LoggingContext.main", "Code=Server.Reply; Result=Fault; Elapsed=" + elapsed + "; Service=MyService; Version=MyVersion; Exception=" + e.toString());
            logger.warn((URI)null, "LoggingContext.main", "Thrown Exception", (Object)e);
        }
        finally {
            LoggingContext.clear();
        }
    }
}

