/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.DME2CacheStats;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractRegistryCache;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryFS;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2ServiceEndpointData;
import java.util.ArrayList;
import java.util.List;

public class DME2EndpointCacheFS
extends DME2AbstractRegistryCache<String, DME2ServiceEndpointData> {
    private static final Logger logger = LoggerFactory.getLogger(DME2EndpointCacheFS.class);
    private DME2EndpointRegistryFS registry;

    public DME2EndpointCacheFS(DME2Configuration config, DME2EndpointRegistryFS registry, String managerName, boolean isStale) throws DME2Exception {
        super(config, DME2Endpoint.class, DME2EndpointRegistryType.FileSystem, registry, managerName, isStale);
        this.registry = registry;
    }

    public List<DME2Endpoint> getEndpoints(String service) {
        DME2ServiceEndpointData serviceEndpointData = (DME2ServiceEndpointData)this.get(service);
        if (serviceEndpointData != null) {
            return serviceEndpointData.getEndpointList();
        }
        return new ArrayList<DME2Endpoint>();
    }

    public void putEndpoints(String service, List<DME2Endpoint> endpoints) {
        DME2ServiceEndpointData serviceEndpointData = new DME2ServiceEndpointData(endpoints, service, 0L, 0L);
        this.put(service, serviceEndpointData);
    }

    @Override
    public CacheElement fetchFromSource(CacheElement.Key<String> requestValue) throws DME2Exception {
        if (requestValue == null) {
            logger.warn(null, "fetchFromSource", "Request element was null");
            return null;
        }
        List<DME2Endpoint> endpoints = this.registry.fetchEndpointsFromSource(requestValue.getKey());
        CacheElement.Value<DME2ServiceEndpointData> value = this.createCacheValue(new DME2ServiceEndpointData(endpoints, requestValue.getKey(), 0L, 0L));
        return this.createCacheElement(requestValue, value);
    }

    @Override
    public void refresh() {
    }

    @Override
    public DME2CacheStats getStats(String serviceName, Integer hourOfDay) {
        return null;
    }

    @Override
    public void disableCacheStats() {
    }

    @Override
    public void enableCacheStats() {
    }

    @Override
    public boolean isCacheStatsEnabled() {
        return false;
    }
}

