/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.AbstractCache;
import com.att.aft.dme2.cache.DME2CacheStats;
import com.att.aft.dme2.cache.DME2CacheStatsHolder;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractRegistryCache;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryGRM;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2ServiceEndpointData;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.ErrorContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class DME2EndpointCacheGRM
extends DME2AbstractRegistryCache<String, DME2ServiceEndpointData> {
    private static final Logger logger = LoggerFactory.getLogger(DME2EndpointCacheGRM.class);
    private final byte[] cacheLockMonitor = new byte[0];
    private transient DME2EndpointRegistryGRM registry;
    private final Map<String, DME2CacheStatsHolder> cacheStats = Collections.synchronizedMap(new HashMap());
    private boolean enableCacheStats = true;
    private long endpointLeaseRenewFrequency;
    private long sepCacheAllStaleTtlMs;
    private Timer renewLeaseTimer;
    private byte[] lock = new byte[0];
    private long endpointLastQueriedInterval;
    private long infrequentEndpointCacheTTL;
    private long endpointCacheTTL;
    private long endpointCacheEmptyTTL;
    private long[] emptyCacheTTLRefreshIntervals;
    private long[] emptyCacheTTLRefreshDefaultIntervals = new long[]{300000L, 300000L, 300000L, 600000L, 900000L};
    private DME2Configuration config;

    public DME2EndpointCacheGRM(DME2Configuration config, DME2EndpointRegistryGRM registry, String managerName, boolean isStale) throws DME2Exception {
        super(config, DME2Endpoint.class, DME2EndpointRegistryType.GRM, registry, managerName, isStale);
        this.config = config;
        this.registry = registry;
        this.initialize();
    }

    public void initialize() {
        this.endpointLeaseRenewFrequency = this.registry.getConfig().getInt("DME2_SEP_LEASE_RENEW_FREQUENCY_MS");
        this.sepCacheAllStaleTtlMs = this.registry.getConfig().getLong("DME2_SEP_CACHE_ALL_STALE_TTL_MS");
        this.endpointLastQueriedInterval = this.registry.getConfig().getInt("DME2_SERVICE_LAST_QUERIED_INTERVAL_MS");
        this.infrequentEndpointCacheTTL = this.registry.getConfig().getInt("DME2_SEP_CACHE_INFREQUENT_TTL_MS");
        this.endpointCacheTTL = this.registry.getConfig().getInt("DME2_SEP_CACHE_TTL_MS");
        this.endpointCacheEmptyTTL = this.registry.getConfig().getInt("DME2_SEP_CACHE_EMPTY_TTL_MS");
        this.emptyCacheTTLRefreshIntervals = this.getEmptyCacheTTLIntervalsFromProperties(this.registry.getConfig().getProperty("DME2_SEP_EMPTY_CACHE_TTL_INTERVALS"), this.emptyCacheTTLRefreshDefaultIntervals);
        this.renewLeaseTimer = new Timer("DME2::DME2EndpointRegistryGRM::epExpireTimer", true);
        this.renewLeaseTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    DME2EndpointCacheGRM.this.registry.renewAllLeases();
                }
                catch (Throwable e) {
                    logger.warn((URI)null, "run", LogMessage.ERROR_RENEWING_ALL, (Object)e);
                }
            }
        }, this.endpointLeaseRenewFrequency, this.endpointLeaseRenewFrequency);
    }

    public List<DME2Endpoint> getEndpoints(String serviceName) {
        List<DME2Endpoint> endpoints = new ArrayList<DME2Endpoint>();
        if (!serviceName.startsWith("/")) {
            serviceName = "/" + serviceName;
        }
        logger.debug((URI)null, "getEndpoints", "Retrieving endpoints for serviceName {}", (Object)serviceName);
        try {
            endpoints = this.getEndpoints(new DmeUniformResource(this.config, new URI("http://DME2LOCAL" + serviceName)));
        }
        catch (MalformedURLException e) {
            logger.debug((URI)null, "get", LogMessage.DEBUG_MESSAGE, (Object)"URISyntaxException", (Object)e);
        }
        catch (URISyntaxException e) {
            logger.debug((URI)null, "get", LogMessage.DEBUG_MESSAGE, (Object)"MalformedURLException", (Object)e);
        }
        return endpoints;
    }

    public DME2ServiceEndpointData getEndpointData(String serviceName) {
        CacheElement.Value cacheValue = this.cache.get(this.createCacheKey(serviceName));
        return cacheValue != null ? (DME2ServiceEndpointData)cacheValue.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<DME2Endpoint> getEndpoints(DmeUniformResource uniformResource) {
        int staleEndpointCount;
        logger.debug(null, "getEndpoint", LogMessage.METHOD_ENTER);
        String routeOffer = uniformResource.getRouteOffer();
        List<Object> endpoints = new ArrayList();
        DME2ServiceEndpointData endpointData = this.getSingleServiceEndpointData(uniformResource.getPath());
        if (routeOffer != null && routeOffer.contains("~")) {
            String[] routeOffers = routeOffer.split("~");
            String serviceName = uniformResource.getService();
            String serviceVersion = uniformResource.getVersion();
            String envContext = uniformResource.getEnvContext();
            for (String subRouteOffer : routeOffers) {
                String thisServiceName = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, subRouteOffer);
                List<DME2Endpoint> thisEndpointList = this.getSingleServiceEndpoints(thisServiceName);
                if (thisEndpointList == null) continue;
                endpoints.addAll(thisEndpointList);
            }
        } else if (endpointData != null) {
            endpoints = endpointData.getEndpointList();
        }
        if (endpoints == null || endpoints.isEmpty()) {
            this.registry.addStaleRouteOffer(uniformResource.getPath(), null);
            endpoints = new ArrayList();
        }
        if (endpoints.size() == this.config.getInt("AFT_DME2_FAST_CACHE_EP_ELIGIBLE_COUNT") && (staleEndpointCount = this.countStaleEndpoints(uniformResource.getPath(), endpoints)) > this.config.getInt("AFT_DME2_FAST_CACHE_STALE_EP_ELIGIBLE_COUNT")) {
            byte[] byArray = this.cacheLockMonitor;
            // MONITORENTER : this.cacheLockMonitor
            Long ttl = null;
            if (endpointData != null) {
                ttl = endpointData.getExpirationTime();
            }
            if (ttl == null || ttl > System.currentTimeMillis() + this.sepCacheAllStaleTtlMs) {
                endpointData.setCacheTTL(this.sepCacheAllStaleTtlMs);
                this.put(uniformResource.getPath(), endpointData);
                logger.debug((URI)null, "getEndpoint", "Code=DMEEndpointRegistryGRM.getCachedEndpoints; Adding service {} to list for allep stale refresh thread ;", (Object)uniformResource.getPath());
            }
            // MONITOREXIT : byArray
        }
        logger.debug(null, "getEndpoint", LogMessage.METHOD_EXIT);
        return endpoints;
    }

    protected int countStaleEndpoints(String serviceURI, List<DME2Endpoint> epList) {
        ArrayList<DME2Endpoint> staleEndpointsList = new ArrayList<DME2Endpoint>();
        for (DME2Endpoint endpoint : epList) {
            if (endpoint == null || !this.registry.isEndpointStale(endpoint.toURLString()).booleanValue()) continue;
            staleEndpointsList.add(endpoint);
        }
        if (staleEndpointsList.size() > 0) {
            logger.debug((URI)null, "countStaleEndpoints", LogMessage.CACHED_STALE, (Object)serviceURI, (Object)staleEndpointsList);
        }
        return staleEndpointsList.size();
    }

    protected List<DME2Endpoint> getSingleServiceEndpoints(String serviceName) {
        CacheElement.Value cacheElement = this.cache.get(this.createCacheKey(serviceName));
        if (cacheElement != null && cacheElement.getValue() != null) {
            return ((DME2ServiceEndpointData)cacheElement.getValue()).getEndpointList();
        }
        return null;
    }

    protected DME2ServiceEndpointData getSingleServiceEndpointData(String serviceName) {
        CacheElement.Value cacheElement = this.cache.get(this.createCacheKey(serviceName));
        if (cacheElement != null && cacheElement.getValue() != null) {
            return (DME2ServiceEndpointData)cacheElement.getValue();
        }
        return null;
    }

    public void shutdownTimerTask() {
        logger.debug(null, "shutdownTimerTask", LogMessage.METHOD_ENTER);
        if (this.renewLeaseTimer != null) {
            this.renewLeaseTimer.cancel();
        }
        this.cache.shutdownTimerTask();
        logger.debug(null, "shutdownTimerTask", LogMessage.METHOD_EXIT);
    }

    public String toString() {
        return ((AbstractCache)this.cache).getKeys();
    }

    @Override
    public CacheElement fetchFromSource(CacheElement.Key requestValue) throws DME2Exception {
        DME2ServiceEndpointData endpointData = null;
        if (requestValue != null) {
            String service = (String)requestValue.getKey();
            Map<String, String> serviceMap = DME2URIUtils.splitServiceURIString(service);
            List<DME2Endpoint> endpoints = this.registry.fetchEndpoints(serviceMap.get("service"), serviceMap.get("version"), serviceMap.get("envContext"), serviceMap.get("routeOffer"), service);
            endpointData = new DME2ServiceEndpointData(endpoints, service, this.endpointCacheTTL, 0L);
        }
        return this.createCacheElement(requestValue, this.createCacheValue(endpointData));
    }

    @Override
    public void refresh() {
        this.refreshAllCachedEndpoints();
    }

    private void refreshAllCachedEndpoints() {
        ArrayList<String> serviceURIList = new ArrayList<String>();
        if (this.cache == null) {
            return;
        }
        for (CacheElement.Key key : this.cache.getKeySet()) {
            if (key == null) continue;
            serviceURIList.add((String)key.getKey());
        }
        Collections.shuffle(serviceURIList);
        logger.debug(null, "refreshAllCachedEndpoints", "Code=Trace.DME2EndpointCache.refreshCachedDME2Endpoints; Refreshing cached endpoints");
        logger.debug((URI)null, "refreshAllCachedEndpoints", LogMessage.REFRESH_ENDPOINTS, (Object)new Date());
        for (String serviceURI : serviceURIList) {
            try {
                String routeOfferVal;
                Long expiration = 0L;
                Map<String, String> map = DME2Utils.splitServiceURIString(serviceURI);
                if (map != null && map.containsKey("routeOffer") && (routeOfferVal = map.get("routeOffer")) != null && this.config.getProperty("~") != null && routeOfferVal.contains(this.config.getProperty("~"))) {
                    logger.debug((URI)null, "refreshAllCachedEndpoints", LogMessage.SKIP_REFRESH_ENDPOINTS, (Object)serviceURI);
                    continue;
                }
                DME2ServiceEndpointData cachedEndpoint = (DME2ServiceEndpointData)this.get(serviceURI);
                if (cachedEndpoint != null) {
                    expiration = cachedEndpoint.getExpirationTime();
                }
                if (expiration > System.currentTimeMillis()) continue;
                logger.debug((URI)null, "refreshAllCachedEndpoints", LogMessage.UPDATE_ENDPOINTS, (Object)serviceURI);
                logger.debug((URI)null, "refreshAllCachedEndpoints", "Code=Trace.DME2EndpointCache.refreshCachedDME2Endpoints; Updating endpoints for {}", (Object)serviceURI);
                this.refreshCachedEndpoint(serviceURI);
                logger.debug((URI)null, "refreshAllCachedEndpoints", LogMessage.REFRESH_LOOKUP, (Object)serviceURI);
                logger.debug((URI)null, "refreshAllCachedEndpoints", "Refreshed cached endpoints for lookup [{}]", (Object)serviceURI);
            }
            catch (DME2Exception e) {
                logger.debug((URI)null, "refreshAllCachedEndpoints", LogMessage.REFRESH_FAILED, (Object)serviceURI, (Object)e);
                logger.debug((URI)null, "refreshAllCachedEndpoints", "Refresh of cached endpoints for [{}] failed: {}", (Object)serviceURI, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DME2Endpoint> refreshCachedEndpoint(String service) throws DME2Exception {
        long start = System.currentTimeMillis();
        ArrayList<DME2Endpoint> endpointList = new ArrayList<DME2Endpoint>();
        String serviceName = null;
        String serviceVersion = null;
        String envContext = null;
        String routeOffer = null;
        String cacheStatsURI = null;
        DME2CacheStatsHolder statsHolder = null;
        long startTime = 0L;
        try {
            String uriStr = "http://DME2LOCAL/" + service;
            DmeUniformResource uri = new DmeUniformResource(this.config, new URI(uriStr));
            serviceName = uri.getService();
            serviceVersion = uri.getVersion();
            envContext = uri.getEnvContext();
            routeOffer = uri.getRouteOffer();
            cacheStatsURI = "/service=" + serviceName + "/version=" + serviceVersion + "/envContext=" + envContext;
            statsHolder = this.cacheStats.get(cacheStatsURI);
            if (statsHolder == null) {
                statsHolder = new DME2CacheStatsHolder(cacheStatsURI, this.config);
                this.cacheStats.put(cacheStatsURI, statsHolder);
            }
            String serviceURI = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, routeOffer);
            startTime = System.currentTimeMillis();
            endpointList.addAll(this.registry.fetchEndpoints(serviceName, serviceVersion, envContext, routeOffer, serviceURI));
            statsHolder.recordRefreshSuccess(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
        }
        catch (Exception e) {
            statsHolder.recordRefreshFailure(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
            throw new DME2Exception("AFT-DME2-0605", new ErrorContext().add("extendedMessage", e.getMessage()).add("uri", service), (Throwable)e);
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            CacheElement.Value wrappedValue;
            long ttl;
            DME2ServiceEndpointData cachedEndpoint;
            long lastQueriedAt = 0L;
            if (endpointList.size() > 0) {
                logger.debug((URI)null, "refreshCachedEndpoint", "Endpoint list has 0 elements for {}", (Object)service);
                cachedEndpoint = (DME2ServiceEndpointData)this.get(service);
                if (cachedEndpoint != null) {
                    lastQueriedAt = cachedEndpoint.getLastQueried();
                }
                ttl = lastQueriedAt > 0L && this.config.getBoolean("AFT_DME2_ENABLE_SELECTIVE_REFRESH") ? (System.currentTimeMillis() - lastQueriedAt >= this.endpointLastQueriedInterval ? this.infrequentEndpointCacheTTL : this.endpointCacheTTL) : this.endpointCacheTTL;
                this.put(service, new DME2ServiceEndpointData(endpointList, service, ttl, System.currentTimeMillis()));
            } else {
                logger.warn((URI)null, "refreshCachedEndpoint", LogMessage.REFRESH_DEFERRED, (Object)"refreshCachedEndpoint", (Object)service);
                ttl = this.endpointCacheEmptyTTL;
                cachedEndpoint = (DME2ServiceEndpointData)this.get(service);
                if (cachedEndpoint != null) {
                    String msg;
                    int emptyCacheRefreshAttemptCount = cachedEndpoint.getEmptyCacheRefreshAttemptCount();
                    if (emptyCacheRefreshAttemptCount == this.emptyCacheTTLRefreshIntervals.length - 1) {
                        ttl = this.emptyCacheTTLRefreshIntervals[this.emptyCacheTTLRefreshIntervals.length - 1];
                        msg = String.format("SEP Empty Cache TTL has already reached the last interval for service %s. TTL value will remain at: %s. Current empty cache refresh attempt count: %s ", service, ttl, emptyCacheRefreshAttemptCount);
                        logger.debug((URI)null, "refreshCachedEndpoint", LogMessage.DEBUG_MESSAGE, (Object)msg);
                    } else if (this.emptyCacheTTLRefreshIntervals.length == 1) {
                        ttl = this.emptyCacheTTLRefreshIntervals[0];
                    } else {
                        ttl = this.emptyCacheTTLRefreshIntervals[++emptyCacheRefreshAttemptCount];
                        ((DME2ServiceEndpointData)this.get(service)).setEmptyCacheRefreshAttemptCount(emptyCacheRefreshAttemptCount);
                        msg = String.format("Advancing to next Emtpy Cache TTL interval value for service %s. New value: %s", service, ttl);
                        logger.debug((URI)null, "refreshCachedEndpoint", "New empty cache refresh attempt count: {}", (Object)emptyCacheRefreshAttemptCount);
                        logger.debug((URI)null, "refreshCachedEndpoint", LogMessage.DEBUG_MESSAGE, (Object)msg);
                    }
                }
            }
            CacheElement cachedEndpointElement = this.getCacheElement(service);
            if (cachedEndpointElement != null && cachedEndpointElement.getValue() != null && (wrappedValue = cachedEndpointElement.getValue()).getValue() != null && wrappedValue.getValue() instanceof DME2ServiceEndpointData) {
                DME2ServiceEndpointData data = (DME2ServiceEndpointData)wrappedValue.getValue();
                logger.debug((URI)null, "refreshCachedEndpoint", "Setting {} endpoint ttl to {}", (Object)data.getServiceURI(), (Object)ttl);
                data.setCacheTTL(ttl);
                cachedEndpointElement.setTtl(data.getCacheTTL());
            }
            logger.debug(null, "refreshCachedEndpoint", LogMessage.CACHED_ENDPOINTS, service, System.currentTimeMillis() - start, endpointList.size());
            // ** MonitorExit[var13_11] (shouldn't be in output)
            return endpointList;
        }
    }

    private long[] getEmptyCacheTTLIntervalsFromProperties(String property, long[] defaultValue) {
        long[] emptyCacheTTLIntervals = null;
        if (property == null) {
            return defaultValue;
        }
        try {
            String[] tokens;
            for (String token : tokens = property.split(",")) {
                if (!DME2URIUtils.isParseable(token.trim(), Long.class)) {
                    return defaultValue;
                }
                boolean enforceMinEmptyCacheTTLIntervalValue = this.registry.getConfig().getBoolean("DME2_ENFORCE_MIN_EMPTY_CACHE_TTL_INTERVAL_VALUE");
                if (!enforceMinEmptyCacheTTLIntervalValue || Long.parseLong(token) >= 300000L) continue;
                logger.warn((URI)null, "getEmptyCacheTTLIntervalsFromProperties", "Interval values cannot be less than 5 minutes. Value provided: {}. Using default interval values of: {}", (Object)token, (Object)Arrays.asList(new long[][]{this.emptyCacheTTLRefreshDefaultIntervals}));
                return defaultValue;
            }
            emptyCacheTTLIntervals = new long[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                emptyCacheTTLIntervals[i] = Long.parseLong(tokens[i].trim());
            }
        }
        catch (Exception e) {
            logger.debug((URI)null, "getEmptyCacheTTLIntervalsFromProperties", "Error occurred while attempting while resolving Empty SEP Cache TTL Intervals. Using default.", (Object)e);
            return defaultValue;
        }
        logger.debug((URI)null, "getEmptyCacheTTLIntervalsFromProperties", "Empty SEP Cache TTL Intervals resolved from properties: {}", (Object)property);
        return emptyCacheTTLIntervals;
    }

    @Override
    public DME2CacheStats getStats(String serviceName, Integer hourOfDay) {
        if (serviceName != null && this.cacheStats.get(serviceName) != null) {
            DME2CacheStatsHolder stats = this.cacheStats.get(serviceName);
            if (hourOfDay >= 0 && hourOfDay <= 23) {
                return stats.getHourlyStats(hourOfDay);
            }
            return this.cacheStats.get(serviceName).getStats();
        }
        return null;
    }

    @Override
    public void disableCacheStats() {
        this.enableCacheStats = false;
    }

    @Override
    public void enableCacheStats() {
        this.enableCacheStats = true;
    }

    @Override
    public boolean isCacheStatsEnabled() {
        return this.enableCacheStats;
    }
}

