/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.collections.CollectionUtils;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMInstance;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractEndpointRegistry;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointCacheFS;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2FileHandler;
import com.att.aft.dme2.manager.registry.DME2JDBCEndpoint;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import com.att.aft.dme2.manager.registry.DME2RouteInfoCacheFS;
import com.att.aft.dme2.manager.registry.DME2StaleCache;
import com.att.aft.dme2.manager.registry.util.DME2DistanceUtil;
import com.att.aft.dme2.manager.registry.util.DME2FileUtil;
import com.att.aft.dme2.manager.registry.util.Version;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.types.RouteInfo;
import com.att.aft.dme2.util.DME2URIUtils;
import com.att.aft.dme2.util.DME2ValidationUtil;
import com.att.aft.dme2.util.ErrorContext;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DME2EndpointRegistryFS
extends DME2AbstractEndpointRegistry
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DME2EndpointRegistryFS.class);
    protected static final long DEFAULT_CACHE_STALENESS = 300000L;
    protected static final String CONFIG_KEY_FILE = "AFT_DME2_EP_REGISTRY_FS_DIR";
    protected static final String HTTP_PREFIX = "http://";
    protected static final String FORWARD_SLASH = "/";
    protected static final String HOST_PORT_SEPARATOR = ":";
    protected DME2EndpointCacheFS endpointCache;
    protected DME2RouteInfoCacheFS routeInfoCache;
    private Unmarshaller unmarshaller;
    private boolean isMarshalling = false;
    private static final String SCHEMA_NAMESPACE = "com.att.aft.dme2.types";
    private final Map<String, Long> lastUpdateTimeMsMap = Collections.synchronizedMap(new HashMap());
    private File dir;
    private final List<DME2Endpoint> localPublishedList = new CopyOnWriteArrayList<DME2Endpoint>();

    public DME2EndpointCacheFS getEndpointCache() {
        return this.endpointCache;
    }

    public DME2RouteInfoCacheFS getRouteInfoCache() {
        return this.routeInfoCache;
    }

    public DME2EndpointRegistryFS(DME2Configuration config, String managerName) throws DME2Exception {
        super(config, managerName);
        this.endpointCache = new DME2EndpointCacheFS(config, this, managerName, false);
        this.routeInfoCache = new DME2RouteInfoCacheFS(config, this, managerName);
        this.staleEndpointCache = new DME2StaleCache(config, DME2Endpoint.class, DME2EndpointRegistryType.FileSystem, this, managerName);
        this.staleRouteOfferCache = new DME2StaleCache(config, DME2RouteOffer.class, DME2EndpointRegistryType.FileSystem, this, managerName);
        if (this.unmarshaller == null) {
            this.unmarshaller = this.createUnmarshaller();
        }
    }

    private Unmarshaller createUnmarshaller() throws DME2Exception {
        JAXBContext jaxBContext;
        try {
            jaxBContext = JAXBContext.newInstance((String)SCHEMA_NAMESPACE);
        }
        catch (JAXBException e) {
            throw new DME2Exception("AFT-DME2-1550", new ErrorContext().add("extendedMessage", e.getMessage()).add("manager", this.managerName), (Throwable)e);
        }
        try {
            return jaxBContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new DME2Exception("AFT-DME2-1551", new ErrorContext().add("extendedMessage", e.getMessage()).add("manager", this.managerName), (Throwable)e);
        }
    }

    @Override
    public void init(Properties properties) throws DME2Exception {
        super.init(properties);
        String fileName = this.getConfig().getProperty(CONFIG_KEY_FILE);
        if (fileName == null) {
            fileName = "dme2-fs-registry";
        }
        this.dir = new File(fileName);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    @Override
    public List<DME2Endpoint> findEndpoints(String serviceName, String serviceVersion, String envContext, String routeOffer) throws DME2Exception {
        String service = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, routeOffer);
        DME2FileHandler fileHandler = new DME2FileHandler(this.dir, service, 300000L, DME2EndpointRegistryFS.getClientLatitude(), DME2EndpointRegistryFS.getClientLongitude());
        Long sourceLastUpdateTimeMs = this.lastUpdateTimeMsMap.get(service);
        List<DME2Endpoint> endpoints = null;
        if (sourceLastUpdateTimeMs == null || sourceLastUpdateTimeMs >= fileHandler.getLastModified()) {
            endpoints = this.endpointCache.getEndpoints(service);
        }
        if (endpoints == null || endpoints.isEmpty()) {
            endpoints = this.fetchEndpointsFromSource(fileHandler);
            this.endpointCache.putEndpoints(service, endpoints);
            this.lastUpdateTimeMsMap.put(service, fileHandler.getLastModified());
        }
        return endpoints;
    }

    @Override
    public DME2RouteInfo getRouteInfo(String serviceName, String serviceVersion, String envContext) throws DME2Exception {
        String path = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext);
        File file = new File(this.dir, path + "/routeInfo.xml");
        DME2RouteInfo routeInfo = (DME2RouteInfo)this.routeInfoCache.get(path);
        if (routeInfo == null || routeInfo.lastUpdated() < file.lastModified()) {
            routeInfo = this.fetchRouteInfoFromSource(path);
            this.routeInfoCache.put(path, routeInfo);
        }
        return routeInfo;
    }

    private List<DME2Endpoint> fetchEndpointsFromSource(DME2FileHandler fileHandler) throws DME2Exception {
        return fileHandler.readEndpoints();
    }

    protected List<DME2Endpoint> fetchEndpointsFromSource(String service) throws DME2Exception {
        return this.fetchEndpointsFromSource(new DME2FileHandler(this.dir, service, 300000L, DME2EndpointRegistryFS.getClientLatitude(), DME2EndpointRegistryFS.getClientLongitude()));
    }

    protected DME2RouteInfo fetchRouteInfoFromSource(String path) throws DME2Exception {
        JAXBElement<RouteInfo> element = null;
        List<File> matchingFiles = DME2FileUtil.hierarchicalFileLookup(this.dir, path + "/routeInfo.xml");
        HashMap<Version, DME2RouteInfo> routeInfoMap = new HashMap<Version, DME2RouteInfo>();
        for (File file : matchingFiles) {
            element = this.readRouteInfo(file);
            routeInfoMap.put(new Version(((RouteInfo)element.getValue()).getServiceVersion()), new DME2RouteInfo((RouteInfo)element.getValue(), this.getConfig()));
        }
        ArrayList sortedVersionList = new ArrayList(routeInfoMap.keySet());
        Collections.sort(sortedVersionList);
        if (sortedVersionList.isEmpty()) {
            throw new DME2Exception("AFT-DME2-9602", new ErrorContext().add("path", path).add("path", path));
        }
        return (DME2RouteInfo)routeInfoMap.get(sortedVersionList.get(0));
    }

    protected synchronized JAXBElement<RouteInfo> readRouteInfo(File file) throws DME2Exception {
        boolean isMarshallingWasSet = false;
        try {
            Unmarshaller currentUnmarshaller;
            if (!this.isMarshalling) {
                this.isMarshalling = true;
                isMarshallingWasSet = true;
                currentUnmarshaller = this.unmarshaller;
            } else {
                currentUnmarshaller = this.createUnmarshaller();
            }
            StreamSource ss = new StreamSource(file);
            JAXBElement jAXBElement = (JAXBElement)currentUnmarshaller.unmarshal((Source)ss);
            return jAXBElement;
        }
        catch (JAXBException e) {
            throw new DME2Exception("AFT-DME2-1552", new ErrorContext().add("extendedMessage", e.getMessage()), (Throwable)e);
        }
        finally {
            if (isMarshallingWasSet) {
                this.isMarshalling = false;
            }
        }
    }

    @Override
    public void publish(String service, String path, String host, int port, double latitude, double longitude, String protocol) throws DME2Exception {
        this.publish(service, path, host, port, latitude, longitude, protocol, null);
    }

    @Override
    public void publish(String service, String path, String host, int port, double latitude, double longitude, String protocol, boolean updateLease) throws DME2Exception {
        this.publish(service, path, host, port, latitude, longitude, protocol, null);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol, Properties props) throws DME2Exception {
        this.publish(service, path, host, port, (double)this.getConfig().getDouble("AFT_LATITUDE"), (double)this.getConfig().getDouble("AFT_LONGITUDE"), protocol, props);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol) throws DME2Exception {
        this.publish(service, path, host, port, (double)this.getConfig().getDouble("AFT_LATITUDE"), (double)this.getConfig().getDouble("AFT_LONGITUDE"), protocol, null);
    }

    @Override
    public void publish(String serviceURI, String contextPath, String hostAddress, int port, double latitude, double longitude, String protocol, Properties props, boolean updateLease) throws DME2Exception {
        this.publish(serviceURI, contextPath, hostAddress, port, latitude, longitude, protocol, props);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol, boolean updateLease) throws DME2Exception {
        this.publish(service, path, host, port, (double)this.getConfig().getLong("AFT_LATITUDE"), (double)this.getConfig().getLong("AFT_LONGITUDE"), protocol, null);
    }

    private void publish(String servicePath, String contextPath, String host, int port, double latitude, double longitude, String protocol, Properties inProps) throws DME2Exception {
        Object urlStr = null;
        double distance = DME2DistanceUtil.calculateDistanceBetween(DME2EndpointRegistryFS.getClientLatitude(), DME2EndpointRegistryFS.getClientLongitude(), latitude, longitude);
        DmeUniformResource uniformResource = this.buildUniformResource(protocol, servicePath, host, port);
        int queryIndexStart = servicePath.indexOf(63);
        if (queryIndexStart != -1) {
            servicePath = servicePath.substring(0, queryIndexStart);
        }
        String serviceContext = "service=" + uniformResource.getService() + "/version=" + uniformResource.getVersion() + "/envContext=" + uniformResource.getEnvContext() + "/routeOffer=" + uniformResource.getRouteOffer();
        DME2FileHandler fileHandler = new DME2FileHandler(this.dir, serviceContext, 300000L, DME2EndpointRegistryFS.getClientLatitude(), DME2EndpointRegistryFS.getClientLongitude());
        logger.debug((URI)null, "publish", LogMessage.PUBLISH_FILE, (Object)(serviceContext + ".txt"));
        Properties props = fileHandler.readProperties();
        String propsKey = host + "," + port;
        props.setProperty(propsKey, "latitude=" + latitude + ";longitude=" + longitude + ";lease=" + System.currentTimeMillis() + ";protocol=" + protocol + ";contextPath=" + (contextPath == null ? servicePath : contextPath) + ";routeOffer=" + uniformResource.getRouteOffer());
        DME2Endpoint ep = null;
        if ("dme2jdbc".equals(protocol)) {
            try {
                DME2ValidationUtil.validateJDBCEndpointRequiredFields(inProps, servicePath);
            }
            catch (DME2Exception e) {
                throw new DME2Exception(e.getErrorCode(), e.getErrorMessage(), new Object[0]);
            }
            ep = new DME2JDBCEndpoint(distance);
            if (inProps != null) {
                StringBuffer buff = new StringBuffer();
                if (inProps.containsKey("KEY_DME2_JDBC_DATABASE_NAME")) {
                    ((DME2JDBCEndpoint)ep).setDatabaseName((String)props.get("KEY_DME2_JDBC_DATABASE_NAME"));
                    buff.append("DME2JDBCDatabaseName=" + inProps.get("KEY_DME2_JDBC_DATABASE_NAME") + ";");
                }
                if (inProps.containsKey("KEY_DME2_JDBC_HEALTHCHECK_USER")) {
                    ((DME2JDBCEndpoint)ep).setHealthCheckUser((String)props.get("KEY_DME2_JDBC_HEALTHCHECK_USER"));
                    buff.append("DME2JDBCHealthCheckUser=" + inProps.get("KEY_DME2_JDBC_HEALTHCHECK_USER") + ";");
                }
                if (inProps.containsKey("KEY_DME2_JDBC_DATABASE_NAME")) {
                    ((DME2JDBCEndpoint)ep).setHealthCheckPassword((String)props.get("KEY_DME2_JDBC_HEALTHCHECK_PASSWORD"));
                    buff.append("DME2JDBCHealthCheckPassword=" + inProps.get("KEY_DME2_JDBC_HEALTHCHECK_PASSWORD") + ";");
                }
                if (inProps.containsKey("KEY_DME2_JDBC_HEALTHCHECK_DRIVER")) {
                    ((DME2JDBCEndpoint)ep).setHealthCheckDriver((String)inProps.get("KEY_DME2_JDBC_HEALTHCHECK_DRIVER"));
                    buff.append("DME2JDBCHealthCheckDriver=" + inProps.get("KEY_DME2_JDBC_HEALTHCHECK_DRIVER") + ";");
                }
                for (String propName : inProps.stringPropertyNames()) {
                    buff.append(propName + "=" + inProps.get(propName));
                }
                String endpointProps = props.getProperty(propsKey);
                props.setProperty(propsKey, endpointProps + ";" + buff.toString());
            }
        } else {
            ep = new DME2Endpoint(serviceContext, distance);
        }
        ep.setHost(host);
        ep.setPort(port);
        ep.setLatitude(latitude);
        ep.setLongitude(longitude);
        ep.setLease(System.currentTimeMillis());
        ep.setProtocol(protocol);
        if (contextPath == null) {
            ep.setContextPath(servicePath);
        } else {
            ep.setContextPath(contextPath);
        }
        this.localPublishedList.add(ep);
        fileHandler.storeProperties(props, true);
    }

    @Override
    public void unpublish(String serviceName, String host, int port) throws DME2Exception {
        DME2FileHandler fileHandler = new DME2FileHandler(this.dir, serviceName, 300000L, DME2EndpointRegistryFS.getClientLatitude(), DME2EndpointRegistryFS.getClientLongitude());
        logger.debug((URI)null, "unpublish", LogMessage.UNPUBLISHING_FILE, (Object)(serviceName + ".txt"));
        Properties props = fileHandler.readProperties();
        props.remove(host + "," + port);
        for (DME2Endpoint ep : this.localPublishedList) {
            if (ep.getHost() == null || !ep.getHost().equalsIgnoreCase(host) || ep.getPort() != port) continue;
            this.localPublishedList.remove(ep);
        }
        fileHandler.storeProperties(props, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lease(DME2Endpoint endpoint) throws DME2Exception {
        this.publish(endpoint.getPath(), endpoint.getContextPath(), endpoint.getHost(), endpoint.getPort(), endpoint.getLatitude(), endpoint.getLongitude(), endpoint.getProtocol(), endpoint.getEndpointProperties());
        List<DME2Endpoint> list = this.localPublishedList;
        synchronized (list) {
            this.localPublishedList.remove(endpoint);
        }
    }

    private void refreshPublishedDME2Endpoints() {
        for (DME2Endpoint ep : this.localPublishedList) {
            try {
                this.lease(ep);
            }
            catch (DME2Exception e) {
                logger.debug((String)null, (URI)null, "refreshPublishedDME2Endpoints", LogMessage.DEBUG_MESSAGE, (Object)"DME2Exception", (Object)e);
            }
        }
    }

    @Override
    public void refresh() {
        this.refreshPublishedDME2Endpoints();
        this.endpointCache.clear();
    }

    @Override
    public void shutdown() {
        for (DME2Endpoint ep : this.localPublishedList) {
            try {
                this.unpublish(ep);
            }
            catch (Exception e) {
                logger.warn((URI)null, "run", LogMessage.ERROR_UNPUBLISHING, (Object)ep);
            }
        }
    }

    private void unpublish(DME2Endpoint ep) throws DME2Exception {
        this.unpublish(ep.getPath(), ep.getHost(), ep.getPort());
    }

    @Override
    public void run() {
        this.shutdown();
    }

    @Override
    public DME2Endpoint[] find(String serviceKey, String version, String env, String routeOffer) throws DME2Exception {
        List<DME2Endpoint> endpoints = this.findEndpoints(serviceKey, version, env, routeOffer);
        DME2Endpoint[] endpointArray = null;
        if (CollectionUtils.isNotEmpty(endpoints)) {
            endpointArray = endpoints.toArray(new DME2Endpoint[endpoints.size()]);
        }
        return endpointArray;
    }

    @Override
    public void registerJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
    }

    @Override
    public void updateJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
    }

    @Override
    public void deregisterJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
    }

    @Override
    public List<ClientJVMInstance> findRegisteredJVM(String envContext, Boolean activeOnly, String hostAddress, String mechID, String processID) throws DME2Exception {
        return null;
    }
}

