/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractEndpointRegistry;
import com.att.aft.dme2.manager.registry.util.DME2DistanceUtil;
import com.att.aft.dme2.manager.registry.util.DME2RouteInfoUtil;
import com.att.aft.dme2.types.DataPartition;
import com.att.aft.dme2.types.ListDataPartition;
import com.att.aft.dme2.types.Route;
import com.att.aft.dme2.types.RouteGroup;
import com.att.aft.dme2.types.RouteInfo;
import com.att.aft.dme2.types.RouteLocationSelector;
import com.att.aft.dme2.types.RouteOffer;
import com.att.aft.dme2.types.VersionMap;
import com.att.aft.dme2.types.VersionMapInfo;
import com.att.aft.dme2.util.ErrorContext;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class DME2RouteInfo
implements Serializable {
    private static final long serialVersionUID = -6605370283684623928L;
    private static final Logger logger = LoggerFactory.getLogger(DME2RouteInfo.class);
    private static JAXBContext jaxBContext = null;
    private String dme2BootstrapProperties;
    private String dataPartitionKeyPath;
    private Long expirationTime;
    private long cacheTTL;
    private long lastUpdated;
    private String serviceName;
    private String serviceVersion;
    private String envContext;
    private DME2Manager manager;
    private RouteInfo routeInfo;
    private List<VersionMap> versionMaps;
    private boolean hasPartitions = false;
    private boolean hasRangePartitions = false;
    private boolean hasListPartitions = false;
    private final NavigableMap<String, DataPartition> partitionMap = new TreeMap<String, DataPartition>();
    private List<ListDataPartition> LDPList = new ArrayList<ListDataPartition>();
    private final Map<String, RouteGroup> routeGroupMap = new TreeMap<String, RouteGroup>();
    private final Map<String, DME2RouteOffer> routeOfferMap = new ConcurrentHashMap<String, DME2RouteOffer>();

    private DME2RouteInfo() {
    }

    public DME2RouteInfo(RouteInfo inputRouteInfo, DME2Configuration configuration) throws DME2Exception {
        this.routeInfo = inputRouteInfo;
        this.cacheTTL = configuration.getInt("DME2_ROUTEINFO_CACHE_TTL_MS");
        this.expirationTime = this.cacheTTL + System.currentTimeMillis();
        this.lastUpdated = System.currentTimeMillis();
        DME2RouteInfoUtil.convertRouteInfo(this, inputRouteInfo);
    }

    public DME2RouteInfo(File file) throws JAXBException, DME2Exception {
        Unmarshaller unmarshaller = jaxBContext.createUnmarshaller();
        JAXBElement element = (JAXBElement)unmarshaller.unmarshal(file);
        this.routeInfo = (RouteInfo)element.getValue();
        DME2RouteInfoUtil.loadPartitionMap(this.routeInfo, this);
        DME2RouteInfoUtil.loadRouteGroupMap(this.routeInfo, this);
    }

    public long lastUpdated() {
        return 0L;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public String getEnvContext() {
        return this.envContext;
    }

    public void setManager(DME2Manager manager) {
        this.manager = manager;
    }

    public DME2Manager getManager() {
        return this.manager;
    }

    public String getDme2BootstrapProperties() {
        return this.dme2BootstrapProperties;
    }

    public void setDme2BootstrapProperties(String dme2BootstrapProperties) {
        this.dme2BootstrapProperties = dme2BootstrapProperties;
    }

    public String getDataPartitionKeyPath() {
        return this.dataPartitionKeyPath;
    }

    public void setDataPartitionKeyPath(String dataPartitionKeyPath) {
        this.dataPartitionKeyPath = dataPartitionKeyPath;
    }

    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setCacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setEnvContext(String envContext) {
        this.envContext = envContext;
    }

    public RouteInfo getRouteInfo() {
        return this.routeInfo;
    }

    public void setRouteInfo(RouteInfo routeInfo) {
        this.routeInfo = routeInfo;
    }

    public boolean isHasPartitions() {
        return this.hasPartitions;
    }

    public void setHasPartitions(boolean hasPartitions) {
        this.hasPartitions = hasPartitions;
    }

    public List<VersionMap> getVersionMaps() {
        return this.versionMaps;
    }

    public void setVersionMaps(List<VersionMap> versionMaps) {
        this.versionMaps = versionMaps;
    }

    public NavigableMap<String, DataPartition> getPartitionMap() {
        return this.partitionMap;
    }

    public boolean isHasRangePartitions() {
        return this.hasRangePartitions;
    }

    public void setHasRangePartitions(boolean hasRangePartitions) {
        this.hasRangePartitions = hasRangePartitions;
    }

    public boolean isHasListPartitions() {
        return this.hasListPartitions;
    }

    public void setHasListPartitions(boolean hasListPartitions) {
        this.hasListPartitions = hasListPartitions;
    }

    public List<ListDataPartition> getLDPList() {
        return this.LDPList;
    }

    public void setLDPList(List<ListDataPartition> LDPList) {
        this.LDPList = LDPList;
    }

    public Map<String, RouteGroup> getRouteGroupMap() {
        return this.routeGroupMap;
    }

    public List<DME2RouteOffer> getRouteOffers(String envContext, String partnerName, String keyValue, String stickySelectorKey) throws DME2Exception {
        return this.getRouteOffers(envContext, partnerName, keyValue, stickySelectorKey, false);
    }

    public List<DME2RouteOffer> getRouteOffers(String envContext2, String partnerName, String keyValue, String stickySelectorKey, boolean checkDataPartitionRange) throws DME2Exception {
        return this.getRouteOffers(envContext2, partnerName, keyValue, stickySelectorKey, checkDataPartitionRange, null);
    }

    public List<DME2RouteOffer> getRouteOffers(String envContext2, String partnerName, String keyValue, String stickySelectorKey, boolean checkDataPartitionRange, String preferredRouteOffer) throws DME2Exception {
        RouteOffer pRouteOffer;
        RouteGroup routeGroup;
        boolean addedPreferredRouteOffer = false;
        String partitionName = null;
        if (keyValue != null && this.isHasPartitions()) {
            if (checkDataPartitionRange) {
                partitionName = this.checkRangePartitions(keyValue);
                if (partitionName == null && !this.isHasListPartitions()) {
                    throw new DME2Exception("AFT-DME2-0101", new ErrorContext().add("service", this.getServiceName()).add("version", this.getServiceVersion()).add("partner", partnerName).add("key", keyValue));
                }
                if (partitionName == null && this.isHasListPartitions() && (partitionName = this.checkListPartitions(keyValue)) == null) {
                    throw new DME2Exception("AFT-DME2-0105", new ErrorContext().add("service", this.getServiceName()).add("version", this.getServiceVersion()).add("partner", partnerName).add("key", keyValue));
                }
            } else {
                partitionName = this.checkListPartitions(keyValue);
                if (partitionName == null && !this.isHasRangePartitions()) {
                    throw new DME2Exception("AFT-DME2-0105", new ErrorContext().add("service", this.getServiceName()).add("version", this.getServiceVersion()).add("partner", partnerName).add("key", keyValue));
                }
                if (partitionName == null && this.isHasRangePartitions() && (partitionName = this.checkRangePartitions(keyValue)) == null) {
                    throw new DME2Exception("AFT-DME2-0101", new ErrorContext().add("service", this.getServiceName()).add("version", this.getServiceVersion()).add("partner", partnerName).add("key", keyValue));
                }
            }
        }
        if ((routeGroup = this.getRouteGroup(partnerName)) == null && (routeGroup = this.getRouteGroup("*")) == null) {
            throw new DME2Exception("AFT-DME2-0101", new ErrorContext().add("service", this.getServiceName()).add("version", this.getServiceVersion()).add("partner", partnerName).add("key", keyValue));
        }
        List<Route> routes = routeGroup.getRoute();
        TreeMap<Integer, DME2RouteOffer> sequencedMap = new TreeMap<Integer, DME2RouteOffer>();
        int inactiveCount = 0;
        int totalRouteOffers = 0;
        for (Route route : routes) {
            DME2RouteOffer mergedRO;
            DME2RouteOffer roBySequence;
            String fqName;
            String version;
            DME2RouteOffer roByKey;
            String cacheKey;
            double distance;
            RouteLocationSelector selector;
            if ((keyValue != null && !"".equals(keyValue) || stickySelectorKey != null) && (keyValue != null && stickySelectorKey != null && this.isHasPartitions() && (route.getDataPartitionRef() != null && route.getDataPartitionRef().size() == 0 || route.getStickySelectorKey() == null) || stickySelectorKey != null && keyValue == null && this.isHasPartitions() && route.getDataPartitionRef() != null && route.getDataPartitionRef().size() != 0 || stickySelectorKey == null && keyValue != null && route.getStickySelectorKey() != null || partitionName != null && (route.getDataPartitionRef() == null || route.getDataPartitionRef().size() <= 0 || !route.getDataPartitionRef().contains(partitionName))) || (selector = route.getRouteLocationSelector()) != null && (distance = DME2DistanceUtil.calculateDistanceBetween(DME2AbstractEndpointRegistry.getClientLatitude(), DME2AbstractEndpointRegistry.getClientLongitude(), selector.getLatitude(), selector.getLongitude())) > selector.getMaxDistance()) continue;
            boolean foundDynamicStickKey = false;
            for (RouteOffer offer : route.getRouteOffer()) {
                if (!offer.isActive() || stickySelectorKey == null || offer.getName() == null || !offer.getName().equalsIgnoreCase(stickySelectorKey) || !offer.isAllowDynamicStickiness()) continue;
                if (preferredRouteOffer != null && preferredRouteOffer.equals(offer.getName())) {
                    addedPreferredRouteOffer = true;
                }
                foundDynamicStickKey = true;
                cacheKey = this.envContext + "_" + offer + "_" + routeGroup.getName();
                roByKey = this.routeOfferMap.get(cacheKey);
                if (roByKey == null) {
                    version = this.applyVersionMapping(offer);
                    fqName = routeGroup.getName() + "." + route.getName() + "." + offer.getName();
                    roByKey = new DME2RouteOffer(this.getServiceName(), version, this.envContext, offer, fqName, this.manager);
                    this.routeOfferMap.put(cacheKey, roByKey);
                }
                mergedRO = (roBySequence = (DME2RouteOffer)sequencedMap.get(roByKey.getSequence())) == null ? roByKey.clone() : roBySequence.withSearchFilter(roBySequence.getSearchFilter() + "~" + roByKey.getSearchFilter());
                sequencedMap.put(roByKey.getSequence(), mergedRO);
            }
            if (route.getStickySelectorKey() != null && stickySelectorKey != null && !foundDynamicStickKey && !route.getStickySelectorKey().equals(stickySelectorKey) || stickySelectorKey != null && route.getStickySelectorKey() == null) continue;
            totalRouteOffers += route.getRouteOffer().size();
            if (foundDynamicStickKey) continue;
            for (RouteOffer offer : route.getRouteOffer()) {
                if (!offer.isActive()) {
                    ++inactiveCount;
                    continue;
                }
                if (preferredRouteOffer != null && preferredRouteOffer.equals(offer.getName())) {
                    addedPreferredRouteOffer = true;
                }
                if ((roByKey = this.routeOfferMap.get(cacheKey = this.envContext + "_" + offer + "_" + routeGroup.getName())) == null) {
                    version = this.applyVersionMapping(offer);
                    fqName = routeGroup.getName() + "." + route.getName() + "." + offer.getName();
                    roByKey = new DME2RouteOffer(this.getServiceName(), version, this.envContext, offer, fqName, this.manager);
                    this.routeOfferMap.put(cacheKey, roByKey);
                }
                mergedRO = (roBySequence = (DME2RouteOffer)sequencedMap.get(roByKey.getSequence())) == null ? roByKey.clone() : roBySequence.withSearchFilter(roBySequence.getSearchFilter() + "~" + roByKey.getSearchFilter());
                sequencedMap.put(roByKey.getSequence(), mergedRO);
            }
        }
        if (preferredRouteOffer != null && !addedPreferredRouteOffer && (pRouteOffer = this.getRouteOffersForcePreferredRouteOffer(sequencedMap, routeGroup, preferredRouteOffer, partitionName)) != null) {
            if (!pRouteOffer.isActive()) {
                ++inactiveCount;
            } else {
                DME2RouteOffer roBySequence;
                String cacheKey = this.envContext + "_" + pRouteOffer + "_" + routeGroup.getName();
                DME2RouteOffer roByKey = this.routeOfferMap.get(cacheKey);
                if (roByKey == null) {
                    String version = this.applyVersionMapping(pRouteOffer);
                    String fqName = routeGroup.getName() + "." + pRouteOffer.getName() + "." + pRouteOffer.getName();
                    roByKey = new DME2RouteOffer(this.getServiceName(), version, this.envContext, pRouteOffer, fqName, this.manager);
                    this.routeOfferMap.put(cacheKey, roByKey);
                }
                DME2RouteOffer mergedRO = (roBySequence = (DME2RouteOffer)sequencedMap.get(roByKey.getSequence())) == null ? roByKey.clone() : roBySequence.withSearchFilter(roBySequence.getSearchFilter() + "~" + roByKey.getSearchFilter());
                sequencedMap.put(roByKey.getSequence(), mergedRO);
                ++totalRouteOffers;
            }
        }
        if (inactiveCount == totalRouteOffers) {
            throw new DME2Exception("AFT-DME2-0103", new ErrorContext().add("service", this.getServiceName()).add("version", this.getServiceVersion()).add("partner", partnerName).add("key", keyValue));
        }
        return Collections.unmodifiableList(new ArrayList(sequencedMap.values()));
    }

    private String checkRangePartitions(String keyValue) {
        String partitionName = null;
        Map.Entry<String, DataPartition> entry = this.partitionMap.floorEntry(keyValue);
        if (entry == null) {
            return null;
        }
        DataPartition partition = entry.getValue();
        if (!entry.getKey().equals(keyValue) && partition.getHigh().equals(entry.getKey())) {
            return null;
        }
        partitionName = partition.getName();
        return partitionName;
    }

    private String checkListPartitions(String keyValue) {
        String partitionName = null;
        if (this.isHasListPartitions() && keyValue != null) {
            for (ListDataPartition dp : this.LDPList) {
                if (!dp.getValue().contains(keyValue)) continue;
                partitionName = dp.getName();
                break;
            }
        }
        return partitionName;
    }

    private RouteGroup getRouteGroup(String partnerName) {
        return this.routeGroupMap.get(partnerName);
    }

    private String applyVersionMapping(RouteOffer routeOffer) {
        List<VersionMap> verMapList = this.getVersionMappings();
        if (verMapList != null) {
            for (VersionMap verMap : verMapList) {
                if (!verMap.getName().equals(routeOffer.getVersionMapRef())) continue;
                for (VersionMapInfo verMapInfo : verMap.getVersionMapInfo()) {
                    String[] clientVersionTokens;
                    String[] fromVersionTokens;
                    if (verMapInfo.getFromVersionFilter().matches("[0-9]+\\.[*]") || verMapInfo.getFromVersionFilter().matches("[0-9]+\\.[*]\\.[*]")) {
                        fromVersionTokens = verMapInfo.getFromVersionFilter().split("\\.");
                        if (!(!this.getServiceVersion().contains(".") ? fromVersionTokens[0].equals(this.getServiceVersion()) : (clientVersionTokens = this.getServiceVersion().split("\\."))[0].equals(fromVersionTokens[0]))) continue;
                        return verMapInfo.getOutgoingVersionFilter();
                    }
                    if (verMapInfo.getFromVersionFilter().matches("[0-9]+\\.[*]\\.[0-9]+")) {
                        fromVersionTokens = verMapInfo.getFromVersionFilter().split("\\.");
                        if (!this.getServiceVersion().contains(".") || (clientVersionTokens = this.getServiceVersion().split("\\.")).length != 3 || !clientVersionTokens[0].equals(fromVersionTokens[0]) || !clientVersionTokens[2].equals(fromVersionTokens[2])) continue;
                        return verMapInfo.getOutgoingVersionFilter();
                    }
                    if (verMapInfo.getFromVersionFilter().matches("[0-9]+")) {
                        if (this.getServiceVersion().contains(".") || !this.getServiceVersion().equals(verMapInfo.getFromVersionFilter())) continue;
                        return verMapInfo.getOutgoingVersionFilter();
                    }
                    if (verMapInfo.getFromVersionFilter().matches("[0-9]+\\.[0-9]+")) {
                        fromVersionTokens = verMapInfo.getFromVersionFilter().split("\\.");
                        if (!this.getServiceVersion().contains(".") || (clientVersionTokens = this.getServiceVersion().split("\\.")).length != 2 || !clientVersionTokens[0].equals(fromVersionTokens[0]) || !clientVersionTokens[1].equals(fromVersionTokens[1])) continue;
                        return verMapInfo.getOutgoingVersionFilter();
                    }
                    if (!verMapInfo.getFromVersionFilter().matches("[0-9]+\\.[0-9]+\\.[0-9]+") || !this.getServiceVersion().equals(verMapInfo.getFromVersionFilter())) continue;
                    return verMapInfo.getOutgoingVersionFilter();
                }
            }
        }
        return this.getServiceVersion();
    }

    private List<VersionMap> getVersionMappings() {
        if (this.routeInfo == null || this.routeInfo.getVersionMappings() == null) {
            return null;
        }
        return this.routeInfo.getVersionMappings().getVersionMap();
    }

    public RouteOffer getRouteOffersForcePreferredRouteOffer(Map<Integer, DME2RouteOffer> sequencedMap, RouteGroup routeGroup, String preferredRouteOffer, String partitionName) throws DME2Exception {
        List<Route> routes = routeGroup.getRoute();
        boolean foundRouteOffer = false;
        for (Route route : routes) {
            for (RouteOffer offer : route.getRouteOffer()) {
                if (offer.getName() == null || !offer.getName().equalsIgnoreCase(preferredRouteOffer)) continue;
                foundRouteOffer = true;
                if (!offer.isActive()) break;
                return offer;
            }
            if (!foundRouteOffer) continue;
            break;
        }
        return null;
    }

    static {
        try {
            jaxBContext = JAXBContext.newInstance((String)"com.att.aft.dme2.types");
        }
        catch (JAXBException e) {
            logger.error((URI)null, "static", LogMessage.REPORT_ERROR, (Object)"error in static initializer", (Object)e);
        }
    }
}

