/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry.util;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.grm.types.v1.ServiceEndPoint;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2JDBCEndpoint;
import com.att.aft.dme2.manager.registry.util.DME2DistanceUtil;
import com.att.aft.dme2.registry.dto.ServiceEndpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import com.att.aft.dme2.util.XMLGregorianCalendarConverter;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;

public class DME2EndpointUtil {
    private DME2EndpointUtil() {
    }

    public static DME2Endpoint convertEndpoint(ServiceEndpoint serviceEndpoint, String serviceURI, Long expireTime, double clientLatitude, double clientLongitude) {
        DME2Endpoint endpoint;
        if (serviceEndpoint == null) {
            return null;
        }
        double epLat = Double.valueOf(serviceEndpoint.getLatitude());
        double epLong = Double.valueOf(serviceEndpoint.getLongitude());
        double distance = DME2DistanceUtil.calculateDistanceBetween(clientLatitude, clientLongitude, epLat, epLong);
        if ("dme2jdbc".equalsIgnoreCase(serviceEndpoint.getProtocol())) {
            endpoint = new DME2JDBCEndpoint(distance);
            ((DME2JDBCEndpoint)endpoint).setDatabaseName(serviceEndpoint.getDmeJDBCDatabaseName());
            ((DME2JDBCEndpoint)endpoint).setHealthCheckUser(serviceEndpoint.getDmeJDBCHealthCheckUser());
            ((DME2JDBCEndpoint)endpoint).setHealthCheckPassword(serviceEndpoint.getDmeJDBCHealthCheckPassword());
            ((DME2JDBCEndpoint)endpoint).setHealthCheckDriver(serviceEndpoint.getDmeJDBCHealthCheckDriver());
        } else {
            endpoint = new DME2Endpoint(distance);
            endpoint.setContextPath(serviceEndpoint.getContextPath());
        }
        endpoint.setServiceName(serviceURI);
        if (null != serviceEndpoint.getContextPath()) {
            endpoint.setPath(serviceEndpoint.getContextPath());
        } else {
            endpoint.setPath("");
        }
        endpoint.setHost(serviceEndpoint.getHostAddress());
        endpoint.setPort(Integer.valueOf(serviceEndpoint.getPort()));
        endpoint.setLatitude(Double.valueOf(serviceEndpoint.getLatitude()));
        endpoint.setLongitude(Double.valueOf(serviceEndpoint.getLongitude()));
        endpoint.setLease(expireTime);
        endpoint.setProtocol(serviceEndpoint.getProtocol().toUpperCase());
        endpoint.setRouteOffer(serviceEndpoint.getRouteOffer());
        endpoint.setEndpointProperties(serviceEndpoint.getAdditionalProperties());
        endpoint.setSimpleName(serviceEndpoint.getName());
        endpoint.setServiceVersion(serviceEndpoint.getVersion());
        return endpoint;
    }

    public static DME2Endpoint buildDME2Endpoint(double clientLatitude, double clientLongitude, DmeUniformResource uniformResource, String contextPath, String env, String host, int port, String protocol, double latitude, double longitude, Properties props) {
        DME2Endpoint endpoint;
        double distance = DME2DistanceUtil.calculateDistanceBetween(clientLatitude, clientLongitude, latitude, longitude);
        if (protocol.equalsIgnoreCase("dme2jdbc")) {
            endpoint = new DME2JDBCEndpoint(distance);
            if (props != null) {
                if (props.containsKey("KEY_DME2_JDBC_DATABASE_NAME")) {
                    ((DME2JDBCEndpoint)endpoint).setDatabaseName((String)props.get("KEY_DME2_JDBC_DATABASE_NAME"));
                }
                if (props.containsKey("KEY_DME2_JDBC_HEALTHCHECK_USER")) {
                    ((DME2JDBCEndpoint)endpoint).setHealthCheckUser((String)props.get("KEY_DME2_JDBC_HEALTHCHECK_USER"));
                }
                if (props.containsKey("KEY_DME2_JDBC_DATABASE_NAME")) {
                    ((DME2JDBCEndpoint)endpoint).setHealthCheckPassword((String)props.get("KEY_DME2_JDBC_HEALTHCHECK_PASSWORD"));
                }
                if (props.containsKey("KEY_DME2_JDBC_HEALTHCHECK_DRIVER")) {
                    ((DME2JDBCEndpoint)endpoint).setHealthCheckDriver((String)props.get("KEY_DME2_JDBC_HEALTHCHECK_DRIVER"));
                }
            }
        } else {
            endpoint = new DME2Endpoint(distance);
        }
        endpoint.setContextPath(contextPath);
        endpoint.setSimpleName(uniformResource.getService());
        endpoint.setServiceName(uniformResource.getService());
        endpoint.setEnvContext(env);
        endpoint.setHost(host);
        endpoint.setPort(port);
        endpoint.setPath(contextPath);
        endpoint.setLatitude(latitude);
        endpoint.setLongitude(longitude);
        endpoint.setProtocol(protocol);
        endpoint.setEndpointProperties(props);
        endpoint.setDmeUniformResource(uniformResource);
        endpoint.setRouteOffer(uniformResource.getRouteOffer());
        endpoint.setServiceVersion(uniformResource.getVersion());
        Calendar now = Calendar.getInstance(DME2Manager.getTimezone());
        return endpoint;
    }

    public static ServiceEndpoint convertToServiceEndpoint(DME2Configuration config, DME2Endpoint publishedEndpoint) {
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        serviceEndpoint.setName(publishedEndpoint.getServiceName());
        serviceEndpoint.setVersion(publishedEndpoint.getServiceVersion());
        serviceEndpoint.setPort(String.valueOf(publishedEndpoint.getPort()));
        serviceEndpoint.setProtocol(publishedEndpoint.getProtocol());
        serviceEndpoint.setLatitude(String.valueOf(publishedEndpoint.getLatitude()));
        serviceEndpoint.setLongitude(String.valueOf(publishedEndpoint.getLongitude()));
        serviceEndpoint.setHostAddress(publishedEndpoint.getHost());
        serviceEndpoint.setContextPath(publishedEndpoint.getContextPath());
        serviceEndpoint.setRouteOffer(publishedEndpoint.getRouteOffer());
        serviceEndpoint.setEnv(publishedEndpoint.getEnvContext());
        Map<String, String> queryParams = publishedEndpoint.getDmeUniformResource().getQueryParamsMap();
        if (queryParams.get("supportedVersionRange") != null) {
            serviceEndpoint.setClientSupportedVersions(queryParams.get("supportedVersionRange"));
        }
        if (publishedEndpoint instanceof DME2JDBCEndpoint) {
            DME2JDBCEndpoint jdbcEndpoint = (DME2JDBCEndpoint)publishedEndpoint;
            serviceEndpoint.setDmeJDBCDatabaseName(jdbcEndpoint.getDatabaseName());
            serviceEndpoint.setDmeJDBCHealthCheckUser(jdbcEndpoint.getHealthCheckUser());
            serviceEndpoint.setDmeJDBCHealthCheckPassword(jdbcEndpoint.getHealthCheckPassword());
            serviceEndpoint.setDmeJDBCHealthCheckDriver(jdbcEndpoint.getHealthCheckDriver());
        }
        Properties additionalProperties = publishedEndpoint.getEndpointProperties();
        Calendar now = Calendar.getInstance(DME2Manager.getTimezone());
        long nowMs = System.currentTimeMillis();
        if (additionalProperties != null && additionalProperties.get("KEY_SEP_LEASE_EXPIRATION_OVERRIDE_MIN") != null) {
            now.add(13, Integer.parseInt((String)additionalProperties.get("KEY_SEP_LEASE_EXPIRATION_OVERRIDE_MIN")));
        } else if (publishedEndpoint instanceof DME2JDBCEndpoint || additionalProperties != null && Boolean.valueOf(additionalProperties.getProperty("DME2_REGISTER_STATIC_ENDPOINT")).booleanValue()) {
            now.set(1, 9999);
            now.set(2, 8);
            now.set(5, 9);
        } else {
            now.add(14, config.getInt("DME2_SEP_LEASE_LENGTH_MS"));
        }
        if (additionalProperties != null) {
            serviceEndpoint.setAdditionalProperties(additionalProperties);
        }
        serviceEndpoint.setExpirationTime(XMLGregorianCalendarConverter.asXMLGregorianCalendar(now.getTime()));
        return serviceEndpoint;
    }

    public static ServiceEndpoint convertGrmEndpointToAccessorEndpoint(ServiceEndPoint input) {
        ServiceEndpoint sep = new ServiceEndpoint();
        sep.setContextPath(input.getContextPath());
        sep.setName(input.getName());
        sep.setVersion(input.getVersion().getMajor() + "." + input.getVersion().getMinor() + "." + input.getVersion().getPatch());
        sep.setPort(input.getListenPort());
        sep.setProtocol(input.getProtocol());
        sep.setLatitude(input.getLatitude());
        sep.setLongitude(input.getLongitude());
        sep.setHostAddress(input.getHostAddress());
        sep.setContextPath(input.getContextPath());
        sep.setRouteOffer(input.getRouteOffer());
        sep.setAdditionalProperties(DME2URIUtils.convertNameValuePairToProperties(input.getProperties()));
        sep.setDmeVersion(input.getDME2Version());
        sep.setClientSupportedVersions(input.getClientSupportedVersions());
        sep.setDmeJDBCDatabaseName(input.getDME2JDBCDatabaseName());
        sep.setDmeJDBCHealthCheckUser(input.getDME2JDBCHealthCheckUser());
        sep.setDmeJDBCHealthCheckPassword(input.getDME2JDBCHealthCheckPassword());
        sep.setExpirationTime(input.getExpirationTime());
        return sep;
    }
}

