/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry.util;

import com.att.aft.dme2.internal.apache.commons.lang.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DME2FileUtil {
    private DME2FileUtil() {
    }

    public static List<File> hierarchicalFileLookup(File currentDir, String path) {
        String[] pathPieces;
        String firstPiece;
        ArrayList<File> files = new ArrayList<File>();
        if (path == null || path.isEmpty() || currentDir == null || !currentDir.exists()) {
            return files;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((firstPiece = (pathPieces = path.split("/"))[0]).startsWith("version=")) {
            for (File f : currentDir.listFiles()) {
                String fileName;
                if (!f.isDirectory() || !(fileName = f.getName()).equals(firstPiece) && !fileName.startsWith(firstPiece + ".")) continue;
                files.addAll(DME2FileUtil.hierarchicalFileLookup(new File(currentDir + "/" + fileName), StringUtils.join((Object[])Arrays.copyOfRange(pathPieces, 1, pathPieces.length), "/")));
            }
        } else if (pathPieces.length > 1) {
            files.addAll(DME2FileUtil.hierarchicalFileLookup(new File(currentDir.getAbsolutePath() + "/" + firstPiece), StringUtils.join((Object[])Arrays.copyOfRange(pathPieces, 1, pathPieces.length), "/")));
        } else {
            File file = new File(currentDir + "/" + firstPiece);
            if (file.exists()) {
                files.add(file);
            }
        }
        return files;
    }
}

