/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.util.grm.DNSIPResolver;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class GRMEndPointsDiscoveryHelperDNS
implements IGRMEndPointDiscovery {
    private final String grmServersEnvDNSName;
    private final String grmSeedProtocol;
    private final String grmSeedPort;
    private final String grmSeedPath;
    private static final Logger logger = LoggerFactory.getLogger(GRMEndPointsDiscoveryHelperDNS.class);

    protected GRMEndPointsDiscoveryHelperDNS(String grmServersEnvDNSName, String grmSeedProtocol, String grmSeedPort, String grmSeedPath) {
        logger.debug(null, "ctor", LogMessage.METHOD_ENTER);
        logger.debug(null, "ctor", "DNSNAME: {} SEED PROTOCOL: {} SEED PORT: {} SEED PATH: {}", grmServersEnvDNSName, grmSeedProtocol, grmSeedPort, grmSeedPath);
        this.grmServersEnvDNSName = grmServersEnvDNSName;
        this.grmSeedProtocol = grmSeedProtocol;
        this.grmSeedPort = grmSeedPort;
        this.grmSeedPath = grmSeedPath;
        logger.debug(null, "ctor", LogMessage.METHOD_EXIT);
    }

    @Override
    public List<String> getGRMEndpoints() {
        try {
            logger.debug((URI)null, "getGRMEndpoints", "Getting Seed GRM servers from following DNS Name: {}", (Object)this.grmServersEnvDNSName);
            List<String> listGRMServerIPs = DNSIPResolver.getListIPForName(this.grmServersEnvDNSName);
            return this.convertIPListToURL(listGRMServerIPs);
        }
        catch (UnknownHostException ex) {
            logger.error((URI)null, "getGRMEndpoints", "Can't get GRM Server list from DNS = {}", (Object)this.grmServersEnvDNSName, (Object)ex);
            return new ArrayList<String>(0);
        }
    }

    private List<String> convertIPListToURL(List<String> ipList) {
        ArrayList<String> urlList = new ArrayList<String>(ipList.size());
        for (String ip : ipList) {
            String address = this.ipToGRMServerEndpointURL(ip);
            logger.debug((URI)null, "convertIPListToURL", "Found GRM Seed host ip {} , adding following address as seed: {}", (Object)ip, (Object)address);
            urlList.add(address);
        }
        return urlList;
    }

    private String ipToGRMServerEndpointURL(String ip) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.grmSeedProtocol);
        buff.append("://");
        buff.append(ip);
        buff.append(":");
        buff.append(this.grmSeedPort);
        buff.append(this.grmSeedPath);
        return buff.toString();
    }

    @Override
    public void close() {
    }
}

