/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.grm.types.v1.ServiceEndPoint;
import com.att.aft.dme2.internal.grm.types.v1.VersionDefinition;
import com.att.aft.dme2.internal.grm.v1.FindRunningServiceEndPointRequest;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.util.DME2EndpointUtil;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.registry.dto.ServiceEndpoint;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class GRMEndPointsDiscoveryHelperGRM
implements IGRMEndPointDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(GRMEndPointsDiscoveryHelperGRM.class);
    protected ServiceEndPoint sep;
    protected FindRunningServiceEndPointRequest req;
    protected BaseAccessor grmServiceAccessor;
    private DME2Configuration config;
    private String grmedgeURL;
    private List<String> grmedgeURLFromDNS;
    private String[] grmedgeAFTDirectURLList;

    protected GRMEndPointsDiscoveryHelperGRM(String environment, String protocol, String serviceName, String version, BaseAccessor grmServiceAccessor, DME2Configuration configuration) {
        this.config = configuration;
        this.grmServiceAccessor = grmServiceAccessor;
        this.buildFindGRMServiceEndPointRequest(environment, protocol, serviceName, version);
    }

    protected GRMEndPointsDiscoveryHelperGRM(String grmedgeDirectURL, DME2Configuration configuration) {
        this.config = configuration;
        this.grmedgeURL = grmedgeDirectURL;
    }

    protected GRMEndPointsDiscoveryHelperGRM(List<String> grmedgeDNSURLs, DME2Configuration configuration) {
        this.config = configuration;
        this.grmedgeURLFromDNS = grmedgeDNSURLs;
    }

    protected GRMEndPointsDiscoveryHelperGRM(String[] grmedgeAFTDirectURLs, DME2Configuration configuration) {
        this.config = configuration;
        this.grmedgeAFTDirectURLList = grmedgeAFTDirectURLs;
    }

    @Override
    public List<String> getGRMEndpoints() {
        ArrayList<String> newGRMServers = new ArrayList<String>();
        if (!this.config.getProperty("GRM_EDGE_DIRECT_HOST").isEmpty()) {
            newGRMServers.add(this.grmedgeURL);
        } else if (!this.config.getProperty("GRM_EDGE_CUSTOM_DNS").isEmpty()) {
            for (String aURL : this.grmedgeURLFromDNS) {
                newGRMServers.add(aURL);
            }
        } else if (!this.config.getProperty("AFT_DME2_GRM_URLS").isEmpty()) {
            for (String aURL : this.grmedgeAFTDirectURLList) {
                newGRMServers.add(aURL);
            }
        } else {
            try {
                ServiceEndpoint sep = DME2EndpointUtil.convertGrmEndpointToAccessorEndpoint(this.req.getServiceEndPoint());
                sep.setEnv(this.req.getEnv());
                List<ServiceEndpoint> endPoints = this.grmServiceAccessor.findRunningServiceEndPoint(sep);
                if (endPoints != null && !endPoints.isEmpty()) {
                    for (ServiceEndpoint sepNew : endPoints) {
                        if (this.config.getBoolean("DME2_OVERRIDE_GRM_SERVER_PATH")) {
                            sepNew.setContextPath(this.config.getProperty("DME2_GRM_SERVER_PATH"));
                        }
                        newGRMServers.add(this.convertServiceEndPointToString(sepNew));
                    }
                } else {
                    logger.debug(null, "getGRMEndpoints", "call to following GRM Seed Server returned with no result: ");
                }
            }
            catch (DME2Exception e) {
                logger.debug((URI)null, "getGRMEndpoints", "call to following GRM Seed Server to get other GRM servers failed with following exception: ", (Object)e);
            }
            if (newGRMServers.isEmpty()) {
                logger.debug(null, "getGRMEndpoints", "Call to GRM seed servers to get other GRM server did not return any result.");
            }
        }
        return newGRMServers;
    }

    private void buildFindGRMServiceEndPointRequest(String environment, String protocol, String serviceName, String version) {
        VersionDefinition vd = DME2Utils.buildVersionDefinition(this.config, version);
        this.sep = new ServiceEndPoint();
        this.sep.setProtocol(protocol);
        this.sep.setVersion(vd);
        this.sep.setName(serviceName);
        this.req = new FindRunningServiceEndPointRequest();
        this.req.setServiceEndPoint(this.sep);
        this.req.setEnv(environment);
    }

    private String convertServiceEndPointToString(ServiceEndpoint sep) {
        return sep.getProtocol() + "://" + sep.getHostAddress() + ":" + sep.getPort() + sep.getContextPath();
    }

    public void setGrmServiceAccessor(BaseAccessor grmServiceAccessor) {
        this.grmServiceAccessor = grmServiceAccessor;
    }

    @Override
    public void close() {
    }
}

