/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.util.SecurityContext;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMInstance;
import com.att.aft.dme2.internal.grm.types.v1.ContainerInstance;
import com.att.aft.dme2.internal.grm.types.v1.LRM;
import com.att.aft.dme2.internal.grm.types.v1.ServiceEndPoint;
import com.att.aft.dme2.internal.grm.types.v1.ServiceVersionDefinition;
import com.att.aft.dme2.internal.grm.types.v1.VersionDefinition;
import com.att.aft.dme2.internal.grm.v1.AddServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.DeleteServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.FindClientJVMInstanceRequest;
import com.att.aft.dme2.internal.grm.v1.FindClientJVMInstanceResponse;
import com.att.aft.dme2.internal.grm.v1.FindRunningServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.FindRunningServiceEndPointResponse;
import com.att.aft.dme2.internal.grm.v1.GetRouteInfoRequest;
import com.att.aft.dme2.internal.grm.v1.GetRouteInfoResponse;
import com.att.aft.dme2.internal.grm.v1.RegisterClientJVMInstanceRequest;
import com.att.aft.dme2.internal.grm.v1.UpdateServiceEndPointRequest;
import com.att.aft.dme2.internal.gson.Gson;
import com.att.aft.dme2.internal.gson.GsonBuilder;
import com.att.aft.dme2.internal.jackson.map.ObjectMapper;
import com.att.aft.dme2.internal.jersey.core.util.Base64;
import com.att.aft.dme2.internal.jettison.json.JSONException;
import com.att.aft.dme2.internal.jettison.json.JSONObject;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.registry.accessor.AbstractGRMAccessor;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.registry.dto.GRMEndpoint;
import com.att.aft.dme2.registry.dto.ServiceEndpoint;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2CustomXGCalConverter;
import com.att.aft.dme2.util.DME2URIUtils;
import com.att.aft.dme2.util.DME2ValidationUtil;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.OfferCache;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class RestGRMAccessor
extends AbstractGRMAccessor
implements BaseAccessor {
    private static final Logger logger = LoggerFactory.getLogger(RestGRMAccessor.class.getName());
    private static String CREDENTIALS;
    private static List<String> attemptedOffers;
    private ObjectMapper mapper;

    public RestGRMAccessor(DME2Configuration config, SecurityContext ctx, IGRMEndPointDiscovery discovery) {
        super(config, ctx, discovery);
        CREDENTIALS = "Basic " + new String(Base64.encode(config.getProperty("DME2_GRM_USER") + ":" + config.getProperty("DME2_GRM_PASS")));
        this.mapper = new ObjectMapper();
    }

    @Override
    public void addServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        LRM lrm = this.buildLRM(input);
        ContainerInstance ci = this.buildContainerInstance(input);
        AddServiceEndPointRequest req = new AddServiceEndPointRequest();
        req.setEnv(input.getEnv());
        req.setLrmRef(lrm);
        req.setServiceEndPoint(sep);
        req.setCheckNcreateParents(true);
        if (ci.getName() != null && !ci.getName().startsWith("dummy")) {
            req.setContainerInstanceRef(ci);
        }
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "addServiceEndPoint", "AddServiceEndpoint {}", (Object)jsonRequest);
            this.invokeGRMService(AddServiceEndPointRequest.class.getSimpleName(), jsonRequest);
        }
        catch (Throwable e) {
            logger.debug((URI)null, "addServiceEndPoint", "Error in invoking GRM addServiceEndpoint", (Object)e);
            throw this.processException(e, "addServiceEndPoint", req.getEnv() + "/" + req.getServiceEndPoint().getName() + ":" + req.getServiceEndPoint().getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeGRMService(String requestName, String request) throws DME2Exception {
        long start = System.currentTimeMillis();
        ArrayList<String> offerList = new ArrayList<String>();
        OfferCache offerCache = OfferCache.getInstance();
        String response = null;
        List<String> endpointsToAttempt = this.grmEndPointDiscovery.getGRMEndpoints();
        if (System.getProperty("AFT_DME2_DEBUG_GRM_EPS") != null && !request.contains("Metrics") && !request.contains("delete")) {
            attemptedOffers = new ArrayList<String>();
        }
        String grmCode = null;
        String grmMessage = null;
        String faultMessage = null;
        long startTime = System.currentTimeMillis();
        int iterationCount = 0;
        String skipStaleOffers = this.config.getProperty("DME2_RETRY_STALE_GRM_OFFERS");
        Iterator<String> iter = endpointsToAttempt.iterator();
        while (iter.hasNext()) {
            String faultResponse;
            if (System.currentTimeMillis() - startTime >= (long)overallTimeout) break;
            String currentGRMEndpoint = iter.next();
            String finalURL = this.getFinalRequestURL(currentGRMEndpoint, this.config.getProperty(requestName).substring(0, this.config.getProperty(requestName).indexOf("@")));
            String method = this.config.getProperty(requestName).substring(this.config.getProperty(requestName).indexOf("@") + 1, this.config.getProperty(requestName).length());
            logger.debug(null, "invokeGRMService", String.format("Preparing to invoke GRM with URL: %s. -- Attempt number: [%s]", currentGRMEndpoint, iterationCount));
            if (System.getProperty("AFT_DME2_DEBUG_GRM_EPS") != null && !request.contains("Metrics") && !request.contains("delete")) {
                attemptedOffers.add(currentGRMEndpoint);
            }
            if (skipStaleOffers.equalsIgnoreCase("true") && offerCache.isStale(currentGRMEndpoint)) continue;
            HttpURLConnection conn = null;
            URL url = null;
            InputStream istream = null;
            try {
                logger.debug(null, "invokeGRMService", "GRMService connectTimeout \t{}\t ;GRMService readTimeout \t{}; GRM Rest URL \t{}", connectTimeout, readTimeout, finalURL);
                url = new URL(finalURL);
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                if (url.getProtocol().equalsIgnoreCase("https")) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(AllowAllHostnameVerifier.INSTANCE);
                }
                this.sendRequest(conn, request, method);
                int respCode = conn.getResponseCode();
                if (respCode != 200) {
                    faultResponse = null;
                    faultResponse = conn.getInputStream() != null ? this.parseResponse(conn.getInputStream()) : (conn.getErrorStream() != null ? this.parseResponse(conn.getErrorStream()) : conn.getResponseMessage());
                    logger.debug((URI)null, "invokeGRMService", "FaultResponse from GRMService \t{}", (Object)faultResponse);
                    throw new Exception(" GRM Service Call Failed; StatusCode=" + respCode + "; GRMFaultResponse=" + faultResponse);
                }
                logger.debug(null, "invokeGRMService", "ElapsedTime from GRMService \t" + (System.currentTimeMillis() - start) + " GRM Endpoint Used=" + currentGRMEndpoint);
                faultResponse = response = this.parseResponse(conn.getInputStream());
                return faultResponse;
            }
            catch (SocketTimeoutException e) {
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.debug((String)null, (URI)null, "invokeGRMService", "SocketTimeoutException from GRMService for offer {}", (Object)currentGRMEndpoint, (Object)e);
                    logger.error((String)null, (URI)null, "invokeGRMService", "AFT-DME2-0914", (Object)new ErrorContext().add("GRM URL", currentGRMEndpoint), (Object)e);
                }
                iter.remove();
                offerCache.setStale(currentGRMEndpoint);
                offerList.add(currentGRMEndpoint);
            }
            catch (ConnectException e) {
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.debug((String)null, (URI)null, "invokeGRMService", "ConnectException from GRMService for offer {}", (Object)currentGRMEndpoint, (Object)e);
                    logger.warn((String)null, (URI)null, "invokeGRMService", "AFT-DME2-0913", (Object)new ErrorContext().add("GRM URL", currentGRMEndpoint), (Object)e);
                }
                iter.remove();
                offerCache.setStale(currentGRMEndpoint);
                offerList.add(currentGRMEndpoint);
            }
            catch (Throwable e) {
                logger.debug((URI)null, "invokeGRMService", "Error in invoking GRM", (Object)e);
                faultResponse = null;
                if (conn != null) {
                    InputStream err = conn.getErrorStream();
                    try {
                        faultResponse = this.parseResponse(err);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (faultResponse != null) {
                        try {
                            JSONObject jsonFaultResponse = new JSONObject(faultResponse);
                            JSONObject jsonFaultString = jsonFaultResponse.getJSONObject("faultString");
                            grmCode = (String)jsonFaultString.get("grmcode");
                            grmMessage = (String)jsonFaultString.get("message");
                            faultMessage = (String)jsonFaultString.get("faultMessage");
                        }
                        catch (JSONException e1) {
                            try {
                                JSONObject jsonFaultResponse = new JSONObject(faultResponse);
                                grmCode = (String)jsonFaultResponse.get("code");
                                grmMessage = (String)jsonFaultResponse.get("message");
                                faultMessage = (String)jsonFaultResponse.get("message");
                            }
                            catch (JSONException e2) {
                                logger.debug((URI)null, "invokeGRMService", "Error in invoking GRM: JSONException", (Object)e2);
                            }
                        }
                    }
                }
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.debug(null, "invokeGRMService", "Throwable from GRMService for offer {}; GRMFaultResponse={}", currentGRMEndpoint, faultResponse, e);
                    logger.warn((String)null, (URI)null, "invokeGRMService", "AFT-DME2-0915", (Object)new ErrorContext().add("GRM URL", currentGRMEndpoint), (Object)e);
                }
                iter.remove();
                offerCache.setStale(currentGRMEndpoint);
                offerList.add(currentGRMEndpoint);
            }
            finally {
                if (istream == null) continue;
                try {
                    istream.close();
                }
                catch (IOException e) {
                    logger.debug((URI)null, "invokeGRMService", "Non-fatal IOException closing output stream to GRM", (Object)e);
                }
            }
        }
        offerCache.removeStaleness(offerList);
        if (grmCode != null && grmMessage != null) {
            throw new DME2Exception(grmCode, grmMessage, new Object[0]);
        }
        if (faultMessage != null) {
            String[] faultInfo;
            if (faultMessage.contains("GRMSVC") && (faultInfo = this.getGRMFaultInfo(faultMessage)) != null) {
                throw new DME2Exception(faultInfo[0], faultInfo[1], new Object[0]);
            }
            throw new DME2Exception("AFT-DME2-0916", new ErrorContext().add("GRM URLs", Arrays.asList(this.grmURLs).toString()).add("faultMessage", faultMessage));
        }
        if (this.grmURLs != null) {
            throw new DME2Exception("AFT-DME2-0902", new ErrorContext().add("GRM URLs", Arrays.asList(this.grmURLs).toString()));
        }
        throw new DME2Exception("AFT-DME2-0902", new ErrorContext().add("GRM URLs", "No GRM URL Found"));
    }

    private String getFinalRequestURL(String currentGRMEndpoint, String contextPath) {
        if (currentGRMEndpoint.endsWith("/")) {
            return currentGRMEndpoint.concat(contextPath);
        }
        if (contextPath.startsWith("/")) {
            return currentGRMEndpoint.concat(contextPath);
        }
        return currentGRMEndpoint.concat("/").concat(contextPath);
    }

    private String parseResponse(InputStream istream) throws IOException {
        byte[] buffer = new byte[1024];
        int iter_length = 0;
        int total_length = 0;
        StringBuffer strBuffer = new StringBuffer();
        while (iter_length != -1) {
            iter_length = istream.read(buffer, 0, 1024);
            if (iter_length < 0) continue;
            String tmpStr = new String(buffer, 0, iter_length);
            total_length += iter_length;
            strBuffer.append(tmpStr);
        }
        return strBuffer.toString();
    }

    protected void sendRequest(HttpURLConnection conn, String request, String method) throws Exception {
        logger.debug((URI)null, "sendRequest", "Request JSON to GRM | {}", (Object)request);
        conn.setRequestMethod(method);
        if (this.config.getBoolean(DME2Constants.DME2_GRM_AUTH)) {
            conn.setRequestProperty("Authorization", CREDENTIALS);
        }
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream out = conn.getOutputStream();
        out.write(request.getBytes());
        out.flush();
        out.close();
    }

    @Override
    public void updateServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        LRM lrm = this.buildLRM(input);
        UpdateServiceEndPointRequest req = new UpdateServiceEndPointRequest();
        req.setUpdateLease(true);
        req.setEnv(input.getEnv());
        req.setLrmRef(lrm);
        ContainerInstance ci = this.buildContainerInstance(input);
        if (ci.getName() != null && !ci.getName().startsWith("dummy")) {
            req.setContainerInstanceRef(ci);
        }
        req.setServiceEndPoint(sep);
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "updateServiceEndPoint", "UpdateServiceEndpoint {}", (Object)jsonRequest);
            this.invokeGRMService(UpdateServiceEndPointRequest.class.getSimpleName(), jsonRequest);
        }
        catch (Throwable e) {
            throw this.processException(e, "UpdateServiceEndPoint", req.getEnv() + "/" + req.getServiceEndPoint().getName() + ":" + req.getServiceEndPoint().getVersion());
        }
    }

    @Override
    public void deleteServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        DeleteServiceEndPointRequest req = new DeleteServiceEndPointRequest();
        req.setEnv(input.getEnv());
        req.getServiceEndPoint().add(sep);
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "deleteServiceEndPoint", "DeleteServiceEndPoint {}", (Object)jsonRequest);
            this.invokeGRMService(DeleteServiceEndPointRequest.class.getSimpleName(), jsonRequest);
        }
        catch (Throwable e) {
            throw this.processException(e, "DeleteServiceEndPoint", req.getEnv() + "/" + req.getServiceEndPoint().toString());
        }
    }

    private ServiceEndPoint buildGRMServiceEndpoint(ServiceEndpoint input) {
        ServiceEndPoint sep = new ServiceEndPoint();
        sep.setName(input.getName());
        sep.setVersion(this.buildVersionDefinition(input.getVersion()));
        sep.setListenPort(input.getPort());
        sep.setProtocol(input.getProtocol());
        sep.setLatitude(input.getLatitude());
        sep.setLongitude(input.getLongitude());
        sep.setHostAddress(input.getHostAddress());
        sep.setContextPath(input.getContextPath());
        sep.setRouteOffer(input.getRouteOffer());
        sep.getProperties().addAll(DME2URIUtils.convertPropertiestoNameValuePairs(input.getAdditionalProperties()));
        sep.setDME2Version(input.getDmeVersion());
        sep.setClientSupportedVersions(input.getClientSupportedVersions());
        sep.setDME2JDBCDatabaseName(input.getDmeJDBCDatabaseName());
        sep.setDME2JDBCHealthCheckUser(input.getDmeJDBCHealthCheckUser());
        sep.setDME2JDBCHealthCheckPassword(input.getDmeJDBCHealthCheckPassword());
        sep.setExpirationTime(input.getRegistrationTime());
        return sep;
    }

    private ContainerInstance buildContainerInstance(ServiceEndpoint input) {
        ContainerInstance contInstance = new ContainerInstance();
        String containerName = input.getContainerName();
        String containerVersion = input.getContainerVersion();
        String containerRouteOffer = input.getContainerRouteOffer();
        String pid = input.getPid();
        String containerHost = input.getContainerHost();
        if (containerName == null) {
            String string = containerName = this.config.getProperty("AFT_DME2_CONTAINER_NAME_KEY") != null ? this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_NAME_KEY")) : null;
        }
        if (containerVersion == null) {
            containerVersion = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_VERSION_KEY"));
        }
        if (containerRouteOffer == null) {
            containerRouteOffer = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_ROUTEOFFER_KEY"));
        }
        if (pid == null) {
            pid = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_PID_KEY"));
        }
        if (containerHost == null && (containerHost = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY"))) == null) {
            containerHost = input.getHostAddress();
        }
        contInstance.setName(containerName);
        contInstance.setVersion(this.buildVersionDefinition(containerVersion));
        contInstance.setRouteOffer(containerRouteOffer);
        contInstance.setProcessId(pid);
        contInstance.setHostAddress(containerHost);
        return contInstance;
    }

    private LRM buildLRM(ServiceEndpoint request) {
        LRM lrm = new LRM();
        String port = request.getPort();
        if (port == null) {
            port = this.config.getProperty("lrmPort");
        }
        lrm.setHostAddress(request.getHostAddress());
        lrm.setListenPort(port);
        return lrm;
    }

    private VersionDefinition buildVersionDefinition(String version) {
        if (version == null) {
            return null;
        }
        DME2ValidationUtil.validateVersionFormat(this.config, version);
        int majorVersion = 0;
        int minorVersion = 0;
        String patchVersion = null;
        VersionDefinition vd = new VersionDefinition();
        if (version != null) {
            String[] tmpVersion = version.split("\\.");
            if (tmpVersion.length == 3) {
                majorVersion = Integer.parseInt(tmpVersion[0]);
                minorVersion = Integer.parseInt(tmpVersion[1]);
                patchVersion = tmpVersion[2];
            }
            if (tmpVersion.length == 2) {
                majorVersion = Integer.parseInt(tmpVersion[0]);
                minorVersion = Integer.parseInt(tmpVersion[1]);
                patchVersion = null;
            }
            if (tmpVersion.length == 1) {
                majorVersion = Integer.parseInt(tmpVersion[0]);
                minorVersion = -1;
                patchVersion = null;
            }
        }
        vd.setMajor(majorVersion);
        vd.setMinor(minorVersion);
        vd.setPatch(patchVersion);
        return vd;
    }

    public String getDiscoveryURL() throws DME2Exception {
        if (this.discoveryURL == null) {
            this.discoveryURL = "aftdsc:///?service=SOACloudEndpointRegistryGRMLWPService&version=1.0&bindingType=http&envContext={ENV}";
            this.discoveryURL = this.discoveryURL.replace("{ENV}", this.getEnvLetter());
        }
        return this.discoveryURL;
    }

    public String getEnvLetter() {
        String aftEnv;
        if (envLetter != null) {
            return envLetter;
        }
        String platStr = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_SCLD_PLATFORM_KEY"));
        if (platStr == null) {
            platStr = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_PLATFORM_KEY"));
        }
        if ((aftEnv = this.config.getProperty("AFT_ENVIRONMENT")) != null && platStr == null) {
            envLetter = aftEnv.equalsIgnoreCase("AFTUAT") ? "T" : (aftEnv.equalsIgnoreCase("AFTPRD") ? "P" : null);
        }
        if (aftEnv == null && platStr == null) {
            envLetter = null;
        }
        if (platStr != null) {
            envLetter = platStr.equalsIgnoreCase("SANDBOX-DEV") ? "D" : (platStr.equalsIgnoreCase("SANDBOX-LAB") ? "L" : (platStr.equalsIgnoreCase("NON-PROD") ? "T" : (platStr.equalsIgnoreCase("PROD") ? "P" : null)));
        }
        return envLetter;
    }

    public List<String> getGRMEndpoints(List<GRMEndpoint> endPoints) {
        ArrayList<String> activeOfferList = new ArrayList<String>();
        ArrayList<String> staleOfferList = new ArrayList<String>();
        OfferCache offerCache = OfferCache.getInstance();
        for (GRMEndpoint endPoint : endPoints) {
            String endpoint = endPoint.getAddress();
            if (!offerCache.isStale(endpoint)) {
                activeOfferList.add(endpoint);
                continue;
            }
            staleOfferList.add(endpoint);
        }
        if (!staleOfferList.isEmpty()) {
            logger.debug(null, "getGRMEndpoints", "Adding stale GRM offers to the end of the active offer list. Stale Offers=" + staleOfferList.toString());
            activeOfferList.addAll(activeOfferList.size(), staleOfferList);
        }
        logger.debug(null, "getGRMEndpoints", "////// Resolved the following GRM Endpoints from Discovery: " + activeOfferList.toString());
        return activeOfferList;
    }

    public String[] getGRMFaultInfo(String faultMessage) {
        int delim;
        String[] faultInfo = null;
        if (faultMessage.contains("GRMSVC") && (delim = faultMessage.indexOf("]")) > 0) {
            String grmCode = faultMessage.substring(0, delim + 1).trim();
            grmCode = grmCode.replace("[", "").replace("]", "");
            String grmMessage = faultMessage.substring(delim + 3).trim();
            faultInfo = new String[]{grmCode, grmMessage};
            return faultInfo;
        }
        return null;
    }

    private DME2Exception processException(Throwable e, String method, String data) {
        String logcode = null;
        String code = null;
        if (e instanceof JAXBException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".JAXB;Error=";
            code = "AFT-DME2-0903";
        } else if (e instanceof SOAPException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".SOAP;Error=";
            code = "AFT-DME2-0904";
        } else if (e instanceof ParserConfigurationException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".ParseConfig;Error=";
            code = "AFT-DME2-0905";
        } else if (e instanceof SAXException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".Parse;Error=";
            code = "AFT-DME2-0906";
        } else if (e instanceof IOException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".IO;Error=";
            code = "AFT-DME2-0907";
        } else if (e instanceof DOMException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".DOM;Error=";
            code = "AFT-DME2-0908";
        } else if (e instanceof TransformerFactoryConfigurationError) {
            logcode = "Code=Exception.GRMAccessor." + method + ".TRANSFORM;Error=";
            code = "AFT-DME2-0909";
        } else if (e instanceof TransformerException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".TRANSFORM;Error=";
            code = "AFT-DME2-0910";
        } else {
            if (e instanceof DME2Exception) {
                return (DME2Exception)e;
            }
            logcode = "Code=Exception.GRMAccessor." + method + ".UNKNOWN;Error=";
            code = "AFT-DME2-0911";
        }
        logger.error((String)null, (URI)null, method, LogMessage.GRM_RETHROW, (Object)code, (Object)e);
        return new DME2Exception(code, new ErrorContext().add("extendedData", data).add("exceptionMessage", e.getMessage()));
    }

    @Override
    public List<ServiceEndpoint> findRunningServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        FindRunningServiceEndPointRequest req = new FindRunningServiceEndPointRequest();
        req.setEnv(input.getEnv());
        req.setServiceEndPoint(sep);
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "findRunningServiceEndPoint", "FindRunningServiceEndPoint {}", (Object)jsonRequest);
            String reply = this.invokeGRMService(FindRunningServiceEndPointRequest.class.getSimpleName(), jsonRequest);
            logger.debug((URI)null, "findRunningServiceEndPoint", "FindRunningServiceEndPoint Response {}", (Object)reply);
            if (reply != null) {
                FindRunningServiceEndPointResponse resp = new FindRunningServiceEndPointResponse();
                Gson gsonForFindRunning = new GsonBuilder().registerTypeAdapter((Type)((Object)XMLGregorianCalendar.class), new DME2CustomXGCalConverter.Serializer()).registerTypeAdapter((Type)((Object)XMLGregorianCalendar.class), new DME2CustomXGCalConverter.Deserializer()).create();
                resp = gsonForFindRunning.fromJson(reply.replace("ServiceEndPointList", "serviceEndPointList"), FindRunningServiceEndPointResponse.class);
                return this.convertToServiceEndpointList(resp.getServiceEndPointList());
            }
            return null;
        }
        catch (Throwable e) {
            throw this.processException(e, "findRunningServiceEndPoint", input.getEnv() + "/" + input.getName() + ":" + input.getDmeVersion());
        }
    }

    private List<ServiceEndpoint> convertToServiceEndpointList(List<ServiceEndPoint> serviceEndPointList) {
        ArrayList<ServiceEndpoint> serviceEndPoints = new ArrayList<ServiceEndpoint>();
        for (ServiceEndPoint sep : serviceEndPointList) {
            serviceEndPoints.add(this.buildServiceEndpoint(sep));
        }
        return serviceEndPoints;
    }

    @Override
    public String getRouteInfo(ServiceEndpoint input) throws DME2Exception {
        ServiceVersionDefinition svd = new ServiceVersionDefinition();
        svd.setName(input.getName());
        svd.setVersion(this.buildVersionDefinition(input.getVersion()));
        GetRouteInfoRequest req = new GetRouteInfoRequest();
        req.setEnv(input.getEnv());
        req.setServiceVersionDefinition(svd);
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "getRouteInfo", "GetRouteInfo {}", (Object)jsonRequest);
            String reply = this.invokeGRMService(GetRouteInfoRequest.class.getSimpleName(), jsonRequest);
            if (reply != null) {
                GetRouteInfoResponse resp = this.mapper.readValue(reply, GetRouteInfoResponse.class);
                return resp.getRouteInfoXml();
            }
            return null;
        }
        catch (Throwable e) {
            throw this.processException(e, "getRouteInfo", input.getEnv() + "/" + input.getName());
        }
    }

    @Override
    public void registerClientJVMInstance(RegisterClientJVMInstanceRequest req) throws DME2Exception {
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "registerClientJVMInstance", "RegisterClientJVMInstance {}", (Object)jsonRequest);
            this.invokeGRMService(RegisterClientJVMInstanceRequest.class.getSimpleName(), jsonRequest);
        }
        catch (Throwable e) {
            throw this.processException(e, "registerClientJVMInstance", req.getEnv() + "/" + req.toString());
        }
    }

    @Override
    public List<ClientJVMInstance> findClientJVMInstance(FindClientJVMInstanceRequest req) throws DME2Exception {
        try {
            Gson gson = new Gson();
            String jsonRequest = gson.toJson(req);
            logger.debug((URI)null, "findClientJVMInstance", "FindClientJVMInstance {}", (Object)jsonRequest);
            String reply = this.invokeGRMService(FindClientJVMInstanceRequest.class.getSimpleName(), jsonRequest);
            if (reply != null) {
                FindClientJVMInstanceResponse resp = this.mapper.readValue(reply, FindClientJVMInstanceResponse.class);
                return resp.getClientJVMInstanceList();
            }
            return null;
        }
        catch (Throwable e) {
            throw this.processException(e, "findClientJVMInstance", req.getEnv() + "/" + req.toString());
        }
    }

    private ServiceEndpoint buildServiceEndpoint(ServiceEndPoint input) {
        ServiceEndpoint sep = new ServiceEndpoint();
        sep.setContextPath(input.getContextPath());
        sep.setName(input.getName());
        sep.setVersion(input.getVersion().getMajor() + "." + input.getVersion().getMinor() + "." + input.getVersion().getPatch());
        sep.setPort(input.getListenPort());
        sep.setProtocol(input.getProtocol());
        sep.setLatitude(input.getLatitude());
        sep.setLongitude(input.getLongitude());
        sep.setHostAddress(input.getHostAddress());
        sep.setContextPath(input.getContextPath());
        sep.setRouteOffer(input.getRouteOffer());
        sep.setAdditionalProperties(DME2URIUtils.convertNameValuePairToProperties(input.getProperties()));
        sep.setDmeVersion(input.getDME2Version());
        sep.setClientSupportedVersions(input.getClientSupportedVersions());
        sep.setDmeJDBCDatabaseName(input.getDME2JDBCDatabaseName());
        sep.setDmeJDBCHealthCheckUser(input.getDME2JDBCHealthCheckUser());
        sep.setDmeJDBCHealthCheckPassword(input.getDME2JDBCHealthCheckPassword());
        sep.setExpirationTime(input.getExpirationTime());
        sep.setRegistrationTime(input.getRegistrationTime());
        return sep;
    }

    @Override
    public IGRMEndPointDiscovery getGrmEndPointDiscovery() {
        return this.grmEndPointDiscovery;
    }

    static {
        attemptedOffers = null;
    }

    private static enum AllowAllHostnameVerifier implements HostnameVerifier
    {
        INSTANCE;


        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

