/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.util.SecurityContext;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMInstance;
import com.att.aft.dme2.internal.grm.types.v1.ContainerInstance;
import com.att.aft.dme2.internal.grm.types.v1.LRM;
import com.att.aft.dme2.internal.grm.types.v1.ServiceEndPoint;
import com.att.aft.dme2.internal.grm.types.v1.ServiceVersionDefinition;
import com.att.aft.dme2.internal.grm.types.v1.VersionDefinition;
import com.att.aft.dme2.internal.grm.v1.AddServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.AddServiceEndPointResponse;
import com.att.aft.dme2.internal.grm.v1.DeleteServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.DeleteServiceEndPointResponse;
import com.att.aft.dme2.internal.grm.v1.FindClientJVMInstanceRequest;
import com.att.aft.dme2.internal.grm.v1.FindClientJVMInstanceResponse;
import com.att.aft.dme2.internal.grm.v1.FindRunningServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.FindRunningServiceEndPointResponse;
import com.att.aft.dme2.internal.grm.v1.FindServiceEndPointBySVDRequest;
import com.att.aft.dme2.internal.grm.v1.FindServiceEndPointBySVDResponse;
import com.att.aft.dme2.internal.grm.v1.FindServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.FindServiceEndPointResponse;
import com.att.aft.dme2.internal.grm.v1.GetRouteInfoRequest;
import com.att.aft.dme2.internal.grm.v1.GetRouteInfoResponse;
import com.att.aft.dme2.internal.grm.v1.RegisterClientJVMInstanceRequest;
import com.att.aft.dme2.internal.grm.v1.RegisterClientJVMInstanceResponse;
import com.att.aft.dme2.internal.grm.v1.UpdateServiceEndPointRequest;
import com.att.aft.dme2.internal.grm.v1.UpdateServiceEndPointResponse;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.registry.accessor.AbstractGRMAccessor;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.registry.bootstrap.RegistryBootstrap;
import com.att.aft.dme2.registry.bootstrap.RegistryBootstrapFactory;
import com.att.aft.dme2.registry.dto.GRMEndpoint;
import com.att.aft.dme2.registry.dto.ServiceEndpoint;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2URIUtils;
import com.att.aft.dme2.util.DME2ValidationUtil;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.OfferCache;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SoapGRMAccessor
extends AbstractGRMAccessor
implements BaseAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SoapGRMAccessor.class.getName());
    private static JAXBContext context;
    private static List<String> attemptedOffers;
    private static final String MS = " ms";

    private static synchronized JAXBContext initContext(DME2Configuration config) {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{GetRouteInfoRequest.class, GetRouteInfoResponse.class, FindServiceEndPointBySVDRequest.class, FindServiceEndPointBySVDResponse.class, FindRunningServiceEndPointRequest.class, FindRunningServiceEndPointResponse.class, FindServiceEndPointRequest.class, FindServiceEndPointResponse.class, AddServiceEndPointRequest.class, AddServiceEndPointResponse.class, DeleteServiceEndPointRequest.class, DeleteServiceEndPointResponse.class, UpdateServiceEndPointRequest.class, UpdateServiceEndPointResponse.class, RegisterClientJVMInstanceRequest.class, RegisterClientJVMInstanceResponse.class, ClientJVMInstance.class, FindClientJVMInstanceRequest.class, FindClientJVMInstanceResponse.class});
            return context;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected SoapGRMAccessor(DME2Configuration config, SecurityContext ctx, IGRMEndPointDiscovery grmEndPointDiscovery) {
        super(config, ctx, grmEndPointDiscovery);
        context = SoapGRMAccessor.initContext(config);
    }

    @Override
    public void registerClientJVMInstance(RegisterClientJVMInstanceRequest req) throws DME2Exception {
        try {
            String request = this.getSOAPRequest(req);
            this.invokeGRMService(request);
        }
        catch (Throwable e) {
            throw this.processException(e, "registerClientJVMInstance", req.getEnv() + "/" + req.getClientJvmInstance().toString());
        }
    }

    @Override
    public List<ClientJVMInstance> findClientJVMInstance(FindClientJVMInstanceRequest req) throws DME2Exception {
        long start = System.currentTimeMillis();
        String reply = null;
        try {
            String request = this.getSOAPRequest(req);
            reply = this.invokeGRMService(request);
            if (reply != null) {
                String temp = this.getResponse(reply);
                ByteArrayInputStream input = new ByteArrayInputStream(temp.getBytes("UTF-8"));
                Unmarshaller unmarshaller = context.createUnmarshaller();
                FindClientJVMInstanceResponse element = (FindClientJVMInstanceResponse)FindClientJVMInstanceResponse.class.cast(unmarshaller.unmarshal((InputStream)input));
                logger.debug((URI)null, "findClientJVMInstance", "findClientJVMInstance GRMResponseParsingElapsed={} {}", (Object)(System.currentTimeMillis() - start), (Object)MS);
                return element.getClientJVMInstanceList();
            }
        }
        catch (Throwable e) {
            throw this.processException(e, "findClientJVMInstance", req.getEnv() + "/" + req.toString());
        }
        return null;
    }

    @Override
    public void addServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        LRM lrm = this.buildLRM(input);
        ContainerInstance ci = this.buildContainerInstance(input);
        AddServiceEndPointRequest req = new AddServiceEndPointRequest();
        req.setEnv(input.getEnv());
        req.setLrmRef(lrm);
        req.setServiceEndPoint(sep);
        req.setCheckNcreateParents(true);
        if (ci.getName() != null && !ci.getName().startsWith("dummy")) {
            req.setContainerInstanceRef(ci);
        }
        try {
            String request = this.getSOAPRequest(req);
            logger.debug((URI)null, "addServiceEndPoint", "AddServiceEndpoint {} ", (Object)request);
            String reply = this.invokeGRMService(request);
            logger.debug((URI)null, "addServiceEndPoint", "AddServiceEdnpoint Response {}", (Object)reply);
        }
        catch (Throwable e) {
            logger.debug((URI)null, "addServiceEndPoint", "Error in invoking GRM addServiceEndpoint", (Object)e);
            throw this.processException(e, "addServiceEndPoint", req.getEnv() + "/" + req.getServiceEndPoint().getName() + ":" + req.getServiceEndPoint().getVersion());
        }
    }

    @Override
    public void updateServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        LRM lrm = this.buildLRM(input);
        UpdateServiceEndPointRequest req = new UpdateServiceEndPointRequest();
        req.setUpdateLease(true);
        req.setEnv(input.getEnv());
        req.setLrmRef(lrm);
        ContainerInstance ci = this.buildContainerInstance(input);
        if (ci.getName() != null && !ci.getName().startsWith("dummy")) {
            req.setContainerInstanceRef(ci);
        }
        req.setServiceEndPoint(sep);
        try {
            String request = this.getSOAPRequest(req);
            logger.debug(null, "updateServiceEndPoint", "UpdateServiceEndpoint " + request);
            this.invokeGRMService(request);
        }
        catch (Throwable e) {
            throw this.processException(e, "UpdateServiceEndPoint", req.getEnv() + "/" + req.getServiceEndPoint().getName() + ":" + req.getServiceEndPoint().getVersion());
        }
    }

    @Override
    public void deleteServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        DeleteServiceEndPointRequest req = new DeleteServiceEndPointRequest();
        req.setEnv(input.getEnv());
        req.getServiceEndPoint().add(sep);
        try {
            String request = this.getSOAPRequest(req);
            String string = this.invokeGRMService(request);
        }
        catch (Throwable e) {
            throw this.processException(e, "DeleteServiceEndPoint", req.getEnv() + "/" + req.getServiceEndPoint().toString());
        }
    }

    @Override
    public List<ServiceEndpoint> findRunningServiceEndPoint(ServiceEndpoint input) throws DME2Exception {
        ServiceEndPoint sep = this.buildGRMServiceEndpoint(input);
        FindRunningServiceEndPointRequest req = new FindRunningServiceEndPointRequest();
        req.setEnv(input.getEnv());
        req.setServiceEndPoint(sep);
        try {
            String request = this.getSOAPRequest(req);
            String reply = this.invokeGRMService(request);
            if (reply != null) {
                String temp = this.getResponse(reply);
                ByteArrayInputStream ipStream = new ByteArrayInputStream(temp.getBytes("UTF-8"));
                Unmarshaller unmarshaller = context.createUnmarshaller();
                FindRunningServiceEndPointResponse element = (FindRunningServiceEndPointResponse)FindRunningServiceEndPointResponse.class.cast(unmarshaller.unmarshal((InputStream)ipStream));
                return this.convertToServiceEndpointList(element.getServiceEndPointList());
            }
            return null;
        }
        catch (Throwable e) {
            throw this.processException(e, "findRunningServiceEndPoint", input.getEnv() + "/" + input.getName() + ":" + input.getDmeVersion());
        }
    }

    private List<ServiceEndpoint> convertToServiceEndpointList(List<ServiceEndPoint> serviceEndPointList) {
        ArrayList<ServiceEndpoint> serviceEndPoints = new ArrayList<ServiceEndpoint>();
        for (ServiceEndPoint sep : serviceEndPointList) {
            serviceEndPoints.add(this.buildServiceEndpoint(sep));
        }
        return serviceEndPoints;
    }

    @Override
    public String getRouteInfo(ServiceEndpoint input) throws DME2Exception {
        ServiceVersionDefinition svd = new ServiceVersionDefinition();
        svd.setName(input.getName());
        svd.setVersion(this.buildVersionDefinition(input.getVersion()));
        GetRouteInfoRequest req = new GetRouteInfoRequest();
        req.setEnv(input.getEnv());
        req.setServiceVersionDefinition(svd);
        try {
            long start = System.currentTimeMillis();
            String request = this.getSOAPRequest(req);
            logger.debug(null, "getRouteInfo", "getRouteInfo getSOAPRequestJAXB=" + (System.currentTimeMillis() - start) + MS);
            start = System.currentTimeMillis();
            String reply = this.invokeGRMService(request);
            logger.debug(null, "getRouteInfo", "getRouteInfo getGRMResponseElapsed=" + (System.currentTimeMillis() - start) + MS);
            start = System.currentTimeMillis();
            if (reply != null) {
                String temp = this.getResponse(reply);
                ByteArrayInputStream ipStream = new ByteArrayInputStream(temp.getBytes("UTF-8"));
                Unmarshaller unmarshaller = context.createUnmarshaller();
                GetRouteInfoResponse element = (GetRouteInfoResponse)GetRouteInfoResponse.class.cast(unmarshaller.unmarshal((InputStream)ipStream));
                logger.debug(null, "getRouteInfo", "getRouteInfo GRMResponseParsingElapsed=" + (System.currentTimeMillis() - start) + MS);
                return element.getRouteInfoXml();
            }
            return null;
        }
        catch (Throwable e) {
            throw this.processException(e, "getRouteInfo", input.getEnv() + "/" + input.getName());
        }
    }

    private String getResponse(String xml) throws SOAPException, DOMException, DME2Exception, TransformerFactoryConfigurationError, TransformerException {
        String replyString = null;
        logger.debug(null, "getResponse", "Response XML from GRM | " + xml);
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage rspMessage = factory.createMessage();
        StreamSource preppedMsgSrc = new StreamSource(new ByteArrayInputStream(xml.getBytes()));
        rspMessage.getSOAPPart().setContent((Source)preppedMsgSrc);
        rspMessage.saveChanges();
        if (rspMessage.getSOAPBody().hasFault()) {
            SOAPFault fault = rspMessage.getSOAPBody().getFault();
            logger.debug(null, "getResponse", "GRMAccessor getResponse hasFault;" + fault.getTextContent());
            String errorCode = null;
            String errorMessage = null;
            if (fault.getFaultString() != null) {
                int i = fault.getFaultString().indexOf(",");
                if (i > -1) {
                    errorCode = fault.getFaultString().substring(0, i).trim();
                    errorMessage = fault.getFaultString().substring(i + 1).trim();
                    if (errorCode != null && errorCode.equals("GRMSVC-2004")) {
                        SOAPBody soapBody = rspMessage.getSOAPBody();
                        Node node = soapBody.getFirstChild();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(new DOMSource(node), new StreamResult(bos));
                        replyString = new String(bos.toByteArray());
                        return replyString;
                    }
                } else {
                    errorCode = "AFT-DME2-0612";
                    errorMessage = fault.getFaultString();
                }
            } else {
                errorCode = "AFT-DME2-0612";
                errorMessage = "An unknown fault was returned from the GRM Service call: " + fault.getFaultCode();
            }
            throw new DME2Exception(errorCode, new ErrorContext().add("errorMessage", errorMessage));
        }
        SOAPBody soapBody = rspMessage.getSOAPBody();
        Node node = soapBody.getFirstChild();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(node), new StreamResult(bos));
        replyString = new String(bos.toByteArray());
        return replyString;
    }

    private String getSOAPRequest(Object req) throws JAXBException, SOAPException, ParserConfigurationException, SAXException, IOException {
        long start = System.currentTimeMillis();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.fragment", (Object)true);
        StringWriter sw = new StringWriter();
        marshaller.marshal(req, (Writer)sw);
        logger.debug(null, "getSOAPRequest", "getSOAPRequest getSOAPRequest Marshal=" + (System.currentTimeMillis() - start) + MS);
        SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPHeader header = null;
        if (this.config.getBoolean(DME2Constants.DME2_GRM_AUTH)) {
            logger.debug(null, "getSOAPRequest", "getSOAPRequest Adding WSSecurity header");
            soapEnvelope.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            header = soapEnvelope.getHeader() == null ? soapEnvelope.addHeader() : soapEnvelope.getHeader();
            String namespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            SOAPHeaderElement securityElement = header.addHeaderElement(soapEnvelope.createName("Security", "wsse", namespace));
            securityElement.addNamespaceDeclaration("", namespace);
            SOAPElement usernameTokenElement = securityElement.addChildElement(soapEnvelope.createName("UsernameToken", "wsse", namespace));
            usernameTokenElement.addNamespaceDeclaration("", namespace);
            SOAPElement usernameElement = usernameTokenElement.addChildElement("Username", "wsse");
            SOAPElement passwordElement = usernameTokenElement.addChildElement("Password", "wsse");
            usernameElement.setValue(this.config.getProperty("DME2_GRM_USER"));
            passwordElement.setValue(this.config.getProperty("DME2_GRM_PASS"));
            soapMessage.saveChanges();
        }
        SOAPBody soapBody = soapEnvelope.getBody();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        soapBody.addDocument(docBuilder.parse(new ByteArrayInputStream(sw.getBuffer().toString().getBytes())));
        soapMessage.saveChanges();
        ByteArrayOutputStream soapMsgWriter = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)soapMsgWriter);
        logger.debug(null, "getSOAPRequest", "getSOAPRequest getSOAPRequest SOAPMessageBuild=" + (System.currentTimeMillis() - start) + MS);
        return new String(soapMsgWriter.toByteArray());
    }

    public List<String> getGRMEndpoints(List<GRMEndpoint> endPoints) {
        ArrayList<String> activeOfferList = new ArrayList<String>();
        ArrayList<String> staleOfferList = new ArrayList<String>();
        OfferCache offerCache = OfferCache.getInstance();
        for (GRMEndpoint endPoint : endPoints) {
            String endpoint = endPoint.getAddress();
            if (!offerCache.isStale(endpoint)) {
                activeOfferList.add(endpoint);
                continue;
            }
            staleOfferList.add(endpoint);
        }
        if (!staleOfferList.isEmpty()) {
            logger.debug(null, "getGRMEndpoints", "Adding stale GRM offers to the end of the active offer list. Stale Offers=" + staleOfferList.toString());
            activeOfferList.addAll(activeOfferList.size(), staleOfferList);
        }
        logger.debug(null, "getGRMEndpoints", "////// Resolved the following GRM Endpoints from Discovery: " + activeOfferList.toString());
        return activeOfferList;
    }

    public String getDiscoveryURL() throws DME2Exception {
        if (this.discoveryURL == null) {
            this.discoveryURL = "aftdsc:///?service=SOACloudEndpointRegistryGRMLWPService&version=1.0&bindingType=http&envContext={ENV}";
            this.discoveryURL = this.discoveryURL.replace("{ENV}", this.getEnvLetter());
            logger.warn((URI)null, "getDiscoveryURL", "DISCOVERY URL: {}", (Object)this.discoveryURL);
        }
        return this.discoveryURL;
    }

    public String getEnvLetter() {
        String aftEnv;
        if (envLetter != null) {
            return envLetter;
        }
        String platStr = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_SCLD_PLATFORM_KEY"));
        if (platStr == null) {
            platStr = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_PLATFORM_KEY"));
        }
        if ((aftEnv = this.config.getProperty("AFT_ENVIRONMENT")) != null && platStr == null) {
            envLetter = aftEnv.equalsIgnoreCase("AFTUAT") ? "T" : (aftEnv.equalsIgnoreCase("AFTPRD") ? "P" : null);
        }
        if (aftEnv == null && platStr == null) {
            envLetter = null;
        }
        if (platStr != null) {
            envLetter = platStr.equalsIgnoreCase("SANDBOX-DEV") ? "D" : (platStr.equalsIgnoreCase("SANDBOX-LAB") ? "L" : (platStr.equalsIgnoreCase("NON-PROD") ? "T" : (platStr.equalsIgnoreCase("PROD") ? "P" : null)));
        }
        return envLetter == null ? "" : envLetter;
    }

    private DME2Exception processException(Throwable e, String method, String data) {
        String logcode = null;
        String code = null;
        if (e instanceof JAXBException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".JAXB;Error=";
            code = "AFT-DME2-0903";
        } else if (e instanceof SOAPException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".SOAP;Error=";
            code = "AFT-DME2-0904";
        } else if (e instanceof ParserConfigurationException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".ParseConfig;Error=";
            code = "AFT-DME2-0905";
        } else if (e instanceof SAXException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".Parse;Error=";
            code = "AFT-DME2-0906";
        } else if (e instanceof IOException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".IO;Error=";
            code = "AFT-DME2-0907";
        } else if (e instanceof DOMException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".DOM;Error=";
            code = "AFT-DME2-0908";
        } else if (e instanceof TransformerFactoryConfigurationError) {
            logcode = "Code=Exception.GRMAccessor." + method + ".TRANSFORM;Error=";
            code = "AFT-DME2-0909";
        } else if (e instanceof TransformerException) {
            logcode = "Code=Exception.GRMAccessor." + method + ".TRANSFORM;Error=";
            code = "AFT-DME2-0910";
        } else {
            if (e instanceof DME2Exception) {
                return (DME2Exception)e;
            }
            logcode = "Code=Exception.GRMAccessor." + method + ".UNKNOWN;Error=";
            code = "AFT-DME2-0911";
        }
        logger.error((URI)null, method, LogMessage.GRM_RETHROW, (Object)code, (Object)e);
        ErrorContext errCtx = new ErrorContext();
        errCtx.add("extendedData", data);
        errCtx.add("exceptionMessage", e.getMessage());
        return new DME2Exception(code, errCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeGRMService(String request) throws DME2Exception {
        boolean logAttemptedOffers;
        long start = System.currentTimeMillis();
        ArrayList<String> offerList = new ArrayList<String>();
        OfferCache offerCache = OfferCache.getInstance();
        String response = null;
        List<String> endpointsToAttempt = this.grmEndPointDiscovery.getGRMEndpoints();
        boolean bl = logAttemptedOffers = System.getProperty("AFT_DME2_DEBUG_GRM_EPS") != null && !request.contains("Metrics") && !request.contains("delete");
        if (logAttemptedOffers) {
            attemptedOffers = new ArrayList<String>();
        }
        String grmCode = null;
        String grmMessage = null;
        String faultMessage = null;
        long startTime = System.currentTimeMillis();
        int iterationCount = 0;
        String skipStaleOffers = this.config.getProperty("DME2_RETRY_STALE_GRM_OFFERS");
        Iterator<String> iter = endpointsToAttempt.iterator();
        while (iter.hasNext()) {
            String faultResponse;
            if (System.currentTimeMillis() - startTime >= (long)overallTimeout) break;
            String currentGRMEndpoint = iter.next().trim();
            logger.debug((URI)null, "invokeGRMService", "Preparing to invoke GRM with URL: {}. -- Attempt number: [{}]", (Object)currentGRMEndpoint, (Object)iterationCount);
            if (logAttemptedOffers) {
                attemptedOffers.add(currentGRMEndpoint);
            }
            if (skipStaleOffers.equalsIgnoreCase("true") && offerCache.isStale(currentGRMEndpoint)) continue;
            HttpURLConnection conn = null;
            URL url = null;
            InputStream istream = null;
            try {
                logger.debug(null, "invokeGRMService", "GRMService connectTimeout \t" + connectTimeout + "\t ;GRMService readTimeout \t" + readTimeout);
                logger.debug((URI)null, "invokeGRMService", "GRM url {}", (Object)currentGRMEndpoint);
                url = new URL(currentGRMEndpoint);
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                if (this.secCtx.isSSL() || url.getProtocol().equalsIgnoreCase("https")) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(AllowAllHostnameVerifier.INSTANCE);
                }
                this.sendRequest(conn, request);
                istream = conn.getInputStream();
                int respCode = conn.getResponseCode();
                if (respCode != 200) {
                    faultResponse = this.parseResponse(istream);
                    logger.debug((URI)null, "invokeGRMService", "FaultResponse from GRMService \t{}", (Object)faultResponse);
                    throw new Exception(" GRM Service Call Failed; StatusCode=" + respCode + "; GRMFaultResponse=" + faultResponse);
                }
                logger.debug(null, "invokeGRMService", "ElapsedTime from GRMService \t" + (System.currentTimeMillis() - start) + " GRM Endpoint Used=" + currentGRMEndpoint);
                response = this.parseResponse(istream);
                logger.debug((URI)null, "invokeGRMService", "Response: {}", (Object)response);
                faultResponse = response;
                return faultResponse;
            }
            catch (SocketTimeoutException e) {
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.debug((URI)null, "invokeGRMService", "SocketTimeoutException from GRMService for offer {}", (Object)currentGRMEndpoint, (Object)e);
                    logger.error((URI)null, "invokeGRMService", "AFT-DME2-0914 {}", (Object)new ErrorContext().add("GRM URL", currentGRMEndpoint), (Object)e);
                }
                iter.remove();
                offerCache.setStale(currentGRMEndpoint);
                offerList.add(currentGRMEndpoint);
            }
            catch (ConnectException e) {
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.debug((URI)null, "invokeGRMService", "ConnectException from GRMService for offer {}", (Object)currentGRMEndpoint, (Object)e);
                    logger.warn((URI)null, "invokeGRMService", "AFT-DME2-0913 {}", (Object)new ErrorContext().add("GRM URL", currentGRMEndpoint), (Object)e);
                }
                iter.remove();
                offerCache.setStale(currentGRMEndpoint);
                offerList.add(currentGRMEndpoint);
            }
            catch (Throwable e) {
                logger.debug((URI)null, "invokeGRMService", "Error in invoking GRM", (Object)e);
                faultResponse = null;
                if (conn != null) {
                    int faultstringIndex;
                    InputStream err = conn.getErrorStream();
                    try {
                        faultResponse = this.parseResponse(err);
                    }
                    catch (Exception ex) {
                        logger.debug((URI)null, "invokeGRMService", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)ex);
                    }
                    if (faultResponse != null && (faultstringIndex = faultResponse.indexOf("<faultstring>")) > -1) {
                        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
                        StringReader stringReader = new StringReader(faultResponse);
                        XMLStreamReader reader = null;
                        try {
                            reader = inputFactory.createXMLStreamReader(stringReader);
                            String element = null;
                            while (reader.hasNext()) {
                                try {
                                    reader.nextTag();
                                }
                                catch (Exception xe) {
                                    if (element != null && element.equals("code")) {
                                        grmCode = reader.getText();
                                    } else if (element != null && element.equals("message")) {
                                        grmMessage = reader.getText();
                                    } else if (element != null && element.equals("faultmessage")) {
                                        faultMessage = reader.getText();
                                    }
                                    element = null;
                                    continue;
                                }
                                if (reader.isStartElement()) {
                                    if (reader.getNamespaceURI() != null && reader.getNamespaceURI().equals("http://scld.att.com/grm/v1")) {
                                        if (reader.getLocalName() != null && reader.getLocalName().equals("code")) {
                                            element = "code";
                                            continue;
                                        }
                                        if (reader.getLocalName() == null || !reader.getLocalName().equals("message")) continue;
                                        element = "message";
                                        continue;
                                    }
                                    if (reader.getNamespaceURI() != null && reader.getNamespaceURI().startsWith("http://schemas.xmlsoap.org/soap/envelope")) {
                                        if (reader.getLocalName() == null || !reader.getLocalName().equals("faultstring")) continue;
                                        element = "faultmessage";
                                        continue;
                                    }
                                    if (reader.getLocalName() == null || !reader.getLocalName().equals("faultstring")) continue;
                                    element = "faultmessage";
                                    continue;
                                }
                                if (element == null || !reader.isCharacters()) continue;
                                if (element.equals("code")) {
                                    grmCode = reader.getText();
                                } else if (element.equals("message")) {
                                    grmMessage = reader.getText();
                                } else if (element.equals("faultmessage")) {
                                    faultMessage = reader.getText();
                                }
                                element = null;
                            }
                        }
                        catch (Exception x) {
                            logger.debug((URI)null, "invokeGRMService", LogMessage.GRM_IGNORABLE, (Object)x);
                        }
                    }
                }
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.debug((URI)null, "invokeGRMService", "Throwable from GRMService for offer " + currentGRMEndpoint + "; GRMFaultResponse=" + faultResponse, (Object)e);
                    logger.warn((URI)null, "invokeGRMService", "AFT-DME2-0915", (Object)new ErrorContext().add("GRM URL", currentGRMEndpoint), (Object)e);
                }
                iter.remove();
                offerCache.setStale(currentGRMEndpoint);
                offerList.add(currentGRMEndpoint);
            }
            finally {
                if (istream == null) continue;
                try {
                    istream.close();
                }
                catch (IOException e) {
                    logger.debug((URI)null, "invokeGRMService", "Non-fatal IOException closing output stream to GRM", (Object)e);
                }
            }
        }
        offerCache.removeStaleness(offerList);
        if (grmCode != null && grmMessage != null) {
            throw new DME2Exception(grmCode, grmMessage, new Object[0]);
        }
        if (faultMessage != null) {
            String[] faultInfo;
            if (faultMessage.contains("GRMSVC") && (faultInfo = this.getGRMFaultInfo(faultMessage)) != null) {
                throw new DME2Exception(faultInfo[0], faultInfo[1], new Object[0]);
            }
            throw new DME2Exception("AFT-DME2-0916", new ErrorContext().add("GRM URLs", endpointsToAttempt.toString()).add("faultMessage", faultMessage));
        }
        throw new DME2Exception("AFT-DME2-0902", new ErrorContext().add("GRM URLs", endpointsToAttempt.toString()));
    }

    public String[] getGRMFaultInfo(String faultMessage) {
        int delim;
        String[] faultInfo = null;
        if (faultMessage.contains("GRMSVC") && (delim = faultMessage.indexOf("]")) > 0) {
            String grmCode = faultMessage.substring(0, delim + 1).trim();
            grmCode = grmCode.replace("[", "").replace("]", "");
            String grmMessage = faultMessage.substring(delim + 3).trim();
            faultInfo = new String[]{grmCode, grmMessage};
            return faultInfo;
        }
        return null;
    }

    private String parseResponse(InputStream istream) throws IOException {
        byte[] buffer = new byte[1024];
        int iter_length = 0;
        int total_length = 0;
        StringBuffer strBuffer = new StringBuffer();
        while (iter_length != -1) {
            iter_length = istream.read(buffer, 0, 1024);
            if (iter_length < 0) continue;
            String tmpStr = new String(buffer, 0, iter_length);
            total_length += iter_length;
            strBuffer.append(tmpStr);
        }
        return strBuffer.toString();
    }

    protected void sendRequest(HttpURLConnection conn, String request) throws Exception {
        logger.debug(null, "sendRequest", "Request XML to GRM | " + request);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream out = conn.getOutputStream();
        out.write(request.getBytes());
        out.flush();
        out.close();
    }

    public List<GRMEndpoint> getGRMEndpoints(String discoveryURL, String directURL) throws DME2Exception {
        String url = null;
        if (this.config.getProperty("AFT_DME2_FORCE_GRM_LOOKUP") != null) {
            this.grmURLs = null;
        }
        if (directURL != null) {
            url = directURL;
            logger.warn((URI)null, "getGRMEndpointIterator", "AFT-DME2-0912", (Object)new ErrorContext().add("overrideGRMUrls", url));
        } else {
            url = discoveryURL;
        }
        if (url != null) {
            this.grmURLs = url.split(",");
        }
        RegistryBootstrap fetcher = RegistryBootstrapFactory.getRegistryBootstrapHandler(this.config);
        return fetcher.getGRMEndpoints(this.grmURLs);
    }

    private ServiceEndpoint buildServiceEndpoint(ServiceEndPoint input) {
        ServiceEndpoint sep = new ServiceEndpoint();
        sep.setContextPath(input.getContextPath());
        sep.setName(input.getName());
        sep.setVersion(input.getVersion().getMajor() + "." + input.getVersion().getMinor() + "." + input.getVersion().getPatch());
        sep.setPort(input.getListenPort());
        sep.setProtocol(input.getProtocol());
        sep.setLatitude(input.getLatitude());
        sep.setLongitude(input.getLongitude());
        sep.setHostAddress(input.getHostAddress());
        sep.setContextPath(input.getContextPath());
        sep.setRouteOffer(input.getRouteOffer());
        sep.setAdditionalProperties(DME2URIUtils.convertNameValuePairToProperties(input.getProperties()));
        sep.setDmeVersion(input.getDME2Version());
        sep.setClientSupportedVersions(input.getClientSupportedVersions());
        sep.setDmeJDBCDatabaseName(input.getDME2JDBCDatabaseName());
        sep.setDmeJDBCHealthCheckUser(input.getDME2JDBCHealthCheckUser());
        sep.setDmeJDBCHealthCheckPassword(input.getDME2JDBCHealthCheckPassword());
        sep.setExpirationTime(input.getExpirationTime());
        return sep;
    }

    private ServiceEndPoint buildGRMServiceEndpoint(ServiceEndpoint input) {
        ServiceEndPoint sep = new ServiceEndPoint();
        sep.setName(input.getName());
        sep.setVersion(this.buildVersionDefinition(input.getVersion()));
        sep.setListenPort(input.getPort());
        sep.setProtocol(input.getProtocol());
        sep.setLatitude(input.getLatitude());
        sep.setLongitude(input.getLongitude());
        sep.setHostAddress(input.getHostAddress());
        sep.setContextPath(input.getContextPath());
        String containerRouteOffer = input.getContainerRouteOffer();
        if (containerRouteOffer == null) {
            containerRouteOffer = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_ROUTEOFFER_KEY"));
        }
        String serviceRouteOffer = input.getRouteOffer();
        sep.setRouteOffer(containerRouteOffer != null ? containerRouteOffer : serviceRouteOffer);
        sep.getProperties().addAll(DME2URIUtils.convertPropertiestoNameValuePairs(input.getAdditionalProperties()));
        sep.setDME2Version(input.getDmeVersion());
        sep.setClientSupportedVersions(input.getClientSupportedVersions());
        sep.setDME2JDBCDatabaseName(input.getDmeJDBCDatabaseName());
        sep.setDME2JDBCHealthCheckUser(input.getDmeJDBCHealthCheckUser());
        sep.setDME2JDBCHealthCheckPassword(input.getDmeJDBCHealthCheckPassword());
        sep.setExpirationTime(input.getExpirationTime());
        return sep;
    }

    private ContainerInstance buildContainerInstance(ServiceEndpoint input) {
        String containerHost;
        ContainerInstance contInstance = new ContainerInstance();
        String containerName = input.getContainerName();
        String containerVersion = input.getContainerVersion();
        String containerRouteOffer = input.getContainerRouteOffer();
        String pid = input.getPid();
        String string = containerHost = input.getContainerHost() != null ? input.getContainerHost() : input.getHostAddress();
        if (containerName == null) {
            String string2 = containerName = this.config.getProperty("AFT_DME2_CONTAINER_NAME_KEY") != null ? this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_NAME_KEY")) : null;
        }
        if (containerVersion == null) {
            containerVersion = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_VERSION_KEY"));
        }
        if (containerRouteOffer == null) {
            containerRouteOffer = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_ROUTEOFFER_KEY"));
        }
        if (pid == null) {
            pid = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_PID_KEY"));
        }
        if (containerHost == null) {
            containerHost = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY"));
        }
        contInstance.setName(containerName);
        contInstance.setVersion(this.buildVersionDefinition(containerVersion));
        contInstance.setRouteOffer(containerRouteOffer);
        contInstance.setProcessId(pid);
        contInstance.setHostAddress(containerHost);
        return contInstance;
    }

    private LRM buildLRM(ServiceEndpoint request) {
        LRM lrm = new LRM();
        String port = request.getPort();
        if (port == null) {
            port = this.config.getProperty("lrmPort");
        }
        lrm.setHostAddress(request.getHostAddress());
        lrm.setListenPort(port);
        return lrm;
    }

    private VersionDefinition buildVersionDefinition(String version) {
        if (version == null) {
            return null;
        }
        DME2ValidationUtil.validateVersionFormat(this.config, version);
        int majorVersion = 0;
        int minorVersion = 0;
        String patchVersion = null;
        VersionDefinition vd = new VersionDefinition();
        if (version != null) {
            String[] tmpVersion = version.split("\\.");
            if (tmpVersion.length == 3) {
                majorVersion = Integer.parseInt(tmpVersion[0]);
                minorVersion = Integer.parseInt(tmpVersion[1]);
                patchVersion = tmpVersion[2];
            }
            if (tmpVersion.length == 2) {
                majorVersion = Integer.parseInt(tmpVersion[0]);
                minorVersion = Integer.parseInt(tmpVersion[1]);
                patchVersion = null;
            }
            if (tmpVersion.length == 1) {
                majorVersion = Integer.parseInt(tmpVersion[0]);
                minorVersion = -1;
                patchVersion = null;
            }
        }
        vd.setMajor(majorVersion);
        vd.setMinor(minorVersion);
        vd.setPatch(patchVersion);
        return vd;
    }

    @Override
    public IGRMEndPointDiscovery getGrmEndPointDiscovery() {
        return this.grmEndPointDiscovery;
    }

    static {
        attemptedOffers = null;
    }

    private static enum AllowAllHostnameVerifier implements HostnameVerifier
    {
        INSTANCE;


        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

