/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.request;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.DefaultRequestProcessor;
import com.att.aft.dme2.api.RequestFacade;
import com.att.aft.dme2.api.http.HttpRequestInvoker;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.LoggingContext;
import com.att.aft.dme2.request.Request;
import com.att.aft.dme2.request.RequestContext;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;

public class ContextFactory {
    private static ContextFactory instance = null;
    private DME2Configuration config = new DME2Configuration();

    public RequestContext createContext(DME2Manager mgr, Request request) throws DME2Exception {
        if (mgr != null) {
            this.config = mgr.getConfig();
        }
        this.initRequestHeaders(request);
        LoggingContext logContext = this.createLoggingContext(request);
        RequestContext context = new RequestContext();
        context.setLogContext(logContext);
        context.setMgr(mgr);
        context.setRequest(request);
        context.setUniformResource(request.getUniformResource());
        return context;
    }

    private void initRequestHeaders(Request request) {
        if (request.getClientHeaders() == null || request.getClientHeaders().get("JMSMessageID") == null) {
            request.getClientHeaders().put("JMSMessageID", "ID:" + UUID.randomUUID().toString());
            if (request.getUniformResource().getPartner() != null) {
                request.getClientHeaders().put("com.att.aft.dme2.partner", request.getUniformResource().getPartner());
                request.getClientHeaders().put("DME2_REQUEST_PARTNER", request.getUniformResource().getPartner());
            } else if (request.getPartner() != null) {
                request.getClientHeaders().put("com.att.aft.dme2.partner", request.getPartner());
                request.getClientHeaders().put("DME2_REQUEST_PARTNER", request.getPartner());
            }
        } else if (request.getUniformResource().getPartner() != null) {
            request.getClientHeaders().put("com.att.aft.dme2.partner", request.getUniformResource().getPartner());
            request.getClientHeaders().put("DME2_REQUEST_PARTNER", request.getUniformResource().getPartner());
        } else if (request.getPartner() != null) {
            request.getClientHeaders().put("com.att.aft.dme2.jms.partner", request.getPartner());
            request.getClientHeaders().put("DME2_JMS_REQUEST_PARTNER", request.getPartner());
        }
    }

    private String getIpAddr() {
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextFactory getInstance() {
        if (instance != null) return instance;
        Class<ContextFactory> clazz = ContextFactory.class;
        synchronized (ContextFactory.class) {
            instance = new ContextFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public RequestFacade createFacade(RequestContext context) {
        RequestFacade facade = null;
        if (context.getRequest() instanceof HttpRequest) {
            HttpRequestInvoker invoker = new HttpRequestInvoker(context);
            DefaultRequestProcessor defaultRequestProcessor = new DefaultRequestProcessor(invoker);
            defaultRequestProcessor.setPreferLocal(context.getUniformResource().isPreferLocalEPs());
            context.getRequest().setRequestProcessor(defaultRequestProcessor);
            facade = new RequestFacade(context, defaultRequestProcessor);
        }
        return facade;
    }

    private LoggingContext createLoggingContext(Request request) throws DME2Exception {
        LoggingContext context = null;
        try {
            context = new LoggingContext();
            String conversationId = null;
            String trackingId = null;
            boolean sendTraceInfo = false;
            if (request instanceof HttpRequest) {
                Map<String, String> headers = ((HttpRequest)request).getRequestHeaders();
                String msgId = headers.get(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSMessageID");
                if (msgId == null) {
                    msgId = headers.get("JMSMessageID");
                }
                if ((conversationId = headers.get(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSConversationID")) == null) {
                    conversationId = headers.get("JMSConversationID");
                }
                trackingId = msgId + (conversationId == null ? "" : "(" + conversationId + ")") + (request.getStickySelectorKey() == null ? "" : "(stickySelector=" + request.getStickySelectorKey() + ")");
                Map<String, String> requestHeaders = ((HttpRequest)request).getRequestHeaders();
                String reqTraceOn = requestHeaders.get("AFT_DME2_REQ_TRACE_ON");
                if (reqTraceOn != null) {
                    sendTraceInfo = true;
                }
            }
            context.setTrackingId(trackingId);
            context.setConversationId(conversationId);
            context.setSendTraceInfo(sendTraceInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }
}

