/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.request;

import com.att.aft.dme2.internal.apache.commons.collections.MapUtils;
import com.att.aft.dme2.iterator.service.IteratorEndpointOrderHandler;
import com.att.aft.dme2.iterator.service.IteratorRouteOfferOrderHandler;
import com.att.aft.dme2.request.Request;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest
extends Request {
    protected long exchangeRoundTripTimeOut;
    protected long connectTimeout;
    protected long perEndpointTimeoutMs;
    protected String httpMethod;
    boolean presentExchangeRoundTripTimeOut = false;
    private List<IteratorEndpointOrderHandler> endpointOrderHandlers = new ArrayList<IteratorEndpointOrderHandler>();
    private List<IteratorRouteOfferOrderHandler> routeOfferOrderHandlers = new ArrayList<IteratorRouteOfferOrderHandler>();

    public HttpRequest(URI uri) {
        super(uri);
    }

    public boolean isPresentExchangeRoundTripTimeOut() {
        return this.presentExchangeRoundTripTimeOut;
    }

    public long getExchangeRoundTripTimeOut() {
        return this.exchangeRoundTripTimeOut;
    }

    public Map<String, String> getRequestHeaders() {
        if (this.headers == null) {
            return new HashMap<String, String>();
        }
        return this.headers;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getPerEndpointTimeoutMs() {
        return this.perEndpointTimeoutMs;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public List<IteratorRouteOfferOrderHandler> getIteratorRouteOfferOrderHandlers() {
        return this.routeOfferOrderHandlers;
    }

    public List<IteratorEndpointOrderHandler> getEndpointOrderHandlers() {
        return this.endpointOrderHandlers;
    }

    public void setIteratorEndpointOrderHandler(IteratorEndpointOrderHandler iteratorEndpointOrderHandler) {
        this.endpointOrderHandlers.add(iteratorEndpointOrderHandler);
    }

    public void setIteratorRouteOfferOrderHandler(IteratorRouteOfferOrderHandler iteratorRouteOfferOrderHandler) {
        this.routeOfferOrderHandlers.add(iteratorRouteOfferOrderHandler);
    }

    public static final class RequestBuilder
    extends Request.RequestBuilder<HttpRequest, RequestBuilder> {
        public RequestBuilder(URI uri) {
            super(uri);
        }

        public RequestBuilder withExchangeRoundTripTimeOut(long exchangeRoundTripTimeOut) {
            ((HttpRequest)this.obj).exchangeRoundTripTimeOut = exchangeRoundTripTimeOut;
            ((HttpRequest)this.obj).presentExchangeRoundTripTimeOut = true;
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withPerEndpointTimeoutMs(long perEndpointTimeoutMs) {
            ((HttpRequest)this.obj).perEndpointTimeoutMs = perEndpointTimeoutMs;
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withHeaders(Map<String, String> inHeaders) {
            HashMap<String, String> headers = null;
            if (MapUtils.isNotEmpty(inHeaders)) {
                if (((HttpRequest)this.obj).headers == null) {
                    ((HttpRequest)this.obj).headers = headers = new HashMap<String, String>(inHeaders);
                } else {
                    ((HttpRequest)this.obj).headers.putAll(inHeaders);
                }
            }
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withHeader(String name, String value) {
            HashMap<String, String> headers = null;
            if (((HttpRequest)this.obj).headers == null) {
                headers = new HashMap<String, String>();
                headers.put(name, value);
                ((HttpRequest)this.obj).headers = headers;
            } else {
                ((HttpRequest)this.obj).headers.put(name, value);
            }
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withHttpMethod(String method) {
            ((HttpRequest)this.obj).httpMethod = method;
            return (RequestBuilder)this.thisObj;
        }

        @Override
        protected HttpRequest createObj(URI uri) {
            return new HttpRequest(uri);
        }

        @Override
        protected RequestBuilder getThis() {
            return this;
        }

        public RequestBuilder withIteratorRouteOfferOrderHandler(IteratorRouteOfferOrderHandler handler) {
            if (((HttpRequest)this.obj).routeOfferOrderHandlers == null) {
                ((HttpRequest)this.obj).routeOfferOrderHandlers = new ArrayList();
            }
            ((HttpRequest)this.obj).routeOfferOrderHandlers.add(handler);
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withIteratorEndpointOrderHandler(IteratorEndpointOrderHandler handler) {
            if (((HttpRequest)this.obj).endpointOrderHandlers == null) {
                ((HttpRequest)this.obj).endpointOrderHandlers = new ArrayList();
            }
            ((HttpRequest)this.obj).endpointOrderHandlers.add(handler);
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withIteratorRouteOfferOrderHandlers(List<IteratorRouteOfferOrderHandler> handlers) {
            if (((HttpRequest)this.obj).routeOfferOrderHandlers == null) {
                ((HttpRequest)this.obj).routeOfferOrderHandlers = new ArrayList();
            }
            ((HttpRequest)this.obj).routeOfferOrderHandlers.addAll(handlers);
            return (RequestBuilder)this.thisObj;
        }

        public RequestBuilder withIteratorEndpointOrderHandlers(List<IteratorEndpointOrderHandler> handlers) {
            if (((HttpRequest)this.obj).endpointOrderHandlers == null) {
                ((HttpRequest)this.obj).endpointOrderHandlers = new ArrayList();
            }
            ((HttpRequest)this.obj).endpointOrderHandlers.addAll(handlers);
            return (RequestBuilder)this.thisObj;
        }
    }
}

