/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.request;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.RequestProcessorIntf;
import com.att.aft.dme2.api.SimpleRealm;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class Request {
    protected String context;
    protected String subContext;
    protected String queryParams;
    protected String lookupUri;
    protected String charset;
    private String stickySelectorKey;
    protected boolean preferLocalEPs;
    protected boolean ignoreFailoverOnExpire;
    protected boolean useVersionRange = true;
    protected String partner;
    protected String routeOffer;
    protected boolean isEncoded;
    protected SimpleRealm realm;
    protected String preferredRouteOffer;
    protected Properties configs;
    protected long readTimeout;
    protected boolean returnResponseAsBytes = false;
    protected AsyncResponseHandlerIntf responseHandler = null;
    protected RequestProcessorIntf requestProcessor;
    private DmeUniformResource uniformResource;
    protected Map<String, String> headers;
    protected boolean presentPreferLocalEPs = false;
    protected boolean presentUseVersionRange = false;

    protected Request(URI uri) {
    }

    public boolean isPresentUseVersionRange() {
        return this.presentUseVersionRange;
    }

    public boolean isPresentPreferLocalEPs() {
        return this.presentPreferLocalEPs;
    }

    public RequestProcessorIntf getRequestProcessor() {
        return this.requestProcessor;
    }

    public void setRequestProcessor(RequestProcessorIntf requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    public AsyncResponseHandlerIntf getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(AsyncResponseHandlerIntf responseHandler) {
        this.responseHandler = responseHandler;
    }

    public String getContext() {
        return this.context;
    }

    public String getSubContext() {
        return this.subContext;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public String getStickySelectorKey() {
        return this.stickySelectorKey;
    }

    public boolean isPreferLocalEPs() {
        return this.preferLocalEPs;
    }

    public boolean isIgnoreFailoverOnExpire() {
        return this.ignoreFailoverOnExpire;
    }

    public boolean isUseVersionRange() {
        return this.useVersionRange;
    }

    public String getPartner() {
        return this.partner;
    }

    public String getRouteOffer() {
        return this.routeOffer;
    }

    public boolean isEncoded() {
        return this.isEncoded;
    }

    public String getLookupUri() {
        return this.lookupUri;
    }

    public void setLookupUri(String lookupUri) {
        this.lookupUri = lookupUri;
    }

    public SimpleRealm getRealm() {
        return this.realm;
    }

    public String getPreferredRouteOffer() {
        return this.preferredRouteOffer;
    }

    public void setPreferredRouteOffer(String preferredRouteOffer) {
        this.preferredRouteOffer = preferredRouteOffer;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isReturnResponseAsBytes() {
        return this.returnResponseAsBytes;
    }

    public void setReturnResponseAsBytes(boolean returnResponseAsBytes) {
        this.returnResponseAsBytes = returnResponseAsBytes;
    }

    public DmeUniformResource getUniformResource() {
        return this.uniformResource;
    }

    public void setUniformResource(DmeUniformResource uniformResource) {
        this.uniformResource = uniformResource;
    }

    public Map<String, String> getClientHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    protected static abstract class RequestBuilder<T extends Request, B extends RequestBuilder<T, B>> {
        protected T obj;
        protected B thisObj;

        public RequestBuilder(URI uri) {
            this.obj = this.createObj(uri);
            this.thisObj = this.getThis();
        }

        public B withContext(String context) {
            ((Request)this.obj).context = context;
            return this.thisObj;
        }

        public B withSubContext(String subContext) {
            ((Request)this.obj).subContext = subContext;
            return this.thisObj;
        }

        public B withQueryParams(String queryParams) {
            ((Request)this.obj).queryParams = queryParams;
            return this.thisObj;
        }

        public B withUseVersionRange(boolean useVersionRange) {
            ((Request)this.obj).useVersionRange = useVersionRange;
            ((Request)this.obj).presentUseVersionRange = true;
            return this.thisObj;
        }

        public B withPreferLocalEPs(boolean preferLocalEPs) {
            ((Request)this.obj).preferLocalEPs = preferLocalEPs;
            ((Request)this.obj).presentPreferLocalEPs = true;
            return this.thisObj;
        }

        public B withAuthCreds(String realmName, String username, String password) {
            SimpleRealm realm;
            ((Request)this.obj).realm = realm = new SimpleRealm(realmName, username, password);
            return this.thisObj;
        }

        public B withPreferredRouteOffer(String preferredRouteOffer) {
            ((Request)this.obj).preferredRouteOffer = preferredRouteOffer;
            return this.thisObj;
        }

        public B withCharset(String charset) {
            ((Request)this.obj).charset = charset;
            return this.thisObj;
        }

        public B withLookupURL(String lookupUri) throws DME2Exception {
            if (lookupUri == null) {
                throw new DME2Exception("AFT-DME2-0605", new ErrorContext().add("extendedMessage", "uri=null"));
            }
            ((Request)this.obj).lookupUri = lookupUri.trim();
            return this.thisObj;
        }

        public B withReadTimeout(long readTimeout) {
            ((Request)this.obj).readTimeout = readTimeout;
            return this.thisObj;
        }

        public B withReturnResponseAsBytes(boolean returnResponseAsBytes) {
            ((Request)this.obj).returnResponseAsBytes = returnResponseAsBytes;
            return this.thisObj;
        }

        public B withResponseHandlers(AsyncResponseHandlerIntf responseHandler) {
            ((Request)this.obj).responseHandler = responseHandler;
            return this.thisObj;
        }

        public T build() {
            return this.obj;
        }

        protected abstract T createObj(URI var1);

        protected abstract B getThis();
    }
}

