/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.api.websocket;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.websocket.client.WebSocketClient;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketListener;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.server.api.websocket.DME2WSCliConnManager;
import com.att.aft.dme2.server.api.websocket.DME2WSCliConnection;
import com.att.aft.dme2.server.api.websocket.DME2WSCliMessageHandler;
import com.att.aft.dme2.server.api.websocket.DME2WsConnectionRetry;
import java.net.URI;
import java.util.HashMap;

public class DME2CliWebSocket
implements WebSocketListener {
    private static Logger logger = LoggerFactory.getLogger(DME2CliWebSocket.class);
    private DME2WSCliConnection connection = null;
    private DME2WSCliMessageHandler handler = null;
    private WebSocketClient wsClient = null;
    private DmeUniformResource uri = null;
    private DME2Manager dme2Mgr = null;
    private String endpoint = null;
    private int maxConnectionIdleTime = 60;
    private String trackingID;
    private final StringBuffer epTraceRoute = new StringBuffer();
    public static final String EP = "[EP=";
    private DME2WSCliConnManager wsConnMgr;
    private long connectionOpenedTime;
    private boolean logStats = true;
    private final String RETRY = "retry";
    private final String FAILOVER = "failover";
    private DME2Configuration config = new DME2Configuration();

    public DME2CliWebSocket(DME2WSCliMessageHandler handler, DME2Manager mgr) {
        this.handler = handler;
        this.dme2Mgr = mgr;
    }

    @Override
    public void onWebSocketText(String message) {
        logger.info(null, "onWebSocketText", LogMessage.WS_CONNECTION_RECEIVE_MSG, this.connection.getTrackingId(), this.uri, this.endpoint, message.length());
        if (this.logStats) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("MSG_SIZE", message.length());
            props.put("EVENT_TIME", System.currentTimeMillis());
            props.put("REPLY_EVENT", true);
            props.put("QUEUE_NAME", this.uri.getUrl().toString());
            props.put("DME2_INTERFACE_PORT", this.uri.getUrl().getPort() + "");
            props.put("ELAPSED_TIME", 0);
            props.put("MESSAGE_ID", this.trackingID);
            props.put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
            props.put("DME2_INTERFACE_PROTOCOL", "ws");
            props.put("REPLY_EVENT", true);
            if (this.uri.getPartner() != null) {
                props.put("DME2_REQUEST_PARTNER", this.uri.getPartner());
            }
            logger.debug((URI)null, "onWebSocketText", "DME2Exchange postWSReceiveEvent ", (Object)props);
            this.dme2Mgr.postStatEvent(props);
        }
        try {
            this.handler.processTextMessage(message);
        }
        catch (Exception e) {
            logger.warn(null, "onWebSocketText", LogMessage.WS_CLI_HANDLER_EXCEPTION, "OnMessage(text)", this.uri, this.endpoint, this.connection.getTrackingId(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebSocketConnect(WebSocketConnection conn) {
        Object object = this.wsConnMgr.getLock();
        synchronized (object) {
            if (this.connection == null) {
                this.connection = new DME2WSCliConnection(conn, this.dme2Mgr, this.wsConnMgr);
                this.getHandler().setConnection(this.connection);
                this.connection.setMaxIdleTime(this.maxConnectionIdleTime);
                this.connection.setUri(this.uri);
                this.connection.setTrackingId(this.trackingID);
                this.connection.setEndpoint(this.endpoint);
                this.wsConnMgr.setUserClose(false);
            } else {
                this.connection.setMaxIdleTime(this.maxConnectionIdleTime);
                this.connection.setUri(this.uri);
                this.connection.setTrackingId(this.trackingID);
                this.connection.setEndpoint(this.endpoint);
                this.connection.setConnection(conn);
                this.wsConnMgr.setUserClose(false);
            }
            this.connectionOpenedTime = System.currentTimeMillis();
            logger.info(null, "onWebSocketConnect(WebSocketConnection)", LogMessage.WS_CONNECTION_OPEN_MSG, this.connection.getTrackingId(), this.uri, this.endpoint);
            if (this.logStats) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("EVENT_TIME", System.currentTimeMillis());
                props.put("FAULT_EVENT", false);
                props.put("QUEUE_NAME", this.endpoint);
                props.put("ELAPSED_TIME", 0);
                props.put("AFT_DME2_CONNECT_ID", this.connection.getTrackingId());
                props.put("DME2_INTERFACE_PROTOCOL", "ws");
                props.put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
                if (this.uri.getPartner() != null) {
                    props.put("DME2_REQUEST_PARTNER", this.uri.getPartner());
                }
                logger.debug((URI)null, "onWebSocketConnect", "DME2Exchange postWSConnectionOpenEvent {}", (Object)props);
                this.dme2Mgr.postStatEvent(props);
            }
            try {
                this.handler.onOpen(this.connection);
            }
            catch (Exception e) {
                logger.warn(null, "onWebSocketConnect(WebSocketConnection)", LogMessage.WS_CLI_HANDLER_EXCEPTION, "OnOpen", this.uri, this.endpoint, this.connection.getTrackingId(), e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebSocketClose(int closeCode, String message) {
        if (this.connection == null) {
            return;
        }
        logger.info(null, "onWebSocketClose", LogMessage.WS_CONNECTION_CLOSE_MSG, this.connection.getTrackingId(), closeCode, this.uri, this.endpoint);
        if (this.logStats) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("EVENT_TIME", System.currentTimeMillis());
            props.put("FAULT_EVENT", false);
            props.put("QUEUE_NAME", this.endpoint);
            props.put("ELAPSED_TIME", System.currentTimeMillis() - this.getConnection().getConnectStartTime());
            props.put("AFT_DME2_CONNECT_ID", this.connection.getTrackingId());
            props.put("DME2_INTERFACE_PROTOCOL", "ws");
            props.put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
            if (this.uri.getPartner() != null) {
                props.put("DME2_REQUEST_PARTNER", this.uri.getPartner());
            }
            logger.debug((URI)null, "onWebSocketConnect", "DME2Exchange postWSConnectionCloseEvent ", (Object)props);
            this.dme2Mgr.postStatEvent(props);
        }
        Object object = this.wsConnMgr.getLock();
        synchronized (object) {
            try {
                if (closeCode == 1000 && !this.wsConnMgr.isUserClose()) {
                    long currentTime = System.currentTimeMillis();
                    long elapsedTime = currentTime - this.connectionOpenedTime;
                    if (elapsedTime >= (long)this.maxConnectionIdleTime) {
                        logger.debug(null, "onWebSocketClose", LogMessage.WS_CONN_RETRY, this.uri, this.connection.getTrackingId(), closeCode, this.endpoint);
                        this.wsConnMgr.setUserClose(false);
                        this.dme2Mgr.getWsRetryThreadpool().submit(new DME2WsConnectionRetry(this.wsConnMgr, "retry", closeCode, message));
                    } else {
                        this.handler.onConnClose(closeCode, message);
                    }
                    return;
                }
                if (closeCode == 1000 && this.wsConnMgr.isUserClose()) {
                    this.handler.onConnClose(closeCode, message);
                    return;
                }
                if (this.wsConnMgr.isFailoverRequired(message, closeCode)) {
                    if (this.wsConnMgr.isRetryRequired(message, closeCode)) {
                        logger.debug(null, "onWebSocketClose", LogMessage.WS_CONN_RETRY, this.uri, this.connection.getTrackingId(), closeCode, this.endpoint);
                        this.dme2Mgr.getWsRetryThreadpool().submit(new DME2WsConnectionRetry(this.wsConnMgr, "retry", closeCode, message));
                    } else if (this.wsConnMgr.isHandleFailover()) {
                        logger.debug((URI)null, "onWebSocketClose", LogMessage.WS_CONN_FAILOVER, (Object)this.uri, (Object)this.connection.getTrackingId());
                        this.dme2Mgr.getWsRetryThreadpool().submit(new DME2WsConnectionRetry(this.wsConnMgr, "failover", closeCode, message));
                    } else {
                        this.handler.onConnClose(closeCode, message);
                    }
                } else {
                    this.handler.onConnClose(closeCode, message);
                }
            }
            catch (Exception e) {
                logger.warn(null, "onWebSocketClose", LogMessage.WS_CLI_HANDLER_EXCEPTION, this.uri, this.endpoint, this.connection.getTrackingId(), e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebSocketBinary(byte[] data, int offset, int length) {
        Object object = this.wsConnMgr.getLock();
        synchronized (object) {
            logger.info(null, "onWebSocketBinary", LogMessage.WS_CONNECTION_RECEIVE_MSG, this.connection.getTrackingId(), this.uri, this.endpoint, data.length);
            if (this.logStats) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("MSG_SIZE", data.length);
                props.put("EVENT_TIME", System.currentTimeMillis());
                props.put("REPLY_EVENT", true);
                props.put("QUEUE_NAME", this.uri.getUrl().toString());
                props.put("DME2_INTERFACE_PORT", this.uri.getUrl().getPort() + "");
                props.put("ELAPSED_TIME", 0);
                props.put("MESSAGE_ID", this.trackingID);
                props.put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
                props.put("DME2_INTERFACE_PROTOCOL", "ws");
                props.put("REPLY_EVENT", true);
                if (this.uri.getPartner() != null) {
                    props.put("DME2_REQUEST_PARTNER", this.uri.getPartner());
                }
                logger.debug((URI)null, "onWebSocketBinary", "DME2Exchange postWSReceiveEvent ", (Object)props);
                this.dme2Mgr.postStatEvent(props);
            }
            try {
                this.handler.processBinaryMessage(data, offset, length);
            }
            catch (Exception e) {
                logger.warn(null, "onWebSocketBinary", LogMessage.WS_CLI_HANDLER_EXCEPTION, this.uri, this.endpoint, this.connection.getTrackingId(), e.getMessage());
            }
        }
    }

    @Override
    public void onWebSocketException(WebSocketException error) {
    }

    public DME2WSCliConnection getConnection() {
        return this.connection;
    }

    public void setConnection(DME2WSCliConnection connection) {
        this.connection = connection;
    }

    public WebSocketClient getWsClient() {
        return this.wsClient;
    }

    public void setWsClient(WebSocketClient wsClient) {
        this.wsClient = wsClient;
    }

    public DmeUniformResource getUri() {
        return this.uri;
    }

    public void setUri(DmeUniformResource uri) {
        this.uri = uri;
    }

    public DME2WSCliMessageHandler getHandler() {
        return this.handler;
    }

    public void setHandler(DME2WSCliMessageHandler handler) {
        this.handler = handler;
    }

    public DME2Manager getDme2Mgr() {
        return this.dme2Mgr;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public void setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
    }

    public void setTrackingId(String trackingID) {
        this.trackingID = trackingID;
    }

    public String getTrackingID() {
        return this.trackingID;
    }

    public StringBuffer getEpTraceRoute() {
        return this.epTraceRoute;
    }

    public DME2WSCliConnManager getWsConnMgr() {
        return this.wsConnMgr;
    }

    public void setWsConnMgr(DME2WSCliConnManager wsConnMgr) {
        this.wsConnMgr = wsConnMgr;
        this.logStats = wsConnMgr.isLogStats();
    }

    public boolean isLogStats() {
        return this.logStats;
    }

    public void setLogStats(boolean logStats) {
        this.logStats = logStats;
    }
}

