/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.api.websocket;

import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import java.io.IOException;

public class DME2ServerWSConnection {
    private WebSocketConnection connection;
    private String trackingId;

    public DME2ServerWSConnection(WebSocketConnection connection) {
        this.connection = connection;
    }

    protected WebSocketConnection getConnection() {
        return this.connection;
    }

    protected void setConnection(WebSocketConnection connection) {
        this.connection = connection;
    }

    public void sendMessage(String data) throws IOException {
        this.getConnection().write(null, null, data);
    }

    public void sendMessage(byte[] data, int offset, int length) throws IOException {
        this.getConnection().write(null, null, data, offset, length);
    }

    public boolean isOpen() {
        if (this.connection != null) {
            return this.connection.isOpen();
        }
        return false;
    }

    public void setMaxIdleTime(int ms) {
        if (this.connection != null) {
            this.connection.getPolicy().setIdleTimeout(ms);
        }
    }

    public void setMaxTextMessageSize(int size) {
        if (this.connection != null) {
            this.connection.getPolicy().setMaxTextMessageSize(size);
        }
    }

    public void setMaxBinaryMessageSize(int size) {
        if (this.connection != null) {
            this.connection.getPolicy().setMaxBinaryMessageSize(size);
        }
    }

    public int getMaxIdleTime() {
        if (this.connection != null) {
            return this.connection.getPolicy().getIdleTimeout();
        }
        return 0;
    }

    public int getMaxTextMessageSize() {
        if (this.connection != null) {
            return this.connection.getPolicy().getMaxTextMessageSize();
        }
        return 0;
    }

    public int getMaxBinaryMessageSize() {
        if (this.connection != null) {
            return this.connection.getPolicy().getMaxBinaryMessageSize();
        }
        return 0;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }
}

