/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.api.websocket;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.websocket.client.WebSocketClient;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.service.DME2BaseEndpointIterator;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.server.api.websocket.DME2CliWebSocket;
import com.att.aft.dme2.server.api.websocket.DME2WSCliMessageHandler;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ErrorContext;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class DME2WSCliConnManager {
    private static Logger logger = LoggerFactory.getLogger(DME2WSCliConnManager.class);
    private final DME2Manager manager;
    private DmeUniformResource uniformResource;
    private DME2BaseEndpointIterator iterator;
    public static final String SERVICE = "service";
    private static final String AFT_DME2_0702 = null;
    private DME2EndpointReference currentEndpointReference;
    private boolean attemptingRetry;
    private boolean isEndpointResolved;
    private final String lookupURI;
    private final StringBuffer routeOfferBuffer = new StringBuffer();
    private boolean tRACEON = false;
    private String subContext;
    private String context;
    private boolean preferLocal = false;
    private String hostFromArgs = null;
    private static DME2Configuration config = new DME2Configuration();
    private String currentFinalUrl = null;
    private String url = null;
    private long sendStart;
    private String hostname = null;
    private int maxTextMessageSize = 32768;
    private int maxBinaryMessageSize = 32768;
    private DME2CliWebSocket dme2Socket = null;
    private long maxConnectionTimeout = 5000L;
    private long maxConnIdleTime = 5000L;
    private int maxConnDuration = 60;
    private String trackingID;
    private String preferredRouteOffer;
    private boolean handleFailover = true;
    private String queryParams = null;
    private boolean logStats = true;
    private boolean isUserClose = false;
    private int maxConnAttempts = 1;
    private boolean enableTraceRoute = false;
    private Properties iteratorProps = null;
    private Object lock = new Object();
    private final String DME2_TRACKING_ID = "dme2_tracking_id";

    public DME2WSCliConnManager(DME2Manager mgr, DmeUniformResource dme2Uri, DME2WSCliMessageHandler handler) throws DME2Exception {
        this.manager = mgr;
        this.uniformResource = dme2Uri;
        this.hostFromArgs = config.getProperty("AFT_DME2_CONTAINER_HOST_KEY");
        this.dme2Socket = new DME2CliWebSocket(handler, this.manager);
        this.handleFailover = config.getBoolean("AFT_DME2_WS_HANDLE_FAILOVER");
        this.logStats = config.getBoolean("AFT_DME2_WEBSOCKET_METRICS_COLLECTION");
        this.dme2Socket.setLogStats(this.logStats);
        this.maxConnAttempts = config.getInt("AFT_DME2_WS_MAX_RETRY_COUNT");
        this.enableTraceRoute = config.getBoolean("AFT_DME2_WS_ENABLE_TRACE_ROUTE");
        this.maxTextMessageSize = config.getInt("AFT_DME2_SERVER_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE");
        this.maxBinaryMessageSize = config.getInt("AFT_DME2_SERVER_WEBSOCKET_MAX_BINARY_MESSAGE_SIZE");
        try {
            this.hostname = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.debug((URI)null, "ctor", "Exception", (Object)e);
        }
        try {
            this.lookupURI = this.stripQueryParamsFromURIString(dme2Uri.getUrl().toURI().toString());
        }
        catch (URISyntaxException e) {
            ErrorContext ec = new ErrorContext();
            ec.add(SERVICE, this.uniformResource.getUrl().toString());
            DME2Exception ex = new DME2Exception("AFT-DME2-3001", ec);
            logger.error((URI)null, "ctor", "AFT-DME2-3001", (Object)ec, (Object)ex);
            throw ex;
        }
    }

    public void connect() throws DME2Exception {
        this.initLoggingContext();
        Properties iteratorProps = new Properties();
        if (this.preferredRouteOffer != null) {
            iteratorProps.put("AFT_DME2_PREFERRED_ROUTEOFFER", this.preferredRouteOffer);
        }
        if (!this.iterator.hasNext()) {
            ErrorContext ec = new ErrorContext();
            ec.add(SERVICE, this.lookupURI);
            if (this.iterator.getRouteOffersTried() != null) {
                ec.add("routeOffersTried", this.iterator.getRouteOffersTried());
            }
            DME2Exception e = new DME2Exception(AFT_DME2_0702, ec);
            logger.error((URI)null, "connect", "AFT_DME2_0702", (Object)ec, (Object)e);
            throw e;
        }
        while (this.iterator.hasNext()) {
            this.resolveFinalRequestURLFromIterator();
            if (!this.isEndpointResolved) {
                ErrorContext ec = new ErrorContext();
                ec.add(SERVICE, this.lookupURI);
                ec.add("routeOffersTried", this.routeOfferBuffer.toString());
                DME2Exception e = new DME2Exception(AFT_DME2_0702, ec);
                logger.error((URI)null, "connect", "AFT_DME2_0702", (Object)ec, (Object)e);
                throw e;
            }
            try {
                logger.debug((URI)null, "connect", "CREATE_WS_CONNECTION", (Object)this.getURL());
                this.sendStart = System.currentTimeMillis();
                WebSocketClient wsClient = this.manager.getWsClientFactory().getWsClientFactory();
                wsClient.setMaxTextMessageBufferSize(this.maxTextMessageSize);
                wsClient.setMaxBinaryMessageBufferSize(this.maxBinaryMessageSize);
                this.dme2Socket.setWsClient(wsClient);
                this.dme2Socket.setUri(this.uniformResource);
                this.dme2Socket.setEndpoint(this.currentFinalUrl);
                this.dme2Socket.setMaxConnectionIdleTime((int)this.maxConnIdleTime);
                this.dme2Socket.setTrackingId(this.trackingID);
                this.dme2Socket.setWsConnMgr(this);
                if (this.isEnableTraceRoute()) {
                    this.dme2Socket.getEpTraceRoute().append("[EP=" + this.currentFinalUrl + ";");
                    if (this.currentEndpointReference.getRouteOffer().getRouteOffer() != null) {
                        this.dme2Socket.getEpTraceRoute().append("routeOffer=" + this.currentEndpointReference.getRouteOffer().getSearchFilter() + "]");
                    } else {
                        this.dme2Socket.getEpTraceRoute().append("]");
                    }
                }
                wsClient.connect(this.dme2Socket, new URI(this.currentFinalUrl)).get(this.getMaxConnectionTimeout(), TimeUnit.MILLISECONDS);
                logger.debug(null, "connect", "WS_CONNECTION_CONVERSATION ENDED;TrackingId=" + this.trackingID + ";URL=" + this.currentFinalUrl + ";elapsed=" + (System.currentTimeMillis() - this.sendStart));
                logger.debug((URI)null, "connect", LogMessage.WS_CONVERSATION_CLOSE_MSG, (Object)this.trackingID, (Object)this.currentFinalUrl);
                return;
            }
            catch (Exception e) {
                this.debugIt("WS_CONNECT_EXCEPTION", e.getClass().getCanonicalName() + ";" + e.getMessage());
                logger.debug(null, "connect", LogMessage.WS_CONNECTION_FAIL_MSG, this.trackingID, this.currentFinalUrl, e.getMessage());
                if (this.isEnableTraceRoute()) {
                    this.dme2Socket.getEpTraceRoute().append("[EP=" + this.currentFinalUrl + ":WS_CONNECT_EXCEPTION]");
                }
                this.iterator.setStale();
            }
        }
        if (this.iterator.isAllElementsExhausted()) {
            this.debugIt("connect", "WS_ENDPOINTS_EXHAUSTED");
            if (this.isLogStats()) {
                HashMap<String, Object> props1 = new HashMap<String, Object>();
                props1.put("EVENT_TIME", System.currentTimeMillis());
                props1.put("FAULT_EVENT", true);
                props1.put("QUEUE_NAME", this.lookupURI);
                props1.put("ELAPSED_TIME", 0);
                props1.put("MESSAGE_ID", this.trackingID);
                props1.put("DME2_INTERFACE_PROTOCOL", "ws");
                props1.put("DME2_INTERFACE_ROLE", config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
                props1.put("DME2_INTERFACE_PORT", 0);
                props1.put("FAULT_EVENT", true);
                if (this.uniformResource.getPartner() != null) {
                    props1.put("DME2_REQUEST_PARTNER", this.uniformResource.getPartner());
                }
                logger.debug((URI)null, "connect", "DME2Exchange postFaultEvent {}", (Object)props1);
                this.manager.postStatEvent(props1);
            }
            ErrorContext ec = new ErrorContext();
            ec.add(SERVICE, this.lookupURI);
            DME2Exception e = new DME2Exception("AFT-DME2-0703", ec);
            logger.error((URI)null, "connect", "AFT-DME2-0703", (Object)ec, (Object)e);
            throw e;
        }
        logger.debug(null, "connect", LogMessage.METHOD_EXIT);
    }

    private void resolveFinalRequestURLFromIterator() throws DME2Exception {
    }

    private void debugIt(String method, String key, String i) {
        if (this.tRACEON) {
            this.debugIt(method, key + ":" + i);
        }
    }

    private void debugIt(String method, String key, int i) {
        if (this.tRACEON) {
            this.debugIt(method, key + ":" + i);
        }
    }

    private void debugIt(String method, String message) {
        if (this.tRACEON && this.dme2Socket.getConnection() != null) {
            logger.debug(null, method, "WSObjReference: {} DME2 WS trackingId: {} - {}", this.hashCode(), this.trackingID, message);
        } else if (this.tRACEON) {
            logger.debug((URI)null, method, "WSObjReference: {} {}", (Object)this.hashCode(), (Object)message);
        }
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public String getSubContext() {
        return this.subContext != null ? this.subContext : "";
    }

    public void setSubContext(String subContext) {
        this.subContext = subContext;
    }

    private boolean matchServletPath(String context, String subContext, String endpointPaths) {
        String clientURLContext = context != null ? context : ("/" + subContext != null ? subContext : "");
        clientURLContext = clientURLContext.replaceAll("//", "/");
        String[] contextPaths = endpointPaths.split(",");
        for (int j = 0; j < contextPaths.length; ++j) {
            String[] toks = contextPaths[j].split("/");
            StringBuffer pathToCompare = new StringBuffer();
            for (int i = 0; i < toks.length; ++i) {
                if (toks[i].length() <= 0) continue;
                if (toks[i].startsWith("{") && toks[i].endsWith("}")) {
                    pathToCompare.append("/.*");
                    continue;
                }
                if (toks[i].startsWith("(") && toks[i].endsWith(")")) {
                    pathToCompare.append("/.*");
                    continue;
                }
                pathToCompare.append("/" + toks[i]);
            }
            if (pathToCompare.length() <= 0 || !clientURLContext.matches(pathToCompare.toString())) continue;
            return true;
        }
        return false;
    }

    public DmeUniformResource getDmeUniformResource() {
        return this.uniformResource;
    }

    public void setDmeUniformResource(DmeUniformResource uniformResource) {
        this.uniformResource = uniformResource;
    }

    public DmeUniformResource.DmeUrlType getDME2URLType() {
        return this.uniformResource.getUrlType();
    }

    public void setPreferLocal(boolean preferLocal) {
        this.preferLocal = preferLocal;
    }

    public boolean isPreferLocal() {
        return this.preferLocal;
    }

    public void setURL(String url) {
        if (url.contains("?")) {
            String urlStr = url.substring(0, url.lastIndexOf("?"));
            String queryStr = url.substring(url.lastIndexOf("?"), url.length());
            url = url + queryStr + "&" + "dme2_tracking_id" + "=" + this.trackingID;
        } else {
            url = url + "?" + "dme2_tracking_id" + "=" + this.trackingID;
        }
        String protocol = url.substring(0, url.lastIndexOf("://") + 3);
        String newUrl = url.replace(protocol, protocol.toLowerCase());
        if ((this.uniformResource.toString().startsWith("ws://") || this.uniformResource.toString().startsWith("wss://") || this.uniformResource.toString().startsWith("WS://") || this.uniformResource.toString().startsWith("WSS://")) && this.uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.DIRECT) {
            String ipProtocol = this.uniformResource.toString().substring(0, this.uniformResource.toString().lastIndexOf("://") + 3);
            newUrl = url.replace(protocol, ipProtocol);
        }
        this.url = newUrl;
        this.currentFinalUrl = newUrl;
        this.debugIt("WS_SET_URL", this.url);
    }

    private String getURL() {
        return this.currentFinalUrl;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this.maxTextMessageSize = maxTextMessageSize;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this.maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public long getMaxConnectionTimeout() {
        return this.maxConnectionTimeout;
    }

    public void setMaxConnectionTimeout(long val) {
        this.maxConnectionTimeout = val;
    }

    public long getMaxConnIdleTime() {
        return this.maxConnIdleTime;
    }

    public void setMaxConnIdleTime(long maxConnIdleTime) {
        this.maxConnIdleTime = maxConnIdleTime;
    }

    public void close() throws DME2Exception {
        if (this.dme2Socket.getConnection() != null) {
            this.dme2Socket.getConnection().close();
        }
    }

    public int getMaxConnDuration() {
        return this.maxConnDuration;
    }

    public void setMaxConnDuration(int maxConnDuration) {
        this.maxConnDuration = maxConnDuration;
    }

    private void initLoggingContext() {
        try {
            String conversationId = UUID.randomUUID().toString();
            this.trackingID = "WS_ID_" + conversationId + (this.getStickySelectorKey() == null ? "" : "(stickySelector=" + this.getStickySelectorKey() + ")");
            DME2Constants.setContext(this.trackingID, null);
        }
        catch (Exception e) {
            logger.warn((URI)null, "initLoggingContext", LogMessage.EXCH_CTX_FAIL, (Object)e);
        }
    }

    public String getStickySelectorKey() {
        return this.uniformResource.getStickySelectorKey();
    }

    public String getPreferredRouteOffer() {
        return this.preferredRouteOffer;
    }

    public void setPreferredRouteOffer(String preferredRouteOffer) {
        this.preferredRouteOffer = preferredRouteOffer;
    }

    public boolean isHandleFailover() {
        return this.handleFailover;
    }

    public void failoverConnection() throws DME2Exception {
        if (this.isEnableTraceRoute()) {
            this.dme2Socket.getEpTraceRoute().append("[EP=" + this.currentFinalUrl + ":onException=connection closed];");
        }
        this.iterator.setStale();
        this.dme2Socket = this.createDME2WebSocket(this.dme2Socket);
        while (this.iterator.hasNext()) {
            try {
                this.resolveFinalRequestURLFromIterator();
                logger.debug((URI)null, "failoverConnection", LogMessage.WS_CONN_FAILOVER, (Object)this.getURL(), (Object)this.trackingID);
                DME2Constants.setContext(this.trackingID, null);
                this.debugIt("CREATE_WS_CONNECTION", this.getURL());
                this.sendStart = System.currentTimeMillis();
                this.dme2Socket.setUri(this.uniformResource);
                this.dme2Socket.setEndpoint(this.currentFinalUrl);
                if (this.isEnableTraceRoute()) {
                    this.dme2Socket.getEpTraceRoute().append("[EP=" + this.currentFinalUrl + "; routeOffer=" + this.currentEndpointReference.getRouteOffer().getSearchFilter() + "]");
                }
                this.dme2Socket.getWsClient().connect(this.dme2Socket, new URI(this.currentFinalUrl)).get(this.getMaxConnectionTimeout(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (Exception e) {
                this.debugIt("WS_CONNECT_EXCEPTION", e.getClass().getCanonicalName() + ";" + e.getMessage());
                logger.debug(null, "failoverConnection", LogMessage.WS_CONNECTION_FAIL_MSG, this.trackingID, this.currentFinalUrl, e.getMessage());
                if (!this.isEnableTraceRoute()) continue;
                this.dme2Socket.getEpTraceRoute().append("[EP=" + this.currentFinalUrl + ":WS_CONNECT_EXCEPTION]");
            }
        }
        if (this.iterator.isAllElementsExhausted()) {
            ErrorContext ec;
            this.debugIt("failoverConnection", "DO_WS_FAILOVER_ENDPOINTS_EXHAUSTED");
            try {
                if (this.isLogStats()) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("EVENT_TIME", System.currentTimeMillis());
                    props.put("FAULT_EVENT", true);
                    props.put("QUEUE_NAME", this.lookupURI);
                    props.put("DME2_INTERFACE_PORT", new URI(this.currentFinalUrl).getPort() + "");
                    props.put("FAULT_EVENT", true);
                    props.put("ELAPSED_TIME", 0);
                    props.put("MESSAGE_ID", this.trackingID);
                    props.put("DME2_INTERFACE_PROTOCOL", "ws");
                    props.put("DME2_INTERFACE_ROLE", config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
                    if (this.uniformResource.getPartner() != null) {
                        props.put("DME2_REQUEST_PARTNER", this.uniformResource.getPartner());
                    }
                    logger.debug((URI)null, "failoverConnection", "DME2Exchange postFaultEvent {}", (Object)props);
                    this.manager.postStatEvent(props);
                }
            }
            catch (Exception e1) {
                ec = new ErrorContext();
                ec.add("Code", "DME2Client.Fault");
                ec.add("extendedMessage", e1.getMessage());
                logger.debug((URI)null, "failoverConnection", "AFT-DME2-5101", (Object)ec);
            }
            String endpointsAttempted = this.dme2Socket.getEpTraceRoute() != null ? this.dme2Socket.getEpTraceRoute().toString() : null;
            ec = new ErrorContext();
            ec.add(SERVICE, this.lookupURI);
            ec.add("TRACKING_ID", this.trackingID);
            ec.add("URI", this.lookupURI);
            if (endpointsAttempted != null) {
                ec.add("endpointsAttempted", endpointsAttempted);
            }
            DME2Exception dme2Exception = new DME2Exception("AFT-DME2-0703", ec);
            logger.error((URI)null, "failoverConnection", "AFT-DME2-0703", (Object)ec, (Object)dme2Exception);
            throw dme2Exception;
        }
        logger.debug(null, "failoverConnection", LogMessage.METHOD_EXIT);
    }

    public boolean isFailoverRequired(String replyMessage, int respCode) {
        boolean isFailoverRequired = false;
        if (config.getProperty("AFT_DME2_FAILOVER_WS_CLOSE_CDS").contains(String.valueOf(respCode))) {
            isFailoverRequired = true;
        }
        return isFailoverRequired;
    }

    public boolean isRetryRequired(String replyMessage, int respCode) {
        boolean isRetryRequired = false;
        if (config.getProperty("AFT_DME2_RETRY_WS_CLOSE_CDS").contains(String.valueOf(respCode))) {
            isRetryRequired = true;
        }
        return isRetryRequired;
    }

    public void retryConnection() throws DME2Exception {
        int i = 0;
        this.dme2Socket = this.createDME2WebSocket(this.dme2Socket);
        while (i < this.maxConnAttempts) {
            try {
                this.debugIt("CREATE_WS_CONNECTION", this.getURL());
                this.sendStart = System.currentTimeMillis();
                this.dme2Socket.setUri(this.uniformResource);
                this.dme2Socket.setEndpoint(this.currentFinalUrl);
                this.dme2Socket.getWsClient().connect(this.dme2Socket, new URI(this.currentFinalUrl)).get(this.getMaxConnectionTimeout(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (Exception e) {
                this.debugIt("WS_CONNECT_EXCEPTION", e.getClass().getCanonicalName() + ";" + e.getMessage());
                logger.debug(null, "retryConnection", LogMessage.WS_CONNECTION_FAIL_MSG, this.trackingID, this.currentFinalUrl, e.getMessage());
                if (this.isHandleFailover() && i == this.maxConnAttempts - 1) {
                    this.failoverConnection();
                    continue;
                }
                if (this.isHandleFailover() || i != this.maxConnAttempts - 1) continue;
                ErrorContext ec = new ErrorContext();
                ec.add("Code", "DME2Client.Fault");
                ec.add("extendedMessage", "Retry failed and failover is disabled.");
                ec.add("WS_TRACKING_ID", this.trackingID);
                ec.add("URI", this.lookupURI);
                ec.add("ERROR_MESSAGE", e.getMessage());
                DME2Exception dme2Exception = new DME2Exception("AFT-DME2-3009", ec);
                logger.error((URI)null, "retryConnection", "AFT-DME2-3009", (Object)ec, (Object)e);
                throw dme2Exception;
            }
        }
    }

    public String getQueryParams() {
        return this.queryParams != null ? this.queryParams : "";
    }

    public void setQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    public void setQueryParams(Map<String, String> mapParams, boolean encode) {
        if (mapParams == null || mapParams.size() == 0) {
            this.queryParams = "";
            return;
        }
        StringBuffer sb = new StringBuffer(mapParams.size() * 2);
        sb.append("?");
        for (Map.Entry<String, String> e : mapParams.entrySet()) {
            try {
                sb.append(e.getKey()).append("=").append(encode ? URLEncoder.encode(e.getValue() != null ? e.getValue() : "", Charset.forName("UTF-8").name()) : (e.getValue() != null ? e.getValue() : "")).append("&");
            }
            catch (UnsupportedEncodingException uee) {
                this.debugIt("Could not encode parameter:", e + ";" + uee);
            }
        }
        this.queryParams = sb.toString();
    }

    private String stripQueryParamsFromURIString(String uriString) {
        int indexOfQuery = uriString.indexOf("?");
        if (indexOfQuery > 0) {
            return uriString.substring(0, indexOfQuery);
        }
        return uriString;
    }

    public boolean isLogStats() {
        return this.logStats;
    }

    public boolean isUserClose() {
        return this.isUserClose;
    }

    public void setUserClose(boolean isUserClose) {
        this.isUserClose = isUserClose;
    }

    public boolean isEnableTraceRoute() {
        return this.enableTraceRoute;
    }

    public DME2CliWebSocket getDme2Socket() {
        return this.dme2Socket;
    }

    public Object getLock() {
        return this.lock;
    }

    public String getEpTraceRoute() {
        if (this.dme2Socket != null) {
            return this.dme2Socket.getEpTraceRoute().toString();
        }
        return "";
    }

    public DME2CliWebSocket createDME2WebSocket(DME2CliWebSocket dme2Socket) {
        DME2CliWebSocket socket = new DME2CliWebSocket(dme2Socket.getHandler(), this.manager);
        socket.getEpTraceRoute().append(dme2Socket.getEpTraceRoute());
        socket.setWsClient(dme2Socket.getWsClient());
        socket.setWsConnMgr(dme2Socket.getWsConnMgr());
        socket.setTrackingId(dme2Socket.getTrackingID());
        socket.setHandler(dme2Socket.getHandler());
        socket.setMaxConnectionIdleTime(dme2Socket.getMaxConnectionIdleTime());
        socket.setLogStats(dme2Socket.isLogStats());
        return socket;
    }

    public void setHandleFailover(boolean handleFailover) {
        this.handleFailover = handleFailover;
    }
}

