/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.api.websocket;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.server.api.websocket.DME2WSCliConnManager;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DME2WSCliConnection {
    private static Logger logger = LoggerFactory.getLogger(DME2WSCliConnection.class);
    private String trackingId;
    private WebSocketConnection connection = null;
    private long connectStartTime;
    private long connectEndTime;
    private DmeUniformResource uri;
    private DME2Manager dme2Mgr;
    private String endpoint;
    private DME2WSCliConnManager wsConnMgr = null;
    private DME2Configuration config = new DME2Configuration();

    public DME2WSCliConnection(WebSocketConnection conn, DME2Manager mgr, DME2WSCliConnManager wsConnMgr) {
        this.connection = conn;
        this.connectStartTime = System.currentTimeMillis();
        this.dme2Mgr = mgr;
        this.wsConnMgr = wsConnMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message) throws DME2Exception {
        block9: {
            try {
                if (this.connection != null && this.connection.isOpen()) {
                    Object props;
                    logger.info(null, "sendMessage", LogMessage.WS_CONNECTION_SEND_MSG, this.trackingId, this.uri, this.endpoint, message.length());
                    if (this.wsConnMgr.isLogStats()) {
                        props = new HashMap<String, Long>();
                        ((HashMap)props).put("EVENT_TIME", System.currentTimeMillis());
                        ((HashMap)props).put("FAULT_EVENT", false);
                        ((HashMap)props).put("ELAPSED_TIME", 0);
                        ((HashMap)props).put("AFT_DME2_CONNECT_ID", this.trackingId);
                        ((HashMap)props).put("DME2_INTERFACE_PROTOCOL", "ws");
                        ((HashMap)props).put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
                        ((HashMap)props).put("DME2_INTERFACE_PORT", this.uri.getUrl().getPort() + "");
                        if (this.uri.getPartner() != null) {
                            ((HashMap)props).put("DME2_REQUEST_PARTNER", this.uri.getPartner());
                        }
                        logger.debug((URI)null, "sendMessage", "DME2Exchange postWSSendEvent {}", props);
                        this.dme2Mgr.postStatEvent((Map<String, Object>)props);
                    }
                    props = this.wsConnMgr.getLock();
                    synchronized (props) {
                        this.connection.write(null, null, message);
                        break block9;
                    }
                }
                ErrorContext ec = new ErrorContext();
                ec.add("WS_TRACKING_ID", this.trackingId);
                ec.add("URI", this.uri.toString());
                ec.add("ENDPOINT", this.endpoint);
                ec.add("MESSAGE_LEN", String.valueOf(message.length()));
                DME2Exception ex = new DME2Exception("AFT-DME2-3004", ec);
                throw ex;
            }
            catch (DME2Exception e) {
                throw e;
            }
            catch (Exception e) {
                ErrorContext ec = new ErrorContext();
                ec.add("WS_TRACKING_ID", this.getTrackingId());
                ec.add("URI", this.uri.toString());
                ec.add("ENDPOINT", this.endpoint);
                ec.add("MESSAGE_LEN", String.valueOf(message.length()));
                ec.add("ERROR_MESSAGE", e.getMessage());
                DME2Exception ex = new DME2Exception("AFT-DME2-3005", ec, (Throwable)e);
                logger.error((URI)null, "sendMessage", "AFT-DME2-3005", (Object)ec, (Object)ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] data, int offset, int length) throws DME2Exception {
        block9: {
            try {
                if (this.connection != null && this.connection.isOpen()) {
                    Object props;
                    logger.info(null, "sendMessage(byte[], int, int)", LogMessage.WS_CONNECTION_SEND_MSG, this.trackingId, this.uri, this.endpoint, data.length);
                    if (this.wsConnMgr.isLogStats()) {
                        props = new HashMap<String, Long>();
                        ((HashMap)props).put("EVENT_TIME", System.currentTimeMillis());
                        ((HashMap)props).put("FAULT_EVENT", false);
                        ((HashMap)props).put("ELAPSED_TIME", 0);
                        ((HashMap)props).put("AFT_DME2_CONNECT_ID", this.trackingId);
                        ((HashMap)props).put("DME2_INTERFACE_PROTOCOL", "ws");
                        ((HashMap)props).put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
                        ((HashMap)props).put("DME2_INTERFACE_PORT", this.uri.getUrl().getPort() + "");
                        if (this.uri.getPartner() != null) {
                            ((HashMap)props).put("DME2_REQUEST_PARTNER", this.uri.getPartner());
                        }
                        logger.debug((URI)null, "sendMessage", "DME2Exchange postWSSendEvent {}", props);
                        this.dme2Mgr.postStatEvent((Map<String, Object>)props);
                    }
                    props = this.wsConnMgr.getLock();
                    synchronized (props) {
                        this.connection.write(null, null, data, offset, length);
                        break block9;
                    }
                }
                ErrorContext ec = new ErrorContext();
                ec.add("WS_TRACKING_ID", this.trackingId);
                ec.add("URI", this.uri.toString());
                ec.add("ENDPOINT", this.endpoint);
                ec.add("MESSAGE_LEN", String.valueOf(data.toString().length()));
                DME2Exception ex = new DME2Exception("AFT-DME2-3004", ec);
                logger.error((URI)null, "sendMessage(byte[], int, int)", "AFT-DME2-3004 {}", (Object)ec, (Object)ex);
                throw ex;
            }
            catch (DME2Exception e) {
                throw e;
            }
            catch (Exception e) {
                ErrorContext ec = new ErrorContext();
                ec.add("WS_CONNECT_ID", this.trackingId);
                ec.add("URI", this.uri.toString());
                ec.add("ENDPOINT", this.endpoint);
                ec.add("MESSAGE", data.toString());
                ec.add("ERROR_MESSAGE", e.getMessage());
                DME2Exception ex = new DME2Exception("AFT-DME2-3005", ec, (Throwable)e);
                logger.error((URI)null, "sendMessage(byte[], int, int)", "AFT-DME2-3005 {}", (Object)ec, (Object)ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DME2Exception {
        Object object = this.wsConnMgr.getLock();
        synchronized (object) {
            try {
                if (this.connection != null && this.connection.isOpen()) {
                    this.connectEndTime = System.currentTimeMillis();
                    this.wsConnMgr.setUserClose(true);
                    this.connection.close();
                }
            }
            catch (Exception e) {
                ErrorContext ec = new ErrorContext();
                ec.add("WS_CONNECT_ID", this.trackingId);
                ec.add("URI", this.uri.toString());
                ec.add("ENDPOINT", this.endpoint);
                ec.add("ERROR_MESSAGE", e.getMessage());
                DME2Exception ex = new DME2Exception("AFT-DME2-3006", ec, (Throwable)e);
                logger.error((URI)null, "close", "AFT-DME2-3006 {}", (Object)ec, (Object)ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.wsConnMgr.getLock();
        synchronized (object) {
            if (this.connection != null) {
                return this.connection.isOpen();
            }
        }
        return false;
    }

    public void setMaxIdleTime(int ms) {
        if (this.connection != null) {
            this.connection.getPolicy().setIdleTimeout(ms);
        }
    }

    public void setMaxTextMessageSize(int size) {
        if (this.connection != null) {
            this.connection.getPolicy().setMaxTextMessageSize(size);
        }
    }

    public void setMaxBinaryMessageSize(int size) {
        if (this.connection != null) {
            this.connection.getPolicy().setMaxBinaryMessageSize(size);
        }
    }

    public int getMaxIdleTime() {
        if (this.connection != null) {
            return this.connection.getPolicy().getIdleTimeout();
        }
        return 0;
    }

    public int getMaxTextMessageSize() {
        if (this.connection != null) {
            return this.connection.getPolicy().getMaxTextMessageSize();
        }
        return 0;
    }

    public int getMaxBinaryMessageSize() {
        if (this.connection != null) {
            return this.connection.getPolicy().getMaxBinaryMessageSize();
        }
        return 0;
    }

    public long getConnectStartTime() {
        return this.connectStartTime;
    }

    public long getConnectEndTime() {
        return this.connectEndTime;
    }

    public void setConnectEndTime(long connectEndTime) {
        this.connectEndTime = connectEndTime;
    }

    public DmeUniformResource getUri() {
        return this.uri;
    }

    public void setUri(DmeUniformResource uri) {
        this.uri = uri;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public DME2WSCliConnManager getWsConnMgr() {
        return this.wsConnMgr;
    }

    public WebSocketConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(WebSocketConnection connection) {
        Object object = this.wsConnMgr.getLock();
        synchronized (object) {
            this.connection = connection;
        }
    }
}

