/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.api.websocket;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.server.api.websocket.DME2WSCliConnection;

public abstract class DME2WSCliMessageHandler {
    private static Logger logger = LoggerFactory.getLogger(DME2WSCliMessageHandler.class);
    private DME2WSCliConnection connection;

    public abstract void processTextMessage(String var1);

    public abstract void onConnClose(int var1, String var2);

    public abstract void onOpen(DME2WSCliConnection var1);

    public abstract void processBinaryMessage(byte[] var1, int var2, int var3);

    public DME2WSCliConnection getConnection() {
        return this.connection;
    }

    public void setConnection(DME2WSCliConnection connection) {
        this.connection = connection;
    }

    public void sendTextMessage(String message) throws DME2Exception {
        this.connection.sendMessage(message);
    }

    public void sendBinaryMessage(byte[] data, int offset, int length) throws DME2Exception {
        this.connection.sendMessage(data, offset, length);
    }

    public void closeConnection() throws DME2Exception {
        this.connection.close();
    }

    public abstract void onException(Exception var1);
}

