/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.api.websocket;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.util.DME2ThreadPoolConfig;
import com.att.aft.dme2.internal.jetty.util.thread.ExecutorThreadPool;
import com.att.aft.dme2.internal.jetty.websocket.client.WebSocketClient;
import com.att.aft.dme2.util.ErrorContext;
import java.util.concurrent.ThreadPoolExecutor;

public class DME2WSClientFactory {
    private WebSocketClient wsClient = null;
    private transient ThreadPoolExecutor wsFactoryThreadpool = null;

    public DME2WSClientFactory(DME2Manager mgr) throws DME2Exception {
        try {
            if (this.wsFactoryThreadpool == null) {
                this.wsFactoryThreadpool = DME2ThreadPoolConfig.getInstance(mgr).createWebSocketFactoryThreadPool();
            }
            this.wsClient = new WebSocketClient(new ExecutorThreadPool(this.wsFactoryThreadpool));
        }
        catch (Exception e) {
            ErrorContext ec = new ErrorContext();
            ec.add("factory", "DME2_WS_CLIENT_FACTORY_CREATION");
            ec.add("ErrorMessage", e.getMessage());
            throw new DME2Exception("AFT-DME2-3003", ec, (Throwable)e);
        }
    }

    public void start() throws DME2Exception {
        try {
            this.wsClient.start();
        }
        catch (Exception e) {
            ErrorContext ec = new ErrorContext();
            ec.add("Factory", "DME2_WS_CLIENT_FACTORY_START");
            ec.add("ErrorMessage", e.getMessage());
            throw new DME2Exception("AFT-DME2-3003", ec, (Throwable)e);
        }
    }

    public void stop() throws DME2Exception {
        try {
            if (this.wsClient != null && this.wsClient.isStarted()) {
                this.wsClient.stop();
            }
        }
        catch (Exception e) {
            throw new DME2Exception("AFT-DME2-3003", new ErrorContext().add("Factory", "DME2_WS_CLIENT_FACTORY_STOP"));
        }
    }

    public WebSocketClient getWsClientFactory() {
        return this.wsClient;
    }
}

