/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.cache;

import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DME2StaleEndpointCache
implements DME2Cache {
    private final Map<String, Long> cache = new ConcurrentHashMap<String, Long>(16, 0.9f, 1);
    private static final Logger logger = LoggerFactory.getLogger(DME2StaleEndpointCache.class);
    private final byte[] lock = new byte[0];
    private DME2Configuration config;
    Timer staleEndpointCleanupTimer;
    private boolean enableCacheStats;

    public DME2StaleEndpointCache(DME2Configuration config) {
        this.config = config;
    }

    public DME2Cache getCache() {
        return this;
    }

    @Override
    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        logger.debug(null, "clear", LogMessage.METHOD_ENTER);
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.cache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            logger.debug(null, "clear", LogMessage.METHOD_EXIT);
            return;
        }
    }

    @Override
    public int getCurrentSize() {
        return this.cache.size();
    }

    @Override
    public String getKeys() {
        return this.cache.keySet().toString();
    }

    @Override
    public void shutdownTimerTask() {
        if (this.staleEndpointCleanupTimer != null) {
            this.staleEndpointCleanupTimer.cancel();
        }
    }
}

