/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.cache;

import com.att.aft.dme2.server.cache.DME2Cache;
import com.att.aft.dme2.server.cache.DME2CacheStats;
import com.att.aft.dme2.server.mbean.DME2CacheMXBean;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class DME2StaleRouteOfferCache
implements DME2Cache,
DME2CacheMXBean {
    private final Map<String, Long> cache = new ConcurrentHashMap<String, Long>();
    private final byte[] lock = new byte[0];
    Timer staleRouteOfferCleanupTimer;
    private boolean enableCacheStats;

    public DME2StaleRouteOfferCache() {
        this.initialize();
    }

    public Map<String, Long> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.cache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getCurrentSize() {
        return this.cache.size();
    }

    @Override
    public long getCacheTTLValue(String key) {
        return 0L;
    }

    @Override
    public long getExpirationTime(String key) {
        if (this.cache.get(key) != null) {
            return this.cache.get(key);
        }
        return 0L;
    }

    @Override
    public String getKeys() {
        return this.cache.keySet().toString();
    }

    @Override
    public void initialize() {
        this.staleRouteOfferCleanupTimer = new Timer("DME2StaleEndpointCache::StaleRouteOfferCleanupTimer", true);
        this.staleRouteOfferCleanupTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (String key : DME2StaleRouteOfferCache.this.cache.keySet()) {
                    long expirationTime = (Long)DME2StaleRouteOfferCache.this.cache.get(key);
                    if (System.currentTimeMillis() <= expirationTime) continue;
                    DME2StaleRouteOfferCache.this.cache.remove(key);
                }
            }
        }, 60000L, 60000L);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void shutdownTimerTask() {
        if (this.staleRouteOfferCleanupTimer != null) {
            this.staleRouteOfferCleanupTimer.cancel();
        }
    }

    @Override
    public DME2CacheStats getStats(String serviceName, Integer hourOfDay) {
        return null;
    }

    @Override
    public void disableCacheStats() {
        this.enableCacheStats = false;
    }

    @Override
    public void enableCacheStats() {
        this.enableCacheStats = true;
    }

    @Override
    public boolean isCacheStatsEnabled() {
        return this.enableCacheStats;
    }
}

