/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.internal.gson.JsonDeserializationContext;
import com.att.aft.dme2.internal.gson.JsonDeserializer;
import com.att.aft.dme2.internal.gson.JsonElement;
import com.att.aft.dme2.internal.gson.JsonObject;
import com.att.aft.dme2.internal.gson.JsonParseException;
import com.att.aft.dme2.internal.gson.JsonPrimitive;
import com.att.aft.dme2.internal.gson.JsonSerializationContext;
import com.att.aft.dme2.internal.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DME2CustomXGCalConverter {

    public static class Deserializer
    implements JsonDeserializer {
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                try {
                    json.getAsString();
                    return DatatypeFactory.newInstance().newXMLGregorianCalendar(json.getAsString());
                }
                catch (IllegalArgumentException ex) {
                    Date date = null;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZZZZ");
                    date = df.parse(json.getAsString());
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), date.getHours(), date.getMinutes(), date.getSeconds(), Integer.MIN_VALUE, date.getTimezoneOffset());
                    return xmlDate;
                }
                catch (UnsupportedOperationException ex) {
                    JsonObject obj = json.getAsJsonObject();
                    XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar();
                    if (obj.get("year") != null) {
                        cal.setYear(obj.get("year").getAsBigInteger());
                    }
                    if (obj.get("month") != null) {
                        cal.setMonth(obj.get("month").getAsInt());
                    }
                    if (obj.get("day") != null) {
                        cal.setDay(obj.get("day").getAsInt());
                    }
                    if (obj.get("timezone") != null) {
                        cal.setTimezone(obj.get("timezone").getAsInt());
                    }
                    if (obj.get("hour") != null) {
                        cal.setHour(obj.get("hour").getAsInt());
                    }
                    if (obj.get("minute") != null) {
                        cal.setMinute(obj.get("minute").getAsInt());
                    }
                    if (obj.get("second") != null) {
                        cal.setSecond(obj.get("second").getAsInt());
                    }
                    if (obj.get("fractionalSecond") != null) {
                        cal.setFractionalSecond(obj.get("fractionalSecond").getAsBigDecimal());
                    }
                    return cal;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Serializer
    implements JsonSerializer {
        public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
            XMLGregorianCalendar xgcal = (XMLGregorianCalendar)src;
            return new JsonPrimitive(xgcal.toXMLFormat());
        }
    }
}

