/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMInstance;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistry;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2Utils;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DME2GRMJVMRegistration {
    private static volatile DME2GRMJVMRegistration INSTANCE;
    private static final Logger logger;

    public static void getInstance(DME2Manager manager, DmeUniformResource uniformResource) {
        DME2GRMJVMRegistration.getOrCreateInstance(manager, uniformResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DME2GRMJVMRegistration getOrCreateInstance(DME2Manager manager, DmeUniformResource uniformResource) {
        DME2GRMJVMRegistration result = INSTANCE;
        if (result != null) return result;
        Class<DME2GRMJVMRegistration> clazz = DME2GRMJVMRegistration.class;
        synchronized (DME2GRMJVMRegistration.class) {
            result = INSTANCE;
            if (INSTANCE != null) return result;
            INSTANCE = result = new DME2GRMJVMRegistration(manager, uniformResource);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public DME2GRMJVMRegistration(DME2Manager manager, DmeUniformResource uniformResource) {
        logger.debug(null, "ctor", LogMessage.METHOD_ENTER);
        try {
            if (manager.getConfig().getBoolean("AFT_DME2_REGISTER_JVM_INSTANCE_ON_GRM")) {
                DME2EndpointRegistry registry = manager.getEndpointRegistry();
                String user = manager.getConfig().getProperty("DME2_GRM_USER");
                String pid = ManagementFactory.getRuntimeMXBean().getName();
                String pidToRegister = pid.contains("@") ? pid.substring(0, pid.indexOf("@")) : pid;
                GregorianCalendar gcal = new GregorianCalendar();
                gcal.add(5, 1);
                XMLGregorianCalendar expTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
                ClientJVMInstance instanceInfo = new ClientJVMInstance();
                instanceInfo.setApplicationId(DME2Utils.getRunningInstanceName(manager.getConfig()));
                instanceInfo.setDme2Environment(uniformResource.getEnvContext());
                instanceInfo.setDme2Version(DME2Manager.getVersion());
                instanceInfo.setHostAddress(manager.getHostname() == null ? InetAddress.getLocalHost().getCanonicalHostName() : manager.getHostname());
                instanceInfo.setJavaVersion(Runtime.class.getPackage().getImplementationVersion());
                instanceInfo.setMechId(user);
                instanceInfo.setProcessId(pidToRegister);
                instanceInfo.setProcessOwner(System.getProperty("user.name"));
                String envContext = uniformResource.getEnvContext();
                this.scheduleJVMRegister(envContext, instanceInfo, manager);
                if (manager.getConfig().getBoolean("AFT_DME2_DEREGISTER_JVM_INSTANCE_ON_GRM")) {
                    DME2DeregisterJVMThread shutdown = DME2DeregisterJVMThread.getInstance(registry, envContext, instanceInfo);
                    Runtime.getRuntime().addShutdownHook(shutdown);
                }
                if (manager.getConfig().getBoolean("AFT_DME2_REFRESH_JVM_INSTANCE_ON_GRM")) {
                    this.scheduleJVMRenewLease(envContext, instanceInfo, manager);
                }
            }
        }
        catch (Exception e) {
            logger.warn((URI)null, "ctor(DME2Manager,DmeUniformResource)", LogMessage.ERROR_REGISTERING_JVM, (Object)e);
        }
        logger.debug(null, "ctor", LogMessage.METHOD_EXIT);
    }

    private void scheduleJVMRegister(String envContext, ClientJVMInstance instanceInfo, DME2Manager manager) {
        logger.debug(null, "scheduleJVMRegister", LogMessage.METHOD_ENTER);
        Timer registerJVMLeaseTimer = null;
        Date date = new Date();
        final String env = envContext;
        final ClientJVMInstance instance = instanceInfo;
        final DME2Manager mgr = manager;
        final DME2EndpointRegistry managerRegistry = mgr.getEndpointRegistry();
        registerJVMLeaseTimer = new Timer("DME2::DME2Server::jvmRegisterTimer", true);
        registerJVMLeaseTimer.schedule(new TimerTask(){
            int attempt = 1;

            @Override
            public void run() {
                while (this.attempt <= mgr.getConfig().getInt("DME2_JVM_LEASE_REGISTER_RETRY_ATTEMPT")) {
                    try {
                        this.register();
                        break;
                    }
                    catch (Exception e) {
                        logger.warn(null, "scheduleJVMRegister", LogMessage.ERROR_REGISTERING_JVM, e.getMessage(), this.attempt, mgr.getConfig().getInt("DME2_JVM_LEASE_REGISTER_RETRY_ATTEMPT"), e);
                        ++this.attempt;
                    }
                }
            }

            private void register() throws Exception {
                managerRegistry.registerJVM(env, instance);
            }
        }, date);
        logger.debug(null, "scheduleJVMRegister", LogMessage.METHOD_EXIT);
    }

    private void scheduleJVMRenewLease(String envContext, ClientJVMInstance instanceInfo, DME2Manager manager) {
        Integer jvmLeaseRenewFrequency = null;
        Timer renewJVMLeaseTimer = null;
        DME2EndpointRegistry managerRegistry = manager.getEndpointRegistry();
        jvmLeaseRenewFrequency = manager.getConfig().getInt("DME2_JVM_LEASE_RENEW_FREQUENCY_MS");
        final String env = envContext;
        final ClientJVMInstance instance = instanceInfo;
        final DME2EndpointRegistry registry = managerRegistry;
        renewJVMLeaseTimer = new Timer("DME2::DME2Server::jvmRenewTimer", true);
        renewJVMLeaseTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    ClientJVMInstance instanceAfter = instance;
                    registry.updateJVM(env, instanceAfter);
                }
                catch (Throwable e) {
                    logger.warn((URI)null, "scheduleJVMRenewLease", LogMessage.ERROR_RENEWING_ALL, (Object)e);
                }
            }
        }, jvmLeaseRenewFrequency.intValue(), (long)jvmLeaseRenewFrequency.intValue());
    }

    static {
        logger = LoggerFactory.getLogger(DME2GRMJVMRegistration.class.getName());
    }

    static class DME2DeregisterJVMThread
    extends Thread {
        private static DME2DeregisterJVMThread instance = null;
        private static final Logger logger = LoggerFactory.getLogger(DME2DeregisterJVMThread.class.getName());
        private DME2EndpointRegistry registry = null;
        private String envContext = null;
        private ClientJVMInstance instanceInfo = null;

        public static DME2DeregisterJVMThread getInstance(DME2EndpointRegistry registry, String envContext, ClientJVMInstance instanceInfo) {
            if (instance == null) {
                return new DME2DeregisterJVMThread(registry, envContext, instanceInfo);
            }
            return instance;
        }

        private DME2DeregisterJVMThread(DME2EndpointRegistry registry, String envContext, ClientJVMInstance instanceInfo) {
            this.registry = registry;
            this.envContext = envContext;
            this.instanceInfo = instanceInfo;
        }

        @Override
        public void run() {
            try {
                this.registry.deregisterJVM(this.envContext, this.instanceInfo);
            }
            catch (Exception e) {
                logger.warn((URI)null, "DME2DeregisterJVMThread.run", LogMessage.ERROR_DEREGISTERING_JVM, (Object)e);
            }
        }
    }
}

