/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class DME2URI {
    private static final Logger logger = LoggerFactory.getLogger(DME2URI.class.getName());
    public static final String STICKY_SELECTOR_KEY = "stickySelectorKey";
    public static final String DATA_CONTEXT_KEY = "dataContext";
    public static final String MATCH_VERSION_RANGE_KEY = "matchVersionRange";
    public static final String PARTNER_KEY = "partner";
    private final URI uri;
    private String stickySelectorKey;
    private String dataContext;
    private String envContext;
    private String partner;
    private String routeOffer;
    private String service;
    private String bindContext;
    private String subContext;
    private DME2UriType type;
    private String version;
    private long endpointReadTimeout;
    private long roundTripTimeout;
    private long connectTimeout;
    private String userName;
    private String password;
    private String realmName;
    private String[] allowedRoles;
    private String loginMethod;
    private boolean preferLocalEPs;
    private boolean ignoreFailoverOnExpire;
    private String queryParams;
    private String logicalService;
    private String namespace;
    private boolean useVersionRange = true;
    private String supportedVersionRange;
    private String driver;
    private DME2Configuration config;

    private static URI toURI(String rawURI) throws DME2Exception {
        if (rawURI == null) {
            throw new DME2Exception(rawURI, new ErrorContext());
        }
        try {
            String encodedURI = rawURI.replaceAll("\\{", "%7B").replaceAll("\\}", "%7D");
            return new URI(encodedURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public DME2URI(DME2Configuration config, String uriStr) throws DME2Exception {
        this(DME2URI.toURI(uriStr));
        this.config = config;
    }

    public DME2URI(URI uri) {
        String value;
        String key;
        String[] pair;
        this.uri = uri;
        String host = uri.getHost();
        this.type = host == null || host.toUpperCase().equals("DME2SEARCH") ? DME2UriType.SEARCHABLE : (host.toUpperCase().equals("DME2RESOLVE") ? DME2UriType.RESOLVABLE : DME2UriType.DIRECT);
        String path = uri.getPath();
        String[] toks = path.split("/");
        String inSubContext = null;
        for (String tok : toks) {
            if (inSubContext != null) {
                inSubContext = inSubContext + "/" + tok;
                continue;
            }
            String[] pair2 = tok.split("=");
            String key2 = pair2[0];
            if (key2.equalsIgnoreCase("subcontext")) {
                inSubContext = "";
                continue;
            }
            if (pair2.length != 2) continue;
            String value2 = pair2[1];
            if (key2.equalsIgnoreCase("service")) {
                this.service = value2;
                continue;
            }
            if (key2.equalsIgnoreCase("version")) {
                this.version = value2;
                continue;
            }
            if (key2.equalsIgnoreCase(PARTNER_KEY)) {
                this.partner = value2;
                continue;
            }
            if (key2.equalsIgnoreCase("envcontext")) {
                this.envContext = value2;
                continue;
            }
            if (key2.equalsIgnoreCase(DATA_CONTEXT_KEY)) {
                this.dataContext = value2;
                continue;
            }
            if (key2.equalsIgnoreCase("routeoffer")) {
                this.routeOffer = value2;
                continue;
            }
            if (key2.equalsIgnoreCase("bindcontext")) {
                this.setBindContext(value2);
                continue;
            }
            if (key2.equalsIgnoreCase("subcontext")) {
                inSubContext = value2;
                continue;
            }
            if (key2.equalsIgnoreCase(STICKY_SELECTOR_KEY)) {
                this.stickySelectorKey = value2;
                continue;
            }
            if (key2.equalsIgnoreCase("ns")) {
                this.setNamespace(value2);
                continue;
            }
            if (!key2.toLowerCase().equals("driver")) continue;
            this.driver = value2;
        }
        if (this.service == null && this.version == null && this.envContext == null) {
            String qParams = uri.getQuery();
            if (qParams != null) {
                String[] queryToks;
                for (String qtok : queryToks = qParams.split("&")) {
                    pair = qtok.split("=");
                    if (pair.length != 2) continue;
                    key = pair[0];
                    value = pair[1];
                    if (key.equalsIgnoreCase("routeoffer")) {
                        this.routeOffer = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("version")) {
                        this.version = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("envcontext")) {
                        this.envContext = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(PARTNER_KEY)) {
                        this.partner = value;
                        continue;
                    }
                    if (!key.equalsIgnoreCase("ns")) continue;
                    this.setNamespace(value);
                }
            }
            if (this.version != null && this.envContext != null && (this.routeOffer != null || this.partner != null)) {
                String uriServiceName = uri.getHost();
                String serviceUri = null;
                serviceUri = this.getNamespace() == null ? this.getReversed(uriServiceName) : uriServiceName;
                if (uri.getPath() != null && !uri.getPath().equals("/")) {
                    this.bindContext = uri.getPath();
                }
                String cpath = null;
                if (this.bindContext != null) {
                    cpath = this.bindContext.startsWith("/") ? this.bindContext.substring(1, this.bindContext.length()) : this.bindContext;
                }
                this.service = this.bindContext != null && cpath != null ? serviceUri + "/" + cpath.replaceAll("\\.", "\\\\\\\\.") : serviceUri;
                if (this.service != null) {
                    this.type = DME2UriType.STANDARD;
                }
            }
        }
        this.setSubContext(inSubContext);
        String queryString = uri.getQuery();
        if (queryString != null) {
            String[] queryToks;
            for (String qtok : queryToks = queryString.split("&")) {
                pair = qtok.split("=");
                if (pair.length != 2) continue;
                key = pair[0];
                value = pair[1];
                if (key.equalsIgnoreCase("endpointreadtimeout")) {
                    try {
                        this.endpointReadTimeout = Math.min(Long.parseLong(value), this.config.getLong("AFT_DME2_EP_READ_TIMEOUT"));
                    }
                    catch (Exception e) {
                        logger.debug((String)null, (URI)null, "DME2URI", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("roundtriptimeout")) {
                    try {
                        this.roundTripTimeout = Math.min(Long.parseLong(value), this.config.getLong("AFT_DME2_DEF_ROUNDTRIP_TIMEOUT_MS"));
                    }
                    catch (Exception e) {
                        this.roundTripTimeout = this.config.getLong("AFT_DME2_DEF_ROUNDTRIP_TIMEOUT_MS");
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("preferlocal")) {
                    this.preferLocalEPs = true;
                    continue;
                }
                if (key.equalsIgnoreCase("ignorefailoveronexpire")) {
                    this.ignoreFailoverOnExpire = true;
                    continue;
                }
                if (key.equalsIgnoreCase("connecttimeoutinms")) {
                    try {
                        this.connectTimeout = Math.min(Long.parseLong(value), this.config.getLong("AFT_DME2_EP_CONN_TIMEOUT"));
                    }
                    catch (Exception e) {
                        logger.debug((String)null, (URI)null, "DME2URI", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("username")) {
                    this.setUserName(value);
                    continue;
                }
                if (key.equalsIgnoreCase("password")) {
                    this.setPassword(value);
                    continue;
                }
                if (key.equalsIgnoreCase("realm")) {
                    this.setRealmName(value);
                    continue;
                }
                if (key.equalsIgnoreCase("loginmethod")) {
                    this.setLoginMethod(value);
                    continue;
                }
                if (key.equalsIgnoreCase("allowedroles") && value != null) {
                    this.setAllowedRoles(value.split(","));
                    continue;
                }
                if (key.equalsIgnoreCase(MATCH_VERSION_RANGE_KEY)) {
                    this.useVersionRange = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("supportedVersionRange")) {
                    this.supportedVersionRange = value;
                    continue;
                }
                this.queryParams = this.queryParams == null ? key + "=" + value : this.queryParams + "&" + key + "=" + value;
            }
        }
    }

    public void assertValid() throws DME2Exception {
        ErrorContext ec = new ErrorContext().add("URI", this.uri.toString());
        switch (this.type) {
            case SEARCHABLE: {
                if (this.partner != null) break;
                throw new DME2Exception("AFT-DME2-9703", ec);
            }
            case RESOLVABLE: 
            case DIRECT: 
            case STANDARD: {
                if (this.routeOffer != null || this.partner != null) break;
                throw new DME2Exception("AFT-DME2-9704", ec);
            }
            default: {
                throw new DME2Exception("AFT-DME2-9705", ec);
            }
        }
        if (this.service == null) {
            throw new DME2Exception("AFT-DME2-9700", ec);
        }
        if (this.version == null) {
            throw new DME2Exception("AFT-DME2-9701", ec);
        }
        if (this.envContext == null) {
            throw new DME2Exception("AFT-DME2-9702", ec);
        }
    }

    public String getDataContext() {
        return this.dataContext;
    }

    public String getEnvContext() {
        return this.envContext;
    }

    public String getPartner() {
        return this.partner;
    }

    public String getRouteOffer() {
        return this.routeOffer;
    }

    public String getService() {
        return this.service;
    }

    public DME2UriType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDataContext(String dataContext) {
        this.dataContext = dataContext;
    }

    public void setEnvContext(String envContext) {
        this.envContext = envContext;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public void setRouteOffer(String routeOffer) {
        this.routeOffer = routeOffer;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setType(DME2UriType type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public URI getOriginalURI() {
        return this.uri;
    }

    public void setStickySelectorKey(String stickySelectorKey) {
        this.stickySelectorKey = stickySelectorKey;
    }

    public String getStickySelectorKey() {
        return this.stickySelectorKey;
    }

    public long getEndpointReadTimeout() {
        return this.endpointReadTimeout;
    }

    public void setEndpointReadTimeout(long endpointReadTimeout) {
        this.endpointReadTimeout = endpointReadTimeout;
    }

    public long getRoundTripTimeout() {
        return this.roundTripTimeout;
    }

    public void setRoundTripTimeout(long roundTripTimeout) {
        this.roundTripTimeout = roundTripTimeout;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setAllowedRoles(String[] newAllowedRoles) {
        this.allowedRoles = newAllowedRoles == null ? null : Arrays.copyOf(newAllowedRoles, newAllowedRoles.length);
    }

    public String[] getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    public String getLoginMethod() {
        return this.loginMethod;
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean isLocalPreferred() {
        return this.preferLocalEPs;
    }

    public void setBindContext(String bindContext) {
        this.bindContext = bindContext;
    }

    public String getBindContext() {
        return this.bindContext;
    }

    public void setSubContext(String subContext) {
        this.subContext = subContext;
    }

    public String getSubContext() {
        return this.subContext;
    }

    public void setIgnoreFailoverOnExpire(boolean ignoreFailoverOnExpire) {
        this.ignoreFailoverOnExpire = ignoreFailoverOnExpire;
    }

    public boolean isIgnoreFailoverOnExpire() {
        return this.ignoreFailoverOnExpire;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public String getSupportedVersionRange() {
        return this.supportedVersionRange;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    private String getReversed(String uriServiceName) {
        if (this.isIPAddress(uriServiceName)) {
            return null;
        }
        String[] domainNameArr = uriServiceName.split("\\.");
        StringBuffer reversedString = new StringBuffer();
        for (int i = domainNameArr.length - 1; i >= 0; --i) {
            if (i != 0) {
                reversedString.append(domainNameArr[i] + ".");
                continue;
            }
            reversedString.append(domainNameArr[i]);
        }
        return reversedString.toString();
    }

    private boolean isIPAddress(String ipAddress) {
        String[] tokens = ipAddress.split("\\.");
        if (tokens.length != 4) {
            return false;
        }
        for (String str : tokens) {
            try {
                int i = Integer.parseInt(str);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public String getLogicalService() {
        return this.logicalService;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isUsingVersionRanges() {
        return this.useVersionRange;
    }

    public String getRegistryServiceSearchKey() {
        if (this.type == DME2UriType.DIRECT || this.type == DME2UriType.SEARCHABLE) {
            return null;
        }
        if (this.type == DME2UriType.RESOLVABLE) {
            return this.service;
        }
        if (this.routeOffer != null && this.bindContext == null) {
            return this.service;
        }
        if (!(this.type != DME2UriType.STANDARD || this.routeOffer != null && this.service.contains("/"))) {
            return null;
        }
        String uriServiceName = this.service.split("/", 2)[0];
        if (this.namespace == null) {
            return uriServiceName + "*";
        }
        return this.namespace + DME2Constants.getNAME_SEP() + uriServiceName + "*";
    }

    public static enum DME2UriType {
        DIRECT,
        RESOLVABLE,
        SEARCHABLE,
        STANDARD;

    }
}

