/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.internal.grm.types.v1.NameValuePair;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DME2URIUtils {
    private static final Logger logger = LoggerFactory.getLogger(DME2URIUtils.class.getName());
    private static final String FORMATTED_PATH = "/service=%s/version=%s/envContext=%s";
    private static final String FORMATTED_PATH_WITH_ROUTE_OFFER = "/service=%s/version=%s/envContext=%s/routeOffer=%s";

    public static String buildServiceURIString(String serviceName, String version, String envContext) {
        if (serviceName == null || version == null || envContext == null) {
            return null;
        }
        return String.format(FORMATTED_PATH, serviceName, version, envContext);
    }

    public static String buildServiceURIString(String serviceName, String version, String envContext, String routeOffer) {
        if (routeOffer == null) {
            return DME2URIUtils.buildServiceURIString(serviceName, version, envContext);
        }
        if (serviceName == null || version == null || envContext == null) {
            return null;
        }
        return String.format(FORMATTED_PATH_WITH_ROUTE_OFFER, serviceName, version, envContext, routeOffer);
    }

    public static String encodeURIString(String uriStr, boolean isEncoded) {
        String encodedStr = uriStr;
        try {
            String uriPrefix = null;
            int contextPathIndex = -1;
            if (uriStr.contains("/service")) {
                contextPathIndex = uriStr.indexOf("/service", 0);
                uriPrefix = uriStr.substring(0, contextPathIndex);
            } else if (uriStr.contains("%2Fservice")) {
                contextPathIndex = uriStr.indexOf("%2Fservice", 0);
                uriPrefix = URLDecoder.decode(uriStr.substring(0, contextPathIndex), "UTF-8");
            }
            if (!isEncoded) {
                String contextPath = uriStr.substring(contextPathIndex);
                String encodedContextPath = URLEncoder.encode(contextPath, "UTF-8");
                String finalEncodedURIStr = uriPrefix + encodedContextPath;
                encodedStr = finalEncodedURIStr.replace("%2F", "/").replace("%3D", "=").replace("%3F", "?").replace("%26", "&");
            } else {
                String encodedContextPath = uriStr.substring(contextPathIndex);
                String finalEncodedURIStr = uriPrefix + encodedContextPath;
                encodedStr = finalEncodedURIStr.replace("%2F", "/").replace("%3D", "=").replace("%3F", "?").replace("%26", "&");
            }
        }
        catch (Exception e) {
            logger.warn((String)null, (URI)null, "encodeURIString", "AFT-DME2-0607", (Object)new ErrorContext().add("URI", uriStr), (Object)e);
        }
        return encodedStr;
    }

    public static String formatClientURIString(String newInString) {
        String inString = newInString;
        String searchPrefix = "http://DME2SEARCH";
        String resolvePrefix = "http://DME2RESOLVE";
        if (!(inString.startsWith("http") || inString.startsWith("dme2") || inString.startsWith("ws"))) {
            if (!inString.startsWith("/")) {
                inString = "/" + inString;
            }
            if (inString.contains("partner")) {
                inString = "http://DME2SEARCH" + inString;
            } else if (inString.contains("routeOffer")) {
                inString = "http://DME2RESOLVE" + inString;
            }
        }
        return inString;
    }

    public static boolean isParseable(String value, Class<?> targetType) {
        try {
            if (targetType == Integer.class) {
                Integer.parseInt(value);
            } else if (targetType == Long.class) {
                Long.parseLong(value);
            } else if (targetType == Double.class) {
                Double.parseDouble(value);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String appendQueryStringToPath(String path, String newQueryStr) {
        String queryStr = newQueryStr;
        if (queryStr == null) {
            return path;
        }
        if (!queryStr.startsWith("?")) {
            queryStr = "?" + queryStr;
        }
        return path + queryStr;
    }

    public static List<NameValuePair> convertPropertiestoNameValuePairs(Properties props) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        if (props != null) {
            for (Object obj : props.keySet()) {
                String key = (String)obj;
                String value = props.getProperty(key);
                NameValuePair nameValPair = new NameValuePair();
                nameValPair.setName(key);
                nameValPair.setValue(value);
                nameValuePairs.add(nameValPair);
            }
        }
        return nameValuePairs;
    }

    public static Properties convertNameValuePairToProperties(List<NameValuePair> nameValuePairs) {
        Properties props = new Properties();
        if (nameValuePairs != null && !nameValuePairs.isEmpty()) {
            for (NameValuePair nameValuePair : nameValuePairs) {
                props.setProperty(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        return props;
    }

    public static Map<String, String> splitServiceURIString(String newServiceURI) {
        String[] toks;
        String serviceURI = newServiceURI;
        HashMap<String, String> serviceURIValues = new HashMap<String, String>();
        if (!serviceURI.startsWith("/")) {
            serviceURI = "/" + serviceURI;
        }
        for (String tok : toks = serviceURI.split("/")) {
            if (!tok.contains("=")) continue;
            String[] pair = tok.split("=");
            String key = pair[0];
            String value = pair[1];
            serviceURIValues.put(key, value);
        }
        return serviceURIValues;
    }

    public static String buildUniformResourceStr(String serviceName, String host, int port) {
        String urlStr = null;
        urlStr = serviceName.startsWith("http") ? serviceName : (serviceName.startsWith("/") ? "http" + host + ":" + port + serviceName : "http" + host + ":" + port + "/" + serviceName);
        return urlStr;
    }
}

