/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.util.ErrorContext;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorCatalog {
    protected static ErrorCatalog instance = new ErrorCatalog();
    private static Set<ResourceBundle> errorBundles = new HashSet<ResourceBundle>();

    protected ErrorCatalog() {
    }

    public static final ErrorCatalog getInstance() {
        return instance;
    }

    public void addErrorTable(ResourceBundle errorBundle) {
        errorBundles.add(errorBundle);
    }

    public final String getErrorMessage(String errorCode, ErrorContext context) {
        StringBuffer buf = new StringBuffer();
        String msg = null;
        for (ResourceBundle errorTable : errorBundles) {
            try {
                msg = errorTable.getString(errorCode);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (msg != null) continue;
        }
        if (msg == null) {
            msg = "Error occured but no localized message is available in the ErrorCatalog, review error code in documentation for more details.";
        }
        buf.append(msg);
        if (context != null && context.size() > 0) {
            buf.append(" [Context: ");
            for (String key : context.keySet()) {
                buf.append(key);
                buf.append("=");
                buf.append((String)context.get(key));
                buf.append(";");
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public static final void logInfo(Logger logger, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.INFO, errorCode, context, e);
    }

    public static final void logInfo(Logger logger, String methodName, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.INFO, methodName, errorCode, context, e);
    }

    public static final void logInfo(Logger logger, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.INFO, errorCode, context, null);
    }

    public static final void logInfo(Logger logger, String methodName, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.INFO, methodName, errorCode, context, null);
    }

    public static final void logWarning(Logger logger, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.WARNING, errorCode, context, e);
    }

    public static final void logWarning(Logger logger, String methodName, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.WARNING, methodName, errorCode, context, e);
    }

    public static final void logWarning(Logger logger, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.WARNING, errorCode, context, null);
    }

    public static final void logWarning(Logger logger, String methodName, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.WARNING, methodName, errorCode, context, null);
    }

    public static final void logSevere(Logger logger, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.SEVERE, errorCode, context, e);
    }

    public static final void logSevere(Logger logger, String methodName, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.SEVERE, methodName, errorCode, context, e);
    }

    public static final void logSevere(Logger logger, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.SEVERE, errorCode, context, null);
    }

    public static final void logSevere(Logger logger, String methodName, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.SEVERE, methodName, errorCode, context, null);
    }

    public static final void logConfig(Logger logger, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.CONFIG, errorCode, context, e);
    }

    public static final void logConfig(Logger logger, String methodName, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.CONFIG, methodName, errorCode, context, e);
    }

    public static final void logConfig(Logger logger, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.CONFIG, errorCode, context, null);
    }

    public static final void logConfig(Logger logger, String methodName, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.CONFIG, methodName, errorCode, context, null);
    }

    public static final void logFine(Logger logger, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.FINE, errorCode, context, e);
    }

    public static final void logFine(Logger logger, String methodName, String errorCode, ErrorContext context, Throwable e) {
        ErrorCatalog.log(logger, Level.FINE, methodName, errorCode, context, e);
    }

    public static final void logFine(Logger logger, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.FINE, errorCode, context, null);
    }

    public static final void logFine(Logger logger, String methodName, String errorCode, ErrorContext context) {
        ErrorCatalog.log(logger, Level.FINE, methodName, errorCode, context, null);
    }

    private static final void log(Logger logger, Level level, String errorCode, ErrorContext context, Throwable e) {
        if (logger != null) {
            if (e == null) {
                logger.logp(level, logger.getName(), "", "Code=" + errorCode + "; " + instance.getErrorMessage(errorCode, context));
            } else {
                logger.logp(level, logger.getName(), "", "Code=" + errorCode + "; " + instance.getErrorMessage(errorCode, context), e);
            }
        }
    }

    private static final void log(Logger logger, Level level, String methodName, String errorCode, ErrorContext context, Throwable e) {
        if (logger != null) {
            if (e == null) {
                logger.logp(level, logger.getName(), methodName, "Code=" + errorCode + "; " + instance.getErrorMessage(errorCode, context));
            } else {
                logger.logp(level, logger.getName(), methodName, "Code=" + errorCode + "; " + instance.getErrorMessage(errorCode, context), e);
            }
        }
    }
}

