/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarConverter {
    private static final Logger logger = LoggerFactory.getLogger(XMLGregorianCalendarConverter.class.getCanonicalName());
    private static DatatypeFactory df = null;

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar(DME2Manager.getTimezone());
        gc.setTimeInMillis(date.getTime());
        return df.newXMLGregorianCalendar(gc);
    }

    public static Date asDate(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        return xgc.toGregorianCalendar().getTime();
    }

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            logger.error((URI)null, "XMLGregorianCalendarConverter()", LogMessage.REPORT_ERROR, (Object)"error in static initializer", (Object)dce);
        }
    }
}

