/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.scld.config;

import com.att.aft.dme2.internal.apache.commons.collections.CollectionUtils;
import com.att.aft.dme2.internal.apache.commons.configuration.PropertiesConfiguration;
import com.att.aft.dme2.internal.apache.commons.lang3.StringUtils;
import com.att.aft.dme2.internal.google.common.collect.Lists;
import com.att.aft.dme2.internal.google.common.collect.Maps;
import com.att.aft.scld.config.ConfigurationIntf;
import com.att.aft.scld.config.defaultconfigs.PropertiesDefaultConfig;
import com.att.aft.scld.config.dto.Config;
import com.att.aft.scld.config.dto.ScldConfig;
import com.att.aft.scld.config.exception.ConfigException;
import com.att.aft.scld.config.strategy.ConfigurationStrategy;
import com.att.aft.scld.config.strategy.FileConfigurationStrategy;
import com.att.aft.scld.config.strategy.GRMPullConfgurationStrategy;
import com.att.aft.scld.config.strategy.JMXConfigurationStrategy;
import com.att.aft.scld.config.strategy.JVMConfigurationStrategy;
import com.att.aft.scld.config.strategy.UserPropertyConfigurationStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager
implements ConfigurationIntf {
    private static Map<String, Config> defaultConfigs = Maps.newConcurrentMap();
    private static Map<String, Map<String, String>> jvmConfigs = Maps.newHashMap();
    private static Map<String, ConfigurationManager> configManagerMap = Maps.newConcurrentMap();
    private Map<String, Map<String, String>> configs = Maps.newConcurrentMap();
    private Map<String, String> currentConfigs = Maps.newConcurrentMap();
    private String managerName = null;
    private List<String> defaultFileConfigNames = null;
    private String fileConfigName = null;
    private List<ConfigurationStrategy> configCommands = Lists.newArrayList();
    protected FileConfigurationStrategy fileStrategy = null;
    private PropertiesConfiguration userPropsConfig = null;

    protected ConfigurationManager() throws ConfigException {
        this.managerName = "defaultConfigurationManager";
        this.defaultFileConfigNames = Lists.newArrayList(ScldConfig.getInstance().getDefaultConfigFileName());
        this.loadDefaultConfigs(ScldConfig.getInstance().getDefaultConfigFileName());
        new JVMConfigurationStrategy().loadConfigs(jvmConfigs, defaultConfigs);
        configManagerMap.put("defaultConfigurationManager", this);
    }

    protected ConfigurationManager(String managerName, List<String> defaultFileConfigNames, String fileName, List<ConfigurationStrategy> configCommands, PropertiesConfiguration userPropsConfig) throws ConfigException {
        this.managerName = managerName;
        this.defaultFileConfigNames = CollectionUtils.isEmpty(defaultFileConfigNames) ? Lists.newArrayList(ScldConfig.getInstance().getDefaultConfigFileName()) : defaultFileConfigNames;
        this.fileConfigName = fileName;
        this.userPropsConfig = userPropsConfig;
        if (CollectionUtils.isNotEmpty(configCommands)) {
            this.configCommands.addAll(configCommands);
        }
    }

    public static ConfigurationManager getInstance() throws ConfigException {
        return ConfigurationManager.getInstance("defaultConfigurationManager");
    }

    public static ConfigurationManager getInstance(String managerName) throws ConfigException {
        return ConfigurationManager.getInstance(managerName, ScldConfig.getInstance().getDefaultConfigFileName(), null, null, null);
    }

    public static ConfigurationManager getInstance(String managerName, String defaultConfigFileName) throws ConfigException {
        return ConfigurationManager.getInstance(managerName, defaultConfigFileName, null, null, null);
    }

    public static ConfigurationManager getInstance(String managerName, String defaultConfigFileName, String fileName) throws ConfigException {
        return ConfigurationManager.getInstance(managerName, defaultConfigFileName, fileName, null, null);
    }

    public static ConfigurationManager getInstance(String managerName, String defaultConfigFileName, List<ConfigurationStrategy> configCommands) throws ConfigException {
        return ConfigurationManager.getInstance(managerName, defaultConfigFileName, null, configCommands, null);
    }

    public static ConfigurationManager getInstance(String managerName, PropertiesConfiguration userPropsConfig) throws ConfigException {
        return ConfigurationManager.getInstance(managerName, ScldConfig.getInstance().getDefaultConfigFileName(), null, null, userPropsConfig);
    }

    public static ConfigurationManager getInstance(String managerName, String defaultConfigFileName, PropertiesConfiguration userPropsConfig) throws ConfigException {
        return ConfigurationManager.getInstance(managerName, defaultConfigFileName, null, null, userPropsConfig);
    }

    public static ConfigurationManager getInstance(String managerName, String defaultConfigFileName, String fileName, List<ConfigurationStrategy> configCommands, PropertiesConfiguration userPropsConfig) throws ConfigException {
        if (!configManagerMap.containsKey(managerName)) {
            ConfigurationManager configManager = new ConfigurationManager(managerName, Lists.newArrayList(defaultConfigFileName), fileName, configCommands, userPropsConfig);
            configManager.initialize();
            configManagerMap.put(managerName, configManager);
        }
        return configManagerMap.get(managerName);
    }

    public static ConfigurationManager getInstance(String managerName, List<String> defaultConfigFileNames, String fileName, List<ConfigurationStrategy> configCommands, PropertiesConfiguration userPropsConfig) throws ConfigException {
        if (!configManagerMap.containsKey(managerName)) {
            ConfigurationManager configManager = new ConfigurationManager(managerName, defaultConfigFileNames, fileName, configCommands, userPropsConfig);
            configManager.initialize();
            configManagerMap.put(managerName, configManager);
        }
        return configManagerMap.get(managerName);
    }

    protected void initialize() throws ConfigException {
        if (CollectionUtils.isNotEmpty(this.defaultFileConfigNames)) {
            for (String defaultFileName : this.defaultFileConfigNames) {
                this.loadDefaultConfigs(defaultFileName);
            }
        }
        this.createStrategy();
        this.invokeStrategy();
        this.loadCurrentConfigs();
    }

    private void createStrategy() {
        ConcurrentMap jvm = Maps.newConcurrentMap();
        ConcurrentMap userProp = Maps.newConcurrentMap();
        ConcurrentMap grmPull = Maps.newConcurrentMap();
        ConcurrentMap jmx = Maps.newConcurrentMap();
        this.configs.put("jvmConfigs", jvm);
        this.configs.put("userPropConfigs", userProp);
        this.configs.put("grmPullConfigs", grmPull);
        this.configs.put("jmxConfigs", jmx);
        if (CollectionUtils.isEmpty(this.configCommands)) {
            this.configCommands = Lists.newArrayList();
            if (StringUtils.isNotBlank(this.fileConfigName)) {
                this.fileStrategy = new FileConfigurationStrategy(this.fileConfigName);
                this.configCommands.add(this.fileStrategy);
            }
            this.configCommands.add(new JVMConfigurationStrategy());
            if (this.userPropsConfig != null) {
                this.configCommands.add(new UserPropertyConfigurationStrategy(this.userPropsConfig));
            }
            this.configCommands.add(new GRMPullConfgurationStrategy());
            this.configCommands.add(new JMXConfigurationStrategy(this.managerName));
        } else {
            for (ConfigurationStrategy configStrategy : this.configCommands) {
                if (!(configStrategy instanceof FileConfigurationStrategy)) continue;
                this.fileStrategy = (FileConfigurationStrategy)configStrategy;
            }
        }
    }

    private void invokeStrategy() throws ConfigException {
        for (ConfigurationStrategy configurationStrategy : this.configCommands) {
            configurationStrategy.loadConfigs(this.configs, defaultConfigs);
            configurationStrategy.registerForRefresh(this.configs, defaultConfigs);
        }
    }

    private void loadDefaultConfigs(String defaultFileConfigName) throws ConfigException {
        PropertiesDefaultConfig config = null;
        ScldConfig configApi = ScldConfig.getInstance();
        if (configApi.getDefaultConfigFileType().equalsIgnoreCase("properties")) {
            config = new PropertiesDefaultConfig();
            Map<String, Config> propDefaultConfigs = config.loadDefaultConfigs(defaultFileConfigName);
            defaultConfigs.putAll(propDefaultConfigs);
        }
    }

    private void loadCurrentConfigs() {
        this.currentConfigs.clear();
        Map<String, String> jvm = this.configs.get("jvmConfigs");
        for (String string : jvm.keySet()) {
            this.currentConfigs.put(string, jvm.get(string));
        }
        Map<String, String> userProp = this.configs.get("userPropConfigs");
        for (String propertyName : userProp.keySet()) {
            this.currentConfigs.put(propertyName, userProp.get(propertyName));
        }
        Map<String, String> map = this.configs.get("jmxConfigs");
        for (String propertyName : map.keySet()) {
            this.currentConfigs.put(propertyName, map.get(propertyName));
        }
    }

    @Override
    public int getInt(String propertyName) {
        return Integer.parseInt(this.getProperty(propertyName));
    }

    public int getInt(String propertyName, int defaultValue) {
        String configValue = this.getProperty(propertyName);
        return configValue != null ? Integer.parseInt(configValue) : defaultValue;
    }

    @Override
    public long getLong(String propertyName) {
        return Long.parseLong(this.getProperty(propertyName));
    }

    public long getLong(String propertyName, long defaultValue) {
        String configValue = this.getProperty(propertyName);
        return configValue != null ? Long.parseLong(configValue) : defaultValue;
    }

    public double getDouble(String propertyName) {
        return Double.parseDouble(this.getProperty(propertyName));
    }

    public double getDouble(String propertyName, double defaultValue) {
        String configValue = this.getProperty(propertyName);
        return configValue != null ? Double.parseDouble(configValue) : defaultValue;
    }

    public void saveToFile() {
    }

    @Override
    public float getFloat(String propertyName) {
        return Float.parseFloat(this.getProperty(propertyName));
    }

    public float getFloat(String propertyName, float defaultValue) {
        String configValue = this.getProperty(propertyName);
        return configValue != null ? Float.parseFloat(configValue) : defaultValue;
    }

    @Override
    public boolean getBoolean(String propertyName) {
        return Boolean.parseBoolean(this.getProperty(propertyName));
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        String configValue = this.getProperty(propertyName);
        return configValue != null ? Boolean.parseBoolean(configValue) : defaultValue;
    }

    @Override
    public String getProperty(String propertyName) {
        if (this.currentConfigs.containsKey(propertyName)) {
            return this.currentConfigs.get(propertyName);
        }
        if (this.fileStrategy != null && this.fileStrategy.getPropertiesConfiguration() != null && StringUtils.isNotBlank(this.fileStrategy.getPropertiesConfiguration().getString(propertyName))) {
            return this.fileStrategy.getPropertiesConfiguration().getString(propertyName);
        }
        return defaultConfigs.get(propertyName) != null ? defaultConfigs.get(propertyName).getDefaultValue() : null;
    }

    public String getProperty(String propertyName, String defaultValue) {
        String configValue = this.getProperty(propertyName);
        return StringUtils.isNoneBlank(configValue) ? configValue : defaultValue;
    }

    public void setPropertyforJmx(String key, String value) {
        Config config = defaultConfigs.get(key);
        if (config != null && config.isUpdatable()) {
            if (StringUtils.isBlank(value)) {
                if (this.configs.get("jmxConfigs").containsKey(key)) {
                    this.configs.get("jmxConfigs").remove(key);
                    this.currentConfigs.remove(key);
                    if (this.configs.get("grmPullConfigs").containsKey(key)) {
                        this.currentConfigs.put(key, this.configs.get("grmPullConfigs").get(key));
                    } else if (this.configs.get("userPropConfigs").containsKey(key)) {
                        this.currentConfigs.put(key, this.configs.get("userPropConfigs").get(key));
                    } else if (this.configs.get("jvmConfigs").containsKey(key)) {
                        this.currentConfigs.put(key, this.configs.get("jvmConfigs").get(key));
                    }
                }
            } else {
                this.configs.get("jmxConfigs").put(key, value);
                this.currentConfigs.put(key, value);
            }
        }
    }

    public void setPropertyforGrmPull(String key, String value) {
        Config config = defaultConfigs.get(key);
        if (config != null && config.isUpdatable() && !this.configs.get("jmxConfigs").containsKey(key)) {
            this.configs.get("grmPullConfigs").put(key, value);
            this.currentConfigs.put(key, value);
        }
    }

    protected String getManagerName() {
        return this.managerName;
    }

    static {
        try {
            new ConfigurationManager();
        }
        catch (ConfigException e) {
            e.printStackTrace();
        }
    }
}

