/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Response;
import com.att.aft.dme2.api.http.HttpResponse;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.FailoverHandler;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DME2DefaultFailoverHandler
implements FailoverHandler {
    private static DME2Configuration config;
    private static final Logger LOGGER;

    public DME2DefaultFailoverHandler(DME2Configuration configuration) {
        config = configuration;
    }

    private boolean isFailoverRequired(String replyMessage, Integer respCode, Map<String, String> respHeaders) {
        boolean isFailoverRequired;
        block5: {
            isFailoverRequired = false;
            String contentType = respHeaders.get("Content-Type");
            boolean isContentTypeValid = false;
            try {
                if (contentType != null && contentType.startsWith(config.getProperty("AFT_DME2_SOAP_REPLY_CONTENT_TYPE"))) {
                    isContentTypeValid = true;
                }
                LOGGER.debug((URI)null, "isFailoverRequired", "DME2Exchange onResponse received 500 internal error;Content-Type={};ResponseContent={}", (Object)contentType, (Object)replyMessage);
                if (replyMessage == null || !replyMessage.contains(config.getProperty("AFT_DME2_ENVELOPE_STR")) || !isContentTypeValid) break block5;
                String responseBytes = replyMessage;
                MessageFactory factory = MessageFactory.newInstance();
                SOAPMessage rspMessage = factory.createMessage();
                StreamSource preppedMsgSrc = new StreamSource(new ByteArrayInputStream(responseBytes.getBytes()));
                rspMessage.getSOAPPart().setContent((Source)preppedMsgSrc);
                rspMessage.saveChanges();
                if (!rspMessage.getSOAPBody().hasFault()) break block5;
                SOAPFault fault = rspMessage.getSOAPBody().getFault();
                LOGGER.debug((URI)null, "isFailoverRequired", "DME2xchange getResponse hasFault;{}", (Object)fault.getTextContent());
                if (fault.getFaultString() == null) break block5;
                String faultString = fault.getFaultString();
                String failoverStringToCheck = config.getProperty("AFT_DME2_FAULT_STRING_FAILOVER");
                if (failoverStringToCheck == null) break block5;
                String[] failoverStrs = failoverStringToCheck.split(",");
                for (int i = 0; i < failoverStrs.length; ++i) {
                    if (faultString.toLowerCase().contains(failoverStrs[i].toLowerCase())) {
                        isFailoverRequired = true;
                        break;
                    }
                    isFailoverRequired = false;
                }
            }
            catch (Throwable e) {
                if (!config.getBoolean("DME2.DEBUG")) break block5;
                LOGGER.error((URI)null, DME2DefaultFailoverHandler.class.getName(), "AFT-DME2-9000", (Object)e);
            }
        }
        return isFailoverRequired;
    }

    @Override
    public boolean isFailoverRequired(DME2Response dme2Response) {
        boolean isFailoverRequired = false;
        if (dme2Response instanceof HttpResponse) {
            HttpResponse failoverHttp = (HttpResponse)dme2Response;
            String replyMessage = failoverHttp.getReplyMessage();
            Integer respCode = failoverHttp.getRespCode();
            Map<String, String> respHeaders = failoverHttp.getRespHeaders();
            if (null != replyMessage && 0 < replyMessage.length() && null != respHeaders) {
                isFailoverRequired = this.isFailoverRequired(replyMessage, respCode, respHeaders);
            }
        }
        return isFailoverRequired;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DME2DefaultFailoverHandler.class.getName());
    }
}

