/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.DME2ServerProperties;
import com.att.aft.dme2.api.DME2ServerStopThread;
import com.att.aft.dme2.api.DME2ServiceHolder;
import com.att.aft.dme2.api.http.DME2QueuedThreadPool;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.jaas.JAASLoginService;
import com.att.aft.dme2.internal.jetty.jaas.callback.ObjectCallback;
import com.att.aft.dme2.internal.jetty.jaas.callback.RequestParameterCallback;
import com.att.aft.dme2.internal.jetty.security.ConstraintMapping;
import com.att.aft.dme2.internal.jetty.security.ConstraintSecurityHandler;
import com.att.aft.dme2.internal.jetty.server.Connector;
import com.att.aft.dme2.internal.jetty.server.Handler;
import com.att.aft.dme2.internal.jetty.server.HttpConfiguration;
import com.att.aft.dme2.internal.jetty.server.HttpConnectionFactory;
import com.att.aft.dme2.internal.jetty.server.Server;
import com.att.aft.dme2.internal.jetty.server.ServerConnector;
import com.att.aft.dme2.internal.jetty.server.handler.ContextHandler;
import com.att.aft.dme2.internal.jetty.server.handler.ContextHandlerCollection;
import com.att.aft.dme2.internal.jetty.server.handler.HandlerCollection;
import com.att.aft.dme2.internal.jetty.servlet.ServletContextHandler;
import com.att.aft.dme2.internal.jetty.servlet.ServletHolder;
import com.att.aft.dme2.internal.jetty.util.security.Constraint;
import com.att.aft.dme2.internal.jetty.util.ssl.SslContextFactory;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.server.jetty.DME2SslSelectChannelConnector;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2ExceptionHandler;
import com.att.aft.dme2.util.ErrorContext;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.Servlet;

public class DME2Server {
    private static final Logger logger = LoggerFactory.getLogger(DME2Server.class.getName());
    private static final String SECURITY_REALM = "securityRealm";
    private static final String SERVLET = "servlet";
    private static final String WEBSOCKET = "websocket";
    private static final String SERVICE = "service";
    private static final String TEST = "test";
    private static final String KEY_KEYSTORE_PASSWORD = "AFT_DME2_KEYSTORE_PASSWORD";
    private static final String KEY_TRUSTSTORE_PASSWORD = "AFT_DME2_TRUSTSTORE_PASSWORD";
    private static final String KEY_PASSWORD = "AFT_DME2_KEY_PASSWORD";
    private static final String PORT_RANGE_ERROR_CODE = "AFT-DME2-0203";
    private static final String PORT_RANGE_ERROR_MSG = "PORT RANGE DEFINED IN INVALID FORMAT";
    private static final String STOP_ERROR_CODE = "AFT-DME2-0201";
    private static final String STOP_ERROR_MSG = "DME2 SERVER STOP FAILED";
    private DME2ServerProperties serverProperties;
    private Server server = null;
    private boolean running = false;
    private ServerConnector connector = null;
    private ContextHandlerCollection root = null;
    private HandlerCollection websocketHandlerCollection = null;
    private String baseAddress = null;
    private DME2Manager manager = null;
    private int persistedPort;
    private String persistedPorts;
    private boolean webSocket = false;
    private DME2Configuration config = null;
    private DME2QueuedThreadPool btp;
    private final Map<String, DME2ServiceHolder> services = new ConcurrentHashMap<String, DME2ServiceHolder>();

    public DME2Server(DME2Configuration config) throws DME2Exception {
        this.config = config;
        this.serverProperties = new DME2ServerProperties(config);
    }

    public void setManager(DME2Manager manager) {
        this.manager = manager;
    }

    public DME2Manager getManager() {
        return this.manager;
    }

    public void setProperties(Properties props) throws DME2Exception {
    }

    public void bindServiceListener(String service, Servlet servlet) throws DME2Exception {
        this.bindServiceListener(service, servlet, null, null, null);
    }

    public void bindServiceListener(String service, Servlet servlet, String securityRealm, String[] allowedRoles, String loginMethod) throws DME2Exception {
        try {
            ServletContextHandler context = new ServletContextHandler();
            if (securityRealm != null) {
                JAASLoginService loginService;
                block17: {
                    if (allowedRoles == null || allowedRoles.length == 0) {
                        throw new DME2Exception("AFT-DME2-0009", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet).add(SECURITY_REALM, securityRealm));
                    }
                    try {
                        LoginContext ctx = new LoginContext(securityRealm, new CallbackHandler(){

                            @Override
                            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                                for (int i = 0; i < callbacks.length; ++i) {
                                    if (callbacks[i] instanceof TextOutputCallback) continue;
                                    if (callbacks[i] instanceof NameCallback) {
                                        NameCallback nc = (NameCallback)callbacks[i];
                                        nc.setName(DME2Server.TEST);
                                        continue;
                                    }
                                    if (callbacks[i] instanceof PasswordCallback) {
                                        PasswordCallback pc = (PasswordCallback)callbacks[i];
                                        pc.setPassword(DME2Server.TEST.toCharArray());
                                        continue;
                                    }
                                    if (callbacks[i] instanceof ObjectCallback) {
                                        ObjectCallback oc = (ObjectCallback)callbacks[i];
                                        oc.setObject(DME2Server.TEST);
                                        continue;
                                    }
                                    if (callbacks[i] instanceof RequestParameterCallback) {
                                        RequestParameterCallback rpc = (RequestParameterCallback)callbacks[i];
                                        rpc.setParameterName("key");
                                        rpc.setParameterValues(new ArrayList());
                                        continue;
                                    }
                                    logger.info((URI)null, "bindServiceListener", LogMessage.SERVER_CALLBACK, (Object)callbacks[i]);
                                }
                            }
                        });
                        ctx.login();
                    }
                    catch (LoginException e) {
                        throw new DME2Exception("AFT-DME2-0012", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet).add(SECURITY_REALM, securityRealm), (Throwable)e);
                    }
                    loginService = new JAASLoginService(securityRealm);
                    try {
                        loginService.start();
                    }
                    catch (Exception e) {
                        throw new DME2Exception("AFT-DME2-0008", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet).add(SECURITY_REALM, securityRealm), (Throwable)e);
                    }
                    try {
                        loginService.login(TEST, TEST, null);
                    }
                    catch (SecurityException e) {
                        if (e.getCause() == null || !(e.getCause() instanceof IOException)) break block17;
                        throw new DME2Exception("AFT-DME2-0011", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet).add(SECURITY_REALM, securityRealm), (Throwable)e);
                    }
                }
                if (loginMethod == null) {
                    throw new DME2Exception("AFT-DME2-0009", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet).add(SECURITY_REALM, securityRealm));
                }
                if (!loginMethod.equals("BASIC") && !loginMethod.equals("CLIENT-CERT")) {
                    throw new DME2Exception("AFT-DME2-0010", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet).add(SECURITY_REALM, securityRealm));
                }
                Constraint constraint = new Constraint();
                if (loginMethod.equals("BASIC")) {
                    constraint.setName("BASIC");
                } else if (loginMethod.equals("CLIENT-CERT")) {
                    constraint.setName("CLIENT_CERT");
                }
                constraint.setRoles(allowedRoles);
                constraint.setAuthenticate(true);
                ConstraintMapping cm = new ConstraintMapping();
                cm.setConstraint(constraint);
                cm.setPathSpec("/*");
                ConstraintSecurityHandler sechandler = new ConstraintSecurityHandler();
                sechandler.setRealmName(securityRealm);
                sechandler.setLoginService(loginService);
                sechandler.addConstraintMapping(cm);
                context.setSecurityHandler(sechandler);
            }
            context.setContextPath("/");
            context.addServlet(new ServletHolder(servlet), ("/" + service).replaceAll("//", "/"));
            this.root.addHandler(context);
            try {
                context.start();
            }
            catch (Exception e) {
                throw new DME2Exception("AFT-DME2-0008", new ErrorContext().add(SERVICE, service).add(SERVLET, "" + servlet));
            }
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, service);
        }
    }

    protected Server getServer() {
        return this.server;
    }

    protected void addHandler(ServletContextHandler handler) {
        this.root.addHandler(handler);
    }

    protected void addHandler(ContextHandler handler) {
        this.websocketHandlerCollection.addHandler(handler);
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws DME2Exception {
        long start = System.currentTimeMillis();
        String defaultPort = null;
        boolean portSet = false;
        logger.debug(null, "start", LogMessage.METHOD_ENTER);
        assert (!this.running);
        String portRange = this.serverProperties.getPortRange();
        Integer connectionIdleTimeMs = this.serverProperties.getConnectionIdleTimeMs();
        Integer corePoolSize = this.serverProperties.getCorePoolSize();
        Integer maxPoolSize = this.serverProperties.getMaxPoolSize();
        Integer port = this.serverProperties.getPort();
        Integer socketAcceptorThreads = this.serverProperties.getSocketAcceptorThreads();
        Integer threadIdleTimeMs = this.serverProperties.getThreadIdleTimeMs();
        Integer requestBufferSize = this.serverProperties.getRequestBufferSize();
        Integer responseBufferSize = this.serverProperties.getResponseBufferSize();
        Boolean reuseAddress = this.serverProperties.isReuseAddress();
        Boolean useDirectBuffers = this.serverProperties.isUseDirectBuffers();
        String hostname = this.serverProperties.getHostname();
        Boolean sslEnable = this.serverProperties.isSslEnable();
        int maxQueueSize = this.serverProperties.getMaxQueueSize();
        int maxRequestPostSize = this.serverProperties.getMaxRequestPostSize();
        int maxRequestHeaderSize = this.serverProperties.getMaxRequestHeaderSize();
        logger.info(null, "start", LogMessage.SERVER_PARAMS, connectionIdleTimeMs, corePoolSize, maxPoolSize, maxQueueSize, threadIdleTimeMs, socketAcceptorThreads, requestBufferSize, responseBufferSize, useDirectBuffers, reuseAddress, maxRequestPostSize > -1 ? Integer.valueOf(maxRequestPostSize) : "", maxRequestHeaderSize > -1 ? Integer.valueOf(maxRequestHeaderSize) : "");
        try {
            String listenIp;
            String listenHost;
            block37: {
                InetAddress inetHost = hostname == null ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
                listenHost = null;
                listenIp = null;
                InetAddress ipHost = InetAddress.getByName(inetHost.getHostAddress());
                listenHost = ipHost.getCanonicalHostName();
                listenIp = hostname != null ? ipHost.getHostAddress() : "0.0.0.0";
                this.btp = new DME2QueuedThreadPool();
                this.btp.setName("DME2::ConnectorDispatchThread");
                this.btp.setMinThreads(corePoolSize);
                this.btp.setMaxThreads(maxPoolSize);
                this.btp.setDaemon(true);
                this.btp.setIdleTimeout(threadIdleTimeMs);
                if (this.server == null) {
                    this.server = new Server(this.btp);
                }
                if (this.connector == null) {
                    this.connector = this.createConnector(this.btp);
                }
                if (listenIp != null) {
                    this.connector.setHost(listenIp);
                }
                this.server.setConnectors(new Connector[]{this.connector});
                Boolean sendDateHeader = this.serverProperties.getSendDateheader();
                Boolean sendServerVersion = this.serverProperties.getSendServerversion();
                Integer gracefulShutdownTimeoutMs = this.serverProperties.getGracefulShutdownTimeMs();
                HttpConfiguration httpConfig = new HttpConfiguration();
                if (sendDateHeader != null) {
                    httpConfig.setSendDateHeader(sendDateHeader);
                }
                if (sendServerVersion != null) {
                    httpConfig.setSendServerVersion(sendServerVersion);
                }
                if (gracefulShutdownTimeoutMs != null) {
                    this.server.setStopTimeout(gracefulShutdownTimeoutMs.intValue());
                }
                this.root = new ContextHandlerCollection();
                this.websocketHandlerCollection = new HandlerCollection(true);
                if (!this.isWebSocket()) {
                    this.server.setHandler(this.root);
                } else {
                    this.server.setHandler(this.websocketHandlerCollection);
                }
                DME2ServerStopThread shutdown = DME2ServerStopThread.getInstance(this);
                shutdown.setDaemon(true);
                Runtime.getRuntime().addShutdownHook(shutdown);
                try {
                    if (this.persistedPorts != null) {
                        this.persistedPort = this.getAvailablePersistedPort(this.persistedPorts);
                        if (this.persistedPort > 0) {
                            this.connector.setPort(this.persistedPort);
                            try {
                                this.server.start();
                                if (this.server.isRunning() && ((ServerConnector)this.server.getConnectors()[0]).getPort() == this.persistedPort) {
                                    portSet = true;
                                }
                            }
                            catch (BindException be) {
                                this.connector = this.createConnector(this.btp);
                            }
                            catch (Throwable te) {
                                this.connector = this.createConnector(this.btp);
                            }
                        }
                    }
                    if (portSet) break block37;
                    if (portRange == null && port == null) {
                        portRange = this.serverProperties.isSslEnable() ? this.config.getProperty("AFT_DME2_SERVER_DEFAULT_SSL_PORT_RANGE") : this.config.getProperty("AFT_DME2_SERVER_DEFAULT_PORT_RANGE");
                    }
                    if (portRange != null) {
                        if (portRange.indexOf(DME2Constants.getPORT_RANGE_SEP()) == -1 && portRange.indexOf(DME2Constants.PORT_DEFAULT_SEP) == -1) {
                            throw new DME2Exception(PORT_RANGE_ERROR_CODE, PORT_RANGE_ERROR_MSG, new Object[0]);
                        }
                        try {
                            String[] portRangeTemp = portRange.split(DME2Constants.PORT_DEFAULT_SEP);
                            String portRangeStr = portRangeTemp[0];
                            if (portRangeTemp.length > 1) {
                                defaultPort = portRangeTemp[1];
                            }
                            String[] ports = portRangeStr.split(DME2Constants.getPORT_RANGE_SEP());
                            String startPortRange = ports[0];
                            String endPortRange = ports[1];
                            int startPortInt = Integer.parseInt(startPortRange);
                            int endPortInt = Integer.parseInt(endPortRange);
                            int getAvailablePortAttemps = 0;
                            for (int i = startPortInt; i <= endPortInt; ++i) {
                                int rPort = this.getAvailablePort(startPortInt, endPortInt);
                                if (++getAvailablePortAttemps > this.config.getInt("AFT_DME2_MAX_GETAVAIL_PORT_ATTEMPT")) break;
                                this.connector.setPort(rPort);
                                port = rPort;
                                try {
                                    this.server.start();
                                }
                                catch (BindException be) {
                                    this.connector = this.createConnector(this.btp);
                                    this.server.setConnectors(new Connector[]{this.connector});
                                    continue;
                                }
                                catch (Throwable te) {
                                    this.connector = this.createConnector(this.btp);
                                    this.server.setConnectors(new Connector[]{this.connector});
                                    continue;
                                }
                                if (!this.server.isRunning() || ((ServerConnector)this.server.getConnectors()[0]).getPort() != rPort) continue;
                                portSet = true;
                                break;
                            }
                        }
                        catch (Exception e) {
                            throw new DME2Exception("AFT-DME2-2101", new ErrorContext().add("extendedMessage", e.getMessage()).add("portRange", portRange), (Throwable)e);
                        }
                        if (!portSet) {
                            if (defaultPort == null) throw new DME2Exception("AFT-DME2-2104", new ErrorContext().add("portRange", portRange));
                            this.connector.setPort(Integer.parseInt(defaultPort));
                            this.server.start();
                        }
                        break block37;
                    }
                    if (port == null || port < 0) {
                        this.connector.setPort(0);
                        this.server.start();
                    } else {
                        this.connector.setPort(port);
                        this.server.start();
                    }
                }
                catch (DME2Exception e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DME2Exception("AFT-DME2-2102", new ErrorContext().add("extendedMessage", e.getMessage()).add("serverPort", this.connector.getPort() + ""), (Throwable)e);
                }
            }
            port = this.connector.getLocalPort();
            if (hostname == null || hostname.trim().equals("")) {
                hostname = listenIp;
            }
            this.serverProperties.setHostname(hostname);
            this.serverProperties.setPort(port);
            this.baseAddress = !this.isWebSocket() ? (sslEnable.booleanValue() ? "https://" + listenHost + ":" + port + "/" : "http://" + listenHost + ":" + port + "/") : (sslEnable != false ? "wss://" + listenHost + ":" + port + "/" : "ws://" + listenHost + ":" + port + "/");
            this.running = true;
            logger.info((URI)null, "start", LogMessage.SERVER_START, (Object)this.baseAddress);
            Collection<DME2ServiceHolder> svcs = this.getServices();
            if (svcs != null && svcs.size() > 0) {
                for (DME2ServiceHolder holder : svcs) {
                    holder.start();
                }
            }
        }
        catch (DME2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new DME2Exception("AFT-DME2-2102", new ErrorContext().add("extendedMessage", e.getMessage()).add("baseAddress", this.baseAddress), (Throwable)e);
        }
        logger.debug(null, "start", LogMessage.METHOD_EXIT);
    }

    public int getServerPoolIdleThreads() {
        assert (this.running);
        logger.debug(null, "getServerPoolIdleThreads", "DME2Server isServerLowOnThread={};serverThreads={};serverIdleThreads={}", this.server.getThreadPool().isLowOnThreads(), this.server.getThreadPool().getThreads(), this.server.getThreadPool().getIdleThreads());
        return this.server.getThreadPool().getIdleThreads();
    }

    public int getServerPoolThreads() {
        assert (this.running);
        return this.server.getThreadPool().getThreads();
    }

    public void stop() throws DME2Exception {
        logger.debug(null, "stop", LogMessage.METHOD_ENTER);
        if (this.running) {
            try {
                this.btp.stop();
            }
            catch (Exception e) {
                logger.error((URI)null, "stop", "Error stopping blocking thread pool in server", (Object)e);
            }
            finally {
                logger.debug((URI)null, "stop", "BTP state: {}", (Object)this.btp.getState());
            }
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new DME2Exception(STOP_ERROR_CODE, STOP_ERROR_MSG, (Throwable)e);
            }
            finally {
                logger.debug((URI)null, "stop", "Server state: {}", (Object)this.server.getState());
            }
        }
        logger.warn(null, "stop", LogMessage.SERVER_STOP_WARN);
        this.connector = null;
        this.server = null;
        this.running = false;
        logger.debug(null, "stop", LogMessage.METHOD_EXIT);
    }

    public void unbindServiceListener(String service) {
        if (this.root.getHandlers() == null) {
            return;
        }
        for (Handler h : this.root.getHandlers()) {
            ContextHandler ch;
            if (!(h instanceof ContextHandler) || !(ch = (ContextHandler)h).getContextPath().equals(("/" + service).replaceAll("//", "/"))) continue;
            this.root.removeHandler(ch);
        }
    }

    public void addService(DME2ServiceHolder holder) throws DME2Exception {
        block11: {
            try {
                if (holder == null) break block11;
                if (holder.getContext() == null) {
                    try {
                        String servicePath = holder.getServiceURI();
                        DmeUniformResource uniformResouce = null;
                        try {
                            uniformResouce = new DmeUniformResource(this.config, servicePath);
                        }
                        catch (MalformedURLException e) {
                            if (!servicePath.startsWith("/")) {
                                servicePath = "/" + servicePath;
                            }
                            String completeServiceURI = null;
                            completeServiceURI = !servicePath.startsWith("http://") && !servicePath.startsWith("dme2://") ? "http://DME2LOCAL" + servicePath : servicePath;
                            uniformResouce = new DmeUniformResource(this.config, completeServiceURI);
                        }
                        if (holder.getDme2WebSocketHandler() != null && holder.getContext() == null) {
                            holder.setContext(uniformResouce.getPath());
                        }
                        if (uniformResouce != null && uniformResouce.getBindContext() != null) {
                            holder.setContext(uniformResouce.getBindContext());
                        }
                        logger.debug((URI)null, "addService", "Throttle Pct Per Partner: {}", (Object)uniformResouce.getThrottlePctPerPartner());
                        holder.setThrottlePctPerPartner(uniformResouce.getThrottlePctPerPartner());
                        holder.setThrottleFilterDisabled(uniformResouce.getThrottleFilterDisabled());
                    }
                    catch (Exception e) {
                        logger.warn((URI)null, "addService", "AFT-DME2-2103", (Object)new ErrorContext().add("ServiceURI", holder.getServiceURI()), (Object)e);
                    }
                }
                this.services.put(holder.getServiceURI(), holder);
                holder.setServer(this);
                if (this.running) {
                    holder.start();
                }
            }
            catch (Exception e) {
                DME2ExceptionHandler.handleException(e, holder.getServiceURI());
            }
        }
    }

    public Collection<DME2ServiceHolder> getServices() {
        return this.services.values();
    }

    public void removeService(DME2ServiceHolder newHolder) throws DME2Exception {
        DME2ServiceHolder holder = newHolder;
        if ((holder = this.services.get(holder.getServiceURI())) != null) {
            if (holder.isActive()) {
                holder.stop();
            }
            this.services.remove(holder.getServiceURI());
        }
    }

    public DME2ServiceHolder getService(String serviceURI) {
        return this.services.get(serviceURI);
    }

    public String getPersistedPorts() {
        return this.persistedPorts;
    }

    public void setPersistedPorts(String persistedPorts) {
        this.persistedPorts = persistedPorts;
    }

    private int getAvailablePort(int aStart, int aEnd) {
        if (aStart > aEnd) {
            throw new IllegalArgumentException("Start cannot exceed End.");
        }
        if (aEnd - aStart <= this.config.getInt("AFT_DME2_GETAVAIL_PORT_RANGE")) {
            for (int i = aStart; i <= aEnd; ++i) {
                if (!this.available(i)) continue;
                return i;
            }
            return aEnd;
        }
        long range = (long)aEnd - (long)aStart + 1L;
        Random aRandom = new Random();
        int port = 0;
        if (port == 0) {
            while ((port = (int)((long)((double)range * aRandom.nextDouble()) + (long)aStart)) <= aEnd && !this.available(port)) {
            }
        }
        return port;
    }

    private int getAvailablePersistedPort(String persistedPorts) {
        int defport = 0;
        if (persistedPorts == null) {
            return 0;
        }
        String[] ports = persistedPorts.split(",");
        for (int i = 0; i < ports.length; ++i) {
            try {
                int port = Integer.parseInt(ports[i]);
                if (!this.available(port)) continue;
                return port;
            }
            catch (NumberFormatException nfe) {
                logger.debug((URI)null, "getAvailablePersistedPort", LogMessage.DEBUG_MESSAGE, (Object)"NumberFormatException", (Object)nfe);
            }
        }
        return defport;
    }

    private ServerConnector createConnector(DME2QueuedThreadPool btp) throws UnknownHostException {
        Integer connectionIdleTimeMs = this.serverProperties.getConnectionIdleTimeMs();
        Integer socketAcceptorThreads = this.serverProperties.getSocketAcceptorThreads();
        Integer requestBufferSize = this.serverProperties.getRequestBufferSize();
        Integer responseBufferSize = this.serverProperties.getResponseBufferSize();
        Boolean reuseAddress = this.serverProperties.isReuseAddress();
        Boolean useDirectBuffers = this.serverProperties.isUseDirectBuffers();
        String hostname = this.serverProperties.getHostname();
        Boolean sslEnable = this.serverProperties.isSslEnable();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setRequestHeaderSize(this.serverProperties.getMaxRequestHeaderSize());
        if (requestBufferSize != null) {
            // empty if block
        }
        if (responseBufferSize != null) {
            httpConfiguration.setOutputBufferSize(responseBufferSize);
        }
        httpConfiguration.setRequestHeaderSize(this.serverProperties.getMaxRequestHeaderSize());
        if (this.config.getBoolean("AFT_DME2_CONFIGURE_CUSTOM_CONNECTOR")) {
            if (sslEnable.booleanValue()) {
                // empty if block
            }
        } else if (sslEnable.booleanValue()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            this.configureSsl(sslContextFactory);
            this.connector = new ServerConnector(this.server, sslContextFactory, new HttpConnectionFactory(httpConfiguration));
        } else {
            this.connector = new ServerConnector(this.server, (int)socketAcceptorThreads, (int)socketAcceptorThreads, new HttpConnectionFactory(httpConfiguration));
        }
        InetAddress inetHost = hostname == null ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
        String listenIp = null;
        InetAddress ipHost = InetAddress.getByName(inetHost.getHostAddress());
        listenIp = hostname != null ? ipHost.getHostAddress() : "0.0.0.0";
        if (listenIp != null) {
            this.connector.setHost(listenIp);
        }
        this.connector.setIdleTimeout(connectionIdleTimeMs.intValue());
        this.connector.setReuseAddress(reuseAddress);
        this.server.setConnectors(new Connector[]{this.connector});
        return this.connector;
    }

    private void configureSsl(SslContextFactory cf) {
        String keystore = this.serverProperties.getKeyStore();
        String keystorePw = this.serverProperties.getConfig().getProperty(KEY_KEYSTORE_PASSWORD);
        String truststore = this.serverProperties.getTrustStore();
        String truststorePw = this.serverProperties.getConfig().getProperty(KEY_TRUSTSTORE_PASSWORD);
        String keyPw = this.serverProperties.getConfig().getProperty(KEY_PASSWORD);
        Boolean allowRenegotiate = this.serverProperties.isAllowRenegotiate();
        Boolean trustAll = this.serverProperties.getSslTrustAll();
        String certAlias = this.serverProperties.getSslCertAlias();
        Boolean needClientAuth = this.serverProperties.getNeedClientAuth();
        Boolean wantClientAuth = this.serverProperties.getWantClientAuth();
        Boolean enableSessionCaching = this.serverProperties.isEnableSessionCaching();
        Integer sslSessionCacheSize = this.serverProperties.getSslSessionCacheSize();
        Integer sslSessionTimeout = this.serverProperties.getSslSessionTimeout();
        Boolean validatePeerCerts = this.serverProperties.isSslValidatePeerCerts();
        Boolean validateCerts = this.serverProperties.isValidateCerts();
        String[] excludeProtocols = this.serverProperties.getExcludeProtocols();
        String[] excludeCipherSuites = this.serverProperties.getExcludeCiperSuites();
        String[] includeProtocols = this.serverProperties.getIncludeProtocols();
        String[] includeCipherSuites = this.serverProperties.getIncludeCiperSuites();
        if (keystore != null) {
            cf.setKeyStorePath(keystore);
        }
        if (keystorePw != null) {
            cf.setKeyStorePassword(keystorePw);
        }
        if (keyPw != null) {
            cf.setKeyManagerPassword(keyPw);
        }
        if (trustAll != null) {
            cf.setTrustAll(trustAll);
        }
        if (certAlias != null) {
            cf.setCertAlias(certAlias);
        }
        if (needClientAuth != null) {
            cf.setNeedClientAuth(needClientAuth);
        }
        if (wantClientAuth != null) {
            cf.setWantClientAuth(wantClientAuth);
        }
        if (enableSessionCaching != null) {
            cf.setSessionCachingEnabled(enableSessionCaching);
        }
        if (sslSessionCacheSize != null) {
            cf.setSslSessionCacheSize(sslSessionCacheSize);
        }
        if (sslSessionTimeout != null) {
            cf.setSslSessionTimeout(sslSessionTimeout);
        }
        if (validatePeerCerts != null) {
            cf.setValidatePeerCerts(validatePeerCerts);
        }
        if (validateCerts != null) {
            cf.setValidateCerts(validateCerts);
        }
        if (truststore != null) {
            cf.setTrustStorePassword(truststorePw);
        } else {
            cf.setTrustStorePassword(keystorePw);
        }
        if (excludeProtocols != null) {
            cf.setExcludeProtocols(excludeProtocols);
        }
        if (includeProtocols != null) {
            cf.setIncludeProtocols(includeProtocols);
        }
        if (excludeCipherSuites != null) {
            cf.setExcludeCipherSuites(excludeCipherSuites);
        }
        if (includeCipherSuites != null) {
            cf.setIncludeCipherSuites(includeCipherSuites);
        }
        cf.setRenegotiationAllowed(allowRenegotiate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean available(int port) {
        logger.debug((URI)null, "available", "DME2Server.available;Trying available for {}", (Object)port);
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.debug((URI)null, "available", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    logger.debug((URI)null, "available", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e);
                }
            }
        }
        return false;
    }

    public String[] getSSLExcludeProtocol() {
        if (this.server != null && this.server.isRunning()) {
            Connector[] cs;
            for (Connector conn : cs = this.server.getConnectors()) {
                if (!(conn instanceof DME2SslSelectChannelConnector)) continue;
                DME2SslSelectChannelConnector sslc = (DME2SslSelectChannelConnector)conn;
                return sslc.getSslContextFactory().getExcludeProtocols();
            }
        }
        return null;
    }

    public HandlerCollection getWebsocketHandlerCollection() {
        return this.websocketHandlerCollection;
    }

    public void setWebsocketHandlerCollection(HandlerCollection websocketHandlerCollection) {
        this.websocketHandlerCollection = websocketHandlerCollection;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    public DME2ServerProperties getServerProperties() {
        return this.serverProperties;
    }
}

