/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.config.DME2Configuration;

public class DME2ServerProperties {
    private static final String KEY_PORT_RANGE = "AFT_DME2_PORT_RANGE";
    private static final String KEY_CONN_IDLE_TIMEOUTMS = "AFT_DME2_CONN_IDLE_TIMEOUTMS";
    private static final String KEY_CORE_POOL_SIZE = "AFT_DME2_CORE_POOL_SIZE";
    private static final String KEY_MAX_POOL_SIZE = "AFT_DME2_MAX_POOL_SIZE";
    private static final String KEY_PORT = "AFT_DME2_PORT";
    private static final String KEY_SOCKET_ACCEPTOR_THREADS = "AFT_DME2_SOCKET_ACCEPTOR_THREADS";
    private static final String KEY_THREAD_IDLE_TIME_MS = "AFT_DME2_THREAD_IDLE_TIME_MS";
    private static final String KEY_REQUEST_BUFFER_SIZE = "AFT_DME2_REQUEST_BUFFER_SIZE";
    private static final String KEY_RESPONSE_BUFFER_SIZE = "AFT_DME2_RESPONSE_BUFFER_SIZE";
    private static final String KEY_REUSE_ADDRESS = "AFT_DME2_REUSE_ADDRESS";
    private static final String KEY_USE_DIRECT_BUFFERS = "AFT_DME2_USE_DIRECT_BUFFERS";
    private static final String KEY_HOSTNAME = "AFT_DME2_HOSTNAME";
    private static final String KEY_SEND_DATEHEADER = "AFT_DME2_SEND_DATEHEADER";
    private static final String KEY_SEND_SERVERVERSION = "AFT_DME2_SEND_SERVERVERSION";
    private static final String KEY_GRACEFUL_SHUTDOWN_TIME_MS = "AFT_DME2_GRACEFUL_SHUTDOWN_TIME_MS";
    private static final String KEY_SSL_ENABLE = "AFT_DME2_SSL_ENABLE";
    private static final String KEY_ALLOW_RENEG = "AFT_DME2_ALLOW_RENEGOTIATE";
    private static final String KEY_KEYSTORE = "AFT_DME2_KEYSTORE";
    private static final String KEY_TRUSTSTORE = "AFT_DME2_TRUSTSTORE";
    private static final String KEY_MAX_QUEUE_SIZE = "AFT_DME2_MAX_QUEUE_SIZE";
    private static final String KEY_MAX_REQUEST_POST_SIZE = "AFT_DME2_MAX_REQUEST_POST_SIZE";
    private static final String KEY_MAX_REQUEST_HEADER_SIZE = "AFT_DME2_MAX_REQUEST_HEADER_SIZE";
    private static final String KEY_SSL_TRUST_ALL = "AFT_DME2_SSL_TRUST_ALL";
    private static final String KEY_SSL_CERT_ALIAS = "AFT_DME2_SSL_CERT_ALIAS";
    private static final String KEY_SSL_NEED_CLIENT_AUTH = "AFT_DME2_SSL_NEED_CLIENT_AUTH";
    private static final String KEY_SSL_WANT_CLIENT_AUTH = "AFT_DME2_SSL_WANT_CLIENT_AUTH";
    private static final String KEY_SSL_ENABLED_SESSION_CACHING = "AFT_DME2_SSL_ENABLED_SESSION_CACHING";
    private static final String KEY_SSL_SESSION_CACHE_SIZE = "AFT_DME2_SSL_SESSION_CACHE_SIZE";
    private static final String KEY_SSL_SESSION_TIMEOUT = "AFT_DME2_SSL_SESSION_TIMEOUT";
    private static final String KEY_SSL_VALIDATE_PEER_CERTS = "AFT_DME2_SSL_VALIDATE_PEER_CERTS";
    private static final String KEY_SSL_VALIDATE_CERTS = "AFT_DME2_SSL_VALIDATE_CERTS";
    private static final String KEY_SSL_EXCLUDE_PROTOCOLS = "AFT_DME2_SSL_EXCLUDE_PROTOCOLS";
    private static final String KEY_SSL_EXCLUDE_CIPHERSUITES = "AFT_DME2_SSL_EXCLUDE_CIPHERSUITES";
    private static final String KEY_SSL_INCLUDE_PROTOCOLS = "AFT_DME2_SSL_INCLUDE_PROTOCOLS";
    private static final String KEY_SSL_INCLUDE_CIPHERSUITES = "AFT_DME2_SSL_INCLUDE_CIPHERSUITES";
    private DME2Configuration config;
    private String hostName;
    private int maxPoolSize;
    private Integer port;
    private int corePoolSize;
    private int connectionIdleTime;
    private String portRange;
    private int requestBufferSize;
    private int responseBufferSize;
    private int socketAcceptorThread;
    private int gracefulShutdownTimeMs;
    private int threadIdleTimeMs;
    private boolean reuseAddress;
    private boolean sslEnable;
    private boolean useDirectBuffers;
    private int maxQueueSize;
    private boolean allowRange;
    private int maxRequestHeaderSize;
    private int maxRequestPostSize;
    private String trustStore;
    private String keyStore;
    private boolean validCertificate;
    private boolean validSslCertificate;
    private int sslSessiontimeout;
    private int sslSessionCacheSize;
    private boolean sslSessionCaching;

    public DME2ServerProperties(DME2Configuration config) {
        this.config = config;
    }

    public int getConnectionIdleTimeMs() {
        return this.config.getInt(KEY_CONN_IDLE_TIMEOUTMS, this.connectionIdleTime);
    }

    public int getCorePoolSize() {
        return this.config.getInt(KEY_CORE_POOL_SIZE, this.corePoolSize);
    }

    public String getHostname() {
        return this.config.getProperty(KEY_HOSTNAME, this.hostName);
    }

    public int getMaxPoolSize() {
        return this.config.getInt(KEY_MAX_POOL_SIZE, this.maxPoolSize);
    }

    public Integer getPort() {
        return this.config.getInteger(KEY_PORT, this.port);
    }

    public int getRequestBufferSize() {
        return this.config.getInt(KEY_REQUEST_BUFFER_SIZE, this.requestBufferSize);
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.config.getInt(KEY_RESPONSE_BUFFER_SIZE, this.responseBufferSize);
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public String getPortRange() {
        return this.config.getProperty(KEY_PORT_RANGE, this.portRange);
    }

    public int getSocketAcceptorThreads() {
        return this.config.getInt(KEY_SOCKET_ACCEPTOR_THREADS, this.socketAcceptorThread);
    }

    public int getThreadIdleTimeMs() {
        return this.config.getInt(KEY_THREAD_IDLE_TIME_MS, this.threadIdleTimeMs);
    }

    public void setConnectionIdleTimeMs(int connectionIdleTimeMs) {
        this.connectionIdleTime = connectionIdleTimeMs;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setHostname(String host) {
        this.hostName = host;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setPortRange(String portRange) {
        this.portRange = portRange;
    }

    public void setSocketAcceptorThreads(int socketAcceptorThreads) {
        this.socketAcceptorThread = socketAcceptorThreads;
    }

    public void setThreadIdleTimeMs(int threadIdleTimeMs) {
        this.threadIdleTimeMs = threadIdleTimeMs;
    }

    public void setGracefulShutdownTimeMs(int gracefulShutdownTimeMs) {
        this.gracefulShutdownTimeMs = gracefulShutdownTimeMs;
    }

    public boolean isUseDirectBuffers() {
        return this.config.getBoolean(KEY_USE_DIRECT_BUFFERS, this.useDirectBuffers);
    }

    public void setUseDirectBuffers(boolean useDirectBuffers) {
        this.useDirectBuffers = useDirectBuffers;
    }

    public boolean isReuseAddress() {
        return this.config.getBoolean(KEY_REUSE_ADDRESS, this.reuseAddress);
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isSslEnable() {
        return this.config.getBoolean(KEY_SSL_ENABLE, this.sslEnable);
    }

    public void setSslEnable(boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public int getMaxRequestHeaderSize() {
        return this.config.getInt(KEY_MAX_REQUEST_HEADER_SIZE, this.maxRequestHeaderSize);
    }

    public int getMaxRequestPostSize() {
        return this.config.getInt(KEY_MAX_REQUEST_POST_SIZE, this.maxRequestPostSize);
    }

    public int getMaxQueueSize() {
        return this.config.getInt(KEY_MAX_QUEUE_SIZE, this.maxQueueSize);
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Boolean isAllowRenegotiate() {
        return this.config.getBoolean(KEY_ALLOW_RENEG, this.allowRange);
    }

    public void setAllowRenegotiate(Boolean allowRange) {
        this.allowRange = allowRange;
    }

    public String getTrustStore() {
        return this.config.getProperty(KEY_TRUSTSTORE, this.trustStore);
    }

    public String getKeyStore() {
        return this.config.getProperty(KEY_KEYSTORE, this.keyStore);
    }

    public String[] getExcludeProtocols() {
        return this.getPropsArray(KEY_SSL_EXCLUDE_PROTOCOLS);
    }

    public String[] getIncludeProtocols() {
        return this.getPropsArray(KEY_SSL_INCLUDE_PROTOCOLS);
    }

    public String[] getExcludeCiperSuites() {
        return this.getPropsArray(KEY_SSL_EXCLUDE_CIPHERSUITES);
    }

    public String[] getIncludeCiperSuites() {
        return this.getPropsArray(KEY_SSL_INCLUDE_CIPHERSUITES);
    }

    private String[] getPropsArray(String key) {
        String temp = this.config.getProperty(key);
        if (temp != null) {
            return temp.split(",");
        }
        return null;
    }

    public Boolean isValidateCerts() {
        return this.config.getBoolean(KEY_SSL_VALIDATE_CERTS, this.validCertificate);
    }

    public Boolean isSslValidatePeerCerts() {
        return this.config.getBoolean(KEY_SSL_VALIDATE_PEER_CERTS, this.validSslCertificate);
    }

    public Integer getSslSessionTimeout() {
        return new Integer(this.config.getInt(KEY_SSL_SESSION_TIMEOUT, this.sslSessiontimeout));
    }

    public Integer getSslSessionCacheSize() {
        return new Integer(this.config.getInt(KEY_SSL_SESSION_CACHE_SIZE, this.sslSessionCacheSize));
    }

    public Boolean isEnableSessionCaching() {
        return this.config.getBoolean(KEY_SSL_ENABLED_SESSION_CACHING, this.sslSessionCaching);
    }

    public Boolean getWantClientAuth() {
        return this.config.getBoolean(KEY_SSL_WANT_CLIENT_AUTH);
    }

    public Boolean getNeedClientAuth() {
        return this.config.getBoolean(KEY_SSL_NEED_CLIENT_AUTH);
    }

    public String getSslCertAlias() {
        return this.config.getProperty(KEY_SSL_CERT_ALIAS);
    }

    public Boolean getSslTrustAll() {
        return this.config.getBoolean(KEY_SSL_TRUST_ALL);
    }

    public Boolean getSendDateheader() {
        return this.config.getBoolean(KEY_SEND_DATEHEADER);
    }

    public Boolean getSendServerversion() {
        return this.config.getBoolean(KEY_SEND_SERVERVERSION);
    }

    public Integer getGracefulShutdownTimeMs() {
        return new Integer(this.config.getInt(KEY_GRACEFUL_SHUTDOWN_TIME_MS, this.gracefulShutdownTimeMs));
    }

    public DME2Configuration getConfig() {
        return this.config;
    }
}

