/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.DME2Server;
import com.att.aft.dme2.api.util.DME2FilterHolder;
import com.att.aft.dme2.api.util.DME2ServletHolder;
import com.att.aft.dme2.api.util.DME2ThrottleFilter;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.lang.exception.ExceptionUtils;
import com.att.aft.dme2.internal.jetty.jaas.JAASLoginService;
import com.att.aft.dme2.internal.jetty.jaas.callback.ObjectCallback;
import com.att.aft.dme2.internal.jetty.jaas.callback.RequestParameterCallback;
import com.att.aft.dme2.internal.jetty.security.ConstraintMapping;
import com.att.aft.dme2.internal.jetty.security.ConstraintSecurityHandler;
import com.att.aft.dme2.internal.jetty.server.handler.ContextHandler;
import com.att.aft.dme2.internal.jetty.server.handler.gzip.GzipHandler;
import com.att.aft.dme2.internal.jetty.servlet.ServletContextHandler;
import com.att.aft.dme2.internal.jetty.servlet.ServletHolder;
import com.att.aft.dme2.internal.jetty.servlets.GzipFilter;
import com.att.aft.dme2.internal.jetty.util.security.Constraint;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketListener;
import com.att.aft.dme2.internal.jetty.websocket.server.WebSocketHandler;
import com.att.aft.dme2.internal.jetty.websocket.servlet.WebSocketServletFactory;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.server.api.websocket.DME2ServerWebSocket;
import com.att.aft.dme2.server.api.websocket.DME2ServerWebSocketHandler;
import com.att.aft.dme2.server.api.websocket.GRMHealthCheckServerWebSocket;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2ExceptionHandler;
import com.att.aft.dme2.util.ErrorContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class DME2ServiceHolder {
    private String context;
    private String serviceURI;
    private String realm;
    private String loginMethod;
    private String[] allowedRoles;
    private Properties contextParams;
    private DME2Server server;
    private DME2Manager manager;
    private Servlet servlet;
    private final boolean active = false;
    private DME2Configuration config;
    private boolean metricsFilterDisabled;
    private List<String> serviceAliases;
    private List<DME2FilterHolder> filters;
    private List<DME2ServletHolder> servletHolders;
    private List<ServletContextListener> contextListeners;
    private GzipHandler gzipHandler = null;
    private static Object serverLock = new Object();
    private static final Logger logger = LoggerFactory.getLogger(DME2ServiceHolder.class);
    private static final String SECURITY_REALM = "securityRealm";
    private static final String SERVLET = "servlet";
    private static final String SERVICE = "service";
    private static final String TEST = "test";
    private DME2ServerWebSocketHandler dme2WebSocketHandler;
    private Float throttlePctPerPartner;
    private Boolean throttleFilterDisabled;
    private Properties serviceProperties;

    public Properties getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Properties props) {
        this.serviceProperties = props;
    }

    public DME2ServerWebSocketHandler getDme2WebSocketHandler() {
        return this.dme2WebSocketHandler;
    }

    public void setDme2WebSocketHandler(DME2ServerWebSocketHandler dme2WebSocketHandler) {
        this.dme2WebSocketHandler = dme2WebSocketHandler;
    }

    public void setManager(DME2Manager manager) {
        this.manager = manager;
        this.config = manager.getConfig();
        this.serviceProperties = manager.getServiceProperties();
        this.metricsFilterDisabled = this.config.getBoolean(DME2Constants.AFT_DME2_DISABLE_METRICS_FILTER);
    }

    public DME2Manager getManager() {
        return this.manager;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServiceURI(String serviceURI) {
        this.serviceURI = serviceURI;
    }

    public void setServiceAliases(List<String> serviceAliases) {
        this.serviceAliases = serviceAliases;
    }

    public List<String> getServiceAliases() {
        return this.serviceAliases;
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void setSecurityRealm(String realm) {
        this.realm = realm;
    }

    public String getSecurityRealm() {
        return this.realm;
    }

    public void setAllowedRoles(String[] newAllowedRoles) {
        this.allowedRoles = newAllowedRoles == null ? null : Arrays.copyOf(newAllowedRoles, newAllowedRoles.length);
    }

    public String[] getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    public String getLoginMethod() {
        return this.loginMethod;
    }

    public void setFilters(List<DME2FilterHolder> filterBeans) {
        this.filters = filterBeans;
    }

    public List<DME2FilterHolder> getFilters() {
        return this.filters;
    }

    public void setServletHolders(List<DME2ServletHolder> servlets) {
        this.servletHolders = servlets;
    }

    public List<DME2ServletHolder> getServletHolders() {
        return this.servletHolders;
    }

    public void setContextListeners(List<ServletContextListener> contextListeners) {
        this.contextListeners = contextListeners;
    }

    public List<ServletContextListener> getContextListeners() {
        return this.contextListeners;
    }

    public boolean isActive() {
        return false;
    }

    public DME2Server getServer() {
        return this.server;
    }

    public void setServer(DME2Server server) {
        this.server = server;
    }

    public boolean isMetricsFilterEnabled() {
        return !this.metricsFilterDisabled;
    }

    public void enableMetricsFilter() {
        this.metricsFilterDisabled = false;
    }

    public void disableMetricsFilter() {
        this.metricsFilterDisabled = true;
    }

    public Properties getContextParams() {
        return this.contextParams;
    }

    public void setContextParams(Properties contextParams) {
        this.contextParams = contextParams;
    }

    public Float getThrottlePctPerPartner() {
        return this.throttlePctPerPartner;
    }

    public void setThrottlePctPerPartner(Float throttlePctPerPartner) {
        this.throttlePctPerPartner = throttlePctPerPartner;
    }

    public Boolean getThrottleFilterDisabled() {
        return this.throttleFilterDisabled;
    }

    public void setThrottleFilterDisabled(Boolean throttleFilterDisabled) {
        this.throttleFilterDisabled = throttleFilterDisabled;
    }

    private WebSocketHandler createWebSocketHandler(final DME2ServerWebSocketHandler webSocketHandler, final DME2Manager dme2Manager) throws DME2Exception {
        WebSocketHandler websocketHandler = new WebSocketHandler(){

            public WebSocketListener doWebSocketConnect(HttpServletRequest request, String protocol) {
                WebSocketListener webSocket = null;
                String trackingId = request.getParameter("dme2_tracking_id");
                if (trackingId == null) {
                    trackingId = DME2ServiceHolder.getTrackingId();
                }
                try {
                    Cookie[] cookies = request.getCookies();
                    boolean isHealthCheck = false;
                    for (Cookie cookie : cookies) {
                        if (!"healthcheck".equals(cookie.getName())) continue;
                        if ("healthcheck".equals(cookie.getValue())) {
                            isHealthCheck = true;
                            break;
                        }
                        ErrorContext ec = new ErrorContext();
                        ec.add("Code", "DME2Server.Fault");
                        throw new DME2Exception("AFT-DME2-6712", ec);
                    }
                    webSocket = isHealthCheck ? new GRMHealthCheckServerWebSocket() : new DME2ServerWebSocket(webSocketHandler, dme2Manager, trackingId);
                }
                catch (Exception e) {
                    ErrorContext ec = new ErrorContext();
                    ec.add("Code", "DME2Server.Fault");
                    ec.add("extendedMessage", e.getMessage());
                    ec.add("StackTrace", ExceptionUtils.getStackTrace(e));
                    logger.info((URI)null, "createWebSocketHandler", LogMessage.WS_SERVER_WEBSOCKET_HEALTHCHECK_EXCEPTION, (Object)ec);
                }
                return webSocket;
            }

            @Override
            public void configure(WebSocketServletFactory factory) {
            }
        };
        return websocketHandler;
    }

    private static String getTrackingId() {
        return "WS_SERVER_ID_" + UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws DME2Exception {
        try {
            if (this.server == null) {
                throw new DME2Exception("AFT-DME2-0013", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm));
            }
            if (!this.server.isRunning()) {
                throw new DME2Exception("AFT-DME2-0014", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm));
            }
            if (this.getDme2WebSocketHandler() != null) {
                WebSocketHandler websocketHandler = this.createWebSocketHandler(this.getDme2WebSocketHandler(), this.getManager());
                ContextHandler context = new ContextHandler();
                String contextPath = this.getContext();
                if (contextPath == null) {
                    context.setContextPath("/");
                } else {
                    context.setContextPath(contextPath);
                }
                context.setHandler(websocketHandler);
                Object object = serverLock;
                synchronized (object) {
                    this.server.addHandler(context);
                    try {
                        context.start();
                    }
                    catch (Exception e) {
                        throw new DME2Exception("AFT-DME2-6714", new ErrorContext().add(SERVICE, this.serviceURI).add("WEBSOCKET HANDLER", "" + websocketHandler));
                    }
                }
                this.manager.publish(this);
                return;
            }
            ServletContextHandler con = new ServletContextHandler();
            con.setMaxFormContentSize(this.server.getServerProperties().getMaxRequestPostSize());
            if (this.realm != null) {
                this.checkForValidJAASConfiguration(con);
            }
            if (this.getContext() != null) {
                con.setContextPath(this.getContext());
            } else {
                con.setContextPath("/");
            }
            logger.debug((URI)null, "start", "config.getBoolean(DME2Constants.DME2_ENABLE_PAYLOAD_COMPRESSION_THRESH_KEY) : {}", (Object)this.config.getBoolean("DME2_ENABLE_PAYLOAD_COMPRESSION_THRESH"));
            if (this.config.getBoolean("DME2_ENABLE_PAYLOAD_COMPRESSION_THRESH") && !this.disableCompressionForServiceOverride()) {
                String serviceString = this.getServiceString();
                if (!serviceString.startsWith("/")) {
                    serviceString = "/" + serviceString;
                }
                this.gzipHandler = this.createGZIPHandler(con, serviceString);
                con.setGzipHandler(this.gzipHandler);
                logger.info((URI)null, "start", LogMessage.DEBUG_MESSAGE, (Object)"GZIP filter enabled for service: {}", (Object)this.getServiceString());
            }
            if (!this.metricsFilterDisabled) {
                logger.debug((URI)null, "start", LogMessage.ADD_METRICS_FILTER, (Object)this.serviceURI);
                this.createMetricsFilter(con);
            }
            this.addThrottleFilter(con);
            Properties conParams = this.getContextParams();
            if (conParams != null) {
                Enumeration<Object> en = conParams.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = conParams.getProperty(key);
                    con.setInitParameter(key, value);
                }
            }
            if (this.servletHolders != null && this.servletHolders.size() > 0) {
                ArrayList<String> servletMappings = new ArrayList<String>();
                for (DME2ServletHolder dme2holder : this.servletHolders) {
                    String servletMapping;
                    String servletContextToRegister = dme2holder.getContextPath();
                    if (servletContextToRegister == null) {
                        servletMapping = ("/" + this.serviceURI).replaceAll("//", "/");
                        con.addServlet(dme2holder.getServletHolder(), servletMapping);
                    } else {
                        servletMapping = ("/" + servletContextToRegister).replaceAll("//", "/");
                        con.addServlet(dme2holder.getServletHolder(), servletMapping);
                    }
                    servletMappings.add(servletMapping);
                    if (dme2holder.getURLMapping() == null) continue;
                    String[] urlMapping = dme2holder.getURLMapping();
                    for (int i = 0; i < urlMapping.length; ++i) {
                        if (servletMappings.contains(urlMapping[i])) continue;
                        con.addServlet(dme2holder.getServletHolder(), urlMapping[i]);
                    }
                }
            } else if (this.context == null) {
                if (this.serviceURI.contains("?")) {
                    String[] tokens = this.serviceURI.split("\\?");
                    con.addServlet(new ServletHolder(this.servlet), ("/" + tokens[0]).replaceAll("//", "/"));
                } else {
                    con.addServlet(new ServletHolder(this.servlet), ("/" + this.serviceURI).replaceAll("//", "/"));
                }
            } else {
                con.addServlet(new ServletHolder(this.servlet), ("/" + this.context).replaceAll("//", "/"));
            }
            if (this.contextListeners != null) {
                for (ServletContextListener scl : this.contextListeners) {
                    con.addEventListener((EventListener)scl);
                }
            }
            if (this.filters != null) {
                for (DME2FilterHolder fh : this.filters) {
                    con.addFilter(fh.getFilterHolder(), fh.getFilterPattern(), fh.getDispatcherType());
                }
            }
            Object object = serverLock;
            synchronized (object) {
                this.server.addHandler(con);
                con.getServletHandler().setEnsureDefaultServlet(false);
                try {
                    con.start();
                }
                catch (Exception e) {
                    throw new DME2Exception("AFT-DME2-0008", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet));
                }
            }
            this.manager.publish(this);
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, this.serviceURI);
        }
    }

    public void stop() throws DME2Exception {
        this.server.unbindServiceListener(this.getServiceURI());
        this.manager.unpublish(this);
    }

    private void createMetricsFilter(ServletContextHandler context) {
        ArrayList<DispatcherType> dlist = new ArrayList<DispatcherType>();
        dlist.add(DispatcherType.REQUEST);
        dlist.add(DispatcherType.FORWARD);
        dlist.add(DispatcherType.ASYNC);
    }

    private void addThrottleFilter(ServletContextHandler context) {
        ArrayList<DME2FilterHolder.RequestDispatcherType> dlist1 = new ArrayList<DME2FilterHolder.RequestDispatcherType>();
        dlist1.add(DME2FilterHolder.RequestDispatcherType.REQUEST);
        dlist1.add(DME2FilterHolder.RequestDispatcherType.FORWARD);
        dlist1.add(DME2FilterHolder.RequestDispatcherType.ASYNC);
        String serviceString = this.getServiceString();
        if (!serviceString.startsWith("/")) {
            serviceString = "/" + serviceString;
        }
        DME2FilterHolder filterHolder = new DME2FilterHolder(new DME2ThrottleFilter(this), serviceString, EnumSet.copyOf(dlist1));
        context.addFilter(filterHolder.getFilterHolder(), filterHolder.getFilterPattern(), filterHolder.getDispatcherType());
    }

    public int getMaxPoolSize() {
        logger.debug((URI)null, "getMaxPoolSize", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter servlet max pool size called");
        return this.server.getServerProperties().getMaxPoolSize();
    }

    private GzipHandler createGZIPHandler(ServletContextHandler context, String patterns) {
        ArrayList<DME2FilterHolder.RequestDispatcherType> dispTypeList = new ArrayList<DME2FilterHolder.RequestDispatcherType>();
        dispTypeList.add(DME2FilterHolder.RequestDispatcherType.REQUEST);
        dispTypeList.add(DME2FilterHolder.RequestDispatcherType.FORWARD);
        dispTypeList.add(DME2FilterHolder.RequestDispatcherType.ASYNC);
        String mimeTypes = this.config.getProperty("DME2_COMPRESSION_ACCEPTABLE_MIME_TYPES");
        String[] mimes = mimeTypes != null ? mimeTypes.split(",") : new String[]{};
        int minGzipSize = this.config.getInt("DME2_PAYLOAD_COMPRESSION_THRESH_SIZE");
        Properties params = new Properties();
        params.put("mimeTypes", mimeTypes);
        params.put("minGzipSize", String.valueOf(minGzipSize));
        params.put("methods", "GET,POST,PUT");
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMimeTypes(mimes);
        gzipHandler.addIncludedMethods("GET", "POST", "PUT");
        gzipHandler.setMinGzipSize(minGzipSize);
        gzipHandler.setIncludedPaths(patterns);
        return gzipHandler;
    }

    private DME2FilterHolder createGZIPFilter() {
        ArrayList<DME2FilterHolder.RequestDispatcherType> dispTypeList = new ArrayList<DME2FilterHolder.RequestDispatcherType>();
        dispTypeList.add(DME2FilterHolder.RequestDispatcherType.REQUEST);
        dispTypeList.add(DME2FilterHolder.RequestDispatcherType.FORWARD);
        dispTypeList.add(DME2FilterHolder.RequestDispatcherType.ASYNC);
        String mimeTypes = this.config.getProperty("DME2_COMPRESSION_ACCEPTABLE_MIME_TYPES");
        int minGzipSize = this.config.getInt("DME2_PAYLOAD_COMPRESSION_THRESH_SIZE");
        Properties params = new Properties();
        params.put("mimeTypes", mimeTypes);
        params.put("minGzipSize", String.valueOf(minGzipSize));
        params.put("methods", "GET,POST,PUT");
        DME2FilterHolder filterHolder = new DME2FilterHolder(new GzipFilter(), this.getServiceString(), EnumSet.copyOf(dispTypeList));
        filterHolder.setInitParams(params);
        return filterHolder;
    }

    private boolean disableCompressionForServiceOverride() {
        String serviceStr = this.serviceURI;
        try {
            URI uri = new URI(serviceStr);
            String queryParams = uri.getQuery();
            if (queryParams != null) {
                String val;
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                if (queryParams.contains("&")) {
                    String[] tokens;
                    for (String tok : tokens = queryParams.split("&")) {
                        String[] keyValuePair = tok.split("=");
                        if (keyValuePair.length != 2) continue;
                        paramsMap.put(keyValuePair[0], keyValuePair[1]);
                    }
                } else {
                    String[] keyValuePair = queryParams.split("=");
                    if (keyValuePair.length == 2) {
                        paramsMap.put(keyValuePair[0], keyValuePair[1]);
                    }
                }
                if (paramsMap.containsKey("disableCompression") && (val = (String)paramsMap.get("disableCompression")).equalsIgnoreCase("true")) {
                    return true;
                }
            }
        }
        catch (URISyntaxException e) {
            logger.error((URI)null, "disableCompressionForServiceOverride", LogMessage.REPORT_ERROR, (Object)"An error occurred while processing the query strings for URI: {}", (Object)serviceStr);
            return true;
        }
        return false;
    }

    private String getServiceString() {
        String str = this.serviceURI;
        String serviceStr = null;
        if (str.contains("?")) {
            String[] tokens = str.split("\\?");
            serviceStr = tokens[0];
            if (!serviceStr.startsWith("/")) {
                serviceStr = "/" + serviceStr;
            }
            return serviceStr;
        }
        return str;
    }

    private void checkForValidJAASConfiguration(ServletContextHandler context) throws DME2Exception {
        JAASLoginService loginService;
        block12: {
            if (this.allowedRoles == null || this.allowedRoles.length == 0) {
                throw new DME2Exception("AFT-DME2-0012", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm));
            }
            try {
                LoginContext ctx = this.createLoginContext();
                ctx.login();
            }
            catch (LoginException e) {
                throw new DME2Exception("AFT-DME2-0015", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm), (Throwable)e);
            }
            loginService = new JAASLoginService(this.realm);
            try {
                loginService.start();
            }
            catch (Exception e) {
                throw new DME2Exception("AFT-DME2-0008", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm), (Throwable)e);
            }
            try {
                loginService.login(TEST, TEST, null);
            }
            catch (SecurityException e) {
                if (e.getCause() == null || !(e.getCause() instanceof IOException)) break block12;
                throw new DME2Exception("AFT-DME2-0011", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm), (Throwable)e);
            }
        }
        if (this.loginMethod == null) {
            throw new DME2Exception("AFT-DME2-0010", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm));
        }
        if (!this.loginMethod.equals("BASIC") && !this.loginMethod.equals("CLIENT-CERT")) {
            throw new DME2Exception("AFT-DME2-0010", new ErrorContext().add(SERVICE, this.serviceURI).add(SERVLET, "" + this.servlet).add(SECURITY_REALM, this.realm));
        }
        Constraint constraint = new Constraint();
        if (this.loginMethod.equals("BASIC")) {
            constraint.setName("BASIC");
        } else if (this.loginMethod.equals("CLIENT-CERT")) {
            constraint.setName("CLIENT_CERT");
        }
        constraint.setRoles(this.allowedRoles);
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler sechandler = new ConstraintSecurityHandler();
        sechandler.setRealmName(this.realm);
        sechandler.setLoginService(loginService);
        sechandler.addConstraintMapping(cm);
        context.setSecurityHandler(sechandler);
    }

    private LoginContext createLoginContext() throws LoginException {
        LoginContext ctx = new LoginContext(this.realm, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof TextOutputCallback) continue;
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback nc = (NameCallback)callbacks[i];
                        nc.setName(DME2ServiceHolder.TEST);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        PasswordCallback pc = (PasswordCallback)callbacks[i];
                        pc.setPassword(DME2ServiceHolder.TEST.toCharArray());
                        continue;
                    }
                    if (callbacks[i] instanceof ObjectCallback) {
                        ObjectCallback oc = (ObjectCallback)callbacks[i];
                        oc.setObject(DME2ServiceHolder.TEST);
                        continue;
                    }
                    if (!(callbacks[i] instanceof RequestParameterCallback)) continue;
                    RequestParameterCallback rpc = (RequestParameterCallback)callbacks[i];
                    rpc.setParameterName("key");
                    rpc.setParameterValues(new ArrayList());
                }
            }
        });
        return ctx;
    }
}

