/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class DME2ServletWrapper
extends GenericServlet {
    private static final long serialVersionUID = -8010643090961103789L;
    private static final Logger logger = LoggerFactory.getLogger(DME2ServletWrapper.class.getName());
    private static final String DME2_SERVLET_INIT_PARAM_SERVICE_URI = "DME2_SERVLET_INIT_PARAM_SERVICE_URI";
    private static final String DME2_SERVLET_INIT_PARAM_CONTEXT_PATH = "DME2_SERVLET_INIT_PARAM_CONTEXT_PATH";
    private static final String DME2_SERVLET_INIT_PARAM_PORT = "DME2_SERVLET_INIT_PARAM_PORT";
    private static final String DME2_SERVLET_INIT_PARAM_PROTOCOL = "DME2_SERVLET_INIT_PARAM_PROTOCOL";
    private static final String DME2_SERVLET_INIT_PARAM_HOST = "DME2_SERVLET_INIT_PARAM_HOST";
    private static final String DME2_SERVLET_INIT_CONFIG_FILE = "DME2_SERVLET_INIT_CONFIG_FILE";
    private static final String DME2_SERVLET_INIT_CONFIG_DEF_FILE = "dme2-servlet-init.properties";
    private DME2Manager mgr;
    private Properties initProperties;
    private final String id = DME2ServletWrapper.generateRandomDME2ManagerID();
    private final Map<String, Properties> serviceProperties = new HashMap<String, Properties>();

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        StringBuilder builder = new StringBuilder();
        for (String key : this.serviceProperties.keySet()) {
            builder.append(key);
            builder.append(" = ");
            builder.append(this.serviceProperties.get(key).toString());
            builder.append("\n\n");
        }
        res.getWriter().write(this.serviceProperties.toString());
        res.getWriter().flush();
    }

    public void init() throws ServletException {
        logger.debug(null, "init", LogMessage.METHOD_ENTER);
        super.init();
        try {
            this.initProperties = this.loadServletInitProperties();
            Map<String, Properties> indexedProperties = this.organizePropertiesByIndex(this.initProperties);
            Set<String> indexes = indexedProperties.keySet();
            for (String index : indexes) {
                Properties props = indexedProperties.get(index);
                this.setServletInitParameters(props, index);
            }
            this.publishService();
        }
        catch (DME2Exception e) {
            logger.error((URI)null, "init", LogMessage.ERROR_PUBLISHING, (Object)e);
            String exitOnServletInitFailure = System.getProperty("AFT_DME2_SYSTEM_EXIT_ON_SERVLET_INIT_FAILURE", "false");
            if (exitOnServletInitFailure.equalsIgnoreCase("true")) {
                logger.info((URI)null, "init", LogMessage.DEBUG_MESSAGE, (Object)"System exiting due to exception when initializing DME2ServletWrapper.");
                System.exit(1);
            }
            throw new ServletException((Throwable)e);
        }
        logger.debug(null, "init", LogMessage.METHOD_EXIT);
    }

    public void destroy() {
        super.destroy();
        logger.debug(null, "destroy", LogMessage.METHOD_ENTER);
        try {
            this.unpublishService();
        }
        catch (DME2Exception e) {
            logger.warn((URI)null, "destroy", LogMessage.UNPUBLISH_IGNORABLE, (Object)e);
        }
        logger.debug(null, "destroy", LogMessage.METHOD_EXIT);
    }

    private void setServletInitParameters(Properties config, String index) throws ServletException {
        logger.debug(null, "setServletInitParameters", LogMessage.METHOD_ENTER);
        Properties tempProps = new Properties();
        String serviceURI = this.getServletInitProperty("DME2_SERVLET_INIT_PARAM_SERVICE_URI." + index, config, null);
        if (serviceURI == null || serviceURI.isEmpty()) {
            ErrorContext ec = new ErrorContext();
            ec.add("serviceURI", serviceURI);
            DME2Exception e = new DME2Exception("AFT-DME2-6800", ec);
            throw new ServletException((Throwable)e);
        }
        tempProps.put("DME2_SERVLET_INIT_PARAM_SERVICE_URI." + index, serviceURI);
        String contextPath = this.getServletInitProperty("DME2_SERVLET_INIT_PARAM_CONTEXT_PATH." + index, config, null);
        if (contextPath != null) {
            tempProps.put("DME2_SERVLET_INIT_PARAM_CONTEXT_PATH." + index, contextPath);
        }
        String portStr = this.getServletInitProperty("DME2_SERVLET_INIT_PARAM_PORT." + index, config, "8080");
        try {
            int port = Integer.parseInt(portStr);
            tempProps.put("DME2_SERVLET_INIT_PARAM_PORT." + index, String.valueOf(port));
        }
        catch (NumberFormatException e) {
            ErrorContext ec = new ErrorContext();
            ec.add("serviceURI", serviceURI);
            ec.add("servicePort", portStr);
            DME2Exception ex = new DME2Exception("AFT-DME2-6803", ec);
            throw new ServletException((Throwable)ex);
        }
        String protocol = this.getServletInitProperty("DME2_SERVLET_INIT_PARAM_PROTOCOL." + index, config, "http");
        tempProps.put("DME2_SERVLET_INIT_PARAM_PROTOCOL." + index, protocol);
        String hostAddress = null;
        try {
            hostAddress = this.getServletInitProperty("DME2_SERVLET_INIT_PARAM_HOST." + index, config, InetAddress.getLocalHost().getCanonicalHostName());
            tempProps.put("DME2_SERVLET_INIT_PARAM_HOST." + index, hostAddress);
        }
        catch (UnknownHostException e) {
            ErrorContext ec = new ErrorContext();
            ec.add("serviceURI", serviceURI);
            ec.add("host", hostAddress);
            DME2Exception ex = new DME2Exception("AFT-DME2-6501", ec);
            throw new ServletException((Throwable)ex);
        }
        this.serviceProperties.put(index, tempProps);
        logger.debug(null, "setServletInitParameters", LogMessage.METHOD_EXIT);
    }

    private static String generateRandomDME2ManagerID() {
        return "DME2ManagerID - " + UUID.randomUUID().toString();
    }

    private void publishService() throws DME2Exception {
        logger.debug(null, "publishService", LogMessage.METHOD_ENTER);
        if (this.mgr == null) {
            DME2Configuration config = new DME2Configuration(this.id, this.initProperties);
            this.mgr = new DME2Manager(this.id, config);
        }
        Set<String> indexes = this.serviceProperties.keySet();
        for (String index : indexes) {
            Properties props = this.serviceProperties.get(index);
            String indexSuffix = "." + index;
            String serviceURI = props.getProperty(DME2_SERVLET_INIT_PARAM_SERVICE_URI + indexSuffix);
            String contextPath = props.getProperty(DME2_SERVLET_INIT_PARAM_CONTEXT_PATH + indexSuffix);
            String hostAddress = props.getProperty(DME2_SERVLET_INIT_PARAM_HOST + indexSuffix);
            String port = props.getProperty(DME2_SERVLET_INIT_PARAM_PORT + indexSuffix);
            String protocol = props.getProperty(DME2_SERVLET_INIT_PARAM_PROTOCOL + indexSuffix);
            try {
                this.mgr.getEndpointRegistry().publish(serviceURI, contextPath, hostAddress, Integer.parseInt(port), protocol);
                logger.debug((URI)null, "publishService", LogMessage.PUBLISH_ENDPOINT, (Object)hostAddress, (Object)port);
            }
            catch (Exception e) {
                logger.error((URI)null, "publishService", LogMessage.ERROR_PUBLISHING, (Object)serviceURI);
            }
        }
        logger.debug(null, "publishService", LogMessage.METHOD_EXIT);
    }

    private void unpublishService() throws DME2Exception {
        logger.debug(null, "unpublishService", LogMessage.METHOD_ENTER);
        Set<String> indexes = this.serviceProperties.keySet();
        for (String index : indexes) {
            Properties props = this.serviceProperties.get(index);
            String indexSuffix = "." + index;
            String serviceURI = props.getProperty(DME2_SERVLET_INIT_PARAM_SERVICE_URI + indexSuffix);
            String hostAddress = props.getProperty(DME2_SERVLET_INIT_PARAM_HOST + indexSuffix);
            String port = props.getProperty(DME2_SERVLET_INIT_PARAM_PORT + indexSuffix);
            try {
                this.mgr.getEndpointRegistry().unpublish(serviceURI, hostAddress, Integer.parseInt(port));
                logger.debug((URI)null, "unpublishService", LogMessage.UNPUBLISHED, (Object)hostAddress, (Object)port);
            }
            catch (Exception e) {
                logger.error((URI)null, "unpublishService", LogMessage.ERROR_UNPUBLISHING, (Object)serviceURI);
            }
        }
        logger.debug(null, "unpublishService", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadServletInitProperties() throws DME2Exception {
        Properties props = new Properties();
        ClassLoader[] cls = new ClassLoader[]{ClassLoader.getSystemClassLoader(), DME2ServletWrapper.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        String fileName = this.resolveServletInitConfigFile();
        boolean isLoaded = false;
        for (ClassLoader cl : cls) {
            InputStream in = cl.getResourceAsStream(fileName);
            if (cl.getResource(fileName) == null) continue;
            logger.info((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)("Loading props from: " + cl.getResource(fileName)));
            if (in == null) continue;
            try {
                props.load(in);
                isLoaded = true;
                logger.info((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)("Successfully loaded props from: " + cl.getResource(fileName)));
                break;
            }
            catch (Exception e) {
                DME2Exception ex = new DME2Exception("AFT-DME2-9999", "IOException Occurred while loading configuration", (Throwable)e);
                logger.warn((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.debug((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e);
                    }
                }
            }
        }
        if (isLoaded) {
            return props;
        }
        InputStream in = null;
        try {
            logger.info((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)("Loading props from: " + fileName));
            in = new FileInputStream(fileName);
            props.load(in);
        }
        catch (IOException e) {
            DME2Exception ex = new DME2Exception("AFT-DME2-9999", "IOException Occurred while loading configuration", (Throwable)e);
            logger.warn((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.debug((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e);
                }
            }
        }
        return props;
    }

    private Map<String, Properties> organizePropertiesByIndex(Properties properties) {
        HashMap<String, Properties> indexedProperties = new HashMap<String, Properties>();
        if (properties.isEmpty()) {
            ServletConfig config = this.getServletConfig();
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                properties.setProperty(key + "." + config.getServletName(), this.getInitParameter(key));
            }
        }
        HashSet<String> propertyIndex = new HashSet<String>();
        Set<Object> propertyKeys = properties.keySet();
        for (Object key : propertyKeys) {
            String keyStr = (String)key;
            String[] tokens = keyStr.split("\\.");
            if (tokens.length != 2) continue;
            propertyIndex.add(tokens[1]);
        }
        for (String index : propertyIndex) {
            Properties props = new Properties();
            for (Object obj : properties.keySet()) {
                String key = (String)obj;
                if (!key.contains("." + index)) continue;
                props.put(key, properties.get(key));
            }
            indexedProperties.put(index, props);
        }
        return indexedProperties;
    }

    private String resolveServletInitConfigFile() {
        String fileName = this.getInitParameter(DME2_SERVLET_INIT_CONFIG_FILE);
        if (fileName == null) {
            fileName = System.getProperty("AFT_DME2_SERVLET_INIT_CONFIG_FILE", DME2_SERVLET_INIT_CONFIG_DEF_FILE);
        }
        logger.info((URI)null, "loadServletInitProperties", LogMessage.DEBUG_MESSAGE, (Object)("Resolved Servlet init configuration file: " + fileName));
        return fileName;
    }

    private String getServletInitProperty(String key, Properties props, String defaultValue) {
        String value = null;
        if (key == null) {
            return defaultValue;
        }
        if (props != null) {
            value = props.getProperty(key);
        }
        if (value == null) {
            value = this.getInitParameter(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        String msg = String.format("Resolved property for key %s. Value is: %s", key, value);
        logger.debug((URI)null, "getServletInitProperty", LogMessage.DEBUG_MESSAGE, (Object)msg);
        return value;
    }
}

